/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.apache.calcite.sql.SqlAggFunction;
import org.apache.calcite.sql.SqlAsOperator;
import org.apache.calcite.sql.SqlBasicCall;
import org.apache.calcite.sql.SqlCall;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.parser.SqlParserPos;
import org.apache.calcite.sql.util.SqlBasicVisitor;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.model.NDataModel;

public class SqlIdentifierFormatterVisitor
extends SqlBasicVisitor<Void> {
    private final String expr;
    private final Map<String, Set<String>> table2cols = Maps.newHashMap();
    private final Map<String, Set<String>> col2tables = Maps.newHashMap();

    public SqlIdentifierFormatterVisitor(String expr, List<NDataModel.NamedColumn> fullQualifiedNamedColumns) {
        this.expr = expr;
        for (NDataModel.NamedColumn col : fullQualifiedNamedColumns) {
            if (col.getStatus() == NDataModel.ColumnStatus.TOMB) continue;
            String aliasDotColumn = col.getAliasDotColumn();
            String[] nameParts = aliasDotColumn.split("\\.");
            if (nameParts.length < 2) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_MODEL_TYPE, "Found invalid stored full qualified column name for " + nameParts[nameParts.length - 1]);
            }
            String table = nameParts[nameParts.length - 2];
            this.table2cols.putIfAbsent(table, Sets.newHashSet());
            String column = nameParts[nameParts.length - 1];
            Set<String> cols = this.table2cols.get(table);
            if (cols.contains(column)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.DUPLICATED_COLUMN_NAME, String.format(Locale.ROOT, "Found duplicate stored column %s for table %s!", column, table));
            }
            cols.add(column);
            this.col2tables.putIfAbsent(column, Sets.newHashSet());
            this.col2tables.get(column).add(table);
        }
    }

    public Void visit(SqlIdentifier id) {
        if (id.names.size() == 1) {
            String column = ((String)id.names.get(0)).toUpperCase(Locale.ROOT).trim();
            Set<String> targetTbls = this.col2tables.getOrDefault(column, Sets.newHashSet());
            if (targetTbls.size() != 1) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COLUMN_NOT_EXIST, String.format(Locale.ROOT, "Found unrecognized or ambiguous column: %s in candidate tables [%s] in expression '%s'.", id, targetTbls.stream().reduce(", ", (x$0, xva$1) -> String.join(x$0, xva$1)), this.expr));
            }
            ImmutableList names = ImmutableList.of((Object)targetTbls.iterator().next(), (Object)column);
            ImmutableList poses = ImmutableList.of((Object)SqlParserPos.ZERO, (Object)id.getComponentParserPosition(0));
            id.setNames((List)names, (List)poses);
        } else if (id.names.size() >= 2) {
            String table = ((String)id.names.get(0)).toUpperCase(Locale.ROOT).trim();
            String column = ((String)id.names.get(1)).toUpperCase(Locale.ROOT).trim();
            Set<String> cols = this.table2cols.get(table);
            if (id.names.size() > 2 || cols == null || !cols.contains(column)) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.COLUMN_NOT_EXIST, String.format(Locale.ROOT, "Found unrecognized column: %s in expression '%s'.", id, this.expr));
            }
            ImmutableList names = ImmutableList.of((Object)table, (Object)column);
            ImmutableList poses = ImmutableList.of((Object)id.getComponentParserPosition(0), (Object)id.getComponentParserPosition(1));
            id.setNames((List)names, (List)poses);
        }
        return null;
    }

    public Void visit(SqlCall call) {
        if (call instanceof SqlBasicCall && (call.getOperator() instanceof SqlAsOperator || call.getOperator() instanceof SqlAggFunction)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, String.format(Locale.ROOT, "Unsupported SqlNode %s in expression %s", call, this.expr));
        }
        return (Void)super.visit(call);
    }
}

