/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.response;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;

public class IndexResponse {
    private Long id;
    private String project;
    private String model;
    private String name;
    private String owner;
    private IndexEntity.Status status;
    @JsonProperty(value="col_order")
    private List<ColOrderPair> colOrder;
    @JsonProperty(value="shard_by_columns")
    private List<String> shardByColumns;
    @JsonProperty(value="sort_by_columns")
    private List<String> sortByColumns;
    @JsonProperty(value="storage_type")
    private int storageType = 20;
    @JsonProperty(value="data_size")
    private long dataSize;
    @JsonProperty(value="usage")
    private long usage;
    @JsonProperty(value="last_modified")
    private long lastModified;
    @JsonProperty(value="related_tables")
    private List<String> relatedTables;
    @JsonIgnore
    private boolean isManual;
    @JsonIgnore
    private boolean isBase;
    @JsonProperty(value="need_update")
    private boolean needUpdate;
    @JsonProperty(value="index_range")
    private IndexEntity.Range indexRange;
    @JsonProperty(value="abnormal_type")
    private NDataLayout.AbnormalType abnormalType;

    @JsonProperty(value="source")
    public IndexEntity.Source getSource() {
        if (this.isBase()) {
            return IndexEntity.isTableIndex((long)this.getId()) ? IndexEntity.Source.BASE_TABLE_INDEX : IndexEntity.Source.BASE_AGG_INDEX;
        }
        if (this.getId() < 20000000000L) {
            if (this.isManual()) {
                return IndexEntity.Source.CUSTOM_AGG_INDEX;
            }
            return IndexEntity.Source.RECOMMENDED_AGG_INDEX;
        }
        if (this.isManual()) {
            return IndexEntity.Source.CUSTOM_TABLE_INDEX;
        }
        return IndexEntity.Source.RECOMMENDED_TABLE_INDEX;
    }

    @Generated
    public IndexResponse() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getProject() {
        return this.project;
    }

    @Generated
    public String getModel() {
        return this.model;
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getOwner() {
        return this.owner;
    }

    @Generated
    public IndexEntity.Status getStatus() {
        return this.status;
    }

    @Generated
    public List<ColOrderPair> getColOrder() {
        return this.colOrder;
    }

    @Generated
    public List<String> getShardByColumns() {
        return this.shardByColumns;
    }

    @Generated
    public List<String> getSortByColumns() {
        return this.sortByColumns;
    }

    @Generated
    public int getStorageType() {
        return this.storageType;
    }

    @Generated
    public long getDataSize() {
        return this.dataSize;
    }

    @Generated
    public long getUsage() {
        return this.usage;
    }

    @Generated
    public long getLastModified() {
        return this.lastModified;
    }

    @Generated
    public List<String> getRelatedTables() {
        return this.relatedTables;
    }

    @Generated
    public boolean isManual() {
        return this.isManual;
    }

    @Generated
    public boolean isBase() {
        return this.isBase;
    }

    @Generated
    public boolean isNeedUpdate() {
        return this.needUpdate;
    }

    @Generated
    public IndexEntity.Range getIndexRange() {
        return this.indexRange;
    }

    @Generated
    public NDataLayout.AbnormalType getAbnormalType() {
        return this.abnormalType;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setProject(String project) {
        this.project = project;
    }

    @Generated
    public void setModel(String model) {
        this.model = model;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setOwner(String owner) {
        this.owner = owner;
    }

    @Generated
    public void setStatus(IndexEntity.Status status) {
        this.status = status;
    }

    @Generated
    public void setColOrder(List<ColOrderPair> colOrder) {
        this.colOrder = colOrder;
    }

    @Generated
    public void setShardByColumns(List<String> shardByColumns) {
        this.shardByColumns = shardByColumns;
    }

    @Generated
    public void setSortByColumns(List<String> sortByColumns) {
        this.sortByColumns = sortByColumns;
    }

    @Generated
    public void setStorageType(int storageType) {
        this.storageType = storageType;
    }

    @Generated
    public void setDataSize(long dataSize) {
        this.dataSize = dataSize;
    }

    @Generated
    public void setUsage(long usage) {
        this.usage = usage;
    }

    @Generated
    public void setLastModified(long lastModified) {
        this.lastModified = lastModified;
    }

    @Generated
    public void setRelatedTables(List<String> relatedTables) {
        this.relatedTables = relatedTables;
    }

    @Generated
    public void setManual(boolean isManual) {
        this.isManual = isManual;
    }

    @Generated
    public void setBase(boolean isBase) {
        this.isBase = isBase;
    }

    @Generated
    public void setNeedUpdate(boolean needUpdate) {
        this.needUpdate = needUpdate;
    }

    @Generated
    public void setIndexRange(IndexEntity.Range indexRange) {
        this.indexRange = indexRange;
    }

    @Generated
    public void setAbnormalType(NDataLayout.AbnormalType abnormalType) {
        this.abnormalType = abnormalType;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof IndexResponse)) {
            return false;
        }
        IndexResponse other = (IndexResponse)o;
        if (!other.canEqual(this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        String this$project = this.getProject();
        String other$project = other.getProject();
        if (this$project == null ? other$project != null : !this$project.equals(other$project)) {
            return false;
        }
        String this$model = this.getModel();
        String other$model = other.getModel();
        if (this$model == null ? other$model != null : !this$model.equals(other$model)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$owner = this.getOwner();
        String other$owner = other.getOwner();
        if (this$owner == null ? other$owner != null : !this$owner.equals(other$owner)) {
            return false;
        }
        IndexEntity.Status this$status = this.getStatus();
        IndexEntity.Status other$status = other.getStatus();
        if (this$status == null ? other$status != null : !this$status.equals(other$status)) {
            return false;
        }
        List<ColOrderPair> this$colOrder = this.getColOrder();
        List<ColOrderPair> other$colOrder = other.getColOrder();
        if (this$colOrder == null ? other$colOrder != null : !((Object)this$colOrder).equals(other$colOrder)) {
            return false;
        }
        List<String> this$shardByColumns = this.getShardByColumns();
        List<String> other$shardByColumns = other.getShardByColumns();
        if (this$shardByColumns == null ? other$shardByColumns != null : !((Object)this$shardByColumns).equals(other$shardByColumns)) {
            return false;
        }
        List<String> this$sortByColumns = this.getSortByColumns();
        List<String> other$sortByColumns = other.getSortByColumns();
        if (this$sortByColumns == null ? other$sortByColumns != null : !((Object)this$sortByColumns).equals(other$sortByColumns)) {
            return false;
        }
        if (this.getStorageType() != other.getStorageType()) {
            return false;
        }
        if (this.getDataSize() != other.getDataSize()) {
            return false;
        }
        if (this.getUsage() != other.getUsage()) {
            return false;
        }
        if (this.getLastModified() != other.getLastModified()) {
            return false;
        }
        List<String> this$relatedTables = this.getRelatedTables();
        List<String> other$relatedTables = other.getRelatedTables();
        if (this$relatedTables == null ? other$relatedTables != null : !((Object)this$relatedTables).equals(other$relatedTables)) {
            return false;
        }
        if (this.isManual() != other.isManual()) {
            return false;
        }
        if (this.isBase() != other.isBase()) {
            return false;
        }
        if (this.isNeedUpdate() != other.isNeedUpdate()) {
            return false;
        }
        IndexEntity.Range this$indexRange = this.getIndexRange();
        IndexEntity.Range other$indexRange = other.getIndexRange();
        if (this$indexRange == null ? other$indexRange != null : !this$indexRange.equals(other$indexRange)) {
            return false;
        }
        NDataLayout.AbnormalType this$abnormalType = this.getAbnormalType();
        NDataLayout.AbnormalType other$abnormalType = other.getAbnormalType();
        return !(this$abnormalType == null ? other$abnormalType != null : !this$abnormalType.equals(other$abnormalType));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof IndexResponse;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        String $project = this.getProject();
        result = result * 59 + ($project == null ? 43 : $project.hashCode());
        String $model = this.getModel();
        result = result * 59 + ($model == null ? 43 : $model.hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $owner = this.getOwner();
        result = result * 59 + ($owner == null ? 43 : $owner.hashCode());
        IndexEntity.Status $status = this.getStatus();
        result = result * 59 + ($status == null ? 43 : $status.hashCode());
        List<ColOrderPair> $colOrder = this.getColOrder();
        result = result * 59 + ($colOrder == null ? 43 : ((Object)$colOrder).hashCode());
        List<String> $shardByColumns = this.getShardByColumns();
        result = result * 59 + ($shardByColumns == null ? 43 : ((Object)$shardByColumns).hashCode());
        List<String> $sortByColumns = this.getSortByColumns();
        result = result * 59 + ($sortByColumns == null ? 43 : ((Object)$sortByColumns).hashCode());
        result = result * 59 + this.getStorageType();
        long $dataSize = this.getDataSize();
        result = result * 59 + (int)($dataSize >>> 32 ^ $dataSize);
        long $usage = this.getUsage();
        result = result * 59 + (int)($usage >>> 32 ^ $usage);
        long $lastModified = this.getLastModified();
        result = result * 59 + (int)($lastModified >>> 32 ^ $lastModified);
        List<String> $relatedTables = this.getRelatedTables();
        result = result * 59 + ($relatedTables == null ? 43 : ((Object)$relatedTables).hashCode());
        result = result * 59 + (this.isManual() ? 79 : 97);
        result = result * 59 + (this.isBase() ? 79 : 97);
        result = result * 59 + (this.isNeedUpdate() ? 79 : 97);
        IndexEntity.Range $indexRange = this.getIndexRange();
        result = result * 59 + ($indexRange == null ? 43 : $indexRange.hashCode());
        NDataLayout.AbnormalType $abnormalType = this.getAbnormalType();
        result = result * 59 + ($abnormalType == null ? 43 : $abnormalType.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "IndexResponse(id=" + this.getId() + ", project=" + this.getProject() + ", model=" + this.getModel() + ", name=" + this.getName() + ", owner=" + this.getOwner() + ", status=" + this.getStatus() + ", colOrder=" + this.getColOrder() + ", shardByColumns=" + this.getShardByColumns() + ", sortByColumns=" + this.getSortByColumns() + ", storageType=" + this.getStorageType() + ", dataSize=" + this.getDataSize() + ", usage=" + this.getUsage() + ", lastModified=" + this.getLastModified() + ", relatedTables=" + this.getRelatedTables() + ", isManual=" + this.isManual() + ", isBase=" + this.isBase() + ", needUpdate=" + this.isNeedUpdate() + ", indexRange=" + this.getIndexRange() + ", abnormalType=" + this.getAbnormalType() + ")";
    }

    public static class ColOrderPair {
        private String key;
        private String value;
        private Long cardinality;

        public ColOrderPair(String key, String value) {
            this.key = key;
            this.value = value;
        }

        public void changeTableAlias(String oldAlias, String newAlias) {
            String[] split = this.key.split("\\.");
            if (split.length == 2) {
                String table = split[0];
                String column = split[1];
                if (table.equalsIgnoreCase(oldAlias)) {
                    this.key = newAlias + "." + column;
                }
            }
        }

        @Generated
        public String getKey() {
            return this.key;
        }

        @Generated
        public String getValue() {
            return this.value;
        }

        @Generated
        public Long getCardinality() {
            return this.cardinality;
        }

        @Generated
        public void setKey(String key) {
            this.key = key;
        }

        @Generated
        public void setValue(String value) {
            this.value = value;
        }

        @Generated
        public void setCardinality(Long cardinality) {
            this.cardinality = cardinality;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof ColOrderPair)) {
                return false;
            }
            ColOrderPair other = (ColOrderPair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            String this$key = this.getKey();
            String other$key = other.getKey();
            if (this$key == null ? other$key != null : !this$key.equals(other$key)) {
                return false;
            }
            String this$value = this.getValue();
            String other$value = other.getValue();
            if (this$value == null ? other$value != null : !this$value.equals(other$value)) {
                return false;
            }
            Long this$cardinality = this.getCardinality();
            Long other$cardinality = other.getCardinality();
            return !(this$cardinality == null ? other$cardinality != null : !((Object)this$cardinality).equals(other$cardinality));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof ColOrderPair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            String $key = this.getKey();
            result = result * 59 + ($key == null ? 43 : $key.hashCode());
            String $value = this.getValue();
            result = result * 59 + ($value == null ? 43 : $value.hashCode());
            Long $cardinality = this.getCardinality();
            result = result * 59 + ($cardinality == null ? 43 : ((Object)$cardinality).hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "IndexResponse.ColOrderPair(key=" + this.getKey() + ", value=" + this.getValue() + ", cardinality=" + this.getCardinality() + ")";
        }

        @Generated
        public ColOrderPair(String key, String value, Long cardinality) {
            this.key = key;
            this.value = value;
            this.cardinality = cardinality;
        }
    }
}

