/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.List;
import java.util.Set;
import lombok.Generated;
import org.apache.commons.lang3.ArrayUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.scheduler.EventBusFactory;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.NIndexPlanManager;
import org.apache.kylin.metadata.model.FusionModel;
import org.apache.kylin.metadata.model.FusionModelManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.rest.aspect.Transaction;
import org.apache.kylin.rest.request.IndexesToSegmentsRequest;
import org.apache.kylin.rest.request.ModelRequest;
import org.apache.kylin.rest.request.OwnerChangeRequest;
import org.apache.kylin.rest.response.BuildBaseIndexResponse;
import org.apache.kylin.rest.response.DataResult;
import org.apache.kylin.rest.response.JobInfoResponse;
import org.apache.kylin.rest.response.JobInfoResponseWithFailure;
import org.apache.kylin.rest.response.NDataModelResponse;
import org.apache.kylin.rest.service.AbstractModelService;
import org.apache.kylin.rest.service.FusionIndexService;
import org.apache.kylin.rest.service.ModelBuildSupporter;
import org.apache.kylin.rest.service.ModelService;
import org.apache.kylin.rest.service.TableFusionModelSupporter;
import org.apache.kylin.rest.service.params.IncrementBuildSegmentParams;
import org.apache.kylin.rest.service.params.IndexBuildParams;
import org.apache.kylin.rest.util.ModelUtils;
import org.apache.kylin.streaming.event.StreamingJobKillEvent;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Service;

@Service(value="fusionModelService")
public class FusionModelService
extends AbstractModelService
implements TableFusionModelSupporter {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FusionModelService.class);
    @Autowired
    private ModelService modelService;
    @Autowired(required=false)
    @Qualifier(value="modelBuildService")
    private ModelBuildSupporter modelBuildService;

    public JobInfoResponse incrementBuildSegmentsManually(IncrementBuildSegmentParams params) throws Exception {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, params.getProject())).getDataModelDesc(params.getModelId());
        if (model.isFusionModel()) {
            NDataModel streamingModel = ((NDataModelManager)this.getManager(NDataModelManager.class, params.getProject())).getDataModelDesc(model.getFusionId());
            IncrementBuildSegmentParams copy = (IncrementBuildSegmentParams)JsonUtil.deepCopyQuietly((Object)params, IncrementBuildSegmentParams.class);
            String oldAliasName = streamingModel.getRootFactTableRef().getTableName();
            String tableName = model.getRootFactTableRef().getTableName();
            copy.getPartitionDesc().changeTableAlias(oldAliasName, tableName);
            return this.modelBuildService.incrementBuildSegmentsManually(copy);
        }
        return this.modelBuildService.incrementBuildSegmentsManually(params);
    }

    @Transaction(project=1)
    public void dropModel(String modelId, String project) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model.fusionModelStreamingPart()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            FusionModel fusionModel = fusionModelManager.getFusionModel(modelId);
            String batchId = fusionModel.getBatchModel().getUuid();
            fusionModelManager.dropModel(modelId);
            this.modelService.dropModel(batchId, project);
        }
        this.modelService.dropModel(modelId, project);
    }

    void innerDopModel(String modelId, String project) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model == null) {
            return;
        }
        if (model.isFusionModel()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            FusionModel fusionModel = fusionModelManager.getFusionModel(modelId);
            if (model.fusionModelBatchPart()) {
                String streamingId = model.getFusionId();
                fusionModelManager.dropModel(streamingId);
                this.modelService.innerDropModel(streamingId, project);
            } else {
                String batchId = fusionModel.getBatchModel().getUuid();
                fusionModelManager.dropModel(modelId);
                this.modelService.innerDropModel(batchId, project);
            }
        }
        this.modelService.innerDropModel(modelId, project);
    }

    @Transaction(project=0)
    public BuildBaseIndexResponse updateDataModelSemantic(String project, ModelRequest request) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, request.getProject())).getDataModelDesc(request.getUuid());
        if (model.isFusionModel()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            String batchId = fusionModelManager.getFusionModel(request.getUuid()).getBatchModel().getUuid();
            ModelRequest copy = (ModelRequest)((Object)JsonUtil.deepCopyQuietly((Object)((Object)request), ModelRequest.class));
            String tableName = model.getRootFactTableRef().getTableDesc().getKafkaConfig().getBatchTable();
            copy.setAlias(FusionModel.getBatchName((String)model.getAlias(), (String)model.getUuid()));
            copy.setRootFactTableName(tableName);
            copy.setUuid(batchId);
            String tableAlias = model.getRootFactTableRef().getTableDesc().getKafkaConfig().getBatchTableAlias();
            String oldAliasName = model.getRootFactTableRef().getTableName();
            this.convertModel(copy, tableAlias, oldAliasName);
            this.modelService.updateDataModelSemantic(project, copy);
        }
        if (model.isStreaming()) {
            request.setWithBaseIndex(false);
        }
        return this.modelService.updateDataModelSemantic(project, request);
    }

    private void convertModel(ModelRequest copy, String tableName, String oldAliasName) {
        copy.getSimplifiedJoinTableDescs().forEach(x -> x.getSimplifiedJoinDesc().changeFKTableAlias(oldAliasName, tableName));
        copy.getSimplifiedDimensions().forEach(x -> x.changeTableAlias(oldAliasName, tableName));
        copy.getSimplifiedMeasures().forEach(x -> x.changeTableAlias(oldAliasName, tableName));
        copy.getPartitionDesc().changeTableAlias(oldAliasName, tableName);
    }

    @Transaction(project=0)
    public void renameDataModel(String project, String modelId, String newAlias, String description) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model.isFusionModel()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            String batchId = fusionModelManager.getFusionModel(modelId).getBatchModel().getUuid();
            this.modelService.renameDataModel(project, batchId, FusionModel.getBatchName((String)newAlias, (String)modelId), description);
        }
        this.modelService.renameDataModel(project, modelId, newAlias, description);
        if (model.isStreaming() || model.isFusionModel()) {
            EventBusFactory.getInstance().postSync((Object)new NDataModel.ModelRenameEvent(project, modelId, newAlias));
        }
    }

    @Transaction(project=0)
    public void updateModelOwner(String project, String modelId, OwnerChangeRequest ownerChangeRequest) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model.isFusionModel()) {
            FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
            String batchId = fusionModelManager.getFusionModel(modelId).getBatchModel().getUuid();
            OwnerChangeRequest batchRequest = (OwnerChangeRequest)JsonUtil.deepCopyQuietly((Object)ownerChangeRequest, OwnerChangeRequest.class);
            this.modelService.updateModelOwner(project, batchId, batchRequest);
        }
        this.modelService.updateModelOwner(project, modelId, ownerChangeRequest);
    }

    public Pair<String, String[]> convertSegmentIdWithName(String modelId, String project, String[] segIds, String[] segNames) {
        boolean existedInStreaming;
        if (ArrayUtils.isEmpty((Object[])segNames)) {
            return new Pair((Object)modelId, (Object)segIds);
        }
        NDataModel dataModel = this.modelService.getModelById(modelId, project);
        String targetModelId = modelId;
        if (dataModel.isFusionModel() && !(existedInStreaming = this.modelService.checkSegmentsExistByName(targetModelId, project, segNames, false))) {
            targetModelId = this.getBatchModel(modelId, project).getUuid();
        }
        String[] segmentIds = this.modelService.convertSegmentIdWithName(targetModelId, project, segIds, segNames);
        return new Pair((Object)targetModelId, (Object)segmentIds);
    }

    public JobInfoResponseWithFailure addIndexesToSegments(String modelId, IndexesToSegmentsRequest buildSegmentsRequest) {
        String targetModelId = modelId;
        NDataModel dataModel = this.modelService.getModelById(modelId, buildSegmentsRequest.getProject());
        if (dataModel.getModelType() == NDataModel.ModelType.HYBRID) {
            boolean existedInStreaming = this.modelService.checkSegmentsExistById(targetModelId, buildSegmentsRequest.getProject(), buildSegmentsRequest.getSegmentIds().toArray(new String[0]), false);
            if (existedInStreaming) {
                throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SEGMENT_UNSUPPORTED_OPERATOR, MsgPicker.getMsg().getFixStreamingSegment());
            }
            targetModelId = this.getBatchModel(modelId, buildSegmentsRequest.getProject()).getUuid();
        } else if (dataModel.getModelType() == NDataModel.ModelType.STREAMING) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SEGMENT_UNSUPPORTED_OPERATOR, MsgPicker.getMsg().getFixStreamingSegment());
        }
        return this.modelBuildService.addIndexesToSegments(IndexBuildParams.builder().project(buildSegmentsRequest.getProject()).modelId(targetModelId).segmentIds(buildSegmentsRequest.getSegmentIds()).layoutIds(buildSegmentsRequest.getIndexIds()).parallelBuildBySegment(buildSegmentsRequest.isParallelBuildBySegment()).priority(buildSegmentsRequest.getPriority()).partialBuild(buildSegmentsRequest.isPartialBuild()).yarnQueue(buildSegmentsRequest.getYarnQueue()).tag(buildSegmentsRequest.getTag()).build());
    }

    private NDataModel getBatchModel(String fusionModelId, String project) {
        FusionModelManager fusionModelManager = FusionModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        FusionModel fusionModel = fusionModelManager.getFusionModel(fusionModelId);
        return fusionModel.getBatchModel();
    }

    public void stopStreamingJob(String modelId, String project) {
        NDataModel model = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).getDataModelDesc(modelId);
        if (model.fusionModelBatchPart()) {
            String streamingId = model.getFusionId();
            EventBusFactory.getInstance().postSync((Object)new StreamingJobKillEvent(project, streamingId));
        }
        if (model.isStreaming()) {
            EventBusFactory.getInstance().postSync((Object)new StreamingJobKillEvent(project, modelId));
        }
    }

    public void onDropModel(String modelId, String project, boolean ignoreType) {
        this.innerDopModel(modelId, project);
    }

    public void onStopStreamingJob(String modelId, String project) {
        this.stopStreamingJob(modelId, project);
    }

    public void setModelUpdateEnabled(DataResult<List<NDataModel>> dataResult) {
        List dataModelList = (List)dataResult.getValue();
        dataModelList.stream().filter(NDataModel::isStreaming).forEach(model -> {
            if (model.isBroken()) {
                ((NDataModelResponse)((Object)model)).setModelUpdateEnabled(false);
            } else {
                ((NDataModelResponse)((Object)model)).setModelUpdateEnabled(!FusionIndexService.checkStreamingJobAndSegments(model.getProject(), model.getUuid()));
            }
        });
    }

    public void setAutoIndexPlanEnabled(DataResult<List<NDataModel>> dataResult) {
        List dataModelList = (List)dataResult.getValue();
        dataModelList.stream().filter(model -> !model.isStreaming() && !model.isBroken()).forEach(model -> {
            if (this.modelService.isAutoIndexPlanEnabled(model.getProject(), model.getId())) {
                ((NDataModelResponse)((Object)model)).setAutoIndexPlanEnable(true);
                IndexPlan indexPlan = ((NIndexPlanManager)this.getManager(NIndexPlanManager.class, model.getProject())).getIndexPlan(model.getId());
                ((NDataModelResponse)((Object)model)).setInstantInitIndexEnable(!ModelUtils.isModelHasAnyData((NDataModelResponse)((Object)model), indexPlan));
            }
        });
    }

    public boolean modelExists(String modelAlias, String project) {
        Set allModelAlias = ((NDataModelManager)this.getManager(NDataModelManager.class, project)).listAllModelAlias();
        for (String alias : allModelAlias) {
            if (!alias.equalsIgnoreCase(modelAlias)) continue;
            return true;
        }
        return false;
    }
}

