/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.util;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.guava30.shaded.common.base.Joiner;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.model.NDataModelManager;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.SegmentStatusEnum;
import org.apache.kylin.metadata.model.TableDesc;
import org.apache.kylin.metadata.model.TableRef;
import org.apache.kylin.metadata.table.InternalTableManager;
import org.apache.kylin.rest.response.SQLResponse;
import org.apache.kylin.rest.service.CacheSignatureQuerySupporter;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class QueryCacheSignatureUtil {
    private static final Logger logger = LoggerFactory.getLogger((String)"query");
    @Autowired
    private static CacheSignatureQuerySupporter queryService;

    public static String createCacheSignature(SQLResponse response, String project) {
        ArrayList signature = Lists.newArrayList();
        queryService = (CacheSignatureQuerySupporter)SpringContext.getBean(CacheSignatureQuerySupporter.class);
        try {
            signature.add(queryService.onCreateAclSignature(project));
        }
        catch (IOException e) {
            logger.error("Fail to get acl signature: ", (Throwable)e);
            return "";
        }
        List<NativeQueryRealization> realizations = response.getNativeRealizations();
        Preconditions.checkState((boolean)CollectionUtils.isNotEmpty(realizations));
        for (NativeQueryRealization realization : realizations) {
            signature.add(QueryCacheSignatureUtil.generateSignature(realization, project, response.getDuration()));
        }
        return Joiner.on((String)",").join((Iterable)signature);
    }

    public static String createCacheSignature(List<String> tables, String project, String modelAlias) {
        NTableMetadataManager tableManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        NDataModelManager modelManager = NDataModelManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project);
        ArrayList signature = Lists.newArrayList();
        queryService = (CacheSignatureQuerySupporter)SpringContext.getBean(CacheSignatureQuerySupporter.class);
        try {
            signature.add(queryService.onCreateAclSignature(project));
        }
        catch (Exception e) {
            logger.error("Fail to get acl signature: ", (Throwable)e);
            return "";
        }
        for (String table : tables) {
            TableDesc tableDesc = tableManager.getTableDesc(table);
            if (tableDesc == null) {
                return "";
            }
            signature.add(String.valueOf(tableDesc.getLastModified()));
        }
        if (modelAlias != null) {
            NDataModel modelDesc = modelManager.getDataModelDescByAlias(modelAlias);
            if (modelDesc == null) {
                return "";
            }
            signature.add(String.valueOf(modelDesc.getLastModified()));
        }
        return Joiner.on((String)",").join((Iterable)signature);
    }

    public static boolean checkCacheExpired(SQLResponse sqlResponse, String project) {
        String signature = sqlResponse.getSignature();
        if (StringUtils.isBlank((CharSequence)signature)) {
            return true;
        }
        if (signature.split(",").length != sqlResponse.getNativeRealizations().size() + 1) {
            return true;
        }
        String lastSignature = QueryCacheSignatureUtil.createCacheSignature(sqlResponse, project);
        if (!signature.equals(lastSignature)) {
            logger.info("[Signature Changed] old signature: [{}] new signature: [{}]", (Object)signature, (Object)lastSignature);
            return true;
        }
        return false;
    }

    public static boolean checkCacheExpired(List<String> tables, String prevSignature, String project, String modelAlias) {
        if (StringUtils.isBlank((CharSequence)prevSignature)) {
            return true;
        }
        if (prevSignature.split(",").length != tables.size() + 1) {
            return true;
        }
        String currSignature = QueryCacheSignatureUtil.createCacheSignature(tables, project, modelAlias);
        return !prevSignature.equals(currSignature);
    }

    private static String generateSignature(NativeQueryRealization realization, String project, long sqlDuration) {
        try {
            return QueryCacheSignatureUtil.signature(realization, project, sqlDuration);
        }
        catch (NullPointerException e) {
            logger.warn("NPE occurred because metadata changed during query.", (Throwable)e);
            return "";
        }
    }

    private static String signature(NativeQueryRealization realization, String project, long sqlDuration) {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String realizationType = realization.getType();
        if ("Table Snapshot".equals(realizationType)) {
            return QueryCacheSignatureUtil.processSnapshot(realization, project, kylinConfig);
        }
        if ("Internal Table".equals(realizationType)) {
            return QueryCacheSignatureUtil.processInternalTable(realization, project, kylinConfig);
        }
        return QueryCacheSignatureUtil.processIndex(realization, project, kylinConfig, sqlDuration);
    }

    private static String processSnapshot(NativeQueryRealization realization, String project, KylinConfig kylinConfig) {
        ArrayList<Long> timeOfSnapshots = new ArrayList<Long>();
        NTableMetadataManager tableMgr = NTableMetadataManager.getInstance((KylinConfig)kylinConfig, (String)project);
        for (String lookup : realization.getLookupTables()) {
            long lastModified = tableMgr.getTableDesc(lookup).getLastModified();
            if (lastModified == 0L) {
                timeOfSnapshots.clear();
                break;
            }
            timeOfSnapshots.add(lastModified);
        }
        return timeOfSnapshots.isEmpty() ? "" : "0;" + Joiner.on((String)"_").join(timeOfSnapshots);
    }

    private static String processInternalTable(NativeQueryRealization realization, String project, KylinConfig kylinConfig) {
        ArrayList<Long> timeOfInternalTable = new ArrayList<Long>();
        InternalTableManager internalTableManager = InternalTableManager.getInstance((KylinConfig)kylinConfig, (String)project);
        for (String internalTable : realization.getLookupTables()) {
            long lastModified = internalTableManager.getInternalTableDesc(internalTable).getLastModified();
            if (lastModified == 0L) {
                timeOfInternalTable.clear();
                break;
            }
            timeOfInternalTable.add(lastModified);
        }
        return timeOfInternalTable.isEmpty() ? "" : "1;" + Joiner.on((String)"_").join(timeOfInternalTable);
    }

    private static String processIndex(NativeQueryRealization realization, String project, KylinConfig kylinConfig, long sqlDuration) {
        LinkedList allLayoutTimes = Lists.newLinkedList();
        LinkedList allSegmentTimes = Lists.newLinkedList();
        NDataflow df = NDataflowManager.getInstance((KylinConfig)kylinConfig, (String)project).getDataflow(realization.getModelId());
        if (df != null && !df.isOffline()) {
            for (NDataSegment seg : df.getSegments(new SegmentStatusEnum[]{SegmentStatusEnum.READY, SegmentStatusEnum.WARNING})) {
                long now = System.currentTimeMillis();
                long latestTime = seg.getSegDetails().getLastModified();
                if (latestTime <= now && latestTime >= now - sqlDuration) {
                    return "";
                }
                allSegmentTimes.add(latestTime);
                Long layoutId = realization.getLayoutId();
                if (!seg.getLayoutIds().contains(layoutId)) continue;
                allLayoutTimes.add(seg.getLayout(layoutId.longValue()).getCreateTime());
            }
            String layoutSignatures = Joiner.on((String)"_").join((Iterable)allLayoutTimes);
            String segSignatures = Joiner.on((String)"_").join((Iterable)allSegmentTimes);
            String tableSignatures = df.getModel().getAllTableRefs().stream().map(TableRef::getTableDesc).map(RootPersistentEntity::getLastModified).map(String::valueOf).collect(Collectors.joining("_"));
            return "2;" + Joiner.on((String)";").join((Object)layoutSignatures, (Object)tableSignatures, new Object[]{segSignatures});
        }
        return "";
    }

    @Generated
    public static CacheSignatureQuerySupporter getQueryService() {
        return queryService;
    }
}

