/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.FileNotFoundException;
import java.io.Serializable;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileAlreadyExistsException;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapred.JobConf;
import org.apache.hadoop.mapred.TaskAttemptContextImpl;
import org.apache.hadoop.mapred.TaskAttemptID;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.TaskAttemptContext;
import org.apache.hadoop.mapreduce.TaskType;
import org.apache.spark.internal.Logging;
import org.apache.spark.rdd.RDD;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.InternalRow;
import org.apache.spark.sql.delta.CheckpointMetaData;
import org.apache.spark.sql.delta.CheckpointMetaData$;
import org.apache.spark.sql.delta.CheckpointV2$;
import org.apache.spark.sql.delta.DeltaConfigs$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.SerializableFileStatus;
import org.apache.spark.sql.delta.SerializableFileStatus$;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.SingleAction$;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.delta.util.FileNames$;
import org.apache.spark.sql.delta.util.JsonUtils$;
import org.apache.spark.sql.execution.QueryExecution;
import org.apache.spark.sql.execution.SQLExecution$;
import org.apache.spark.sql.execution.datasources.OutputWriter;
import org.apache.spark.sql.execution.datasources.OutputWriterFactory;
import org.apache.spark.sql.execution.datasources.parquet.ParquetFileFormat;
import org.apache.spark.sql.functions$;
import org.apache.spark.sql.internal.SQLConf;
import org.apache.spark.sql.types.StructType;
import org.apache.spark.util.LongAccumulator;
import org.apache.spark.util.SerializableConfiguration;
import org.slf4j.Logger;
import scala.Array$;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.GenTraversableOnce;
import scala.collection.Iterator;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayBuffer;
import scala.collection.mutable.ArrayOps;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ManifestFactory$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.java8.JFunction0;
import scala.runtime.java8.JFunction1;
import scala.util.control.NonFatal$;

public final class Checkpoints$
implements DeltaLogging {
    public static Checkpoints$ MODULE$;
    private final String LAST_CHECKPOINT_FILE_NAME;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new Checkpoints$();
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public String LAST_CHECKPOINT_FILE_NAME() {
        return this.LAST_CHECKPOINT_FILE_NAME;
    }

    public Option<StructType> checkpointSchemaToWriteInLastCheckpointFile(SparkSession spark, StructType schema) {
        int checkpointSchemaSizeThreshold = BoxesRunTime.unboxToInt((Object)spark.sessionState().conf().getConf(DeltaSQLConf$.MODULE$.CHECKPOINT_SCHEMA_WRITE_THRESHOLD_LENGTH()));
        return new Some((Object)schema).filter((Function1 & Serializable & scala.Serializable)s -> BoxesRunTime.boxToBoolean((boolean)Checkpoints$.$anonfun$checkpointSchemaToWriteInLastCheckpointFile$1(checkpointSchemaSizeThreshold, s)));
    }

    public CheckpointMetaData writeCheckpoint(SparkSession spark, DeltaLog deltaLog, Snapshot snapshot) {
        return (CheckpointMetaData)this.recordFrameProfile("Delta", "Checkpoints.writeCheckpoint", (Function0 & Serializable & scala.Serializable)() -> {
            List list;
            Configuration hadoopConf = deltaLog.newDeltaHadoopConf();
            boolean useRename = deltaLog.store().isPartialWriteVisible(deltaLog.logPath(), hadoopConf);
            LongAccumulator checkpointRowCount = spark.sparkContext().longAccumulator("checkpointRowCount");
            LongAccumulator numOfFiles = spark.sparkContext().longAccumulator("numOfFiles");
            SQLConf sessionConf = spark.sessionState().conf();
            Option checkpointPartSize = sessionConf.getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKPOINT_PART_SIZE());
            long numParts = BoxesRunTime.unboxToLong((Object)checkpointPartSize.map((Function1)(JFunction1.mcJJ.sp & Serializable & scala.Serializable)partSize -> (long)package$.MODULE$.ceil((double)(snapshot.numOfFiles() + snapshot.numOfRemoves()) / (double)partSize)).getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 1L));
            if (numParts > 1L) {
                list = FileNames$.MODULE$.checkpointFileWithParts(snapshot.path(), snapshot.version(), (int)numParts);
            } else {
                Path path = FileNames$.MODULE$.checkpointFileSingular(snapshot.path(), snapshot.version());
                list = Nil$.MODULE$.$colon$colon((Object)path);
            }
            List checkpointPaths = list;
            None$ numPartsOption = numParts > 1L ? new Some((Object)BoxesRunTime.boxToInteger((int)checkpointPaths.length())) : None$.MODULE$;
            Seq paths = (Seq)checkpointPaths.map((Function1 & Serializable & scala.Serializable)x$9 -> x$9.toString(), Seq$.MODULE$.canBuildFrom());
            Dataset base = snapshot.stateDS().repartition(paths.length(), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.coalesce((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Column[]{functions$.MODULE$.col("add.path"), functions$.MODULE$.col("remove.path")}))})).map((Function1 & Serializable & scala.Serializable)action -> {
                block0: {
                    if (action.add() == null) break block0;
                    numOfFiles.add(1L);
                }
                return action;
            }, SingleAction$.MODULE$.encoder()).drop((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"commitInfo", "cdc"})).withColumn("remove", functions$.MODULE$.col("remove").dropFields((Seq)Predef$.MODULE$.wrapRefArray((Object[])new String[]{"tags"})));
            Dataset<Row> chk = MODULE$.buildCheckpoint((Dataset<Row>)base, snapshot);
            StructType schema = chk.schema().asNullable();
            ParquetFileFormat format = new ParquetFileFormat();
            Job job = Job.getInstance((Configuration)hadoopConf);
            Tuple2 tuple2 = new Tuple2((Object)format.prepareWrite(spark, job, Predef$.MODULE$.Map().empty(), schema), (Object)new SerializableConfiguration(job.getConfiguration()));
            if (tuple2 == null) {
                throw new MatchError((Object)tuple2);
            }
            OutputWriterFactory factory = (OutputWriterFactory)tuple2._1();
            SerializableConfiguration serConf = (SerializableConfiguration)tuple2._2();
            Tuple2 tuple22 = new Tuple2((Object)factory, (Object)serConf);
            Tuple2 tuple23 = tuple22;
            OutputWriterFactory factory2 = (OutputWriterFactory)tuple23._1();
            SerializableConfiguration serConf2 = (SerializableConfiguration)tuple23._2();
            QueryExecution qe = chk.queryExecution();
            SerializableFileStatus[] finalCheckpointFiles = (SerializableFileStatus[])SQLExecution$.MODULE$.withNewExecutionId(qe, (Option)new Some((Object)"Delta checkpoint"), (Function0 & Serializable & scala.Serializable)() -> Checkpoints$.executeFinalCheckpointFiles$1(qe, paths, useRename, serConf2, factory2, schema, checkpointRowCount));
            long checkpointSizeInBytes = BoxesRunTime.unboxToLong((Object)new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps((long[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])finalCheckpointFiles)).map((Function1 & Serializable & scala.Serializable)x$11 -> BoxesRunTime.boxToLong((long)x$11.length()), Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.Long())))).sum((Numeric)Numeric.LongIsIntegral$.MODULE$));
            if (!BoxesRunTime.equalsNumObject((Number)numOfFiles.value(), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles()))) {
                throw DeltaErrors$.MODULE$.checkpointMismatchWithSnapshot();
            }
            if (BoxesRunTime.equalsNumObject((Number)checkpointRowCount.value(), (Object)BoxesRunTime.boxToInteger((int)0))) {
                MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> DeltaErrors$.MODULE$.EmptyCheckpointErrorMessage());
            }
            return new CheckpointMetaData(snapshot.version(), Predef$.MODULE$.Long2long(checkpointRowCount.value()), (Option<Object>)numPartsOption, (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)checkpointSizeInBytes)), (Option<Object>)new Some((Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles())), MODULE$.checkpointSchemaToWriteInLastCheckpointFile(spark, schema), CheckpointMetaData$.MODULE$.apply$default$7());
        });
    }

    public void renameAndCleanupTempPartFile(Path tempPath, Path finalPath, FileSystem fs) {
        boolean renameSuccessful;
        boolean bl;
        try {
            bl = !fs.exists(finalPath) && fs.rename(tempPath, finalPath);
        }
        catch (FileAlreadyExistsException fileAlreadyExistsException) {
            bl = renameSuccessful = false;
        }
        if (!renameSuccessful) {
            try {
                fs.delete(tempPath, false);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                Option option = NonFatal$.MODULE$.unapply(throwable2);
                if (!option.isEmpty()) {
                    Throwable e = (Throwable)option.get();
                    this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(56).append("Error while deleting the temporary checkpoint part file ").append(tempPath).toString(), e);
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
                throw throwable;
            }
        }
    }

    public boolean isGCSPath(Configuration hadoopConf, Path path) {
        String scheme = path.toUri().getScheme();
        return scheme != null ? scheme.equalsIgnoreCase("gs") : path.getFileSystem(hadoopConf).getScheme().equalsIgnoreCase("gs");
    }

    public Dataset<Row> buildCheckpoint(Dataset<Row> state, Snapshot snapshot) {
        BoxedUnit boxedUnit;
        ArrayBuffer additionalCols = new ArrayBuffer();
        SQLConf sessionConf = state.sparkSession().sessionState().conf();
        Object object = this.shouldWriteStatsAsJson(snapshot) ? additionalCols.$plus$eq((Object)functions$.MODULE$.col("add.stats").as("stats")) : BoxedUnit.UNIT;
        boolean includeStructColumns = this.shouldWriteStatsAsStruct(sessionConf, snapshot);
        if (includeStructColumns) {
            Option<Column> partitionValues = CheckpointV2$.MODULE$.extractPartitionValues(snapshot.metadata().partitionSchema(), "add.partitionValues");
            boxedUnit = additionalCols.$plus$plus$eq((TraversableOnce)Option$.MODULE$.option2Iterable(partitionValues));
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return state.withColumn("add", functions$.MODULE$.when(functions$.MODULE$.col("add").isNotNull(), (Object)functions$.MODULE$.struct((Seq)((TraversableLike)new .colon.colon((Object)functions$.MODULE$.col("add.path"), (List)new .colon.colon((Object)functions$.MODULE$.col("add.partitionValues"), (List)new .colon.colon((Object)functions$.MODULE$.col("add.size"), (List)new .colon.colon((Object)functions$.MODULE$.col("add.modificationTime"), (List)new .colon.colon((Object)functions$.MODULE$.col("add.dataChange"), (List)new .colon.colon((Object)functions$.MODULE$.col("add.tags"), (List)new .colon.colon((Object)functions$.MODULE$.col("add.deletionVector"), (List)Nil$.MODULE$)))))))).$plus$plus((GenTraversableOnce)additionalCols, Seq$.MODULE$.canBuildFrom()))));
    }

    public boolean shouldWriteStatsAsStruct(SQLConf conf, Snapshot snapshot) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHECKPOINT_WRITE_STATS_AS_STRUCT().fromMetaData(snapshot.metadata()).getOrElse((Function0)(JFunction0.mcZ.sp & Serializable & scala.Serializable)() -> BoxesRunTime.unboxToBoolean((Object)conf.getConf(DeltaSQLConf$.MODULE$.DELTA_CHECKPOINT_V2_ENABLED()))));
    }

    public boolean shouldWriteStatsAsJson(Snapshot snapshot) {
        return BoxesRunTime.unboxToBoolean((Object)DeltaConfigs$.MODULE$.CHECKPOINT_WRITE_STATS_AS_JSON().fromMetaData(snapshot.metadata()));
    }

    public static final /* synthetic */ boolean $anonfun$checkpointSchemaToWriteInLastCheckpointFile$1(int checkpointSchemaSizeThreshold$1, StructType s) {
        return JsonUtils$.MODULE$.toJson(s, ManifestFactory$.MODULE$.classType(StructType.class)).length() <= checkpointSchemaSizeThreshold$1;
    }

    public static final /* synthetic */ void $anonfun$writeCheckpoint$8(LongAccumulator checkpointRowCount$1, OutputWriter writer$1, InternalRow row) {
        checkpointRowCount$1.add(1L);
        writer$1.write(row);
    }

    public static final /* synthetic */ Iterator $anonfun$writeCheckpoint$6(Seq paths$1, boolean useRename$1, SerializableConfiguration serConf$1, OutputWriterFactory factory$1, StructType schema$1, LongAccumulator checkpointRowCount$1, int x0$1, Iterator x1$1) {
        FileStatus fileStatus;
        Tuple2 tuple2 = new Tuple2((Object)BoxesRunTime.boxToInteger((int)x0$1), (Object)x1$1);
        if (tuple2 != null) {
            Object object;
            Path path;
            int index = tuple2._1$mcI$sp();
            Iterator iter = (Iterator)tuple2._2();
            Path finalPath = new Path((String)paths$1.apply(index));
            if (useRename$1) {
                Path tempPath = new Path(finalPath.getParent(), new StringBuilder(6).append(".").append(finalPath.getName()).append(".").append(UUID.randomUUID()).append(".tmp").toString());
                DeltaFileOperations$.MODULE$.registerTempFileDeletionTaskFailureListener(serConf$1.value(), tempPath);
                path = tempPath;
            } else {
                path = finalPath;
            }
            Path writtenPath = path;
            FileSystem fs = writtenPath.getFileSystem(serConf$1.value());
            JFunction0.mcV.sp & Serializable & scala.Serializable writeAction = (JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
                try {
                    OutputWriter writer = factory$1.newInstance(writtenPath.toString(), schema$1, (TaskAttemptContext)new TaskAttemptContextImpl(new JobConf(serConf$1.value()), new TaskAttemptID("", 0, TaskType.REDUCE, 0, 0)));
                    iter.foreach((Function1 & Serializable & scala.Serializable)row -> {
                        Checkpoints$.$anonfun$writeCheckpoint$8(checkpointRowCount$1, writer, row);
                        return BoxedUnit.UNIT;
                    });
                    writer.close();
                }
                catch (Throwable throwable) {
                    Throwable throwable2 = throwable;
                    if (throwable2 instanceof FileAlreadyExistsException) {
                        FileAlreadyExistsException fileAlreadyExistsException = (FileAlreadyExistsException)throwable2;
                        if (!useRename$1) {
                            if (!fs.exists(writtenPath)) {
                                throw fileAlreadyExistsException;
                            }
                            BoxedUnit boxedUnit = BoxedUnit.UNIT;
                        }
                    }
                    throw throwable;
                }
            };
            if (MODULE$.isGCSPath(serConf$1.value(), writtenPath)) {
                object = DeltaFileOperations$.MODULE$.runInNewThread("delta-gcs-checkpoint-write", DeltaFileOperations$.MODULE$.runInNewThread$default$2(), writeAction);
            } else {
                writeAction.apply$mcV$sp();
                object = BoxedUnit.UNIT;
            }
            if (useRename$1) {
                MODULE$.renameAndCleanupTempPartFile(writtenPath, finalPath, fs);
            }
            try {
                fileStatus = fs.getFileStatus(finalPath);
            }
            catch (Throwable throwable) {
                Throwable throwable2 = throwable;
                if (throwable2 instanceof FileNotFoundException && useRename$1) {
                    throw DeltaErrors$.MODULE$.failOnCheckpointRename(writtenPath, finalPath);
                }
                throw throwable;
            }
        } else {
            throw new MatchError((Object)tuple2);
        }
        FileStatus finalPathFileStatus = fileStatus;
        Iterator iterator = scala.package$.MODULE$.Iterator().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new SerializableFileStatus[]{SerializableFileStatus$.MODULE$.fromStatus(finalPathFileStatus)}));
        return iterator;
    }

    private static final SerializableFileStatus[] executeFinalCheckpointFiles$1(QueryExecution qe$1, Seq paths$1, boolean useRename$1, SerializableConfiguration serConf$1, OutputWriterFactory factory$1, StructType schema$1, LongAccumulator checkpointRowCount$1) {
        RDD qual$1 = qe$1.executedPlan().execute();
        Function2 & Serializable & scala.Serializable x$1 = (Function2 & Serializable & scala.Serializable)(x0$1, x1$1) -> Checkpoints$.$anonfun$writeCheckpoint$6(paths$1, useRename$1, serConf$1, factory$1, schema$1, checkpointRowCount$1, BoxesRunTime.unboxToInt((Object)x0$1), x1$1);
        boolean x$2 = qual$1.mapPartitionsWithIndex$default$2();
        return (SerializableFileStatus[])qual$1.mapPartitionsWithIndex((Function2)x$1, x$2, ClassTag$.MODULE$.apply(SerializableFileStatus.class)).collect();
    }

    private Checkpoints$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        this.LAST_CHECKPOINT_FILE_NAME = "_last_checkpoint";
    }
}

