/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.commands;

import com.databricks.spark.util.DatabricksLogging;
import com.databricks.spark.util.MetricDefinition;
import com.databricks.spark.util.OpType;
import com.databricks.spark.util.TagDefinition;
import java.io.Serializable;
import java.sql.Timestamp;
import java.time.ZoneId;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.spark.broadcast.Broadcast;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.Row$;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.catalyst.TableIdentifier;
import org.apache.spark.sql.catalyst.analysis.Analyzer;
import org.apache.spark.sql.catalyst.expressions.Attribute;
import org.apache.spark.sql.catalyst.expressions.AttributeSet;
import org.apache.spark.sql.catalyst.expressions.Expression;
import org.apache.spark.sql.catalyst.expressions.Literal$;
import org.apache.spark.sql.catalyst.plans.logical.Command;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.catalyst.plans.logical.Statistics;
import org.apache.spark.sql.catalyst.trees.LeafLike;
import org.apache.spark.sql.catalyst.trees.TreeNode;
import org.apache.spark.sql.catalyst.util.DateTimeUtils$;
import org.apache.spark.sql.delta.DeltaErrors$;
import org.apache.spark.sql.delta.DeltaLog;
import org.apache.spark.sql.delta.DeltaOperations;
import org.apache.spark.sql.delta.DeltaOptions;
import org.apache.spark.sql.delta.DeltaTimeTravelSpec;
import org.apache.spark.sql.delta.OptimisticTransaction;
import org.apache.spark.sql.delta.Snapshot;
import org.apache.spark.sql.delta.actions.Action;
import org.apache.spark.sql.delta.actions.AddFile;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.actions.Protocol;
import org.apache.spark.sql.delta.actions.RemoveFile;
import org.apache.spark.sql.delta.actions.SetTransaction;
import org.apache.spark.sql.delta.catalog.DeltaTableV2;
import org.apache.spark.sql.delta.commands.DeltaCommand;
import org.apache.spark.sql.delta.commands.RestoreTableCommand$;
import org.apache.spark.sql.delta.commands.RestoreTableCommandBase;
import org.apache.spark.sql.delta.metering.DeltaLogging;
import org.apache.spark.sql.delta.sources.DeltaSQLConf$;
import org.apache.spark.sql.delta.util.DeltaFileOperations$;
import org.apache.spark.sql.delta.util.DeltaProgressReporter;
import org.apache.spark.sql.execution.command.LeafRunnableCommand;
import org.apache.spark.sql.execution.command.RunnableCommand;
import org.apache.spark.sql.execution.datasources.HadoopFsRelation;
import org.apache.spark.sql.execution.metric.SQLMetric;
import org.apache.spark.sql.internal.SQLConf$;
import org.apache.spark.unsafe.types.UTF8String;
import org.apache.spark.util.SerializableConfiguration;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Option;
import scala.Predef;
import scala.Predef$;
import scala.Product;
import scala.Some;
import scala.Tuple2;
import scala.collection.IndexedSeq;
import scala.collection.Iterator;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Map;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.reflect.api.JavaUniverse;
import scala.reflect.api.Mirror;
import scala.reflect.api.Symbols;
import scala.reflect.api.TypeCreator;
import scala.reflect.api.TypeTags;
import scala.reflect.api.Types;
import scala.reflect.api.Universe;
import scala.reflect.runtime.package$;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.java8.JFunction0;
import scala.util.Success;
import scala.util.Try;
import scala.util.Try$;

@ScalaSignature(bytes="\u0006\u0001\tuc\u0001B\u0010!\u00016B\u0001\u0002\u0015\u0001\u0003\u0016\u0004%\t!\u0015\u0005\t1\u0002\u0011\t\u0012)A\u0005%\"A\u0011\f\u0001BK\u0002\u0013\u0005!\f\u0003\u0005`\u0001\tE\t\u0015!\u0003\\\u0011\u0015\u0001\u0007\u0001\"\u0001b\u0011\u001d)\u0007A1A\u0005B\u0019Da!\u001f\u0001!\u0002\u00139\u0007\"\u0002>\u0001\t\u0003Z\bbBA\u0006\u0001\u0011%\u0011Q\u0002\u0005\b\u0003\u000f\u0002A\u0011BA%\u0011\u001d\t\u0019\u0007\u0001C\u0005\u0003KBq!!)\u0001\t\u0013\t\u0019\u000bC\u0004\u0002>\u0002!I!a0\t\u0013\u0005\u0005\u0007!!A\u0005\u0002\u0005\r\u0007\"CAe\u0001E\u0005I\u0011AAf\u0011%\t\t\u000fAI\u0001\n\u0003\t\u0019\u000fC\u0005\u0002h\u0002\t\t\u0011\"\u0011\u0002j\"I\u0011Q\u001f\u0001\u0002\u0002\u0013\u0005\u0011q\u001f\u0005\n\u0003\u007f\u0004\u0011\u0011!C\u0001\u0005\u0003A\u0011Ba\u0002\u0001\u0003\u0003%\tE!\u0003\t\u0013\t]\u0001!!A\u0005\u0002\te\u0001\"\u0003B\u0012\u0001\u0005\u0005I\u0011\tB\u0013\u000f\u001d\u0011I\u0003\tE\u0001\u0005W1aa\b\u0011\t\u0002\t5\u0002B\u00021\u0019\t\u0003\u0011)\u0004C\u0005\u00038a\u0011\r\u0011\"\u0001\u0002j\"A!\u0011\b\r!\u0002\u0013\tY\u000fC\u0005\u0003<a\t\t\u0011\"!\u0003>!I!1\t\r\u0002\u0002\u0013\u0005%Q\t\u0005\n\u0005'B\u0012\u0011!C\u0005\u0005+\u00121CU3ti>\u0014X\rV1cY\u0016\u001cu.\\7b]\u0012T!!\t\u0012\u0002\u0011\r|W.\\1oINT!a\t\u0013\u0002\u000b\u0011,G\u000e^1\u000b\u0005\u00152\u0013aA:rY*\u0011q\u0005K\u0001\u0006gB\f'o\u001b\u0006\u0003S)\na!\u00199bG\",'\"A\u0016\u0002\u0007=\u0014xm\u0001\u0001\u0014\u000f\u0001q\u0003\b\u0011#H\u001bB\u0011qFN\u0007\u0002a)\u0011\u0011GM\u0001\bY><\u0017nY1m\u0015\t\u0019D'A\u0003qY\u0006t7O\u0003\u00026I\u0005A1-\u0019;bYf\u001cH/\u0003\u00028a\tYAj\\4jG\u0006d\u0007\u000b\\1o!\tId(D\u0001;\u0015\tYD(A\u0004d_6l\u0017M\u001c3\u000b\u0005u\"\u0013!C3yK\u000e,H/[8o\u0013\ty$HA\nMK\u00064'+\u001e8oC\ndWmQ8n[\u0006tG\r\u0005\u0002B\u00056\t\u0001%\u0003\u0002DA\taA)\u001a7uC\u000e{W.\\1oIB\u0011\u0011)R\u0005\u0003\r\u0002\u0012qCU3ti>\u0014X\rV1cY\u0016\u001cu.\\7b]\u0012\u0014\u0015m]3\u0011\u0005![U\"A%\u000b\u0003)\u000bQa]2bY\u0006L!\u0001T%\u0003\u000fA\u0013x\u000eZ;diB\u0011\u0001JT\u0005\u0003\u001f&\u0013AbU3sS\u0006d\u0017N_1cY\u0016\f1b]8ve\u000e,G+\u00192mKV\t!\u000b\u0005\u0002T-6\tAK\u0003\u0002VE\u000591-\u0019;bY><\u0017BA,U\u00051!U\r\u001c;b)\u0006\u0014G.\u001a,3\u00031\u0019x.\u001e:dKR\u000b'\r\\3!\u0003-!\u0018M]4fi&#WM\u001c;\u0016\u0003m\u0003\"\u0001X/\u000e\u0003QJ!A\u0018\u001b\u0003\u001fQ\u000b'\r\\3JI\u0016tG/\u001b4jKJ\fA\u0002^1sO\u0016$\u0018\nZ3oi\u0002\na\u0001P5oSRtDc\u00012dIB\u0011\u0011\t\u0001\u0005\u0006!\u0016\u0001\rA\u0015\u0005\u00063\u0016\u0001\raW\u0001\u0007_V$\b/\u001e;\u0016\u0003\u001d\u00042\u0001\u001b9t\u001d\tIgN\u0004\u0002k[6\t1N\u0003\u0002mY\u00051AH]8pizJ\u0011AS\u0005\u0003_&\u000bq\u0001]1dW\u0006<W-\u0003\u0002re\n\u00191+Z9\u000b\u0005=L\u0005C\u0001;x\u001b\u0005)(B\u0001<5\u0003-)\u0007\u0010\u001d:fgNLwN\\:\n\u0005a,(!C!uiJL'-\u001e;f\u0003\u001dyW\u000f\u001e9vi\u0002\n1A];o)\ra\u00181\u0001\t\u0004QBl\bC\u0001@\u0000\u001b\u0005!\u0013bAA\u0001I\t\u0019!k\\<\t\r\u001dB\u0001\u0019AA\u0003!\rq\u0018qA\u0005\u0004\u0003\u0013!#\u0001D*qCJ\\7+Z:tS>t\u0017aD<ji\"$Um]2sSB$\u0018n\u001c8\u0016\t\u0005=\u0011q\u0003\u000b\u0005\u0003#\t\u0019\u0004\u0006\u0003\u0002\u0014\u0005%\u0002\u0003BA\u000b\u0003/a\u0001\u0001B\u0004\u0002\u001a%\u0011\r!a\u0007\u0003\u0003Q\u000bB!!\b\u0002$A\u0019\u0001*a\b\n\u0007\u0005\u0005\u0012JA\u0004O_RD\u0017N\\4\u0011\u0007!\u000b)#C\u0002\u0002(%\u00131!\u00118z\u0011!\tY#\u0003CA\u0002\u00055\u0012!\u00014\u0011\u000b!\u000by#a\u0005\n\u0007\u0005E\u0012J\u0001\u0005=Eft\u0017-\\3?\u0011\u001d\t)$\u0003a\u0001\u0003o\ta!Y2uS>t\u0007\u0003BA\u001d\u0003\u0003rA!a\u000f\u0002>A\u0011!.S\u0005\u0004\u0003\u007fI\u0015A\u0002)sK\u0012,g-\u0003\u0003\u0002D\u0005\u0015#AB*ue&twMC\u0002\u0002@%\u000bq\u0002]1sg\u0016\u001cFO]5oOR{Gk\u001d\u000b\u0005\u0003\u0017\nI\u0006\u0005\u0003\u0002N\u0005USBAA(\u0015\r)\u0013\u0011\u000b\u0006\u0003\u0003'\nAA[1wC&!\u0011qKA(\u0005%!\u0016.\\3ti\u0006l\u0007\u000fC\u0004\u0002\\)\u0001\r!!\u0018\u0002\u0013QLW.Z:uC6\u0004\b#\u0002%\u0002`\u0005]\u0012bAA1\u0013\n1q\n\u001d;j_:\fabY8naV$X-T3ue&\u001c7\u000f\u0006\u0005\u0002h\u0005M\u0014\u0011RAK!!\tI$!\u001b\u00028\u00055\u0014\u0002BA6\u0003\u000b\u00121!T1q!\rA\u0015qN\u0005\u0004\u0003cJ%\u0001\u0002'p]\u001eDq!!\u001e\f\u0001\u0004\t9(A\u0003u_\u0006#G\rE\u0003\u007f\u0003s\ni(C\u0002\u0002|\u0011\u0012q\u0001R1uCN,G\u000f\u0005\u0003\u0002\u0000\u0005\u0015UBAAA\u0015\r\t\u0019II\u0001\bC\u000e$\u0018n\u001c8t\u0013\u0011\t9)!!\u0003\u000f\u0005#GMR5mK\"9\u00111R\u0006A\u0002\u00055\u0015\u0001\u0003;p%\u0016lwN^3\u0011\u000by\fI(a$\u0011\t\u0005}\u0014\u0011S\u0005\u0005\u0003'\u000b\tI\u0001\u0006SK6|g/\u001a$jY\u0016Dq!a&\f\u0001\u0004\tI*\u0001\u0005t]\u0006\u00048\u000f[8u!\u0011\tY*!(\u000e\u0003\tJ1!a(#\u0005!\u0019f.\u00199tQ>$\u0018AH2iK\u000e\\7K\\1qg\"|GOR5mKN\fe/Y5mC\nLG.\u001b;z)!\t)+a+\u00026\u0006e\u0006c\u0001%\u0002(&\u0019\u0011\u0011V%\u0003\tUs\u0017\u000e\u001e\u0005\b\u0003[c\u0001\u0019AAX\u0003!!W\r\u001c;b\u0019><\u0007\u0003BAN\u0003cK1!a-#\u0005!!U\r\u001c;b\u0019><\u0007bBA\\\u0019\u0001\u0007\u0011qO\u0001\u0006M&dWm\u001d\u0005\b\u0003wc\u0001\u0019AA7\u0003\u001d1XM]:j_:\fAbZ3u)&lWm\u001d;b[B$\"!!\u0018\u0002\t\r|\u0007/\u001f\u000b\u0006E\u0006\u0015\u0017q\u0019\u0005\b!:\u0001\n\u00111\u0001S\u0011\u001dIf\u0002%AA\u0002m\u000babY8qs\u0012\"WMZ1vYR$\u0013'\u0006\u0002\u0002N*\u001a!+a4,\u0005\u0005E\u0007\u0003BAj\u0003;l!!!6\u000b\t\u0005]\u0017\u0011\\\u0001\nk:\u001c\u0007.Z2lK\u0012T1!a7J\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0003?\f)NA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\fabY8qs\u0012\"WMZ1vYR$#'\u0006\u0002\u0002f*\u001a1,a4\u0002\u001bA\u0014x\u000eZ;diB\u0013XMZ5y+\t\tY\u000f\u0005\u0003\u0002n\u0006MXBAAx\u0015\u0011\t\t0!\u0015\u0002\t1\fgnZ\u0005\u0005\u0003\u0007\ny/\u0001\u0007qe>$Wo\u0019;Be&$\u00180\u0006\u0002\u0002zB\u0019\u0001*a?\n\u0007\u0005u\u0018JA\u0002J]R\fa\u0002\u001d:pIV\u001cG/\u00127f[\u0016tG\u000f\u0006\u0003\u0002$\t\r\u0001\"\u0003B\u0003'\u0005\u0005\t\u0019AA}\u0003\rAH%M\u0001\u0010aJ|G-^2u\u0013R,'/\u0019;peV\u0011!1\u0002\t\u0007\u0005\u001b\u0011\u0019\"a\t\u000e\u0005\t=!b\u0001B\t\u0013\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\tU!q\u0002\u0002\t\u0013R,'/\u0019;pe\u0006A1-\u00198FcV\fG\u000e\u0006\u0003\u0003\u001c\t\u0005\u0002c\u0001%\u0003\u001e%\u0019!qD%\u0003\u000f\t{w\u000e\\3b]\"I!QA\u000b\u0002\u0002\u0003\u0007\u00111E\u0001\u0007KF,\u0018\r\\:\u0015\t\tm!q\u0005\u0005\n\u0005\u000b1\u0012\u0011!a\u0001\u0003G\t1CU3ti>\u0014X\rV1cY\u0016\u001cu.\\7b]\u0012\u0004\"!\u0011\r\u0014\ta\u0011y#\u0014\t\u0004\u0011\nE\u0012b\u0001B\u001a\u0013\n1\u0011I\\=SK\u001a$\"Aa\u000b\u0002\u000f=\u0003vLT!N\u000b\u0006Aq\nU0O\u00036+\u0005%A\u0003baBd\u0017\u0010F\u0003c\u0005\u007f\u0011\t\u0005C\u0003Q9\u0001\u0007!\u000bC\u0003Z9\u0001\u00071,A\u0004v]\u0006\u0004\b\u000f\\=\u0015\t\t\u001d#q\n\t\u0006\u0011\u0006}#\u0011\n\t\u0006\u0011\n-#kW\u0005\u0004\u0005\u001bJ%A\u0002+va2,'\u0007\u0003\u0005\u0003Ru\t\t\u00111\u0001c\u0003\rAH\u0005M\u0001\fe\u0016\fGMU3t_24X\r\u0006\u0002\u0003XA!\u0011Q\u001eB-\u0013\u0011\u0011Y&a<\u0003\r=\u0013'.Z2u\u0001")
public class RestoreTableCommand
extends LogicalPlan
implements LeafRunnableCommand,
DeltaCommand,
RestoreTableCommandBase,
scala.Serializable {
    private final DeltaTableV2 sourceTable;
    private final TableIdentifier targetIdent;
    private final Seq<Attribute> output;
    private final String TABLE_SIZE_AFTER_RESTORE;
    private final String NUM_OF_FILES_AFTER_RESTORE;
    private final String NUM_REMOVED_FILES;
    private final String NUM_RESTORED_FILES;
    private final String REMOVED_FILES_SIZE;
    private final String RESTORED_FILES_SIZE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE;
    private final String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE;
    private final Seq<Attribute> outputSchema;
    private Map<String, SQLMetric> metrics;
    private final Seq<Enumeration.Value> nodePatterns;
    private volatile boolean bitmap$0;

    public static Option<Tuple2<DeltaTableV2, TableIdentifier>> unapply(RestoreTableCommand restoreTableCommand) {
        return RestoreTableCommand$.MODULE$.unapply(restoreTableCommand);
    }

    public static String OP_NAME() {
        return RestoreTableCommand$.MODULE$.OP_NAME();
    }

    @Override
    public Seq<Expression> parsePredicates(SparkSession spark, String predicate) {
        return DeltaCommand.parsePredicates$(this, spark, predicate);
    }

    @Override
    public void verifyPartitionPredicates(SparkSession spark, Seq<String> partitionColumns, Seq<Expression> predicates) {
        DeltaCommand.verifyPartitionPredicates$(this, spark, partitionColumns, predicates);
    }

    @Override
    public Map<String, AddFile> generateCandidateFileMap(Path basePath, Seq<AddFile> candidateFiles) {
        return DeltaCommand.generateCandidateFileMap$(this, basePath, candidateFiles);
    }

    @Override
    public Seq<RemoveFile> removeFilesFromPaths(DeltaLog deltaLog, Map<String, AddFile> nameToAddFileMap, Seq<String> filesToRewrite, long operationTimestamp) {
        return DeltaCommand.removeFilesFromPaths$(this, deltaLog, nameToAddFileMap, filesToRewrite, operationTimestamp);
    }

    @Override
    public HadoopFsRelation buildBaseRelation(SparkSession spark, OptimisticTransaction txn, String actionType, Path rootPath, Seq<String> inputLeafFiles, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.buildBaseRelation$(this, spark, txn, actionType, rootPath, inputLeafFiles, nameToAddFileMap);
    }

    @Override
    public AddFile getTouchedFile(Path basePath, String filePath, Map<String, AddFile> nameToAddFileMap) {
        return DeltaCommand.getTouchedFile$(this, basePath, filePath, nameToAddFileMap);
    }

    @Override
    public LogicalPlan resolveIdentifier(Analyzer analyzer, TableIdentifier identifier) {
        return DeltaCommand.resolveIdentifier$(this, analyzer, identifier);
    }

    @Override
    public boolean isCatalogTable(Analyzer analyzer, TableIdentifier tableIdent) {
        return DeltaCommand.isCatalogTable$(this, analyzer, tableIdent);
    }

    @Override
    public boolean isPathIdentifier(TableIdentifier tableIdent) {
        return DeltaCommand.isPathIdentifier$(this, tableIdent);
    }

    @Override
    public DeltaLog getDeltaLog(SparkSession spark, Option<String> path, Option<TableIdentifier> tableIdentifier, String operationName, Map<String, String> hadoopConf) {
        return DeltaCommand.getDeltaLog$(this, spark, path, tableIdentifier, operationName, hadoopConf);
    }

    @Override
    public Map<String, String> getDeltaLog$default$5() {
        return DeltaCommand.getDeltaLog$default$5$(this);
    }

    @Override
    public void sendDriverMetrics(SparkSession spark, Map<String, SQLMetric> metrics) {
        DeltaCommand.sendDriverMetrics$(this, spark, metrics);
    }

    @Override
    public boolean hasBeenExecuted(OptimisticTransaction txn, SparkSession sparkSession, Option<DeltaOptions> options) {
        return DeltaCommand.hasBeenExecuted$(this, txn, sparkSession, options);
    }

    @Override
    public Option<DeltaOptions> hasBeenExecuted$default$3() {
        return DeltaCommand.hasBeenExecuted$default$3$(this);
    }

    @Override
    public Option<SetTransaction> createSetTransaction(SparkSession sparkSession, DeltaLog deltaLog, Option<DeltaOptions> options) {
        return DeltaCommand.createSetTransaction$(this, sparkSession, deltaLog, options);
    }

    @Override
    public Option<DeltaOptions> createSetTransaction$default$3() {
        return DeltaCommand.createSetTransaction$default$3$(this);
    }

    @Override
    public void recordDeltaEvent(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Object data, Option<Path> path) {
        DeltaLogging.recordDeltaEvent$(this, deltaLog, opType, tags, data, path);
    }

    @Override
    public Map<TagDefinition, String> recordDeltaEvent$default$3() {
        return DeltaLogging.recordDeltaEvent$default$3$(this);
    }

    @Override
    public Object recordDeltaEvent$default$4() {
        return DeltaLogging.recordDeltaEvent$default$4$(this);
    }

    @Override
    public Option<Path> recordDeltaEvent$default$5() {
        return DeltaLogging.recordDeltaEvent$default$5$(this);
    }

    @Override
    public <A> A recordDeltaOperationForTablePath(String tablePath, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperationForTablePath$(this, tablePath, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperationForTablePath$default$3() {
        return DeltaLogging.recordDeltaOperationForTablePath$default$3$(this);
    }

    @Override
    public <A> A recordDeltaOperation(DeltaLog deltaLog, String opType, Map<TagDefinition, String> tags, Function0<A> thunk) {
        return (A)DeltaLogging.recordDeltaOperation$(this, deltaLog, opType, tags, thunk);
    }

    @Override
    public <A> Map<TagDefinition, String> recordDeltaOperation$default$3() {
        return DeltaLogging.recordDeltaOperation$default$3$(this);
    }

    @Override
    public <T> T recordFrameProfile(String group, String name, Function0<T> thunk) {
        return (T)DeltaLogging.recordFrameProfile$(this, group, name, thunk);
    }

    @Override
    public Map<TagDefinition, String> getCommonTags(DeltaLog deltaLog, String tahoeId) {
        return DeltaLogging.getCommonTags$(this, deltaLog, tahoeId);
    }

    @Override
    public void logConsole(String line) {
        DatabricksLogging.logConsole$(this, line);
    }

    @Override
    public void recordUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordUsage$default$3() {
        return DatabricksLogging.recordUsage$default$3$(this);
    }

    @Override
    public String recordUsage$default$4() {
        return DatabricksLogging.recordUsage$default$4$(this);
    }

    @Override
    public boolean recordUsage$default$5() {
        return DatabricksLogging.recordUsage$default$5$(this);
    }

    @Override
    public boolean recordUsage$default$6() {
        return DatabricksLogging.recordUsage$default$6$(this);
    }

    @Override
    public boolean recordUsage$default$7() {
        return DatabricksLogging.recordUsage$default$7$(this);
    }

    @Override
    public void recordEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordEvent$default$2() {
        return DatabricksLogging.recordEvent$default$2$(this);
    }

    @Override
    public String recordEvent$default$3() {
        return DatabricksLogging.recordEvent$default$3$(this);
    }

    @Override
    public boolean recordEvent$default$4() {
        return DatabricksLogging.recordEvent$default$4$(this);
    }

    @Override
    public <S> S recordOperation(OpType opType, String opTarget, Map<TagDefinition, String> extraTags, boolean isSynchronous, boolean alwaysRecordStats, boolean allowAuthTags, boolean killJvmIfStuck, MetricDefinition outputMetric, boolean silent, Function0<S> thunk) {
        return (S)DatabricksLogging.recordOperation$(this, opType, opTarget, extraTags, isSynchronous, alwaysRecordStats, allowAuthTags, killJvmIfStuck, outputMetric, silent, thunk);
    }

    @Override
    public <S> String recordOperation$default$2() {
        return DatabricksLogging.recordOperation$default$2$(this);
    }

    @Override
    public <S> boolean recordOperation$default$4() {
        return DatabricksLogging.recordOperation$default$4$(this);
    }

    @Override
    public <S> boolean recordOperation$default$5() {
        return DatabricksLogging.recordOperation$default$5$(this);
    }

    @Override
    public <S> boolean recordOperation$default$6() {
        return DatabricksLogging.recordOperation$default$6$(this);
    }

    @Override
    public <S> boolean recordOperation$default$7() {
        return DatabricksLogging.recordOperation$default$7$(this);
    }

    @Override
    public <S> MetricDefinition recordOperation$default$8() {
        return DatabricksLogging.recordOperation$default$8$(this);
    }

    @Override
    public <S> boolean recordOperation$default$9() {
        return DatabricksLogging.recordOperation$default$9$(this);
    }

    @Override
    public void recordProductUsage(MetricDefinition metric, double quantity, Map<TagDefinition, String> additionalTags, String blob, boolean forceSample, boolean trimBlob, boolean silent) {
        DatabricksLogging.recordProductUsage$(this, metric, quantity, additionalTags, blob, forceSample, trimBlob, silent);
    }

    @Override
    public Map<TagDefinition, String> recordProductUsage$default$3() {
        return DatabricksLogging.recordProductUsage$default$3$(this);
    }

    @Override
    public String recordProductUsage$default$4() {
        return DatabricksLogging.recordProductUsage$default$4$(this);
    }

    @Override
    public boolean recordProductUsage$default$5() {
        return DatabricksLogging.recordProductUsage$default$5$(this);
    }

    @Override
    public boolean recordProductUsage$default$6() {
        return DatabricksLogging.recordProductUsage$default$6$(this);
    }

    @Override
    public boolean recordProductUsage$default$7() {
        return DatabricksLogging.recordProductUsage$default$7$(this);
    }

    @Override
    public void recordProductEvent(MetricDefinition metric, Map<TagDefinition, String> additionalTags, String blob, boolean trimBlob) {
        DatabricksLogging.recordProductEvent$(this, metric, additionalTags, blob, trimBlob);
    }

    @Override
    public Map<TagDefinition, String> recordProductEvent$default$2() {
        return DatabricksLogging.recordProductEvent$default$2$(this);
    }

    @Override
    public String recordProductEvent$default$3() {
        return DatabricksLogging.recordProductEvent$default$3$(this);
    }

    @Override
    public boolean recordProductEvent$default$4() {
        return DatabricksLogging.recordProductEvent$default$4$(this);
    }

    @Override
    public <T> T withStatusCode(String statusCode, String defaultMessage, Map<String, Object> data, Function0<T> body) {
        return (T)DeltaProgressReporter.withStatusCode$(this, statusCode, defaultMessage, data, body);
    }

    @Override
    public <T> Map<String, Object> withStatusCode$default$3() {
        return DeltaProgressReporter.withStatusCode$default$3$(this);
    }

    public final Seq<LogicalPlan> children() {
        return LeafLike.children$((LeafLike)this);
    }

    public final TreeNode mapChildren(Function1 f) {
        return LeafLike.mapChildren$((LeafLike)this, (Function1)f);
    }

    public final TreeNode withNewChildrenInternal(IndexedSeq newChildren) {
        return LeafLike.withNewChildrenInternal$((LeafLike)this, (IndexedSeq)newChildren);
    }

    public AttributeSet producedAttributes() {
        return Command.producedAttributes$((Command)this);
    }

    public Statistics stats() {
        return Command.stats$((Command)this);
    }

    @Override
    public String TABLE_SIZE_AFTER_RESTORE() {
        return this.TABLE_SIZE_AFTER_RESTORE;
    }

    @Override
    public String NUM_OF_FILES_AFTER_RESTORE() {
        return this.NUM_OF_FILES_AFTER_RESTORE;
    }

    @Override
    public String NUM_REMOVED_FILES() {
        return this.NUM_REMOVED_FILES;
    }

    @Override
    public String NUM_RESTORED_FILES() {
        return this.NUM_RESTORED_FILES;
    }

    @Override
    public String REMOVED_FILES_SIZE() {
        return this.REMOVED_FILES_SIZE;
    }

    @Override
    public String RESTORED_FILES_SIZE() {
        return this.RESTORED_FILES_SIZE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE;
    }

    @Override
    public String org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE() {
        return this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE;
    }

    @Override
    public Seq<Attribute> outputSchema() {
        return this.outputSchema;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$TABLE_SIZE_AFTER_RESTORE_$eq(String x$1) {
        this.TABLE_SIZE_AFTER_RESTORE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_OF_FILES_AFTER_RESTORE_$eq(String x$1) {
        this.NUM_OF_FILES_AFTER_RESTORE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_REMOVED_FILES_$eq(String x$1) {
        this.NUM_REMOVED_FILES = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$NUM_RESTORED_FILES_$eq(String x$1) {
        this.NUM_RESTORED_FILES = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$REMOVED_FILES_SIZE_$eq(String x$1) {
        this.REMOVED_FILES_SIZE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$RESTORED_FILES_SIZE_$eq(String x$1) {
        this.RESTORED_FILES_SIZE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_TABLE_SIZE_AFTER_RESTORE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_OF_FILES_AFTER_RESTORE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_REMOVED_FILES = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_NUM_RESTORED_FILES = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_REMOVED_FILES_SIZE = x$1;
    }

    @Override
    public final void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE_$eq(String x$1) {
        this.org$apache$spark$sql$delta$commands$RestoreTableCommandBase$$COLUMN_RESTORED_FILES_SIZE = x$1;
    }

    @Override
    public void org$apache$spark$sql$delta$commands$RestoreTableCommandBase$_setter_$outputSchema_$eq(Seq<Attribute> x$1) {
        this.outputSchema = x$1;
    }

    private Map<String, SQLMetric> metrics$lzycompute() {
        RestoreTableCommand restoreTableCommand = this;
        synchronized (restoreTableCommand) {
            if (!this.bitmap$0) {
                this.metrics = RunnableCommand.metrics$((RunnableCommand)this);
                this.bitmap$0 = true;
            }
        }
        return this.metrics;
    }

    public Map<String, SQLMetric> metrics() {
        return !this.bitmap$0 ? this.metrics$lzycompute() : this.metrics;
    }

    public final Seq<Enumeration.Value> nodePatterns() {
        return this.nodePatterns;
    }

    public final void org$apache$spark$sql$catalyst$plans$logical$Command$_setter_$nodePatterns_$eq(Seq<Enumeration.Value> x$1) {
        this.nodePatterns = x$1;
    }

    public DeltaTableV2 sourceTable() {
        return this.sourceTable;
    }

    public TableIdentifier targetIdent() {
        return this.targetIdent;
    }

    public Seq<Attribute> output() {
        return this.output;
    }

    public Seq<Row> run(SparkSession spark) {
        DeltaLog deltaLog = this.sourceTable().deltaLog();
        Option<Object> version = ((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).version();
        Option<String> timestamp = this.getTimestamp();
        return (Seq)this.recordDeltaOperation(deltaLog, "delta.restore", this.recordDeltaOperation$default$3(), (Function0 & Serializable & scala.Serializable)() -> {
            Predef$.MODULE$.require(version.isEmpty() ^ timestamp.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "Either the version or timestamp should be provided for restore");
            long versionToRestore = BoxesRunTime.unboxToLong((Object)version.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> deltaLog.history().getActiveCommitAtTime(this.parseStringToTs(timestamp), true, deltaLog.history().getActiveCommitAtTime$default$3(), deltaLog.history().getActiveCommitAtTime$default$4()).version()));
            long latestVersion = deltaLog.update(deltaLog.update$default$1(), deltaLog.update$default$2()).version();
            Predef$.MODULE$.require(versionToRestore < latestVersion, (Function0 & Serializable & scala.Serializable)() -> new StringBuilder(66).append("Version to restore (").append(versionToRestore).append(")").append("should be less then last available version (").append(latestVersion).append(")").toString());
            return (Seq)deltaLog.withNewTransaction((Function1 & Serializable & scala.Serializable)txn -> {
                Snapshot latestSnapshot = txn.snapshot();
                Snapshot snapshotToRestore = deltaLog.getSnapshotAt(versionToRestore, deltaLog.getSnapshotAt$default$2());
                Dataset<AddFile> latestSnapshotFiles = latestSnapshot.allFiles();
                Dataset<AddFile> snapshotToRestoreFiles = snapshotToRestore.allFiles();
                Dataset filesToAdd = snapshotToRestoreFiles.join(latestSnapshotFiles, snapshotToRestoreFiles.apply("path").$eq$eq$eq((Object)latestSnapshotFiles.apply("path")), "left_anti").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder()).map((Function1 & Serializable & scala.Serializable)x$1 -> {
                    boolean x$12 = true;
                    String x$2 = x$1.copy$default$1();
                    Map<String, String> x$3 = x$1.copy$default$2();
                    long x$4 = x$1.copy$default$3();
                    long x$5 = x$1.copy$default$4();
                    String x$6 = x$1.copy$default$6();
                    Map<String, String> x$7 = x$1.copy$default$7();
                    DeletionVectorDescriptor x$8 = x$1.copy$default$8();
                    return x$1.copy(x$2, x$3, x$4, x$5, x$12, x$6, x$7, x$8);
                }, org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder());
                Dataset filesToRemove = latestSnapshotFiles.join(snapshotToRestoreFiles, latestSnapshotFiles.apply("path").$eq$eq$eq((Object)snapshotToRestoreFiles.apply("path")), "left_anti").as(org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder()).map((Function1 & Serializable & scala.Serializable)x$2 -> x$2.removeWithTimestamp(x$2.removeWithTimestamp$default$1(), x$2.removeWithTimestamp$default$2()), org.apache.spark.sql.delta.implicits.package$.MODULE$.removeFileEncoder());
                boolean ignoreMissingFiles = BoxesRunTime.unboxToBoolean((Object)spark.sessionState().conf().getConf(SQLConf$.MODULE$.IGNORE_MISSING_FILES()));
                if (!ignoreMissingFiles) {
                    this.checkSnapshotFilesAvailability(deltaLog, (Dataset<AddFile>)filesToAdd, versionToRestore);
                }
                Map metrics = (Map)this.withDescription("metrics", (Function0 & Serializable & scala.Serializable)() -> this.computeMetrics((Dataset<AddFile>)filesToAdd, (Dataset<RemoveFile>)filesToRemove, snapshotToRestore));
                Iterator addActions = (Iterator)this.withDescription("add actions", (Function0 & Serializable & scala.Serializable)() -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(filesToAdd.toLocalIterator()).asScala());
                Iterator removeActions = (Iterator)this.withDescription("remove actions", (Function0 & Serializable & scala.Serializable)() -> (Iterator)JavaConverters$.MODULE$.asScalaIteratorConverter(filesToRemove.toLocalIterator()).asScala());
                txn.updateMetadata(snapshotToRestore.metadata(), txn.updateMetadata$default$2());
                Protocol sourceProtocol = snapshotToRestore.protocol();
                Protocol targetProtocol = latestSnapshot.protocol();
                boolean protocolDowngradeAllowed = BoxesRunTime.unboxToBoolean((Object)this.conf().getConf(DeltaSQLConf$.MODULE$.RESTORE_TABLE_PROTOCOL_DOWNGRADE_ALLOWED()));
                Protocol newProtocol = protocolDowngradeAllowed ? sourceProtocol : sourceProtocol.merge((Seq<Protocol>)Predef$.MODULE$.wrapRefArray((Object[])new Protocol[]{targetProtocol}));
                txn.commitLarge(spark, (Iterator<Action>)scala.package$.MODULE$.Iterator().single((Object)newProtocol).$plus$plus((Function0 & Serializable & scala.Serializable)() -> addActions).$plus$plus((Function0 & Serializable & scala.Serializable)() -> removeActions), new DeltaOperations.Restore(version, timestamp), (Map<String, String>)Predef$.MODULE$.Map().empty(), (Map<String, String>)metrics.mapValues((Function1 & Serializable & scala.Serializable)x$3 -> RestoreTableCommand.$anonfun$run$13(BoxesRunTime.unboxToLong((Object)x$3))).toMap(Predef$.MODULE$.$conforms()));
                return (Seq)new .colon.colon((Object)Row$.MODULE$.apply((Seq)Predef$.MODULE$.genericWrapArray((Object)new Object[]{metrics.get((Object)this.TABLE_SIZE_AFTER_RESTORE()), metrics.get((Object)this.NUM_OF_FILES_AFTER_RESTORE()), metrics.get((Object)this.NUM_REMOVED_FILES()), metrics.get((Object)this.NUM_RESTORED_FILES()), metrics.get((Object)this.REMOVED_FILES_SIZE()), metrics.get((Object)this.RESTORED_FILES_SIZE())})), (List)Nil$.MODULE$);
            });
        });
    }

    private <T> T withDescription(String action, Function0<T> f) {
        return this.withStatusCode("DELTA", new StringBuilder(44).append("RestoreTableCommand: compute ").append(action).append("  (table path ").append(this.sourceTable().deltaLog().dataPath()).append(")").toString(), this.withStatusCode$default$3(), f);
    }

    private Timestamp parseStringToTs(Option<String> timestamp) {
        Success success;
        Option option;
        Try try_ = Try$.MODULE$.apply((Function0 & Serializable & scala.Serializable)() -> timestamp.flatMap((Function1 & Serializable & scala.Serializable)tsStr -> {
            ZoneId tz = DateTimeUtils$.MODULE$.getZoneId(SQLConf$.MODULE$.get().sessionLocalTimeZone());
            UTF8String utfStr = UTF8String.fromString((String)tsStr);
            return DateTimeUtils$.MODULE$.stringToTimestamp(utfStr, tz);
        }));
        if (!(try_ instanceof Success) || !((option = (Option)(success = (Success)try_).value()) instanceof Some)) {
            throw DeltaErrors$.MODULE$.timestampInvalid((Expression)Literal$.MODULE$.apply(timestamp.get()));
        }
        Some some = (Some)option;
        long tsMicroseconds = BoxesRunTime.unboxToLong((Object)some.value());
        Timestamp timestamp2 = new Timestamp(tsMicroseconds / 1000L);
        return timestamp2;
    }

    private Map<String, Object> computeMetrics(Dataset<AddFile> toAdd, Dataset<RemoveFile> toRemove, Snapshot snapshot) {
        JavaUniverse $u = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m = package$.MODULE$.universe().runtimeMirror(RestoreTableCommand.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1(RestoreTableCommand $outer) {
            }
        }
        Tuple2 tuple2 = (Tuple2)toAdd.agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"sum")})).as(toAdd.sparkSession().implicits().newProductEncoder(((TypeTags)$u).TypeTag().apply((Mirror)$m, (TypeCreator)new Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator5$1(null)))).head();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        long numRestoredFiles = tuple2._1$mcJ$sp();
        Option restoredFilesSize = (Option)tuple2._2();
        Tuple2 tuple22 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRestoredFiles), (Object)restoredFilesSize);
        Tuple2 tuple23 = tuple22;
        long numRestoredFiles2 = tuple23._1$mcJ$sp();
        Option restoredFilesSize2 = (Option)tuple23._2();
        JavaUniverse $u2 = package$.MODULE$.universe();
        JavaUniverse.JavaMirror $m2 = package$.MODULE$.universe().runtimeMirror(RestoreTableCommand.class.getClassLoader());
        public final class Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator6$1
        extends TypeCreator {
            public <U extends Universe> Types.TypeApi apply(Mirror<U> $m$untyped) {
                Universe $u = $m$untyped.universe();
                Mirror<U> $m = $m$untyped;
                return $u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Tuple2"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)new .colon.colon((Object)$u.internal().reificationSupport().TypeRef($u.internal().reificationSupport().ThisType($m.staticPackage("scala").asModule().moduleClass()), (Symbols.SymbolApi)$m.staticClass("scala.Option"), (List)new .colon.colon((Object)$m.staticClass("scala.Long").asType().toTypeConstructor(), (List)Nil$.MODULE$)), (List)Nil$.MODULE$)));
            }

            public Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator6$1(RestoreTableCommand $outer) {
            }
        }
        Tuple2 tuple24 = (Tuple2)toRemove.agg(Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"count"), (Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)"size"), (Object)"sum")})).as(toAdd.sparkSession().implicits().newProductEncoder(((TypeTags)$u2).TypeTag().apply((Mirror)$m2, (TypeCreator)new Org_apache_spark_sql_delta_commands_RestoreTableCommand$$typecreator6$1(null)))).head();
        if (tuple24 == null) {
            throw new MatchError((Object)tuple24);
        }
        long numRemovedFiles = tuple24._1$mcJ$sp();
        Option removedFilesSize = (Option)tuple24._2();
        Tuple2 tuple25 = new Tuple2((Object)BoxesRunTime.boxToLong((long)numRemovedFiles), (Object)removedFilesSize);
        Tuple2 tuple26 = tuple25;
        long numRemovedFiles2 = tuple26._1$mcJ$sp();
        Option removedFilesSize2 = (Option)tuple26._2();
        return (Map)Predef$.MODULE$.Map().apply((Seq)Predef$.MODULE$.wrapRefArray((Object[])new Tuple2[]{Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_RESTORED_FILES()), (Object)BoxesRunTime.boxToLong((long)numRestoredFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.RESTORED_FILES_SIZE()), restoredFilesSize2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_REMOVED_FILES()), (Object)BoxesRunTime.boxToLong((long)numRemovedFiles2)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.REMOVED_FILES_SIZE()), removedFilesSize2.getOrElse((Function0)(JFunction0.mcJ.sp & Serializable & scala.Serializable)() -> 0L)), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.NUM_OF_FILES_AFTER_RESTORE()), (Object)BoxesRunTime.boxToLong((long)snapshot.numOfFiles())), Predef.ArrowAssoc$.MODULE$.$minus$greater$extension(Predef$.MODULE$.ArrowAssoc((Object)this.TABLE_SIZE_AFTER_RESTORE()), (Object)BoxesRunTime.boxToLong((long)snapshot.sizeInBytes()))}));
    }

    private void checkSnapshotFilesAvailability(DeltaLog deltaLog, Dataset<AddFile> files, long version) {
        this.withDescription("missing files validation", (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> {
            Broadcast hadoopConf;
            SparkSession spark = files.sparkSession();
            String pathString = deltaLog.dataPath().toString();
            String[] missedFiles = (String[])files.mapPartitions(arg_0 -> RestoreTableCommand.$anonfun$checkSnapshotFilesAvailability$2(pathString, hadoopConf = spark.sparkContext().broadcast((Object)new SerializableConfiguration(deltaLog.newDeltaHadoopConf()), ClassTag$.MODULE$.apply(SerializableConfiguration.class)), arg_0), org.apache.spark.sql.delta.implicits.package$.MODULE$.addFileEncoder()).map((Function1 & Serializable & scala.Serializable)x$6 -> x$6.path(), org.apache.spark.sql.delta.implicits.package$.MODULE$.stringEncoder()).head(100);
            if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])missedFiles)).nonEmpty()) {
                throw DeltaErrors$.MODULE$.restoreMissedDataFilesError(missedFiles, version);
            }
        });
    }

    private Option<String> getTimestamp() {
        return ((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).timestamp().isDefined() ? new Some((Object)((DeltaTimeTravelSpec)this.sourceTable().timeTravelOpt().get()).getTimestamp(this.conf()).toString()) : None$.MODULE$;
    }

    public RestoreTableCommand copy(DeltaTableV2 sourceTable, TableIdentifier targetIdent) {
        return new RestoreTableCommand(sourceTable, targetIdent);
    }

    public DeltaTableV2 copy$default$1() {
        return this.sourceTable();
    }

    public TableIdentifier copy$default$2() {
        return this.targetIdent();
    }

    public String productPrefix() {
        return "RestoreTableCommand";
    }

    public int productArity() {
        return 2;
    }

    public Object productElement(int x$1) {
        DeltaTableV2 deltaTableV2;
        int n = x$1;
        switch (n) {
            case 0: {
                deltaTableV2 = this.sourceTable();
                break;
            }
            case 1: {
                deltaTableV2 = this.targetIdent();
                break;
            }
            default: {
                throw new IndexOutOfBoundsException(Integer.toString(x$1));
            }
        }
        return deltaTableV2;
    }

    public Iterator<Object> productIterator() {
        return ScalaRunTime$.MODULE$.typedProductIterator((Product)this);
    }

    public boolean canEqual(Object x$1) {
        return x$1 instanceof RestoreTableCommand;
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public boolean equals(Object x$1) {
        if (this == x$1) return true;
        Object object = x$1;
        if (!(object instanceof RestoreTableCommand)) return false;
        boolean bl = true;
        if (!bl) return false;
        RestoreTableCommand restoreTableCommand = (RestoreTableCommand)x$1;
        DeltaTableV2 deltaTableV2 = this.sourceTable();
        DeltaTableV2 deltaTableV22 = restoreTableCommand.sourceTable();
        if (deltaTableV2 == null) {
            if (deltaTableV22 != null) {
                return false;
            }
        } else if (!((Object)deltaTableV2).equals(deltaTableV22)) return false;
        TableIdentifier tableIdentifier = this.targetIdent();
        TableIdentifier tableIdentifier2 = restoreTableCommand.targetIdent();
        if (tableIdentifier == null) {
            if (tableIdentifier2 != null) {
                return false;
            }
        } else if (!tableIdentifier.equals(tableIdentifier2)) return false;
        if (!restoreTableCommand.canEqual(this)) return false;
        return true;
    }

    public static final /* synthetic */ String $anonfun$run$13(long x$3) {
        return Long.toString(x$3);
    }

    public static final /* synthetic */ Iterator $anonfun$checkSnapshotFilesAvailability$2(String pathString$1, Broadcast hadoopConf$1, Iterator files) {
        Path path = new Path(pathString$1);
        FileSystem fs = path.getFileSystem(((SerializableConfiguration)hadoopConf$1.value()).value());
        return files.filterNot((Function1 & Serializable & scala.Serializable)f -> BoxesRunTime.boxToBoolean((boolean)fs.exists(DeltaFileOperations$.MODULE$.absolutePath(pathString$1, f.path()))));
    }

    public RestoreTableCommand(DeltaTableV2 sourceTable, TableIdentifier targetIdent) {
        this.sourceTable = sourceTable;
        this.targetIdent = targetIdent;
        Command.$init$((Command)this);
        RunnableCommand.$init$((RunnableCommand)this);
        LeafLike.$init$((LeafLike)this);
        DeltaProgressReporter.$init$(this);
        DatabricksLogging.$init$(this);
        DeltaLogging.$init$(this);
        DeltaCommand.$init$(this);
        RestoreTableCommandBase.$init$(this);
        this.output = this.outputSchema();
    }
}

