/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.spark.sql.delta.RowIndexFilter;
import org.apache.spark.sql.delta.actions.DeletionVectorDescriptor;
import org.apache.spark.sql.delta.deletionvectors.DeletedRowsMarkingFilter;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray;
import org.apache.spark.sql.delta.deletionvectors.StoredBitmap;
import org.apache.spark.sql.delta.deletionvectors.StoredBitmap$;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore;
import org.apache.spark.sql.delta.storage.dv.DeletionVectorStore$;
import scala.Function0;
import scala.Option;
import scala.Predef$;
import scala.Serializable;

public final class DeletedRowsMarkingFilter$ {
    public static DeletedRowsMarkingFilter$ MODULE$;

    static {
        new DeletedRowsMarkingFilter$();
    }

    public RowIndexFilter createInstance(DeletionVectorDescriptor deletionVector, Configuration hadoopConf, Option<Path> tablePath) {
        RowIndexFilter rowIndexFilter;
        if (deletionVector.cardinality() == 0L) {
            rowIndexFilter = new DeletedRowsMarkingFilter.KeepAllRowsFilter();
        } else {
            Predef$.MODULE$.require(tablePath.nonEmpty(), (Function0 & java.io.Serializable & Serializable)() -> "Table path is required for non-empty deletion vectors");
            DeletionVectorStore dvStore = DeletionVectorStore$.MODULE$.createInstance(hadoopConf);
            StoredBitmap storedBitmap = StoredBitmap$.MODULE$.create(deletionVector, (Path)tablePath.get());
            RoaringBitmapArray bitmap = storedBitmap.load(dvStore);
            rowIndexFilter = new DeletedRowsMarkingFilter(bitmap);
        }
        return rowIndexFilter;
    }

    private DeletedRowsMarkingFilter$() {
        MODULE$ = this;
    }
}

