/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql.delta.deletionvectors;

import com.google.common.primitives.Ints;
import com.google.common.primitives.UnsignedInts;
import java.io.IOException;
import java.io.Serializable;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.apache.spark.sql.delta.deletionvectors.NativeRoaringBitmapArraySerializationFormat$;
import org.apache.spark.sql.delta.deletionvectors.PortableRoaringBitmapArraySerializationFormat$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArray$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArrayFormat$;
import org.apache.spark.sql.delta.deletionvectors.RoaringBitmapArraySerializationFormat;
import org.roaringbitmap.RelativeRangeConsumer;
import org.roaringbitmap.RoaringBitmap;
import scala.Array$;
import scala.Enumeration;
import scala.Equals;
import scala.Function0;
import scala.Function1;
import scala.Function2;
import scala.MatchError;
import scala.Predef$;
import scala.Tuple2;
import scala.collection.Seq;
import scala.collection.immutable.NumericRange;
import scala.collection.immutable.Range;
import scala.collection.mutable.ArrayOps;
import scala.math.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BooleanRef;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.RichInt$;
import scala.runtime.RichLong$;
import scala.runtime.java8.JFunction1;

@ScalaSignature(bytes="\u0006\u0001\t5d\u0001B\u001a5\u0005\u0005CQa\u0013\u0001\u0005\u00021Cqa\u0014\u0001A\u0002\u0013%\u0001\u000bC\u0004[\u0001\u0001\u0007I\u0011B.\t\r\u0005\u0004\u0001\u0015)\u0003R\u0011\u0015\u0011\u0007\u0001\"\u0001d\u0011\u0019I\u0007\u0001\"\u00057U\"1\u0001\u000f\u0001C\tmEDq\u0001\u001d\u0001\u0005\u0012Y\n\t\u0001\u0003\u0005\u0002\u0016\u0001!\t\u0002NA\f\u0011\u001d\tY\u0002\u0001C\u0001\u0003;Aq!a\b\u0001\t\u0003\t\t\u0003C\u0004\u0002,\u0001!\t!!\f\t\r1\u0004A\u0011AA\u0017\u0011\u001d\t\t\u0004\u0001C\u0001\u0003gAq!!\u000e\u0001\t\u0003\t9\u0004C\u0004\u0002:\u0001!\t!a\u000f\t\u000f\u0005\u0005\u0003\u0001\"\u0001\u0002D!9\u0011\u0011\n\u0001\u0005\u0002\u0005-\u0003BBA(\u0001\u0011\u0005A\nC\u0004\u0002R\u0001!\t!a\u0015\t\u000f\u0005]\u0003\u0001\"\u0001\u0002Z!9\u0011q\u000e\u0001\u0005\u0002\u0005E\u0004bBAE\u0001\u0011\u0005\u00111\u0012\u0005\b\u0003/\u0003A\u0011AAM\u0011\u001d\ti\n\u0001C\u0001\u0003?Cq!!/\u0001\t\u0003\tY\fC\u0004\u0002H\u0002!\t!a\r\t\u000f\u0005%\u0007\u0001\"\u0011\u0002L\"9\u0011Q\u001b\u0001\u0005B\u0005]\u0007bBAn\u0001\u0011\u0005\u0013Q\u001c\u0005\b\u0003?\u0004A\u0011AAq\u0011%\ti\u0010AI\u0001\n\u0003\ty\u0010C\u0005\u0003\u0016\u0001\t\n\u0011\"\u0001\u0002\u0000\"I!q\u0003\u0001\u0012\u0002\u0013\u0005\u0011q \u0005\b\u00053\u0001A\u0011\u0002B\u000e\u0011\u001d\u0011\t\u0003\u0001C\u0005\u0005GA\u0001Ba\n\u0001\t#1$\u0011F\u0004\b\u0005W!\u0004\u0012\u0001B\u0017\r\u0019\u0019D\u0007#\u0001\u00030!11j\nC\u0001\u0005cA\u0011Ba\r(\u0005\u0004%)!a\r\t\u000f\tUr\u0005)A\u0007M\"I!qG\u0014C\u0002\u0013\u0015\u00111\u0007\u0005\b\u0005s9\u0003\u0015!\u0004g\u0011\u001d\u0011Yd\nC\u0001\u0005{AqA!\u0011(\t\u0003\u0011\u0019\u0005C\u0004\u0003H\u001d\"\tA!\u0013\t\u000f\t5s\u0005\"\u0001\u0003P!9!\u0011L\u0014\u0005\u0002\tm\u0003b\u0002B3O\u0011\u0005!q\r\u0002\u0013%>\f'/\u001b8h\u0005&$X.\u00199BeJ\f\u0017P\u0003\u00026m\u0005yA-\u001a7fi&|gN^3di>\u00148O\u0003\u00028q\u0005)A-\u001a7uC*\u0011\u0011HO\u0001\u0004gFd'BA\u001e=\u0003\u0015\u0019\b/\u0019:l\u0015\tid(\u0001\u0004ba\u0006\u001c\u0007.\u001a\u0006\u0002\u007f\u0005\u0019qN]4\u0004\u0001M\u0019\u0001A\u0011%\u0011\u0005\r3U\"\u0001#\u000b\u0003\u0015\u000bQa]2bY\u0006L!a\u0012#\u0003\r\u0005s\u0017PU3g!\t\u0019\u0015*\u0003\u0002K\t\n1Q)];bYN\fa\u0001P5oSRtD#A'\u0011\u00059\u0003Q\"\u0001\u001b\u0002\u000f\tLG/\\1qgV\t\u0011\u000bE\u0002D%RK!a\u0015#\u0003\u000b\u0005\u0013(/Y=\u0011\u0005UCV\"\u0001,\u000b\u0005]s\u0014!\u0004:pCJLgn\u001a2ji6\f\u0007/\u0003\u0002Z-\ni!k\\1sS:<')\u001b;nCB\f1BY5u[\u0006\u00048o\u0018\u0013fcR\u0011Al\u0018\t\u0003\u0007vK!A\u0018#\u0003\tUs\u0017\u000e\u001e\u0005\bA\u000e\t\t\u00111\u0001R\u0003\rAH%M\u0001\tE&$X.\u00199tA\u0005\u0019\u0011\r\u001a3\u0015\u0005q#\u0007\"B3\u0006\u0001\u00041\u0017!\u0002<bYV,\u0007CA\"h\u0013\tAGI\u0001\u0003M_:<\u0017AB1eI\u0006cG\u000e\u0006\u0002]W\")AN\u0002a\u0001[\u00061a/\u00197vKN\u00042a\u00118g\u0013\tyGI\u0001\u0006=e\u0016\u0004X-\u0019;fIz\n\u0001\"\u00193e%\u0006tw-\u001a\u000b\u00039JDQa]\u0004A\u0002Q\fQA]1oO\u0016\u0004\"!^?\u000f\u0005Y\\hBA<{\u001b\u0005A(BA=A\u0003\u0019a$o\\8u}%\tQ)\u0003\u0002}\t\u00069\u0001/Y2lC\u001e,\u0017B\u0001@\u0000\u0005\u0015\u0011\u0016M\\4f\u0015\taH\tF\u0002]\u0003\u0007Aaa\u001d\u0005A\u0002\u0005\u0015\u0001#BA\u0004\u0003#1WBAA\u0005\u0015\u0011\tY!!\u0004\u0002\u0013%lW.\u001e;bE2,'bAA\b\t\u0006Q1m\u001c7mK\u000e$\u0018n\u001c8\n\t\u0005M\u0011\u0011\u0002\u0002\r\u001dVlWM]5d%\u0006tw-Z\u0001\u0007e\u0016lwN^3\u0015\u0007q\u000bI\u0002C\u0003f\u0013\u0001\u0007a-A\u0003dY\u0016\f'\u000fF\u0001]\u0003!\u0019wN\u001c;bS:\u001cH\u0003BA\u0012\u0003S\u00012aQA\u0013\u0013\r\t9\u0003\u0012\u0002\b\u0005>|G.Z1o\u0011\u0015)7\u00021\u0001g\u0003\u001d!x.\u0011:sCf,\"!a\f\u0011\u0007\r\u0013f-A\u0006dCJ$\u0017N\\1mSRLX#\u00014\u0002\u0017I,hn\u00149uS6L'0\u001a\u000b\u0003\u0003G\t!a\u001c:\u0015\u0007q\u000bi\u0004\u0003\u0004\u0002@A\u0001\r!T\u0001\u0005i\"\fG/A\u0003nKJ<W\rF\u0002]\u0003\u000bBa!a\u0012\u0012\u0001\u0004i\u0015!B8uQ\u0016\u0014\u0018\u0001\u00023jM\u001a$2\u0001XA'\u0011\u0019\t9E\u0005a\u0001\u001b\u0006!1m\u001c9z\u0003\u0019\tg\u000e\u001a(piR\u0019A,!\u0016\t\r\u0005}B\u00031\u0001N\u0003U\u0019XM]5bY&TX\rZ*ju\u0016LeNQ=uKN$2AZA.\u0011\u001d\ti&\u0006a\u0001\u0003?\naAZ8s[\u0006$\b\u0003BA1\u0003Or1ATA2\u0013\r\t)\u0007N\u0001\u0019%>\f'/\u001b8h\u0005&$X.\u00199BeJ\f\u0017PR8s[\u0006$\u0018\u0002BA5\u0003W\u0012QAV1mk\u0016L1!!\u001cE\u0005-)e.^7fe\u0006$\u0018n\u001c8\u0002\u0013M,'/[1mSj,G#\u0002/\u0002t\u0005\u001d\u0005bBA;-\u0001\u0007\u0011qO\u0001\u0007EV4g-\u001a:\u0011\t\u0005e\u00141Q\u0007\u0003\u0003wRA!! \u0002\u0000\u0005\u0019a.[8\u000b\u0005\u0005\u0005\u0015\u0001\u00026bm\u0006LA!!\"\u0002|\tQ!)\u001f;f\u0005V4g-\u001a:\t\u000f\u0005uc\u00031\u0001\u0002`\u0005!2/\u001a:jC2L'0Z!t\u0005f$X-\u0011:sCf$B!!$\u0002\u0016B!1IUAH!\r\u0019\u0015\u0011S\u0005\u0004\u0003'#%\u0001\u0002\"zi\u0016Dq!!\u0018\u0018\u0001\u0004\ty&A\u0006eKN,'/[1mSj,Gc\u0001/\u0002\u001c\"9\u0011Q\u000f\rA\u0002\u0005]\u0014!\u00044pe\u0006cG.\u00138SC:<W\rF\u0004]\u0003C\u000b)+a,\t\r\u0005\r\u0016\u00041\u0001g\u0003\u0015\u0019H/\u0019:u\u0011\u001d\t9+\u0007a\u0001\u0003S\u000ba\u0001\\3oORD\u0007cA\"\u0002,&\u0019\u0011Q\u0016#\u0003\u0007%sG\u000fC\u0004\u00022f\u0001\r!a-\u0002\u0011\r|gn];nKJ\u00042!VA[\u0013\r\t9L\u0016\u0002\u0016%\u0016d\u0017\r^5wKJ\u000bgnZ3D_:\u001cX/\\3s\u0003\u001d1wN]#bG\"$2\u0001XA_\u0011\u001d\tyL\u0007a\u0001\u0003\u0003\fqaY8ogVlW\rE\u0003D\u0003\u00074G,C\u0002\u0002F\u0012\u0013\u0011BR;oGRLwN\\\u0019\u0002\t1\f7\u000f^\u0001\tG\u0006tW)];bYR!\u00111EAg\u0011\u001d\ty\u0004\ba\u0001\u0003\u001f\u00042aQAi\u0013\r\t\u0019\u000e\u0012\u0002\u0004\u0003:L\u0018AB3rk\u0006d7\u000f\u0006\u0003\u0002$\u0005e\u0007bBA$;\u0001\u0007\u0011qZ\u0001\tQ\u0006\u001c\bnQ8eKR\u0011\u0011\u0011V\u0001\t[.\u001cFO]5oORA\u00111]Az\u0003k\fI\u0010\u0005\u0003\u0002f\u00065h\u0002BAt\u0003S\u0004\"a\u001e#\n\u0007\u0005-H)\u0001\u0004Qe\u0016$WMZ\u0005\u0005\u0003_\f\tP\u0001\u0004TiJLgn\u001a\u0006\u0004\u0003W$\u0005\"CAR?A\u0005\t\u0019AAr\u0011%\t9p\bI\u0001\u0002\u0004\t\u0019/A\u0002tKBD\u0011\"a? !\u0003\u0005\r!a9\u0002\u0007\u0015tG-\u0001\nnWN#(/\u001b8hI\u0011,g-Y;mi\u0012\nTC\u0001B\u0001U\u0011\t\u0019Oa\u0001,\u0005\t\u0015\u0001\u0003\u0002B\u0004\u0005#i!A!\u0003\u000b\t\t-!QB\u0001\nk:\u001c\u0007.Z2lK\u0012T1Aa\u0004E\u0003)\tgN\\8uCRLwN\\\u0005\u0005\u0005'\u0011IAA\tv]\u000eDWmY6fIZ\u000b'/[1oG\u0016\f!#\\6TiJLgn\u001a\u0013eK\u001a\fW\u000f\u001c;%e\u0005\u0011Rn[*ue&tw\r\n3fM\u0006,H\u000e\u001e\u00134\u00035)\u0007\u0010^3oI\nKG/\\1qgR\u0019AL!\b\t\u000f\t}1\u00051\u0001\u0002*\u0006Ia.Z<MK:<G\u000f[\u0001\u000eg\"\u0014\u0018N\\6CSRl\u0017\r]:\u0015\u0007q\u0013)\u0003C\u0004\u0003 \u0011\u0002\r!!+\u0002\u001bQ|')\u001b;nCB\u001c$GQ5u)\u0005!\u0016A\u0005*pCJLgn\u001a\"ji6\f\u0007/\u0011:sCf\u0004\"AT\u0014\u0014\u0005\u001d\u0012EC\u0001B\u0017\u0003]i\u0015\tW0S\u000bB\u0013ViU#O)\u0006\u0013E*R0W\u00032+V)\u0001\rN\u0003b{&+\u0012)S\u000bN+e\nV!C\u0019\u0016{f+\u0011'V\u000b\u0002\na#T!Y?\nKE+T!Q?\u000e\u000b%\u000bR%O\u00032KE+W\u0001\u0018\u001b\u0006CvLQ%U\u001b\u0006\u0003vlQ!S\t&s\u0015\tT%U3\u0002\nQ!\u00199qYf$2!\u0014B \u0011\u0015aW\u00061\u0001n\u0003%A\u0017n\u001a5CsR,7\u000f\u0006\u0003\u0002*\n\u0015\u0003\"B3/\u0001\u00041\u0017\u0001\u00037po\nKH/Z:\u0015\t\u0005%&1\n\u0005\u0006K>\u0002\rAZ\u0001\u0016I\u0016\u001cw.\u001c9pg\u0016D\u0015n\u001a5M_^\u0014\u0015\u0010^3t)\u0011\u0011\tFa\u0016\u0011\u000f\r\u0013\u0019&!+\u0002*&\u0019!Q\u000b#\u0003\rQ+\b\u000f\\33\u0011\u0015)\u0007\u00071\u0001g\u0003]\u0019w.\u001c9pg\u00164%o\\7IS\u001eDGj\\<CsR,7\u000fF\u0003g\u0005;\u0012\t\u0007C\u0004\u0003`E\u0002\r!!+\u0002\t!Lw\r\u001b\u0005\b\u0005G\n\u0004\u0019AAU\u0003\rawn^\u0001\te\u0016\fGM\u0012:p[R\u0019QJ!\u001b\t\u000f\t-$\u00071\u0001\u0002\u000e\u0006)!-\u001f;fg\u0002")
public final class RoaringBitmapArray
implements Equals {
    private RoaringBitmap[] bitmaps = (RoaringBitmap[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RoaringBitmap.class));

    public static RoaringBitmapArray readFrom(byte[] byArray) {
        return RoaringBitmapArray$.MODULE$.readFrom(byArray);
    }

    public static long composeFromHighLowBytes(int n, int n2) {
        return RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(n, n2);
    }

    public static Tuple2<Object, Object> decomposeHighLowBytes(long l) {
        return RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(l);
    }

    public static int lowBytes(long l) {
        return RoaringBitmapArray$.MODULE$.lowBytes(l);
    }

    public static int highBytes(long l) {
        return RoaringBitmapArray$.MODULE$.highBytes(l);
    }

    public static RoaringBitmapArray apply(Seq<Object> seq) {
        return RoaringBitmapArray$.MODULE$.apply(seq);
    }

    public static long MAX_BITMAP_CARDINALITY() {
        return RoaringBitmapArray$.MODULE$.MAX_BITMAP_CARDINALITY();
    }

    public static long MAX_REPRESENTABLE_VALUE() {
        return RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE();
    }

    private RoaringBitmap[] bitmaps() {
        return this.bitmaps;
    }

    private void bitmaps_$eq(RoaringBitmap[] x$1) {
        this.bitmaps = x$1;
    }

    public void add(long value) {
        Predef$.MODULE$.require(value >= 0L && value <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        Tuple2<Object, Object> tuple2 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(value);
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int high = tuple2._1$mcI$sp();
        int low = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(high, low);
        Tuple2.mcII.sp sp3 = sp2;
        int high2 = sp3._1$mcI$sp();
        int low2 = sp3._2$mcI$sp();
        if (high2 >= this.bitmaps().length) {
            this.extendBitmaps(high2 + 1);
        }
        RoaringBitmap highBitmap = this.bitmaps()[high2];
        highBitmap.add(low2);
    }

    public void addAll(Seq<Object> values) {
        values.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> this.add(value));
    }

    public void addRange(Range range) {
        Predef$.MODULE$.require(0 <= range.start() && range.start() <= range.end());
        if (range.isEmpty()) {
            return;
        }
        if (range.step() != 1) {
            range.foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> this.add(UnsignedInts.toLong((int)i)));
            return;
        }
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).isEmpty()) {
            this.extendBitmaps(1);
        }
        int end = range.isInclusive() ? range.end() + 1 : range.end();
        ((RoaringBitmap)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).head()).add(range.start(), end);
    }

    public void addRange(NumericRange<Object> range) {
        int lastHigh;
        Predef$.MODULE$.require(0L <= BoxesRunTime.unboxToLong((Object)range.start()) && BoxesRunTime.unboxToLong((Object)range.start()) <= BoxesRunTime.unboxToLong((Object)range.end()) && BoxesRunTime.unboxToLong((Object)range.end()) <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        if (range.isEmpty()) {
            return;
        }
        if (BoxesRunTime.unboxToLong((Object)range.step()) != 1L) {
            range.foreach((Function1)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> this.add(value));
            return;
        }
        Tuple2<Object, Object> tuple2 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(BoxesRunTime.unboxToLong((Object)range.start()));
        if (tuple2 == null) {
            throw new MatchError(tuple2);
        }
        int startHigh = tuple2._1$mcI$sp();
        int startLow = tuple2._2$mcI$sp();
        Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(startHigh, startLow);
        Tuple2.mcII.sp sp3 = sp2;
        int startHigh2 = sp3._1$mcI$sp();
        int startLow2 = sp3._2$mcI$sp();
        Tuple2<Object, Object> tuple22 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(BoxesRunTime.unboxToLong((Object)range.end()));
        if (tuple22 == null) {
            throw new MatchError(tuple22);
        }
        int endHigh = tuple22._1$mcI$sp();
        int endLow = tuple22._2$mcI$sp();
        Tuple2.mcII.sp sp4 = new Tuple2.mcII.sp(endHigh, endLow);
        Tuple2.mcII.sp sp5 = sp4;
        int endHigh2 = sp5._1$mcI$sp();
        int endLow2 = sp5._2$mcI$sp();
        int n = lastHigh = endLow2 == 0 && !range.isInclusive() ? endHigh2 - 1 : endHigh2;
        if (lastHigh >= this.bitmaps().length) {
            this.extendBitmaps(lastHigh + 1);
        }
        for (int currentHigh = startHigh2; currentHigh <= lastHigh; ++currentHigh) {
            long start;
            long l = start = currentHigh == startHigh2 ? UnsignedInts.toLong((int)startLow2) : 0L;
            long end = currentHigh == lastHigh ? (range.isInclusive() ? UnsignedInts.toLong((int)endLow2) + 1L : UnsignedInts.toLong((int)endLow2)) : 0x100000000L;
            this.bitmaps()[currentHigh].add(start, end);
        }
    }

    public void remove(long value) {
        block4: {
            Predef$.MODULE$.require(value >= 0L && value <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
            Tuple2<Object, Object> tuple2 = RoaringBitmapArray$.MODULE$.decomposeHighLowBytes(value);
            if (tuple2 == null) {
                throw new MatchError(tuple2);
            }
            int high = tuple2._1$mcI$sp();
            int low = tuple2._2$mcI$sp();
            Tuple2.mcII.sp sp2 = new Tuple2.mcII.sp(high, low);
            Tuple2.mcII.sp sp3 = sp2;
            int high2 = sp3._1$mcI$sp();
            int low2 = sp3._2$mcI$sp();
            if (high2 >= this.bitmaps().length) break block4;
            RoaringBitmap highBitmap = this.bitmaps()[high2];
            highBitmap.remove(low2);
            if (highBitmap.isEmpty()) {
                int latestNonEmpty = this.bitmaps().length - 1;
                boolean done = false;
                while (!done && latestNonEmpty >= 0) {
                    if (this.bitmaps()[latestNonEmpty].isEmpty()) {
                        --latestNonEmpty;
                        continue;
                    }
                    done = true;
                }
                this.shrinkBitmaps(latestNonEmpty + 1);
            }
        }
    }

    public void clear() {
        this.bitmaps_$eq((RoaringBitmap[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RoaringBitmap.class)));
    }

    public boolean contains(long value) {
        boolean bl;
        Predef$.MODULE$.require(value >= 0L && value <= RoaringBitmapArray$.MODULE$.MAX_REPRESENTABLE_VALUE());
        int high = RoaringBitmapArray$.MODULE$.highBytes(value);
        if (high >= this.bitmaps().length) {
            bl = false;
        } else {
            RoaringBitmap highBitmap = this.bitmaps()[high];
            int low = RoaringBitmapArray$.MODULE$.lowBytes(value);
            bl = highBitmap.contains(low);
        }
        return bl;
    }

    /*
     * WARNING - void declaration
     */
    public long[] toArray() {
        void var3_2;
        long cardinality = this.cardinality();
        Predef$.MODULE$.require(cardinality <= Integer.MAX_VALUE);
        long[] values = (long[])Array$.MODULE$.ofDim((int)cardinality, ClassTag$.MODULE$.Long());
        IntRef valuesIndex = IntRef.create((int)0);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$1 -> BoxesRunTime.boxToBoolean((boolean)RoaringBitmapArray.$anonfun$toArray$1(check$ifrefutable$1))).foreach((Function1 & Serializable & scala.Serializable)x$5 -> {
            RoaringBitmapArray.$anonfun$toArray$2(values, valuesIndex, x$5);
            return BoxedUnit.UNIT;
        });
        return var3_2;
    }

    public long[] values() {
        return this.toArray();
    }

    public long cardinality() {
        return BoxesRunTime.unboxToLong((Object)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).foldLeft((Object)BoxesRunTime.boxToLong((long)0L), (Function2 & Serializable & scala.Serializable)(sum, bitmap) -> BoxesRunTime.boxToLong((long)RoaringBitmapArray.$anonfun$cardinality$1(BoxesRunTime.unboxToLong((Object)sum), bitmap))));
    }

    public boolean runOptimize() {
        BooleanRef changeApplied = BooleanRef.create((boolean)false);
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).foreach((Function1 & Serializable & scala.Serializable)bitmap -> {
            RoaringBitmapArray.$anonfun$runOptimize$1(changeApplied, bitmap);
            return BoxedUnit.UNIT;
        });
        return changeApplied.elem;
    }

    public void or(RoaringBitmapArray that) {
        if (this.bitmaps().length < that.bitmaps().length) {
            this.extendBitmaps(that.bitmaps().length);
        }
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])that.bitmaps())).indices().foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            RoaringBitmap thisBitmap = this.bitmaps()[index];
            RoaringBitmap thatBitmap = that.bitmaps()[index];
            thisBitmap.or(thatBitmap);
        });
    }

    public void merge(RoaringBitmapArray other) {
        this.or(other);
    }

    public void diff(RoaringBitmapArray other) {
        this.andNot(other);
    }

    /*
     * WARNING - void declaration
     */
    public RoaringBitmapArray copy() {
        void var1_1;
        RoaringBitmapArray newBitmap = new RoaringBitmapArray();
        newBitmap.merge(this);
        return var1_1;
    }

    public void andNot(RoaringBitmapArray that) {
        int validLength = package$.MODULE$.min(this.bitmaps().length, that.bitmaps().length);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(0), validLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)index -> {
            RoaringBitmap thisBitmap = this.bitmaps()[index];
            RoaringBitmap thatBitmap = that.bitmaps()[index];
            thisBitmap.andNot(thatBitmap);
        });
    }

    public long serializedSizeInBytes(Enumeration.Value format) {
        int magicNumberSize = 4;
        long serializedBitmapsSize = RoaringBitmapArrayFormat$.MODULE$.valueToFormat(format).formatImpl().serializedSizeInBytes(this.bitmaps());
        return (long)magicNumberSize + serializedBitmapsSize;
    }

    public void serialize(ByteBuffer buffer, Enumeration.Value format) {
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        ByteOrder byteOrder2 = buffer.order();
        Predef$.MODULE$.require(!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null), (Function0 & Serializable & scala.Serializable)() -> "RoaringBitmapArray has to be serialized using a little endian buffer");
        buffer.putInt(RoaringBitmapArrayFormat$.MODULE$.valueToFormat(format).formatImpl().MAGIC_NUMBER());
        RoaringBitmapArrayFormat$.MODULE$.valueToFormat(format).formatImpl().serialize(this.bitmaps(), buffer);
    }

    public byte[] serializeAsByteArray(Enumeration.Value format) {
        long size = this.serializedSizeInBytes(format);
        if (!RichLong$.MODULE$.isValidInt$extension(Predef$.MODULE$.longWrapper(size))) {
            throw new IOException(new StringBuilder(60).append("A bitmap was too big to be serialized into an array (").append(size).append(" bytes)").toString());
        }
        ByteBuffer buffer = ByteBuffer.allocate((int)size);
        buffer.order(ByteOrder.LITTLE_ENDIAN);
        this.serialize(buffer, format);
        return buffer.array();
    }

    public void deserialize(ByteBuffer buffer) {
        RoaringBitmapArraySerializationFormat roaringBitmapArraySerializationFormat;
        int magicNumber;
        ByteOrder byteOrder = ByteOrder.LITTLE_ENDIAN;
        ByteOrder byteOrder2 = buffer.order();
        Predef$.MODULE$.require(!(byteOrder != null ? !byteOrder.equals(byteOrder2) : byteOrder2 != null), (Function0 & Serializable & scala.Serializable)() -> "RoaringBitmapArray has to be deserialized using a little endian buffer");
        int n = magicNumber = buffer.getInt();
        if (NativeRoaringBitmapArraySerializationFormat$.MODULE$.MAGIC_NUMBER() == n) {
            roaringBitmapArraySerializationFormat = NativeRoaringBitmapArraySerializationFormat$.MODULE$;
        } else if (PortableRoaringBitmapArraySerializationFormat$.MODULE$.MAGIC_NUMBER() == n) {
            roaringBitmapArraySerializationFormat = PortableRoaringBitmapArraySerializationFormat$.MODULE$;
        } else {
            throw new IOException(new StringBuilder(43).append("Unexpected RoaringBitmapArray magic number ").append(magicNumber).toString());
        }
        NativeRoaringBitmapArraySerializationFormat$ serializationFormat = roaringBitmapArraySerializationFormat;
        this.bitmaps_$eq(serializationFormat.deserialize(buffer));
    }

    public void forAllInRange(long start, int length, RelativeRangeConsumer consumer) {
        throw new UnsupportedOperationException();
    }

    public void forEach(Function1<Object, BoxedUnit> consume) {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).withFilter((Function1 & Serializable & scala.Serializable)check$ifrefutable$2 -> BoxesRunTime.boxToBoolean((boolean)RoaringBitmapArray.$anonfun$forEach$1(check$ifrefutable$2))).foreach((Function1 & Serializable & scala.Serializable)x$6 -> {
            RoaringBitmapArray.$anonfun$forEach$2(consume, x$6);
            return BoxedUnit.UNIT;
        });
    }

    public long last() {
        Predef$.MODULE$.require(this.bitmaps().length > 0);
        Tuple2 tuple2 = (Tuple2)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).zipWithIndex(Array$.MODULE$.canBuildFrom(ClassTag$.MODULE$.apply(Tuple2.class))))).last();
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
        int high = tuple2._2$mcI$sp();
        Tuple2 tuple22 = new Tuple2((Object)bitmap, (Object)BoxesRunTime.boxToInteger((int)high));
        Tuple2 tuple23 = tuple22;
        RoaringBitmap bitmap2 = (RoaringBitmap)tuple23._1();
        int high2 = tuple23._2$mcI$sp();
        return RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(high2, bitmap2.last());
    }

    public boolean canEqual(Object that) {
        return that instanceof RoaringBitmapArray;
    }

    public boolean equals(Object other) {
        RoaringBitmapArray roaringBitmapArray;
        Object object = other;
        boolean bl = object instanceof RoaringBitmapArray ? this == (roaringBitmapArray = (RoaringBitmapArray)object) || Arrays.deepEquals(this.bitmaps(), roaringBitmapArray.bitmaps()) : false;
        return bl;
    }

    public int hashCode() {
        return 131 * Arrays.deepHashCode(this.bitmaps());
    }

    public String mkString(String start, String sep, String end) {
        return new ArrayOps.ofLong(Predef$.MODULE$.longArrayOps(this.toArray())).mkString(start, sep, end);
    }

    public String mkString$default$1() {
        return "";
    }

    public String mkString$default$2() {
        return "";
    }

    public String mkString$default$3() {
        return "";
    }

    private void extendBitmaps(int newLength) {
        if (new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.bitmaps())).isEmpty() && newLength == 1) {
            this.bitmaps_$eq((RoaringBitmap[])((Object[])new RoaringBitmap[]{new RoaringBitmap()}));
            return;
        }
        RoaringBitmap[] newBitmaps = (RoaringBitmap[])Array$.MODULE$.ofDim(newLength, ClassTag$.MODULE$.apply(RoaringBitmap.class));
        System.arraycopy(this.bitmaps(), 0, newBitmaps, 0, this.bitmaps().length);
        RichInt$.MODULE$.until$extension0(Predef$.MODULE$.intWrapper(this.bitmaps().length), newLength).foreach$mVc$sp((Function1)(JFunction1.mcVI.sp & Serializable & scala.Serializable)i -> {
            newBitmaps$1[i] = new RoaringBitmap();
        });
        this.bitmaps_$eq(newBitmaps);
    }

    private void shrinkBitmaps(int newLength) {
        if (newLength == 0) {
            this.bitmaps_$eq((RoaringBitmap[])Array$.MODULE$.empty(ClassTag$.MODULE$.apply(RoaringBitmap.class)));
        } else {
            RoaringBitmap[] newBitmaps = (RoaringBitmap[])Array$.MODULE$.ofDim(newLength, ClassTag$.MODULE$.apply(RoaringBitmap.class));
            System.arraycopy(this.bitmaps(), 0, newBitmaps, 0, newLength);
            this.bitmaps_$eq(newBitmaps);
        }
    }

    /*
     * WARNING - void declaration
     */
    public RoaringBitmap toBitmap32Bit() {
        void var1_1;
        RoaringBitmap bitmap32 = new RoaringBitmap();
        this.forEach((Function1<Object, BoxedUnit>)(JFunction1.mcVJ.sp & Serializable & scala.Serializable)value -> {
            int value32 = Ints.checkedCast((long)value);
            bitmap32.add(value32);
        });
        bitmap32.runOptimize();
        return var1_1;
    }

    public static final /* synthetic */ boolean $anonfun$toArray$1(Tuple2 check$ifrefutable$1) {
        Tuple2 tuple2 = check$ifrefutable$1;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$toArray$2(long[] values$1, IntRef valuesIndex$1, Tuple2 x$5) {
        Tuple2 tuple2 = x$5;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
        int bitmapIndex = tuple2._2$mcI$sp();
        bitmap.forEach(value -> {
            values$1[valuesIndex$1.elem] = RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(bitmapIndex, value);
            ++valuesIndex$1.elem;
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }

    public static final /* synthetic */ long $anonfun$cardinality$1(long sum, RoaringBitmap bitmap) {
        return sum + bitmap.getLongCardinality();
    }

    public static final /* synthetic */ void $anonfun$runOptimize$1(BooleanRef changeApplied$1, RoaringBitmap bitmap) {
        changeApplied$1.elem |= bitmap.runOptimize();
    }

    public static final /* synthetic */ boolean $anonfun$forEach$1(Tuple2 check$ifrefutable$2) {
        Tuple2 tuple2 = check$ifrefutable$2;
        boolean bl = tuple2 != null;
        return bl;
    }

    public static final /* synthetic */ void $anonfun$forEach$2(Function1 consume$1, Tuple2 x$6) {
        Tuple2 tuple2 = x$6;
        if (tuple2 == null) {
            throw new MatchError((Object)tuple2);
        }
        RoaringBitmap bitmap = (RoaringBitmap)tuple2._1();
        int high = tuple2._2$mcI$sp();
        bitmap.forEach(low -> {
            long value = RoaringBitmapArray$.MODULE$.composeFromHighLowBytes(high, low);
            consume$1.apply$mcVJ$sp(value);
        });
        BoxedUnit boxedUnit = BoxedUnit.UNIT;
    }
}

