/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.metrics.service;

import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.metrics.MetricsGroup;
import org.apache.kylin.common.util.ExecutorServiceUtil;
import org.apache.kylin.common.util.InfluxDBUtils;
import org.apache.kylin.common.util.NamedThreadFactory;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.apache.kylin.shaded.influxdb.org.influxdb.BatchOptions;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDB;
import org.apache.kylin.shaded.influxdb.org.influxdb.InfluxDBIOException;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Point;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Pong;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.Query;
import org.apache.kylin.shaded.influxdb.org.influxdb.dto.QueryResult;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InfluxDBInstance {
    private static final Logger logger = LoggerFactory.getLogger(InfluxDBInstance.class);
    private String database;
    private String retentionPolicyName;
    private String retentionDuration;
    private String shardDuration;
    private int replicationFactor;
    private boolean useDefault;
    private static final String DEFAULT_DATABASE = "KYLIN_MONITOR";
    private static final String DEFAULT_RETENTION_POLICY_NAME = "KYLIN_MONITOR_RP";
    private static final String RETENTION_DURATION = "90d";
    private static final String SHARD_DURATION = "7d";
    private static final int REPLICATION_FACTOR = 1;
    private static final boolean USE_DEFAULT = true;
    private volatile InfluxDB influxDB;
    private ScheduledExecutorService scheduledExecutorService;
    private KapConfig config;

    public InfluxDBInstance(String database, String retentionPolicyName, String retentionDuration, String shardDuration, int replicationFactor, boolean useDefault) {
        this.database = database;
        this.retentionPolicyName = retentionPolicyName;
        this.retentionDuration = retentionDuration;
        this.shardDuration = shardDuration;
        this.replicationFactor = replicationFactor;
        this.useDefault = useDefault;
        this.config = KapConfig.wrap((KylinConfig)KylinConfig.getInstanceFromEnv());
    }

    public void init() {
        String addr = this.config.influxdbAddress();
        if (StringUtils.isEmpty((CharSequence)addr)) {
            logger.info("InfluxDB address is empty, skip it");
            return;
        }
        this.tryConnectInfluxDB();
        this.startMonitorInfluxDB();
    }

    private void tryConnectInfluxDB() {
        try {
            if (this.influxDB == null) {
                String addr = this.config.influxdbAddress();
                String username = this.config.influxdbUsername();
                String password = this.config.influxdbPassword();
                boolean enableHttps = this.config.isInfluxdbHttpsEnabled();
                boolean enableUnsafeSsl = this.config.isInfluxdbUnsafeSslEnabled();
                logger.info("Init influxDB, address: {}, username: {}", (Object)addr, (Object)username);
                this.influxDB = InfluxDBUtils.getInfluxDBInstance(addr, username, password, enableHttps, enableUnsafeSsl);
                this.influxDB.setDatabase(this.getDatabase());
                this.influxDB.setRetentionPolicy(this.getRetentionPolicyName());
                if (!this.influxDB.databaseExists(this.getDatabase())) {
                    logger.info("Create influxDB database {}", (Object)this.getDatabase());
                    this.influxDB.createDatabase(this.getDatabase());
                    logger.info("Create influxDB retention policy '{}' on database '{}'", (Object)this.getRetentionPolicyName(), (Object)this.getDatabase());
                    this.influxDB.createRetentionPolicy(this.getRetentionPolicyName(), this.getDatabase(), this.getRetentionDuration(), this.getShardDuration(), this.getReplicationFactor(), this.isUseDefault());
                }
                this.influxDB.enableBatch(BatchOptions.DEFAULTS.actions(1000).bufferLimit(10000).flushDuration(this.config.getInfluxDBFlushDuration()).jitterDuration(500));
            } else {
                Pong pong = this.influxDB.ping();
                MetricsGroup.monitorRegisterMetrics();
                logger.trace("Connected to influxDB successfully. [{}]", (Object)pong);
            }
        }
        catch (Exception ex) {
            if (this.influxDB != null && this.influxDB.isBatchEnabled()) {
                this.influxDB.disableBatch();
            }
            this.influxDB = null;
            if (Throwables.getCausalChain((Throwable)ex).stream().anyMatch(t -> t instanceof InfluxDBIOException)) {
                logger.warn("Check influxDB Instance error, database: {}, retentionPolicy: {} ex: {}", new Object[]{this.getDatabase(), this.getRetentionPolicyName(), ex.getMessage()});
                return;
            }
            logger.error("Unknown exception happened", (Throwable)ex);
        }
    }

    private void startMonitorInfluxDB() {
        logger.info("Start to monitor influxDB Instance, database: {}, retentionPolicy: {}", (Object)this.getDatabase(), (Object)this.getRetentionPolicyName());
        this.scheduledExecutorService = Executors.newSingleThreadScheduledExecutor((ThreadFactory)new NamedThreadFactory("InfluxDBMonitor-" + this.getDatabase()));
        this.scheduledExecutorService.scheduleWithFixedDelay(this::tryConnectInfluxDB, 60L, 600L, TimeUnit.SECONDS);
        Runtime.getRuntime().addShutdownHook(new Thread(() -> {
            this.getInfluxDB().close();
            ExecutorServiceUtil.forceShutdown((ExecutorService)this.scheduledExecutorService);
            logger.info("Shutdown InfluxDB Instance, database: {}, retentionPolicy: {}", (Object)this.getDatabase(), (Object)this.getRetentionPolicyName());
        }));
    }

    public boolean write(String measurement, Map<String, String> tags, Map<String, Object> fields, long timestamp) {
        if (this.influxDB == null) {
            logger.error("InfluxDB is not connected, abort writing.");
            return false;
        }
        Point p = Point.measurement((String)measurement).time(timestamp, TimeUnit.MILLISECONDS).tag(tags).fields(fields).build();
        this.getInfluxDB().write(p);
        return true;
    }

    public QueryResult read(String sql) {
        if (this.influxDB == null) {
            logger.error("InfluxDB is not connected, abort reading.");
            return new QueryResult();
        }
        return this.getInfluxDB().query(new Query(sql, this.getDatabase()));
    }

    @Generated
    public String getDatabase() {
        return this.database;
    }

    @Generated
    public String getRetentionPolicyName() {
        return this.retentionPolicyName;
    }

    @Generated
    public String getRetentionDuration() {
        return this.retentionDuration;
    }

    @Generated
    public String getShardDuration() {
        return this.shardDuration;
    }

    @Generated
    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    @Generated
    public boolean isUseDefault() {
        return this.useDefault;
    }

    @Generated
    public InfluxDB getInfluxDB() {
        return this.influxDB;
    }

    @Generated
    public ScheduledExecutorService getScheduledExecutorService() {
        return this.scheduledExecutorService;
    }

    @Generated
    public KapConfig getConfig() {
        return this.config;
    }

    @Generated
    public void setInfluxDB(InfluxDB influxDB) {
        this.influxDB = influxDB;
    }
}

