/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.measure;

import java.io.Serializable;
import java.nio.ByteBuffer;
import java.util.Collection;
import org.apache.kylin.metadata.datatype.DataType;
import org.apache.kylin.metadata.datatype.DataTypeSerializer;
import org.apache.kylin.metadata.model.MeasureDesc;

public class MeasureCodec
implements Serializable {
    private int nMeasures;
    private DataTypeSerializer[] serializers;

    public MeasureCodec(Collection<MeasureDesc> measureDescs) {
        this(measureDescs.toArray(new MeasureDesc[measureDescs.size()]));
    }

    public MeasureCodec(MeasureDesc ... measureDescs) {
        String[] dataTypes = new String[measureDescs.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            dataTypes[i] = measureDescs[i].getFunction().getReturnType();
        }
        this.init(dataTypes);
    }

    public MeasureCodec(DataType ... dataTypes) {
        this.init(dataTypes);
    }

    public MeasureCodec(String ... dataTypes) {
        this.init(dataTypes);
    }

    private void init(String[] dataTypes) {
        DataType[] typeInstances = new DataType[dataTypes.length];
        for (int i = 0; i < dataTypes.length; ++i) {
            typeInstances[i] = DataType.getType(dataTypes[i]);
        }
        this.init(typeInstances);
    }

    private void init(DataType[] dataTypes) {
        this.nMeasures = dataTypes.length;
        this.serializers = new DataTypeSerializer[this.nMeasures];
        for (int i = 0; i < this.nMeasures; ++i) {
            this.serializers[i] = DataTypeSerializer.create(dataTypes[i]);
        }
    }

    public void encode(int idx, Object o, ByteBuffer buf) {
        this.serializers[idx].serialize(o, buf);
    }

    public int getMeasuresCount() {
        return this.nMeasures;
    }

    public int[] getMaxLength() {
        int[] maxLen = new int[this.nMeasures];
        for (int i = 0; i < this.nMeasures; ++i) {
            maxLen[i] = this.serializers[i].maxLength();
        }
        return maxLen;
    }

    public Object decode(int index, ByteBuffer buf) {
        return this.serializers[index].deserialize(buf);
    }

    public void decode(ByteBuffer buf, Object[] result) {
        assert (result.length == this.nMeasures);
        for (int i = 0; i < this.nMeasures; ++i) {
            result[i] = this.serializers[i].deserialize(buf);
        }
    }
}

