/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.acl;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.Locale;
import java.util.Set;
import org.apache.kylin.guava30.shaded.common.collect.Sets;

@JsonAutoDetect(fieldVisibility=JsonAutoDetect.Visibility.NONE, getterVisibility=JsonAutoDetect.Visibility.NONE, isGetterVisibility=JsonAutoDetect.Visibility.NONE, setterVisibility=JsonAutoDetect.Visibility.NONE)
public class SensitiveDataMask {
    private static final Set<String> VALID_DATA_TYPES = Sets.newHashSet((Object[])new String[]{"string", "varchar", "char", "int", "integer", "bigint", "smallint", "tinyint", "double", "float", "real", "decimal", "date", "timestamp", "datetime"});
    @JsonProperty
    String column;
    @JsonProperty
    MaskType type;

    public static boolean isValidDataType(String dataType) {
        int parenthesesIdx = dataType.indexOf(40);
        return VALID_DATA_TYPES.contains(parenthesesIdx > -1 ? dataType.substring(0, parenthesesIdx).trim().toLowerCase(Locale.ROOT) : dataType.trim().toLowerCase(Locale.ROOT));
    }

    public SensitiveDataMask() {
    }

    public SensitiveDataMask(String column, MaskType type) {
        this.column = column;
        this.type = type;
    }

    public MaskType getType() {
        return this.type;
    }

    public String getColumn() {
        return this.column;
    }

    public static enum MaskType {
        DEFAULT(0),
        AS_NULL(1);

        int priority = 0;

        private MaskType(int priority) {
            this.priority = priority;
        }

        public MaskType merge(MaskType other) {
            if (other == null) {
                return this;
            }
            return this.priority < other.priority ? this : other;
        }
    }
}

