/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.planner.algorithm.greedy;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import com.google.common.util.concurrent.ThreadFactoryBuilder;
import java.math.BigInteger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.kylin.metadata.cube.planner.algorithm.AbstractRecommendAlgorithm;
import org.apache.kylin.metadata.cube.planner.algorithm.BenefitPolicy;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidBenefitModel;
import org.apache.kylin.metadata.cube.planner.algorithm.CuboidStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GreedyAlgorithm
extends AbstractRecommendAlgorithm {
    private static final Logger logger = LoggerFactory.getLogger(GreedyAlgorithm.class);
    private static final int THREAD_NUM = 8;
    private ExecutorService executor;
    private Set<BigInteger> selected = Sets.newLinkedHashSet();
    private List<BigInteger> remaining = Lists.newLinkedList();

    public GreedyAlgorithm(long timeout, BenefitPolicy benefitPolicy, CuboidStats cuboidStats) {
        super(timeout, benefitPolicy, cuboidStats);
    }

    @Override
    public List<BigInteger> start(double spaceLimit) {
        logger.info("Greedy Algorithm started.");
        this.executor = Executors.newFixedThreadPool(8, new ThreadFactoryBuilder().setNameFormat("greedy-algorithm-benefit-calculator-pool-%d").build());
        this.selected.clear();
        double remainingSpace = spaceLimit;
        for (BigInteger mandatoryOne : this.cuboidStats.getAllCuboidsForMandatory()) {
            this.selected.add(mandatoryOne);
            if (this.cuboidStats.getCuboidSize(mandatoryOne) == null) continue;
            remainingSpace -= this.cuboidStats.getCuboidSize(mandatoryOne).doubleValue();
        }
        this.remaining.clear();
        this.remaining.addAll((Collection<BigInteger>)this.cuboidStats.getAllCuboidsForSelection());
        long round = 0L;
        while (!this.shouldCancel()) {
            CuboidBenefitModel best = this.recommendBestOne();
            if (best == null) {
                logger.info("Greedy algorithm ends due to cannot find next best one");
                break;
            }
            if (!this.benefitPolicy.ifEfficient(best)) {
                logger.info("Greedy algorithm ends due to the benefit of the best one is not efficient {}", (Object)best.getBenefit());
                break;
            }
            if ((remainingSpace -= this.cuboidStats.getCuboidSize(best.getCuboidId()).doubleValue()) <= 0.0) {
                logger.info("Greedy algorithm ends due to there's no remaining space");
                break;
            }
            this.selected.add(best.getCuboidId());
            this.remaining.remove(best.getCuboidId());
            this.benefitPolicy.propagateAggregationCost(best.getCuboidId(), this.selected);
            ++round;
            if (!logger.isTraceEnabled()) continue;
            logger.trace(String.format(Locale.ROOT, "Recommend in round %d : %s", round, best.toString()));
        }
        this.executor.shutdown();
        ArrayList excluded = Lists.newArrayList(this.remaining);
        this.remaining.retainAll(this.selected);
        Preconditions.checkArgument((boolean)this.remaining.isEmpty(), (Object)"There should be no intersection between excluded list and selected list.");
        logger.info("Greedy Algorithm finished.");
        if (logger.isTraceEnabled()) {
            logger.trace("Excluded cuboidId size: {}", (Object)excluded.size());
            logger.trace("Excluded cuboidId detail:");
            for (BigInteger cuboid : excluded) {
                logger.trace("cuboidId {} and Cost: {} and Space: {}", new Object[]{cuboid, this.cuboidStats.getCuboidQueryCost(cuboid), this.cuboidStats.getCuboidSize(cuboid)});
            }
            logger.trace("Total Space: {}", (Object)(spaceLimit - remainingSpace));
            logger.trace("Space Expansion Rate: {}", (Object)((spaceLimit - remainingSpace) / this.cuboidStats.getBaseCuboidSize()));
        }
        return Lists.newArrayList(this.selected);
    }

    private CuboidBenefitModel recommendBestOne() {
        int selectedSize = this.selected.size();
        AtomicReference best = new AtomicReference();
        CountDownLatch counter = new CountDownLatch(this.remaining.size());
        for (BigInteger cuboid : this.remaining) {
            this.executor.submit(() -> {
                CuboidBenefitModel currentBest = (CuboidBenefitModel)best.get();
                assert (this.selected.size() == selectedSize);
                CuboidBenefitModel.BenefitModel benefitModel = this.benefitPolicy.calculateBenefit(cuboid, this.selected);
                if (benefitModel != null && (currentBest == null || currentBest.getBenefit() == null || benefitModel.benefit > currentBest.getBenefit())) {
                    while (!best.compareAndSet(currentBest, new CuboidBenefitModel(this.cuboidStats.getCuboidModel(cuboid), benefitModel)) && !(benefitModel.benefit <= (currentBest = (CuboidBenefitModel)best.get()).getBenefit())) {
                    }
                }
                counter.countDown();
            });
        }
        try {
            counter.await();
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        return (CuboidBenefitModel)best.get();
    }
}

