/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.cube.utils;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IndexPlanReduceUtil {
    private static final Logger log = LoggerFactory.getLogger(IndexPlanReduceUtil.class);

    private IndexPlanReduceUtil() {
    }

    public static Map<LayoutEntity, LayoutEntity> collectIncludedLayouts(List<LayoutEntity> inputLayouts, boolean isGarbageCleaning) {
        HashMap redundantMap = Maps.newHashMap();
        HashSet tableIndexGroup = Sets.newHashSet();
        HashMap aggIndexDimGroup = Maps.newHashMap();
        inputLayouts.forEach(layout -> {
            if (IndexEntity.isTableIndex(layout.getId())) {
                tableIndexGroup.add(layout);
            } else {
                List aggIndexDims = layout.getColOrder().stream().filter(idx -> idx < 100000).collect(Collectors.toList());
                aggIndexDimGroup.putIfAbsent(aggIndexDims, Sets.newHashSet());
                ((Set)aggIndexDimGroup.get(aggIndexDims)).add(layout);
            }
        });
        List<LayoutEntity> tableIndexsShareSameDims = IndexPlanReduceUtil.descSortByColOrderSize(Lists.newArrayList((Iterable)tableIndexGroup));
        redundantMap.putAll(IndexPlanReduceUtil.findIncludedLayoutMap(tableIndexsShareSameDims, isGarbageCleaning));
        aggIndexDimGroup.forEach((dims, layouts) -> {
            List<LayoutEntity> aggIndexsShareSameDims = IndexPlanReduceUtil.descSortByColOrderSize(Lists.newArrayList((Iterable)layouts));
            redundantMap.putAll(IndexPlanReduceUtil.findIncludedLayoutMap(aggIndexsShareSameDims, isGarbageCleaning));
        });
        return redundantMap;
    }

    public static List<Set<LayoutEntity>> collectSameDimAggLayouts(List<LayoutEntity> inputLayouts) {
        ArrayList sameDimAggLayouts = Lists.newArrayList();
        HashMap aggLayoutDimGroup = Maps.newHashMap();
        inputLayouts.stream().filter(layout -> !layout.isBase() && !IndexEntity.isTableIndex(layout.getId())).forEach(layout -> {
            ArrayList<Integer> aggLayoutDims = new ArrayList<Integer>();
            for (Integer idx : layout.getColOrder()) {
                if (idx >= 100000) continue;
                aggLayoutDims.add(idx);
            }
            aggLayoutDimGroup.putIfAbsent(aggLayoutDims, Sets.newHashSet());
            ((Set)aggLayoutDimGroup.get(aggLayoutDims)).add(layout);
        });
        sameDimAggLayouts.addAll(aggLayoutDimGroup.values().stream().filter(layouts -> layouts.size() > 1).collect(Collectors.toSet()));
        return sameDimAggLayouts;
    }

    public static IndexPlan mergeSameDimLayout(IndexPlan indexPlan, List<Set<LayoutEntity>> sameDimLayouts) {
        IndexPlan.IndexPlanUpdateHandler updateHandler = indexPlan.createUpdateHandler();
        for (Set<LayoutEntity> layoutEntities : sameDimLayouts) {
            LinkedHashSet colOrder = Sets.newLinkedHashSet();
            ArrayList allColOrders = Lists.newArrayList();
            List<Object> shardByCol = Lists.newArrayList();
            for (LayoutEntity layoutEntity : layoutEntities) {
                colOrder.addAll(layoutEntity.getColOrder());
                allColOrders.addAll(layoutEntity.getColOrder());
                shardByCol = layoutEntity.getShardByColumns();
            }
            LayoutEntity mergedLayout = indexPlan.createLayout(Lists.newArrayList((Iterable)colOrder), true, false, shardByCol);
            log.info("merge colOrders: {} into {}", (Object)allColOrders, mergedLayout.getColOrder());
            updateHandler.add(mergedLayout, true, false);
        }
        return updateHandler.complete();
    }

    private static Map<LayoutEntity, LayoutEntity> findIncludedLayoutMap(List<LayoutEntity> sortedLayouts, boolean isGarbageCleaning) {
        HashMap includedMap = Maps.newHashMap();
        if (sortedLayouts.size() <= 1) {
            return includedMap;
        }
        for (int i = 0; i < sortedLayouts.size(); ++i) {
            LayoutEntity target = sortedLayouts.get(i);
            if (includedMap.containsKey(target)) continue;
            for (int j = i + 1; j < sortedLayouts.size(); ++j) {
                LayoutEntity current = sortedLayouts.get(j);
                if (!isGarbageCleaning && !current.isInProposing() || target.getColOrder().size() == current.getColOrder().size() || includedMap.containsKey(current) || !Objects.equals(current.getShardByColumns(), target.getShardByColumns()) || !IndexPlanReduceUtil.isContained(current, target)) continue;
                includedMap.put(current, target);
            }
        }
        return includedMap;
    }

    private static boolean isContained(LayoutEntity current, LayoutEntity target) {
        boolean isTableIndex = IndexEntity.isTableIndex(target.getId());
        if (isTableIndex) {
            return IndexPlanReduceUtil.isSubPartColOrder(current.getColOrder(), target.getColOrder());
        }
        HashSet currentMeasures = Sets.newHashSet(current.getIndex().getMeasures());
        HashSet targetMeasures = Sets.newHashSet(target.getIndex().getMeasures());
        return targetMeasures.containsAll(currentMeasures);
    }

    public static boolean isSubPartColOrder(List<Integer> curSeq, List<Integer> targetSeq) {
        int j;
        int i = 0;
        for (j = 0; i < curSeq.size() && j < targetSeq.size(); ++j) {
            if (curSeq.get(i).intValue() != targetSeq.get(j).intValue()) continue;
            ++i;
        }
        return i == curSeq.size() && j <= targetSeq.size();
    }

    public static List<LayoutEntity> descSortByColOrderSize(List<LayoutEntity> allLayouts) {
        allLayouts.sort((o1, o2) -> {
            if (o2.getColOrder().size() - o1.getColOrder().size() == 0) {
                return (int)(o1.getId() - o2.getId());
            }
            return o2.getColOrder().size() - o1.getColOrder().size();
        });
        return allLayouts;
    }
}

