/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.asynctask.AbstractAsyncTask;
import org.apache.kylin.metadata.favorite.AsyncTaskMapper;
import org.apache.kylin.metadata.favorite.AsyncTaskTable;
import org.apache.kylin.util.MetadataStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class AsyncTaskStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AsyncTaskStore.class);
    public static final String ASYNC_TASK = "_async_task";
    private final AsyncTaskTable table;
    private final SqlSessionTemplate sqlSessionTemplate;
    private final DataSourceTransactionManager transactionManager;

    public AsyncTaskStore(KylinConfig config) throws Exception {
        this(config, AsyncTaskStore.genTableName(config));
    }

    private AsyncTaskStore(KylinConfig config, String tableName) throws Exception {
        StorageURL url = config.getCoreMetadataDBUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.table = new AsyncTaskTable(tableName);
        this.transactionManager = new DataSourceTransactionManager(dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(MetadataStoreUtil.getSqlSessionFactory(dataSource, this.table.tableNameAtRuntime(), MetadataStoreUtil.TableType.ASYNC_TASK));
    }

    private static String genTableName(KylinConfig config) {
        StorageURL url = config.getCoreMetadataDBUrl();
        String tablePrefix = config.isUTEnv() ? "test_opt" : url.getIdentifier();
        return tablePrefix + ASYNC_TASK;
    }

    public void save(AbstractAsyncTask task) {
        InsertStatementProvider<AbstractAsyncTask> insertStatement;
        AsyncTaskMapper mapper = (AsyncTaskMapper)this.sqlSessionTemplate.getMapper(AsyncTaskMapper.class);
        int rows = mapper.insert(insertStatement = this.getInsertProvider(task));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to insert async task for project (%s)", task.getProject()));
        }
        log.debug("Insert one async task for project ({}) into database.", (Object)task.getProject());
    }

    public void update(AbstractAsyncTask task) {
        UpdateStatementProvider updateStatement;
        AsyncTaskMapper mapper = (AsyncTaskMapper)this.sqlSessionTemplate.getMapper(AsyncTaskMapper.class);
        int rows = mapper.update(updateStatement = this.getUpdateProvider(task));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update async task for project (%s)", task.getProject()));
        }
        log.debug("Update one async task for project ({})", (Object)task.getProject());
    }

    public List<AbstractAsyncTask> queryByType(String taskType) {
        AsyncTaskMapper mapper = (AsyncTaskMapper)this.sqlSessionTemplate.getMapper(AsyncTaskMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByTaskTypeStatementProvider(taskType);
        return mapper.selectMany(statementProvider);
    }

    public AbstractAsyncTask queryByTypeAndKey(String taskKey, String taskType) {
        AsyncTaskMapper mapper = (AsyncTaskMapper)this.sqlSessionTemplate.getMapper(AsyncTaskMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByTypeAndKeyStatementProvider(taskKey, taskType);
        return mapper.selectOne(statementProvider);
    }

    public List<AbstractAsyncTask> queryAll() {
        AsyncTaskMapper mapper = (AsyncTaskMapper)this.sqlSessionTemplate.getMapper(AsyncTaskMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
        return mapper.selectMany(statementProvider);
    }

    public void deleteByProject(String project) {
        AsyncTaskMapper mapper = (AsyncTaskMapper)this.sqlSessionTemplate.getMapper(AsyncTaskMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete favorite rule for project ({})", (Object)project);
    }

    InsertStatementProvider<AbstractAsyncTask> getInsertProvider(AbstractAsyncTask task) {
        InsertDSL provider = SqlBuilder.insert((Object)task).into((SqlTable)this.table);
        return provider.map(this.table.project).toProperty("project").map(this.table.taskAttributes).toProperty("taskAttributes").map(this.table.taskType).toProperty("taskType").map(this.table.taskKey).toProperty("taskKey").map(this.table.updateTime).toProperty("updateTime").map(this.table.createTime).toProperty("createTime").map(this.table.mvcc).toProperty("mvcc").build().render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider getUpdateProvider(AbstractAsyncTask task) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.taskAttributes).equalTo(task::getTaskAttributes).set(this.table.taskType).equalTo(task::getTaskType).set(this.table.taskKey).equalTo(task::getTaskKey).set(this.table.updateTime).equalTo(task::getUpdateTime).set(this.table.mvcc).equalTo((Object)(task.getMvcc() + 1L)).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo(task::getId), new AndOrCriteriaGroup[0])).and(this.table.mvcc, (VisitableCondition)SqlBuilder.isEqualTo(task::getMvcc), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByTaskTypeStatementProvider(String taskType) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.taskType, (VisitableCondition)SqlBuilder.isEqualTo((Object)taskType), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByTypeAndKeyStatementProvider(String taskType, String taskKey) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.taskKey, (VisitableCondition)SqlBuilder.isEqualTo((Object)taskKey), new AndOrCriteriaGroup[0])).and(this.table.taskType, (VisitableCondition)SqlBuilder.isEqualTo((Object)taskType), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(AsyncTaskTable taskTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{taskTable.id, taskTable.project, taskTable.taskKey, taskTable.taskAttributes, taskTable.taskType, taskTable.updateTime, taskTable.createTime, taskTable.mvcc});
    }

    @Generated
    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

