/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.annotation.Clarification;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.favorite.BaseRuleManager;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleStore;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

@Clarification(priority=Clarification.Priority.MAJOR, msg="Enterprise")
public class FavoriteRuleManager
extends BaseRuleManager {
    private final FavoriteRuleStore favoriteRuleStore;
    private final String project;

    public static FavoriteRuleManager getInstance(String project) {
        return (FavoriteRuleManager)Singletons.getInstance((String)project, FavoriteRuleManager.class);
    }

    private FavoriteRuleManager(String project) throws Exception {
        this.project = project;
        this.favoriteRuleStore = new FavoriteRuleStore(KylinConfig.getInstanceFromEnv());
    }

    @Override
    public DataSourceTransactionManager getTransactionManager() {
        return this.favoriteRuleStore.getTransactionManager();
    }

    public List<FavoriteRule> getAll() {
        return this.favoriteRuleStore.queryByProject(this.project);
    }

    public List<FavoriteRule> listAll() {
        return FavoriteRule.FAVORITE_RULE_NAMES.stream().map(this::getOrDefaultByName).collect(Collectors.toList());
    }

    public List<FavoriteRule> listAutoIndexPlanRules() {
        return FavoriteRule.AUTO_INDEX_PLAN_RULE_NAMES.stream().filter(ruleName -> !ruleName.equals("auto_index_plan_option")).map(this::getOrDefaultByName).collect(Collectors.toList());
    }

    public FavoriteRule getByName(String name) {
        return this.favoriteRuleStore.queryByName(this.project, name);
    }

    public String getValue(String ruleName) {
        FavoriteRule rule = this.getOrDefaultByName(ruleName);
        FavoriteRule.Condition condition = (FavoriteRule.Condition)rule.getConds().get(0);
        return condition.getRightThreshold();
    }

    @Override
    public FavoriteRule getOrDefaultByName(String ruleName) {
        return FavoriteRule.getDefaultRuleIfNull(this.getByName(ruleName), ruleName);
    }

    @Override
    protected FavoriteRule copyForWrite(FavoriteRule rule) {
        return rule;
    }

    public void resetRecommendRule() {
        FavoriteRule.getRecommendDefaultRule().forEach(this::updateRule);
    }

    public void resetAutoIndexPlanRule() {
        FavoriteRule.getAutoIndexPlanDefaultRule().forEach(this::updateRule);
    }

    @Override
    protected void saveOrUpdate(FavoriteRule rule) {
        if (rule.getId() == 0) {
            rule.setProject(this.project);
            rule.setCreateTime(System.currentTimeMillis());
            rule.setUpdateTime(rule.getCreateTime());
            this.favoriteRuleStore.save(rule);
        } else {
            rule.setUpdateTime(System.currentTimeMillis());
            this.favoriteRuleStore.update(rule);
        }
    }

    public void delete(FavoriteRule favoriteRule) {
        this.favoriteRuleStore.deleteByName(this.project, favoriteRule.getName());
    }

    public void deleteByProject() {
        this.favoriteRuleStore.deleteByProject(this.project);
    }

    @VisibleForTesting
    public void createRule(FavoriteRule rule) {
        FavoriteRule copy = this.copyForWrite(rule);
        if (this.getByName(copy.getName()) != null) {
            return;
        }
        this.saveOrUpdate(copy);
    }

    @VisibleForTesting
    public List<FavoriteRule> getAllEnabled() {
        ArrayList enabledRules = Lists.newArrayList();
        for (FavoriteRule rule : this.getAll()) {
            if (!rule.isEnabled()) continue;
            enabledRules.add(rule);
        }
        return enabledRules;
    }

    public Set<String> getExcludedTables() {
        FavoriteRule favoriteRule = this.getOrDefaultByName("excluded_tables");
        List<FavoriteRule.AbstractCondition> conditions = favoriteRule.getConds();
        if (CollectionUtils.isEmpty(conditions)) {
            return Sets.newHashSet();
        }
        FavoriteRule.Condition condition = (FavoriteRule.Condition)conditions.get(0);
        return Arrays.stream(condition.getRightThreshold().split(",")).map(table -> table.toUpperCase(Locale.ROOT)).collect(Collectors.toSet());
    }
}

