/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.favorite;

import java.util.List;
import java.util.Locale;
import java.util.Properties;
import javax.sql.DataSource;
import lombok.Generated;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.persistence.metadata.JdbcDataSource;
import org.apache.kylin.common.persistence.metadata.jdbc.JdbcUtil;
import org.apache.kylin.metadata.favorite.FavoriteRule;
import org.apache.kylin.metadata.favorite.FavoriteRuleMapper;
import org.apache.kylin.metadata.favorite.FavoriteRuleTable;
import org.apache.kylin.util.MetadataStoreUtil;
import org.mybatis.dynamic.sql.AndOrCriteriaGroup;
import org.mybatis.dynamic.sql.BasicColumn;
import org.mybatis.dynamic.sql.SqlBuilder;
import org.mybatis.dynamic.sql.SqlTable;
import org.mybatis.dynamic.sql.VisitableCondition;
import org.mybatis.dynamic.sql.delete.DeleteDSL;
import org.mybatis.dynamic.sql.delete.DeleteModel;
import org.mybatis.dynamic.sql.delete.render.DeleteStatementProvider;
import org.mybatis.dynamic.sql.insert.InsertDSL;
import org.mybatis.dynamic.sql.insert.render.InsertStatementProvider;
import org.mybatis.dynamic.sql.render.RenderingStrategies;
import org.mybatis.dynamic.sql.select.QueryExpressionDSL;
import org.mybatis.dynamic.sql.select.SelectModel;
import org.mybatis.dynamic.sql.select.render.SelectStatementProvider;
import org.mybatis.dynamic.sql.update.UpdateDSL;
import org.mybatis.dynamic.sql.update.UpdateModel;
import org.mybatis.dynamic.sql.update.render.UpdateStatementProvider;
import org.mybatis.spring.SqlSessionTemplate;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.jdbc.datasource.DataSourceTransactionManager;

public class FavoriteRuleStore {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(FavoriteRuleStore.class);
    public static final String FAVORITE_RULE = "_favorite_rule";
    private final FavoriteRuleTable table;
    private final SqlSessionTemplate sqlSessionTemplate;
    private final DataSourceTransactionManager transactionManager;

    public FavoriteRuleStore(KylinConfig config) throws Exception {
        this(config, FavoriteRuleStore.genTableName(config));
    }

    private FavoriteRuleStore(KylinConfig config, String tableName) throws Exception {
        StorageURL url = config.getCoreMetadataDBUrl();
        Properties props = JdbcUtil.datasourceParameters((StorageURL)url);
        DataSource dataSource = JdbcDataSource.getDataSource((Properties)props);
        this.table = new FavoriteRuleTable(tableName);
        this.transactionManager = JdbcDataSource.getTransactionManager((DataSource)dataSource);
        this.sqlSessionTemplate = new SqlSessionTemplate(MetadataStoreUtil.getSqlSessionFactory(dataSource, this.table.tableNameAtRuntime(), MetadataStoreUtil.TableType.FAVORITE_RULE));
    }

    private static String genTableName(KylinConfig config) {
        StorageURL url = config.getCoreMetadataDBUrl();
        String tablePrefix = config.isUTEnv() ? "test_opt" : url.getIdentifier();
        return tablePrefix + FAVORITE_RULE;
    }

    public void save(FavoriteRule rule) {
        InsertStatementProvider<FavoriteRule> insertStatement;
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        int rows = mapper.insert(insertStatement = this.getInsertProvider(rule));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to insert favorite rule for project (%s)", rule.getProject()));
        }
        log.debug("Insert one favorite rule for project ({}) into database.", (Object)rule.getProject());
    }

    public void update(FavoriteRule rule) {
        UpdateStatementProvider updateStatement;
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        int rows = mapper.update(updateStatement = this.getUpdateProvider(rule));
        if (rows <= 0) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.FAILED_UPDATE_METADATA, String.format(Locale.ROOT, "Failed to update query history project for project (%s)", rule.getProject()));
        }
        log.debug("Update one favorite rule for project ({})", (Object)rule.getProject());
    }

    public List<FavoriteRule> queryByProject(String project) {
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByProjectStatementProvider(project);
        return mapper.selectMany(statementProvider);
    }

    public FavoriteRule queryByName(String project, String name) {
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = this.getSelectByNameStatementProvider(project, name);
        return mapper.selectOne(statementProvider);
    }

    public List<FavoriteRule> queryAll() {
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        SelectStatementProvider statementProvider = ((SelectModel)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).build()).render(RenderingStrategies.MYBATIS3);
        return mapper.selectMany(statementProvider);
    }

    public void deleteByProject(String project) {
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete favorite rule for project ({})", (Object)project);
    }

    public void deleteByName(String project, String name) {
        FavoriteRuleMapper mapper = (FavoriteRuleMapper)this.sqlSessionTemplate.getMapper(FavoriteRuleMapper.class);
        DeleteStatementProvider deleteStatement = ((DeleteModel)((DeleteDSL.DeleteWhereBuilder)((DeleteDSL.DeleteWhereBuilder)SqlBuilder.deleteFrom((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.name, (VisitableCondition)SqlBuilder.isEqualTo((Object)name), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
        mapper.delete(deleteStatement);
        log.info("Delete favorite rule for project ({})", (Object)project);
    }

    InsertStatementProvider<FavoriteRule> getInsertProvider(FavoriteRule rule) {
        InsertDSL provider = SqlBuilder.insert((Object)rule).into((SqlTable)this.table);
        return provider.map(this.table.project).toProperty("project").map(this.table.conds).toProperty("conds").map(this.table.name).toProperty("name").map(this.table.enabled).toProperty("enabled").map(this.table.updateTime).toProperty("updateTime").map(this.table.createTime).toProperty("createTime").map(this.table.mvcc).toProperty("mvcc").build().render(RenderingStrategies.MYBATIS3);
    }

    UpdateStatementProvider getUpdateProvider(FavoriteRule rule) {
        return ((UpdateModel)((UpdateDSL.UpdateWhereBuilder)((UpdateDSL.UpdateWhereBuilder)SqlBuilder.update((SqlTable)this.table).set(this.table.conds).equalTo(rule::getConds).set(this.table.updateTime).equalTo(rule::getUpdateTime).set(this.table.enabled).equalTo(rule::isEnabled).set(this.table.mvcc).equalTo((Object)(rule.getMvcc() + 1L)).where(this.table.id, (VisitableCondition)SqlBuilder.isEqualTo(rule::getId), new AndOrCriteriaGroup[0])).and(this.table.mvcc, (VisitableCondition)SqlBuilder.isEqualTo(rule::getMvcc), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByProjectStatementProvider(String project) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    SelectStatementProvider getSelectByNameStatementProvider(String project, String name) {
        return ((SelectModel)((QueryExpressionDSL.QueryExpressionWhereBuilder)((QueryExpressionDSL.QueryExpressionWhereBuilder)SqlBuilder.select((BasicColumn[])this.getSelectFields(this.table)).from((SqlTable)this.table).where(this.table.project, (VisitableCondition)SqlBuilder.isEqualTo((Object)project), new AndOrCriteriaGroup[0])).and(this.table.name, (VisitableCondition)SqlBuilder.isEqualTo((Object)name), new AndOrCriteriaGroup[0])).build()).render(RenderingStrategies.MYBATIS3);
    }

    private BasicColumn[] getSelectFields(FavoriteRuleTable ruleTable) {
        return BasicColumn.columnList((BasicColumn[])new BasicColumn[]{ruleTable.id, ruleTable.project, ruleTable.conds, ruleTable.name, ruleTable.enabled, ruleTable.updateTime, ruleTable.createTime, ruleTable.mvcc});
    }

    @Generated
    public SqlSessionTemplate getSqlSessionTemplate() {
        return this.sqlSessionTemplate;
    }

    @Generated
    public DataSourceTransactionManager getTransactionManager() {
        return this.transactionManager;
    }
}

