/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.graph;

import java.util.ArrayList;
import java.util.Objects;
import lombok.NonNull;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.model.ColumnDesc;
import org.apache.kylin.metadata.model.graph.Edge;
import org.apache.kylin.metadata.model.graph.IJoinEdgeMatcher;

public class DefaultJoinEdgeMatcher
implements IJoinEdgeMatcher {
    @Override
    public boolean matches(@NonNull Edge join1, @NonNull Edge join2) {
        if (join1 == null) {
            throw new NullPointerException("join1 is marked @NonNull but is null");
        }
        if (join2 == null) {
            throw new NullPointerException("join2 is marked @NonNull but is null");
        }
        if (join1.isLeftJoin() != join2.isLeftJoin() && !join1.isLeftOrInnerJoin() && !join2.isLeftOrInnerJoin()) {
            return false;
        }
        if (!Objects.equals(join1.nonEquiJoinCondition, join2.nonEquiJoinCondition)) {
            return false;
        }
        if (join1.isLeftJoin()) {
            return this.columnDescEquals(join1.leftCols, join2.leftCols) && this.columnDescEquals(join1.rightCols, join2.rightCols);
        }
        return this.columnDescEquals(join1.leftCols, join2.leftCols) && this.columnDescEquals(join1.rightCols, join2.rightCols) || this.columnDescEquals(join1.leftCols, join2.rightCols) && this.columnDescEquals(join1.rightCols, join2.leftCols);
    }

    private boolean columnDescEquals(ColumnDesc[] a, ColumnDesc[] b) {
        if (a.length != b.length) {
            return false;
        }
        ArrayList oneList = Lists.newArrayList((Object[])a);
        ArrayList anotherList = Lists.newArrayList((Object[])b);
        for (ColumnDesc obj : oneList) {
            anotherList.removeIf(dual -> this.columnDescEquals(obj, (ColumnDesc)dual));
        }
        return anotherList.isEmpty();
    }

    protected boolean columnDescEquals(ColumnDesc a, ColumnDesc b) {
        return Objects.equals(a, b);
    }
}

