/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.schema.strategy;

import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.kylin.metadata.model.schema.SchemaChangeCheckResult;
import org.apache.kylin.metadata.model.schema.SchemaNode;
import org.apache.kylin.metadata.model.schema.SchemaNodeType;
import org.apache.kylin.metadata.model.schema.SchemaUtil;
import org.apache.kylin.metadata.model.schema.strategy.SchemaChangeStrategy;

public class OverWritableStrategy
implements SchemaChangeStrategy {
    @Override
    public List<SchemaNodeType> supportedSchemaNodeTypes() {
        return Arrays.asList(SchemaNodeType.MODEL_DIMENSION, SchemaNodeType.MODEL_MEASURE, SchemaNodeType.RULE_BASED_INDEX, SchemaNodeType.WHITE_LIST_INDEX, SchemaNodeType.TO_BE_DELETED_INDEX);
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> newItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return this.createSchemaChange(difference, entry, importModels, originalModels, originalBrokenModels);
    }

    @Override
    public List<SchemaChangeCheckResult.ChangedItem> reduceItemFunction(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        return this.createSchemaChange(difference, entry, importModels, originalModels, originalBrokenModels);
    }

    private List<SchemaChangeCheckResult.ChangedItem> createSchemaChange(SchemaUtil.SchemaDifference difference, Map.Entry<SchemaNode.SchemaNodeIdentifier, SchemaNode> entry, Set<String> importModels, Set<String> originalModels, Set<String> originalBrokenModels) {
        String modelAlias = entry.getValue().getSubject();
        if (this.overwritable(importModels, originalModels, modelAlias)) {
            return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createOverwritableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
        }
        return Collections.singletonList(SchemaChangeCheckResult.ChangedItem.createCreatableSchemaNode(entry.getKey().getType(), entry.getValue(), this.hasSameName(modelAlias, originalModels), this.hasSameWithBroken(modelAlias, originalBrokenModels)));
    }
}

