/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.model.util;

import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public class MultiPartitionUtil {
    private MultiPartitionUtil() {
    }

    public static boolean isSameValue(String[] values1, String[] values2) {
        if (values1.length != values2.length) {
            return false;
        }
        for (int i = 0; i < values1.length; ++i) {
            if (values1[i].equals(values2[i])) continue;
            return false;
        }
        return true;
    }

    private static Pair<List<String[]>, List<String[]>> partitionValues(List<String[]> originValues, List<String[]> addValues) {
        List<String[]> oldValues = MultiPartitionUtil.cloneList(originValues);
        List<String[]> newValues = MultiPartitionUtil.cloneList(addValues);
        ArrayList duplicates = Lists.newArrayList();
        ArrayList absents = Lists.newArrayList();
        for (String[] newValue : newValues) {
            boolean isSame = false;
            for (String[] oldValue : oldValues) {
                isSame = MultiPartitionUtil.isSameValue(oldValue, newValue);
                if (!isSame) continue;
                duplicates.add(newValue);
                break;
            }
            if (isSame) continue;
            absents.add(newValue);
        }
        return Pair.newPair((Object)duplicates, (Object)absents);
    }

    public static List<String[]> findDuplicateValues(List<String[]> originValues, List<String[]> addValues) {
        return (List)MultiPartitionUtil.partitionValues(originValues, addValues).getFirst();
    }

    public static List<String[]> findAbsentValues(List<String[]> originValues, List<String[]> addValues) {
        return (List)MultiPartitionUtil.partitionValues(originValues, addValues).getSecond();
    }

    public static List<String[]> findDiffValues(List<String[]> allValues, List<String[]> presentValues) {
        ArrayList diffValues = Lists.newArrayList();
        for (String[] value : allValues) {
            if (!presentValues.stream().noneMatch(v -> MultiPartitionUtil.isSameValue(v, value))) continue;
            diffValues.add(value);
        }
        return diffValues;
    }

    public static List<String[]> cloneList(List<String[]> list) {
        ArrayList result = Lists.newArrayList();
        if (CollectionUtils.isNotEmpty(list)) {
            list.forEach(arr -> result.add(arr.clone()));
        }
        return result;
    }
}

