/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.project;

import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.hystrix.NCircuitBreaker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.model.MeasureDesc;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.kylin.metadata.project.NProjectLoader;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.realization.IRealization;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NProjectManager {
    private static final Logger logger = LoggerFactory.getLogger(NProjectManager.class);
    private final KylinConfig config;
    private final NProjectLoader projectLoader;
    private final CachedCrudAssist<ProjectInstance> crud;

    public static NProjectManager getInstance(KylinConfig config) {
        return (NProjectManager)config.getManager(NProjectManager.class);
    }

    static NProjectManager newInstance(KylinConfig config) {
        return new NProjectManager(config);
    }

    public NProjectManager(final KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing NProjectManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.projectLoader = new NProjectLoader(config);
        this.crud = new CachedCrudAssist<ProjectInstance>(this.getStore(), MetadataType.PROJECT, null, ProjectInstance.class){

            @Override
            protected ProjectInstance initEntityAfterReload(ProjectInstance entity, String projectName) {
                entity.init(config);
                return entity;
            }
        };
    }

    public List<ProjectInstance> listAllProjects() {
        return this.crud.listAll();
    }

    public void reloadAll() {
        this.crud.reloadAll();
    }

    public void invalidCache(String resourceName) {
        this.crud.invalidateCache(resourceName);
    }

    public ProjectInstance getProject(String projectName) {
        return this.crud.get(projectName);
    }

    public ProjectInstance getProjectById(String projectId) {
        return this.crud.listByFilter(RawResourceFilter.equalFilter((String)"uuid", (String)projectId)).stream().findAny().orElse(null);
    }

    public ProjectInstance createProject(String projectName, String owner, String description, LinkedHashMap<String, String> overrideProps) {
        logger.info("Creating project " + projectName);
        ProjectInstance currentProject = this.getProject(projectName);
        if (currentProject != null) {
            throw new IllegalStateException("The project named " + projectName + "already exists");
        }
        NCircuitBreaker.verifyProjectCreation((int)this.listAllProjects().size());
        currentProject = this.copyForWrite(ProjectInstance.create(projectName, owner, description, overrideProps));
        currentProject.initConfig(this.config);
        this.checkOverrideProps(currentProject);
        return this.save(currentProject);
    }

    private void checkOverrideProps(ProjectInstance prj) {
        LinkedHashMap<String, String> overrideProps = prj.getOverrideKylinProps();
        if (overrideProps == null) {
            return;
        }
        for (Map.Entry<String, String> entry : overrideProps.entrySet()) {
            if (!StringUtils.isAnyBlank((CharSequence[])new CharSequence[]{entry.getKey(), entry.getValue()})) continue;
            throw new IllegalStateException("Property key/value must not be blank");
        }
    }

    public ProjectInstance dropProject(String projectName) {
        if (StringUtils.isEmpty((CharSequence)projectName)) {
            throw new IllegalArgumentException("Project name not given");
        }
        ProjectInstance projectInstance = this.getProject(projectName);
        if (projectInstance == null) {
            throw new IllegalStateException("The project named " + projectName + " does not exist");
        }
        if (projectInstance.getRealizationCount(null) != 0) {
            throw new IllegalStateException("The project named " + projectName + " can not be deleted because there's still realizations in it. Delete them first.");
        }
        logger.info("Dropping project '" + projectInstance.getName() + "'");
        this.crud.delete(projectName);
        return projectInstance;
    }

    public ProjectInstance updateProject(ProjectInstance project, String newName, String newDesc, LinkedHashMap<String, String> overrideProps) {
        Preconditions.checkArgument((boolean)project.getName().equals(newName));
        return this.updateProject(newName, copyForWrite -> {
            copyForWrite.setName(newName);
            copyForWrite.setDescription(newDesc);
            copyForWrite.setOverrideKylinProps(overrideProps);
            if (copyForWrite.getUuid() == null) {
                copyForWrite.updateRandomUuid();
            }
        });
    }

    private ProjectInstance updateProject(ProjectInstance project) {
        if (this.getProject(project.getName()) == null) {
            throw new IllegalArgumentException("Project '" + project.getName() + "' does not exist!");
        }
        return this.save(project);
    }

    public ProjectInstance copyForWrite(ProjectInstance projectInstance) {
        Preconditions.checkNotNull((Object)projectInstance);
        return this.crud.copyForWrite(projectInstance);
    }

    private ProjectInstance save(ProjectInstance prj) {
        Preconditions.checkArgument((prj != null ? 1 : 0) != 0);
        if (this.getStore().getConfig().isCheckCopyOnWrite() && prj.isCachedAndShared()) {
            throw new IllegalStateException("Copy-on-write violation! The updating entity " + prj + " is a shared object in " + ProjectInstance.class.getSimpleName() + " cache, which should not be.");
        }
        this.crud.save(prj);
        return prj;
    }

    public String getDefaultDatabase(String project) {
        return this.getProject(project).getDefaultDatabase();
    }

    public Set<IRealization> listAllRealizations(String project) {
        return this.projectLoader.listAllRealizations(project);
    }

    public List<NDataModel> listHealthyModels(String project) {
        return this.listAllRealizations(project).stream().map(IRealization::getModel).filter(Objects::nonNull).collect(Collectors.toList());
    }

    public List<MeasureDesc> listEffectiveRewriteMeasures(String project, String factTable) {
        return this.projectLoader.listEffectiveRewriteMeasures(project, factTable);
    }

    KylinConfig getConfig() {
        return this.config;
    }

    ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public void forceDropProject(String project) {
        if (StringUtils.isEmpty((CharSequence)project)) {
            throw new IllegalArgumentException("Project name not given");
        }
        ProjectInstance projectInstance = this.getProject(project);
        if (projectInstance == null) {
            throw new IllegalStateException("The project named " + project + " does not exist");
        }
        RawResourceFilter filter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.EQUAL_CASE_INSENSITIVE, (String)"project", (Object)project);
        MetadataType.NON_GLOBAL_METADATA_TYPE.forEach(type -> {
            NavigableSet paths = Optional.ofNullable(this.getStore().listResourcesRecursively(type.name(), filter)).orElse(Sets.newTreeSet());
            for (String path : paths) {
                this.getStore().deleteResource(path);
            }
        });
        this.crud.delete(project);
    }

    public ProjectInstance updateProject(String project, NProjectUpdater updater) {
        ProjectInstance cached = this.getProject(project);
        ProjectInstance copy = this.copyForWrite(cached);
        updater.modify(copy);
        return this.updateProject(copy);
    }

    public static KylinConfig getProjectConfig(String project) {
        KylinConfig envConfig = KylinConfig.getInstanceFromEnv();
        if (project == null) {
            logger.warn("The project name is null, return KylinCong.getInstanceFromEnv() instead.");
            return envConfig;
        }
        ProjectInstance projectInstance = NProjectManager.getInstance(envConfig).getProject(project);
        return projectInstance == null ? envConfig : projectInstance.getConfig();
    }

    public static Set<IRealization> getRealizations(KylinConfig config, String project, String tableName) {
        return NProjectManager.getInstance((KylinConfig)config).projectLoader.getRealizationsByTable(project, tableName.toUpperCase(Locale.ROOT));
    }

    public static interface NProjectUpdater {
        public void modify(ProjectInstance var1);
    }
}

