/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query;

import java.io.Serializable;
import java.util.List;
import lombok.Generated;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.scheduler.SchedulerEventNotifier;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.metadata.query.QueryHistoryInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryMetrics
extends SchedulerEventNotifier {
    protected static final Logger logger = LoggerFactory.getLogger(QueryMetrics.class);
    protected static final KapConfig kapConfig = KapConfig.getInstanceFromEnv();
    public static final String UNKNOWN = "Unknown";
    public static final String FILTER_CONFLICT = "Filter Conflict";
    public static final String AGG_INDEX = "Agg Index";
    public static final String TABLE_INDEX = "Table Index";
    public static final String TABLE_SNAPSHOT = "Table Snapshot";
    public static final String INTERNAL_TABLE = "Internal Table";
    public static final String TOTAL_SCAN_COUNT = "totalScanCount";
    public static final String TOTAL_SCAN_BYTES = "totalScanBytes";
    public static final String SOURCE_RESULT_COUNT = "sourceResultCount";
    public static final String QUERY_RESPONSE_TIME = "QUERY_RESPONSE_TIME";
    protected long id;
    protected final String queryId;
    protected long queryTime;
    protected String projectName;
    protected String sql;
    protected String sqlPattern;
    protected String submitter;
    protected String server;
    protected long queryDuration;
    protected long totalScanBytes;
    protected long totalScanCount;
    protected long resultRowCount;
    protected long queryJobCount;
    protected long queryStageCount;
    protected long queryTaskCount;
    protected long cpuTime;
    protected boolean isPushdown;
    protected String engineType;
    protected boolean isCacheHit;
    protected String cacheType;
    protected String queryMsg;
    protected boolean isIndexHit;
    protected boolean isTimeout;
    protected String errorType;
    protected String queryStatus;
    protected String month;
    protected long queryFirstDayOfMonth;
    protected long queryFirstDayOfWeek;
    protected long queryDay;
    protected boolean tableIndexUsed;
    protected boolean aggIndexUsed;
    protected boolean tableSnapshotUsed;
    protected String defaultServer;
    protected QueryHistoryInfo queryHistoryInfo;
    protected boolean isUpdateMetrics = false;

    public QueryMetrics(String queryId) {
        this.queryId = queryId;
    }

    public QueryMetrics(String queryId, String defaultServer) {
        this.queryId = queryId;
        this.defaultServer = defaultServer;
    }

    public List<RealizationMetrics> getRealizationMetrics() {
        return ImmutableList.copyOf(this.queryHistoryInfo.realizationMetrics);
    }

    public boolean isSucceed() {
        return "SUCCEEDED".equals(this.queryStatus);
    }

    @Generated
    public long getId() {
        return this.id;
    }

    @Generated
    public String getQueryId() {
        return this.queryId;
    }

    @Generated
    public long getQueryTime() {
        return this.queryTime;
    }

    @Generated
    public String getProjectName() {
        return this.projectName;
    }

    @Generated
    public String getSql() {
        return this.sql;
    }

    @Generated
    public String getSqlPattern() {
        return this.sqlPattern;
    }

    @Generated
    public String getSubmitter() {
        return this.submitter;
    }

    @Generated
    public String getServer() {
        return this.server;
    }

    @Generated
    public long getQueryDuration() {
        return this.queryDuration;
    }

    @Generated
    public long getTotalScanBytes() {
        return this.totalScanBytes;
    }

    @Generated
    public long getTotalScanCount() {
        return this.totalScanCount;
    }

    @Generated
    public long getResultRowCount() {
        return this.resultRowCount;
    }

    @Generated
    public long getQueryJobCount() {
        return this.queryJobCount;
    }

    @Generated
    public long getQueryStageCount() {
        return this.queryStageCount;
    }

    @Generated
    public long getQueryTaskCount() {
        return this.queryTaskCount;
    }

    @Generated
    public long getCpuTime() {
        return this.cpuTime;
    }

    @Generated
    public boolean isPushdown() {
        return this.isPushdown;
    }

    @Generated
    public String getEngineType() {
        return this.engineType;
    }

    @Generated
    public boolean isCacheHit() {
        return this.isCacheHit;
    }

    @Generated
    public String getCacheType() {
        return this.cacheType;
    }

    @Generated
    public String getQueryMsg() {
        return this.queryMsg;
    }

    @Generated
    public boolean isIndexHit() {
        return this.isIndexHit;
    }

    @Generated
    public boolean isTimeout() {
        return this.isTimeout;
    }

    @Generated
    public String getErrorType() {
        return this.errorType;
    }

    @Generated
    public String getQueryStatus() {
        return this.queryStatus;
    }

    @Generated
    public String getMonth() {
        return this.month;
    }

    @Generated
    public long getQueryFirstDayOfMonth() {
        return this.queryFirstDayOfMonth;
    }

    @Generated
    public long getQueryFirstDayOfWeek() {
        return this.queryFirstDayOfWeek;
    }

    @Generated
    public long getQueryDay() {
        return this.queryDay;
    }

    @Generated
    public boolean isTableIndexUsed() {
        return this.tableIndexUsed;
    }

    @Generated
    public boolean isAggIndexUsed() {
        return this.aggIndexUsed;
    }

    @Generated
    public boolean isTableSnapshotUsed() {
        return this.tableSnapshotUsed;
    }

    @Generated
    public String getDefaultServer() {
        return this.defaultServer;
    }

    @Generated
    public QueryHistoryInfo getQueryHistoryInfo() {
        return this.queryHistoryInfo;
    }

    @Generated
    public boolean isUpdateMetrics() {
        return this.isUpdateMetrics;
    }

    @Generated
    public void setId(long id) {
        this.id = id;
    }

    @Generated
    public void setQueryTime(long queryTime) {
        this.queryTime = queryTime;
    }

    @Generated
    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @Generated
    public void setSql(String sql) {
        this.sql = sql;
    }

    @Generated
    public void setSqlPattern(String sqlPattern) {
        this.sqlPattern = sqlPattern;
    }

    @Generated
    public void setSubmitter(String submitter) {
        this.submitter = submitter;
    }

    @Generated
    public void setServer(String server) {
        this.server = server;
    }

    @Generated
    public void setQueryDuration(long queryDuration) {
        this.queryDuration = queryDuration;
    }

    @Generated
    public void setTotalScanBytes(long totalScanBytes) {
        this.totalScanBytes = totalScanBytes;
    }

    @Generated
    public void setTotalScanCount(long totalScanCount) {
        this.totalScanCount = totalScanCount;
    }

    @Generated
    public void setResultRowCount(long resultRowCount) {
        this.resultRowCount = resultRowCount;
    }

    @Generated
    public void setQueryJobCount(long queryJobCount) {
        this.queryJobCount = queryJobCount;
    }

    @Generated
    public void setQueryStageCount(long queryStageCount) {
        this.queryStageCount = queryStageCount;
    }

    @Generated
    public void setQueryTaskCount(long queryTaskCount) {
        this.queryTaskCount = queryTaskCount;
    }

    @Generated
    public void setCpuTime(long cpuTime) {
        this.cpuTime = cpuTime;
    }

    @Generated
    public void setPushdown(boolean isPushdown) {
        this.isPushdown = isPushdown;
    }

    @Generated
    public void setEngineType(String engineType) {
        this.engineType = engineType;
    }

    @Generated
    public void setCacheHit(boolean isCacheHit) {
        this.isCacheHit = isCacheHit;
    }

    @Generated
    public void setCacheType(String cacheType) {
        this.cacheType = cacheType;
    }

    @Generated
    public void setQueryMsg(String queryMsg) {
        this.queryMsg = queryMsg;
    }

    @Generated
    public void setIndexHit(boolean isIndexHit) {
        this.isIndexHit = isIndexHit;
    }

    @Generated
    public void setTimeout(boolean isTimeout) {
        this.isTimeout = isTimeout;
    }

    @Generated
    public void setErrorType(String errorType) {
        this.errorType = errorType;
    }

    @Generated
    public void setQueryStatus(String queryStatus) {
        this.queryStatus = queryStatus;
    }

    @Generated
    public void setMonth(String month) {
        this.month = month;
    }

    @Generated
    public void setQueryFirstDayOfMonth(long queryFirstDayOfMonth) {
        this.queryFirstDayOfMonth = queryFirstDayOfMonth;
    }

    @Generated
    public void setQueryFirstDayOfWeek(long queryFirstDayOfWeek) {
        this.queryFirstDayOfWeek = queryFirstDayOfWeek;
    }

    @Generated
    public void setQueryDay(long queryDay) {
        this.queryDay = queryDay;
    }

    @Generated
    public void setTableIndexUsed(boolean tableIndexUsed) {
        this.tableIndexUsed = tableIndexUsed;
    }

    @Generated
    public void setAggIndexUsed(boolean aggIndexUsed) {
        this.aggIndexUsed = aggIndexUsed;
    }

    @Generated
    public void setTableSnapshotUsed(boolean tableSnapshotUsed) {
        this.tableSnapshotUsed = tableSnapshotUsed;
    }

    @Generated
    public void setDefaultServer(String defaultServer) {
        this.defaultServer = defaultServer;
    }

    @Generated
    public void setQueryHistoryInfo(QueryHistoryInfo queryHistoryInfo) {
        this.queryHistoryInfo = queryHistoryInfo;
    }

    @Generated
    public void setUpdateMetrics(boolean isUpdateMetrics) {
        this.isUpdateMetrics = isUpdateMetrics;
    }

    public static class QueryMetric
    implements Serializable {
        protected String name;
        protected Serializable value;

        public QueryMetric() {
        }

        public QueryMetric(String name, Serializable value) {
            this.name = name;
            this.value = value;
        }

        @Generated
        public String getName() {
            return this.name;
        }

        @Generated
        public Serializable getValue() {
            return this.value;
        }

        @Generated
        public void setName(String name) {
            this.name = name;
        }

        @Generated
        public void setValue(Serializable value) {
            this.value = value;
        }
    }

    public static class RealizationMetrics
    implements Serializable {
        protected String queryId;
        protected long duration;
        protected String layoutId;
        protected String indexType;
        protected String modelId;
        protected long queryTime;
        protected String projectName;
        protected boolean isStreamingLayout;
        protected List<String> snapshots;
        protected long queryFirstDayOfMonth;
        protected long queryFirstDayOfWeek;
        protected long queryDay;

        public RealizationMetrics() {
        }

        public RealizationMetrics(String layoutId, String indexType, String modelId, List<String> snapshots) {
            this.layoutId = layoutId;
            this.indexType = indexType;
            this.modelId = modelId;
            this.snapshots = snapshots;
        }

        @Generated
        public String getQueryId() {
            return this.queryId;
        }

        @Generated
        public long getDuration() {
            return this.duration;
        }

        @Generated
        public String getLayoutId() {
            return this.layoutId;
        }

        @Generated
        public String getIndexType() {
            return this.indexType;
        }

        @Generated
        public String getModelId() {
            return this.modelId;
        }

        @Generated
        public long getQueryTime() {
            return this.queryTime;
        }

        @Generated
        public String getProjectName() {
            return this.projectName;
        }

        @Generated
        public boolean isStreamingLayout() {
            return this.isStreamingLayout;
        }

        @Generated
        public List<String> getSnapshots() {
            return this.snapshots;
        }

        @Generated
        public long getQueryFirstDayOfMonth() {
            return this.queryFirstDayOfMonth;
        }

        @Generated
        public long getQueryFirstDayOfWeek() {
            return this.queryFirstDayOfWeek;
        }

        @Generated
        public long getQueryDay() {
            return this.queryDay;
        }

        @Generated
        public void setQueryId(String queryId) {
            this.queryId = queryId;
        }

        @Generated
        public void setDuration(long duration) {
            this.duration = duration;
        }

        @Generated
        public void setLayoutId(String layoutId) {
            this.layoutId = layoutId;
        }

        @Generated
        public void setIndexType(String indexType) {
            this.indexType = indexType;
        }

        @Generated
        public void setModelId(String modelId) {
            this.modelId = modelId;
        }

        @Generated
        public void setQueryTime(long queryTime) {
            this.queryTime = queryTime;
        }

        @Generated
        public void setProjectName(String projectName) {
            this.projectName = projectName;
        }

        @Generated
        public void setStreamingLayout(boolean isStreamingLayout) {
            this.isStreamingLayout = isStreamingLayout;
        }

        @Generated
        public void setSnapshots(List<String> snapshots) {
            this.snapshots = snapshots;
        }

        @Generated
        public void setQueryFirstDayOfMonth(long queryFirstDayOfMonth) {
            this.queryFirstDayOfMonth = queryFirstDayOfMonth;
        }

        @Generated
        public void setQueryFirstDayOfWeek(long queryFirstDayOfWeek) {
            this.queryFirstDayOfWeek = queryFirstDayOfWeek;
        }

        @Generated
        public void setQueryDay(long queryDay) {
            this.queryDay = queryDay;
        }
    }
}

