/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.query.util;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.sql.JDBCType;
import java.text.SimpleDateFormat;
import java.time.ZoneOffset;
import java.util.Locale;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.calcite.avatica.ColumnMetaData;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.NativeQueryRealization;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.metadata.query.QueryHistory;
import org.apache.kylin.metadata.query.QueryHistorySql;

public class QueryHistoryUtil {
    private QueryHistoryUtil() {
        throw new IllegalStateException("Utility class");
    }

    public static String getDownloadData(QueryHistory queryHistory, ZoneOffset zoneOffset, int zoneOffsetOfHours) {
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss", Locale.getDefault(Locale.Category.FORMAT));
        simpleDateFormat.setTimeZone(TimeZone.getTimeZone(zoneOffset));
        String sign = zoneOffsetOfHours > 0 ? "+" : "";
        String formatQueryTime = simpleDateFormat.format(queryHistory.getQueryTime()) + " GMT" + sign + zoneOffsetOfHours;
        String answerBy = queryHistory.getNativeQueryRealizations() != null && !queryHistory.getNativeQueryRealizations().isEmpty() ? "\"[" + StringUtils.join((Iterable)queryHistory.getNativeQueryRealizations().stream().map(NativeQueryRealization::getModelAlias).collect(Collectors.toList()), (char)',') + "]\"" : queryHistory.getEngineType();
        String queryMsg = queryHistory.getQueryHistoryInfo().getQueryMsg();
        if (StringUtils.isNotEmpty((CharSequence)queryMsg)) {
            queryMsg = "\"" + queryMsg.replace("\"", "\"\"") + "\"";
        }
        QueryHistorySql queryHistorySql = queryHistory.getQueryHistorySql();
        String sql = queryHistorySql.getNormalizedSql();
        return StringUtils.join((Iterable)Lists.newArrayList((Object[])new String[]{formatQueryTime, queryHistory.getDuration() + "ms", queryHistory.getQueryId(), "\"" + sql.replace("\"", "\"\"") + "\"", answerBy, queryHistory.getQueryStatus(), queryHistory.getHostName(), queryHistory.getQuerySubmitter(), queryMsg}), (char)',').replaceAll("\n|\r", " ");
    }

    public static String toQueryHistorySqlText(QueryHistorySql queryHistorySql) throws JsonProcessingException {
        return JsonUtil.writeValueAsString((Object)queryHistorySql);
    }

    public static String toDataType(String className) throws ClassNotFoundException {
        ColumnMetaData.Rep rep = ColumnMetaData.Rep.of(Class.forName(className));
        return JDBCType.valueOf(rep.typeId).getName();
    }
}

