/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.resourcegroup;

import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.AddressUtil;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.resourcegroup.KylinInstance;
import org.apache.kylin.metadata.resourcegroup.RequestTypeEnum;
import org.apache.kylin.metadata.resourcegroup.ResourceGroup;
import org.apache.kylin.metadata.resourcegroup.ResourceGroupMappingInfo;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceGroupManager {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ResourceGroupManager.class);
    private KylinConfig config;
    private CachedCrudAssist<ResourceGroup> crud;

    public static ResourceGroupManager getInstance(KylinConfig config) {
        return (ResourceGroupManager)config.getManager(ResourceGroupManager.class);
    }

    static ResourceGroupManager newInstance(KylinConfig config) {
        return new ResourceGroupManager(config);
    }

    private ResourceGroupManager(KylinConfig cfg) {
        this.config = cfg;
        this.crud = new CachedCrudAssist<ResourceGroup>(this.getStore(), MetadataType.RESOURCE_GROUP, null, ResourceGroup.class){

            @Override
            protected ResourceGroup initEntityAfterReload(ResourceGroup entity, String resourceName) {
                return entity;
            }
        };
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public ResourceGroup getResourceGroup() {
        return this.crud.get("relation");
    }

    public boolean resourceGroupInitialized() {
        return this.getResourceGroup() != null;
    }

    public boolean isProjectBindToResourceGroup(String project) {
        if ("_global".equals(project)) {
            return true;
        }
        return this.getResourceGroup().getResourceGroupMappingInfoList().stream().anyMatch(mapping -> project.equalsIgnoreCase(mapping.getProject()));
    }

    public boolean isResourceGroupEnabled() {
        if (!this.resourceGroupInitialized()) {
            return false;
        }
        return this.getResourceGroup().isResourceGroupEnabled();
    }

    public void initResourceGroup() {
        if (!this.resourceGroupInitialized()) {
            this.save(this.copyForWrite(new ResourceGroup()));
        }
    }

    public ResourceGroup updateResourceGroup(ResourceGroupUpdater updater) {
        ResourceGroup cached = this.getResourceGroup();
        ResourceGroup copy = this.copyForWrite(cached);
        updater.modify(copy);
        return this.updateResourceGroup(copy);
    }

    public List<String> getInstancesForProject(String project) {
        ResourceGroup resourceGroup = this.getResourceGroup();
        List ids = resourceGroup.getResourceGroupMappingInfoList().stream().filter(mapping -> project.equalsIgnoreCase(mapping.getProject()) && mapping.getRequestType() == RequestTypeEnum.BUILD).map(ResourceGroupMappingInfo::getResourceGroupId).distinct().collect(Collectors.toList());
        return resourceGroup.getKylinInstances().stream().filter(instance -> ids.contains(instance.getResourceGroupId())).map(KylinInstance::getInstance).collect(Collectors.toList());
    }

    public List<String> listProjectWithPermission() {
        if (!this.isResourceGroupEnabled()) {
            return NProjectManager.getInstance(this.config).listAllProjects().stream().map(ProjectInstance::getName).collect(Collectors.toList());
        }
        ResourceGroup resourceGroup = this.getResourceGroup();
        String server = AddressUtil.getLocalInstance();
        String currentServerResourceGroupId = resourceGroup.getKylinInstances().stream().filter(instance -> instance.getInstance().equals(server)).map(KylinInstance::getResourceGroupId).findFirst().orElse(null);
        return resourceGroup.getResourceGroupMappingInfoList().stream().filter(mappingInfo -> mappingInfo.getRequestType() == RequestTypeEnum.BUILD && mappingInfo.getResourceGroupId().equals(currentServerResourceGroupId)).map(ResourceGroupMappingInfo::getProject).distinct().collect(Collectors.toList());
    }

    private ResourceGroup copyForWrite(ResourceGroup resourceGroup) {
        Preconditions.checkNotNull((Object)((Object)resourceGroup));
        return this.crud.copyForWrite(resourceGroup);
    }

    private ResourceGroup updateResourceGroup(ResourceGroup resourceGroup) {
        if (!this.crud.contains("relation")) {
            throw new IllegalArgumentException("Resource Group metadata does not exist!");
        }
        return this.save(resourceGroup);
    }

    private ResourceGroup save(ResourceGroup resourceGroup) {
        this.crud.save(resourceGroup);
        return resourceGroup;
    }

    public boolean checkServer(String host) {
        if (StringUtils.isBlank((CharSequence)host)) {
            return true;
        }
        if (this.isResourceGroupEnabled()) {
            return this.getResourceGroup().getKylinInstances().stream().map(KylinInstance::getInstance).noneMatch(server -> StringUtils.equals((CharSequence)server, (CharSequence)host));
        }
        return true;
    }

    public static interface ResourceGroupUpdater {
        public void modify(ResourceGroup var1);
    }
}

