/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.sourceusage;

import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.NavigableSet;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.exception.CommonErrorCode;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.mail.MailNotificationType;
import org.apache.kylin.common.mail.MailNotifier;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.RawResourceFilter;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.cube.model.NCubeJoinedFlatTableDesc;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.model.TblColRef;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.sourceusage.LicenseInfo;
import org.apache.kylin.metadata.sourceusage.SourceUsageRecord;
import org.apache.kylin.metadata.sourceusage.mail.SourceUsageMailUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SourceUsageManager {
    private static final Logger logger = LoggerFactory.getLogger(SourceUsageManager.class);
    final KylinConfig config;
    private final CachedCrudAssist<SourceUsageRecord> crud;

    public static SourceUsageManager getInstance(KylinConfig config) {
        return (SourceUsageManager)config.getManager(SourceUsageManager.class);
    }

    static SourceUsageManager newInstance(KylinConfig config) {
        return new SourceUsageManager(config);
    }

    private SourceUsageManager(KylinConfig config) {
        this.config = config;
        this.crud = new CachedCrudAssist<SourceUsageRecord>(this.getStore(), MetadataType.HISTORY_SOURCE_USAGE, null, SourceUsageRecord.class){

            @Override
            protected SourceUsageRecord initEntityAfterReload(SourceUsageRecord entity, String resourceName) {
                entity.setResPath(MetadataType.mergeKeyWithType((String)resourceName, (MetadataType)MetadataType.HISTORY_SOURCE_USAGE));
                return entity;
            }
        };
    }

    public SourceUsageRecord getSourceUsageRecord(String resourceName) {
        return this.crud.get(resourceName);
    }

    public SourceUsageRecord copy(SourceUsageRecord df) {
        return this.crud.copyBySerialization(df);
    }

    public SourceUsageRecord copyForWrite(SourceUsageRecord df) {
        return this.crud.copyForWrite(df);
    }

    public SourceUsageRecord createSourceUsageRecord(String resourceName, SourceUsageRecord record) {
        record.setResPath(MetadataType.mergeKeyWithType((String)resourceName, (MetadataType)MetadataType.HISTORY_SOURCE_USAGE));
        SourceUsageRecord copy = this.copyForWrite(record);
        return this.crud.save(copy);
    }

    public SourceUsageRecord updateSourceUsageRecord(String resourceName, SourceUsageRecordUpdater updater) {
        SourceUsageRecord record = this.getSourceUsageRecord(resourceName);
        if (record == null) {
            record = new SourceUsageRecord();
        }
        SourceUsageRecord copy = this.copyForWrite(record);
        updater.modify(copy);
        return this.crud.save(copy);
    }

    public Map<String, Long> calcAvgColumnSourceBytes(NDataSegment segment) {
        Set<TblColRef> usedColumns;
        HashMap columnSourceBytes = Maps.newHashMap();
        try {
            usedColumns = new NCubeJoinedFlatTableDesc(segment).getUsedColumns();
        }
        catch (Exception e) {
            return columnSourceBytes;
        }
        long inputRecordsSize = segment.getSourceBytesSize();
        if (inputRecordsSize == -1L) {
            logger.debug("Source bytes size for segment: {} is -1", (Object)segment);
            return columnSourceBytes;
        }
        if (usedColumns.isEmpty()) {
            logger.debug("No effective columns found in segment: {}", (Object)segment);
            return columnSourceBytes;
        }
        ArrayList allColumns = Lists.newArrayList(segment.getModel().getEffectiveNamedColumns().values());
        int columnSize = allColumns.isEmpty() ? usedColumns.size() : allColumns.size();
        long perColumnSize = inputRecordsSize / (long)columnSize;
        for (TblColRef tblColRef : usedColumns) {
            columnSourceBytes.put(tblColRef.getCanonicalName(), perColumnSize);
        }
        return columnSourceBytes;
    }

    public SourceUsageRecord updateSourceUsage(SourceUsageRecord sourceUsageRecord) {
        this.createOrUpdate(sourceUsageRecord);
        return sourceUsageRecord;
    }

    private void createOrUpdate(SourceUsageRecord usageRecord) {
        try {
            SourceUsageRecord record;
            String resourceName = usageRecord.resourceName();
            if (resourceName == null) {
                resourceName = DateFormat.formatToCompactDateStr((long)System.currentTimeMillis());
            }
            record = (record = this.getSourceUsageRecord(resourceName)) == null ? this.createSourceUsageRecord(resourceName, usageRecord) : this.updateSourceUsageRecord(resourceName, copyForWrite -> {
                boolean isSuccessful;
                copyForWrite.setLicenseCapacity(usageRecord.getLicenseCapacity());
                copyForWrite.setCapacityDetails(usageRecord.getCapacityDetails());
                copyForWrite.setCapacityStatus(usageRecord.getCapacityStatus());
                copyForWrite.setCheckTime(usageRecord.getCheckTime());
                copyForWrite.setCurrentCapacity(usageRecord.getCurrentCapacity());
                if (!this.isOverCapacityThreshold(copyForWrite) && !copyForWrite.isCapacityNotification()) {
                    copyForWrite.setCapacityNotification(true);
                    logger.info("Capacity usage is less than threshold, enable notification");
                } else if (copyForWrite.isCapacityNotification() && this.config.isOverCapacityNotificationEnabled() && this.isOverCapacityThreshold(copyForWrite) && (isSuccessful = MailNotifier.notifyUser((KylinConfig)this.config, SourceUsageMailUtil.createMail(MailNotificationType.OVER_LICENSE_CAPACITY_THRESHOLD, copyForWrite.getLicenseCapacity(), copyForWrite.getCurrentCapacity()), (List)Lists.newArrayList((Object[])this.config.getOverCapacityMailingList())))) {
                    copyForWrite.setCapacityNotification(false);
                    logger.info("Capacity usage is more than threshold and notify user, disable notification");
                }
            });
            usageRecord.setCapacityNotification(record.isCapacityNotification());
        }
        catch (Exception e) {
            logger.error("Failed to update source usage record.", (Throwable)e);
        }
    }

    private ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public SourceUsageRecord getLatestRecord() {
        int oneDay = 24;
        SourceUsageRecord r = this.getLatestRecord(oneDay);
        if (r == null) {
            r = this.getLatestRecord(oneDay * 7);
        }
        if (r == null) {
            r = this.getLatestRecord(oneDay * 31);
        }
        if (r == null) {
            return this.getLatestRecord(oneDay * this.getThresholdByDayFromOrigin());
        }
        return r;
    }

    public SourceUsageRecord getLatestRecord(int hoursAgo) {
        List<SourceUsageRecord> recordList = this.getLatestRecordByHours(hoursAgo);
        if (CollectionUtils.isEmpty(recordList)) {
            return null;
        }
        return Collections.max(recordList, (o1, o2) -> {
            long comp = o1.getLastModified() - o2.getLastModified();
            if (comp == 0L) {
                return 0;
            }
            return comp < 0L ? -1 : 1;
        });
    }

    public List<SourceUsageRecord> getLatestRecordByMs(long msAgo) {
        long from = System.currentTimeMillis() - msAgo;
        RawResourceFilter filter = RawResourceFilter.simpleFilter((RawResourceFilter.Operator)RawResourceFilter.Operator.GT, (String)"createTime", (Object)from);
        return this.crud.listByFilter(filter);
    }

    public List<SourceUsageRecord> getAllRecords() {
        return this.crud.listAll();
    }

    public List<SourceUsageRecord> getAllRecordsWithoutInit() {
        ResourceStore resourceStore = ResourceStore.getKylinMetaStore((KylinConfig)this.config);
        NavigableSet allResourcePaths = resourceStore.listResources(MetadataType.HISTORY_SOURCE_USAGE.name());
        if (allResourcePaths == null) {
            return Lists.newArrayList();
        }
        return allResourcePaths.stream().map(this::getRecordWithoutInit).collect(Collectors.toList());
    }

    private SourceUsageRecord getRecordWithoutInit(String path) {
        try {
            RawResource resource = ResourceStore.getKylinMetaStore((KylinConfig)this.config).getResource(path);
            SourceUsageRecord record = (SourceUsageRecord)((Object)JsonUtil.readValue((byte[])resource.getByteSource().read(), SourceUsageRecord.class));
            record.setMvcc(resource.getMvcc());
            return record;
        }
        catch (IOException e) {
            throw new KylinException((ErrorCodeSupplier)CommonErrorCode.UNKNOWN_ERROR_CODE, (Throwable)e);
        }
    }

    public void delSourceUsage(String resourceName) {
        this.crud.delete(resourceName);
    }

    public List<SourceUsageRecord> getLatestRecordByHours(int hoursAgo) {
        return this.getLatestRecordByMs((long)hoursAgo * 3600L * 1000L);
    }

    public List<SourceUsageRecord> getLatestRecordByDays(int daysAgo) {
        return this.getLatestRecordByHours(daysAgo * 24);
    }

    private int getThresholdByDayFromOrigin() {
        try {
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd", Locale.getDefault(Locale.Category.FORMAT));
            Date date = simpleDateFormat.parse("1970-01-01");
            return (int)((System.currentTimeMillis() - date.getTime()) / 86400000L);
        }
        catch (ParseException e) {
            logger.error("parser date error", (Throwable)e);
            return 3650;
        }
    }

    public List<SourceUsageRecord> getLastMonthRecords() {
        return this.getLatestRecordByDays(30);
    }

    private boolean isNotOk(SourceUsageRecord.CapacityStatus status) {
        return SourceUsageRecord.CapacityStatus.TENTATIVE == status || SourceUsageRecord.CapacityStatus.ERROR == status;
    }

    private void setNodeInfo(LicenseInfo info) {
        List servers = this.config.getAllServers();
        int currentNodes = servers.size();
        info.setCurrentNode(currentNodes);
        String licenseNodes = System.getProperty("ke.license.nodes");
        if ("Unlimited".equals(licenseNodes)) {
            info.setNode(-1);
        } else if (!StringUtils.isEmpty((CharSequence)licenseNodes)) {
            try {
                int maximumNodeNums = Integer.parseInt(licenseNodes);
                info.setNode(maximumNodeNums);
                if (maximumNodeNums < currentNodes) {
                    info.setNodeStatus(SourceUsageRecord.CapacityStatus.OVERCAPACITY);
                }
            }
            catch (NumberFormatException e) {
                logger.error("Illegal value of config ke.license.nodes", (Throwable)e);
            }
        }
    }

    private void setSourceUsageInfo(LicenseInfo info, String project) {
        SourceUsageRecord latestHistory = this.getLatestRecord();
        if (latestHistory != null) {
            info.setTime(latestHistory.getCheckTime());
            if (project == null) {
                info.setCurrentCapacity(latestHistory.getCurrentCapacity());
                info.setCapacity(latestHistory.getLicenseCapacity());
                info.setCapacityStatus(latestHistory.getCapacityStatus());
            } else {
                SourceUsageRecord.ProjectCapacityDetail projectCapacity = latestHistory.getProjectCapacity(project);
                if (projectCapacity != null) {
                    info.setCurrentCapacity(projectCapacity.getCapacity());
                    info.setCapacity(projectCapacity.getLicenseCapacity());
                    info.setCapacityStatus(projectCapacity.getStatus());
                }
            }
            if (this.isNotOk(latestHistory.getCapacityStatus())) {
                SourceUsageRecord historyRecord;
                List<SourceUsageRecord> recentHistories = SourceUsageManager.getInstance(this.config).getLastMonthRecords();
                info.setFirstErrorTime(latestHistory.getCheckTime());
                for (int i = recentHistories.size() - 1; i >= 0 && this.isNotOk((historyRecord = recentHistories.get(i)).getCapacityStatus()); --i) {
                    info.setFirstErrorTime(historyRecord.getCheckTime());
                }
            }
        } else {
            logger.warn("Latest history of source usage record is null.");
        }
    }

    private LicenseInfo getLicenseInfo(String project) {
        long dayThreshold;
        LicenseInfo info = new LicenseInfo();
        this.setNodeInfo(info);
        this.setSourceUsageInfo(info, project);
        long firstErrorTime = info.getFirstErrorTime();
        if (firstErrorTime != 0L && (dayThreshold = (System.currentTimeMillis() - firstErrorTime) / 86400000L) >= 30L) {
            logger.warn("Failed to fetch data volume usage for over {} days", (Object)dayThreshold);
        }
        return info;
    }

    public void checkIsOverCapacity(String project) {
        LicenseInfo info;
        SourceUsageRecord.CapacityStatus capacityStatus;
        KylinConfigExt kylinConfig;
        if (this.config.isUTEnv()) {
            return;
        }
        KapConfig kapConfig = KapConfig.getInstanceFromEnv();
        if (!kapConfig.isRecordSourceUsage()) {
            logger.info("Skip check over capacity.");
            return;
        }
        boolean checkProject = false;
        if (project != null && (kylinConfig = NProjectManager.getInstance(this.config).getProject(project).getConfig()).getSourceUsageQuota() != -1L) {
            checkProject = true;
        }
        if (this.isNotOk(capacityStatus = (info = this.getLicenseInfo(checkProject ? project : null)).getCapacityStatus())) {
            logger.warn("Capacity status is not ok: {}, will not block build job", (Object)capacityStatus);
            return;
        }
    }

    public boolean isOverCapacityThreshold(SourceUsageRecord sourceUsageRecord) {
        if ("Unlimited".equals(System.getProperty("ke.license.volume"))) {
            logger.info("Current license has unlimited volume.");
            return false;
        }
        if (sourceUsageRecord == null) {
            logger.debug("Source usage record is null, ignore...");
            return false;
        }
        long currentCapacity = sourceUsageRecord.getCurrentCapacity();
        long totalCapacity = sourceUsageRecord.getLicenseCapacity();
        logger.info("Current capacity is: {}, total capacity is: {}", (Object)currentCapacity, (Object)totalCapacity);
        return (double)currentCapacity > (double)totalCapacity * this.config.getOverCapacityThreshold();
    }

    public <T> T licenseCheckWrap(String project, Callback<T> f) {
        this.checkIsOverCapacity(project);
        return f.process();
    }

    public static interface Callback<T> {
        public T process();
    }

    public static interface SourceUsageRecordUpdater {
        public void modify(SourceUsageRecord var1);
    }
}

