/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.metadata.user;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.transaction.UnitOfWork;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.metadata.user.ManagedUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.core.authority.SimpleGrantedAuthority;

public class NKylinUserManager {
    private static final Logger logger = LoggerFactory.getLogger(NKylinUserManager.class);
    private KylinConfig config;
    private CachedCrudAssist<ManagedUser> crud;

    public static NKylinUserManager getInstance(KylinConfig config) {
        return (NKylinUserManager)config.getManager(NKylinUserManager.class);
    }

    static NKylinUserManager newInstance(KylinConfig config) throws IOException {
        return new NKylinUserManager(config);
    }

    public NKylinUserManager(KylinConfig config) {
        if (!UnitOfWork.isAlreadyInTransaction()) {
            logger.info("Initializing NKylinUserManager with KylinConfig Id: {}", (Object)System.identityHashCode(config));
        }
        this.config = config;
        this.crud = new CachedCrudAssist<ManagedUser>(this.getStore(), MetadataType.USER_INFO, null, ManagedUser.class){

            @Override
            protected ManagedUser initEntityAfterReload(ManagedUser user, String resourceName) {
                return user;
            }
        };
    }

    public ManagedUser copyForWrite(ManagedUser user) {
        return this.crud.copyForWrite(user);
    }

    public ManagedUser copy(ManagedUser user) {
        return this.crud.copyBySerialization(user);
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public ResourceStore getStore() {
        return ResourceStore.getKylinMetaStore((KylinConfig)this.config);
    }

    public ManagedUser get(String name) {
        if (StringUtils.isEmpty((CharSequence)name)) {
            return null;
        }
        return this.crud.get(name);
    }

    public List<ManagedUser> list() {
        return this.list(true);
    }

    public List<ManagedUser> list(boolean needSort) {
        ArrayList<ManagedUser> users = new ArrayList<ManagedUser>(this.crud.listAll());
        if (needSort) {
            users.sort((o1, o2) -> o1.getUsername().compareToIgnoreCase(o2.getUsername()));
        }
        return users;
    }

    public void createUser(ManagedUser user) {
        ManagedUser copy = this.copyForWrite(user);
        this.crud.save(copy);
    }

    public void updateUser(String userName, UserUpdater updater) {
        ManagedUser cached = this.get(userName);
        ManagedUser copy = this.copyForWrite(cached);
        updater.modify(copy);
        this.crud.save(copy);
    }

    @Deprecated
    public void update(ManagedUser user) {
        if (this.exists(user.getUsername())) {
            this.updateUser(user.getUsername(), arg_0 -> ((ManagedUser)user).copyPropertiesTo(arg_0));
        } else {
            this.createUser(user);
        }
    }

    public void delete(String username) {
        this.crud.delete(username);
    }

    public boolean exists(String username) {
        return Objects.nonNull(this.get(username));
    }

    public Set<String> getUserGroups(String userName) {
        ManagedUser user = this.get(userName);
        if (user == null) {
            return Sets.newHashSet();
        }
        return user.getAuthorities().stream().map(SimpleGrantedAuthority::getAuthority).collect(Collectors.toSet());
    }

    public static interface UserUpdater {
        public void modify(ManagedUser var1);
    }
}

