/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.Message;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.metadata.cachesync.CachedCrudAssist;
import org.apache.kylin.rest.security.AclPermissionFactory;
import org.apache.kylin.rest.security.AclRecord;
import org.apache.kylin.rest.security.KylinPermissionGrantingStrategy;
import org.apache.kylin.rest.security.MutableAclRecord;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.apache.kylin.rest.util.SpringContext;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.security.acls.domain.AuditLogger;
import org.springframework.security.acls.domain.ConsoleAuditLogger;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.domain.PrincipalSid;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.AlreadyExistsException;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.PermissionGrantingStrategy;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.core.context.SecurityContextHolder;

public class AclManager {
    private static final Logger logger = LoggerFactory.getLogger(AclManager.class);
    private final PermissionGrantingStrategy permissionGrantingStrategy = new KylinPermissionGrantingStrategy((AuditLogger)new ConsoleAuditLogger());
    private final PermissionFactory aclPermissionFactory = new AclPermissionFactory();
    private KylinConfig config;
    private CachedCrudAssist<AclRecord> crud;

    public static AclManager getInstance(KylinConfig config) {
        return (AclManager)config.getManager(AclManager.class);
    }

    static AclManager newInstance(KylinConfig config) {
        return new AclManager(config);
    }

    public AclManager(KylinConfig config) {
        this.config = config;
        ResourceStore aclStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
        this.crud = new CachedCrudAssist<AclRecord>(aclStore, MetadataType.OBJECT_ACL, null, AclRecord.class){

            @Override
            protected AclRecord initEntityAfterReload(AclRecord acl, String resourceName) {
                acl.init(null, (PermissionFactory)SpringContext.getBean(PermissionFactory.class), (PermissionGrantingStrategy)SpringContext.getBean(PermissionGrantingStrategy.class));
                return acl;
            }
        };
        this.crud.reloadAll();
    }

    public AclManager(KylinConfig config, final PermissionFactory permissionFactory, final PermissionGrantingStrategy permissionGrantingStrategy) {
        this.config = config;
        ResourceStore aclStore = ResourceStore.getKylinMetaStore((KylinConfig)config);
        this.crud = new CachedCrudAssist<AclRecord>(aclStore, MetadataType.ACL, null, AclRecord.class){

            @Override
            protected AclRecord initEntityAfterReload(AclRecord acl, String resourceName) {
                acl.init(null, permissionFactory, permissionGrantingStrategy);
                return acl;
            }
        };
        this.crud.reloadAll();
    }

    public KylinConfig getConfig() {
        return this.config;
    }

    public List<AclRecord> listAll() {
        return this.crud.listAll();
    }

    public void save(AclRecord record) {
        this.crud.save(record);
    }

    public void delete(String id) {
        this.crud.delete(id);
    }

    public AclRecord get(String id) {
        return this.crud.get(id);
    }

    public AclRecord copyForWrite(AclRecord aclRecord) {
        return this.crud.copyForWrite(aclRecord);
    }

    public List<ObjectIdentity> findChildren(ObjectIdentity parentIdentity) {
        List<AclRecord> allAclRecords = this.crud.listAll();
        return allAclRecords.stream().filter(record -> record.getParentDomainObjectInfo() != null && record.getParentDomainObjectInfo().equals(parentIdentity)).map(AclRecord::getObjectIdentity).collect(Collectors.toList());
    }

    public MutableAclRecord readAcl(ObjectIdentity oid) {
        try {
            return (MutableAclRecord)this.readAclById(oid);
        }
        catch (NotFoundException nfe) {
            logger.warn("[UNEXPECTED_THINGS_HAPPENED] acl not found for {}", (Object)oid);
            return null;
        }
    }

    public Acl readAclById(ObjectIdentity object) {
        return this.readAclsById(Collections.singletonList(object)).get(object);
    }

    public Map<ObjectIdentity, Acl> readAclsById(List<ObjectIdentity> oids) {
        HashMap aclMaps = Maps.newHashMap();
        for (ObjectIdentity oid : oids) {
            AclRecord record = this.getAclRecordByCache(AclPermissionUtil.objID(oid));
            if (record == null) {
                throw new NotFoundException(String.format(Locale.ROOT, MsgPicker.getMsg().getAclInfoNotFound(), oid));
            }
            Acl parentAcl = null;
            if (record.isEntriesInheriting() && record.getParentDomainObjectInfo() != null) {
                parentAcl = this.readAclById(record.getParentDomainObjectInfo());
            }
            AclRecord recordCopy = this.crud.copyBySerialization(record);
            recordCopy.init(parentAcl, this.aclPermissionFactory, this.permissionGrantingStrategy);
            aclMaps.put(oid, new MutableAclRecord(recordCopy));
        }
        return aclMaps;
    }

    public MutableAcl createAcl(ObjectIdentity objectIdentity) {
        AclRecord aclRecord = this.getAclRecordByCache(AclPermissionUtil.objID(objectIdentity));
        if (aclRecord != null) {
            throw new AlreadyExistsException(String.format(Locale.ROOT, "ACL of %s exists!", objectIdentity));
        }
        AclRecord record = this.copyForWrite(this.newAclRecord(objectIdentity));
        this.crud.save(record);
        logger.debug("ACL of {} created successfully.", (Object)objectIdentity);
        return (MutableAcl)this.readAclById(objectIdentity);
    }

    public void deleteAcl(ObjectIdentity objectIdentity, boolean deleteChildren) {
        List<ObjectIdentity> children = this.findChildren(objectIdentity);
        if (!deleteChildren && !children.isEmpty()) {
            Message msg = MsgPicker.getMsg();
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, String.format(Locale.ROOT, msg.getIdentityExistChildren(), objectIdentity));
        }
        for (ObjectIdentity oid : children) {
            this.deleteAcl(oid, deleteChildren);
        }
        this.crud.delete(AclPermissionUtil.objID(objectIdentity));
        logger.debug("ACL of {} deleted successfully.", (Object)objectIdentity);
    }

    @Deprecated
    public MutableAcl updateAcl(MutableAcl mutableAcl) {
        return this.updateAcl((MutableAclRecord)mutableAcl, arg_0 -> ((AclRecord)((MutableAclRecord)mutableAcl).getAclRecord()).copyPropertiesTo(arg_0));
    }

    public MutableAclRecord upsertAce(MutableAclRecord acl, Sid sid, Permission perm) {
        return this.updateAcl(acl, record -> record.upsertAce(perm, sid));
    }

    public void batchUpsertAce(MutableAclRecord acl, Map<Sid, Permission> sidToPerm) {
        this.updateAcl(acl, record -> {
            for (Map.Entry entry : sidToPerm.entrySet()) {
                record.upsertAce((Permission)entry.getValue(), (Sid)entry.getKey());
            }
        });
    }

    public MutableAclRecord inherit(MutableAclRecord acl, MutableAclRecord parentAcl) {
        return this.updateAcl(acl, record -> {
            record.setEntriesInheriting(true);
            record.setParent(parentAcl);
        });
    }

    public AclRecord getAclRecordByCache(String id) {
        return this.crud.get(id);
    }

    public AclRecord newAclRecord(ObjectIdentity objID) {
        AclRecord acl = new AclRecord(objID, this.getCurrentSid());
        acl.init(null, this.aclPermissionFactory, this.permissionGrantingStrategy);
        acl.updateRandomUuid();
        return acl;
    }

    private Sid getCurrentSid() {
        return new PrincipalSid(SecurityContextHolder.getContext().getAuthentication());
    }

    private MutableAclRecord updateAcl(MutableAclRecord acl, AclRecordUpdater updater) {
        AclRecord copyForWrite = this.crud.copyForWrite(acl.getAclRecord());
        updater.update(copyForWrite);
        this.crud.save(copyForWrite);
        logger.debug("ACL of {} updated successfully.", (Object)copyForWrite.getObjectIdentity());
        return this.readAcl(acl.getObjectIdentity());
    }

    public static interface AclRecordUpdater {
        public void update(AclRecord var1);
    }
}

