/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;

public enum AclPermissionEnum {
    ADMINISTRATION,
    MANAGEMENT,
    OPERATION,
    READ,
    EMPTY;


    public static String convertToAclPermission(String externalPermission) {
        switch (externalPermission) {
            case "ADMIN": {
                return ADMINISTRATION.name();
            }
            case "MANAGEMENT": {
                return MANAGEMENT.name();
            }
            case "OPERATION": {
                return OPERATION.name();
            }
            case "QUERY": {
                return READ.name();
            }
            case "EMPTY": {
                return EMPTY.name();
            }
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "invalid permission state: " + externalPermission);
    }
}

