/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.Singletons;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.Pair;
import org.apache.kylin.rest.security.AclPermission;
import org.springframework.security.acls.domain.BasePermission;
import org.springframework.security.acls.model.Permission;

public abstract class ExternalAclProvider {
    public static ExternalAclProvider getInstance() {
        return (ExternalAclProvider)Singletons.getInstance(ExternalAclProvider.class, clz -> {
            ExternalAclProvider singleton = null;
            String cls = KylinConfig.getInstanceFromEnv().getExternalAclProvider();
            if (!StringUtils.isBlank((CharSequence)cls)) {
                singleton = (ExternalAclProvider)ClassUtil.newInstance((String)cls);
                singleton.init();
            }
            return singleton;
        });
    }

    public static String convertToExternalPermission(Permission p) {
        String permString = BasePermission.ADMINISTRATION.equals(p) ? "ADMIN" : (AclPermission.MANAGEMENT.equals(p) ? "MANAGEMENT" : (AclPermission.OPERATION.equals(p) ? "OPERATION" : (BasePermission.READ.equals(p) ? "QUERY" : (AclPermission.DATA_QUERY.equals(p) ? "DATA_QUERY" : p.getPattern()))));
        return permString;
    }

    public static void checkExternalPermission(String permission) {
        if (StringUtils.isBlank((CharSequence)permission)) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getEmptyPermission());
        }
        if ("ADMIN".equalsIgnoreCase(permission) || "MANAGEMENT".equalsIgnoreCase(permission) || "OPERATION".equalsIgnoreCase(permission) || "QUERY".equalsIgnoreCase(permission)) {
            return;
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.INVALID_PARAMETER, MsgPicker.getMsg().getInvalidPermission());
    }

    public static String convertToExternalPermission(int mask) {
        switch (mask) {
            case 16: {
                return "ADMIN";
            }
            case 32: {
                return "MANAGEMENT";
            }
            case 64: {
                return "OPERATION";
            }
            case 1: {
                return "QUERY";
            }
            case 128: {
                return "DATA_QUERY";
            }
            case 0: {
                return "EMPTY";
            }
        }
        throw new KylinException((ErrorCodeSupplier)ServerErrorCode.PERMISSION_DENIED, "Invalid permission state: " + mask);
    }

    public abstract void init();

    public abstract boolean checkPermission(String var1, List<String> var2, String var3, String var4, Permission var5);

    public abstract List<Pair<String, AclPermission>> getAcl(String var1, String var2);
}

