/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Objects;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.AclEntity;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.rest.security.ExternalAclProvider;
import org.apache.kylin.rest.util.AclPermissionUtil;
import org.springframework.security.acls.AclPermissionEvaluator;
import org.springframework.security.acls.domain.PermissionFactory;
import org.springframework.security.acls.model.AclService;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.core.Authentication;

public class KylinAclPermissionEvaluator
extends AclPermissionEvaluator {
    private final PermissionFactory permissionFactory;

    public KylinAclPermissionEvaluator(org.apache.kylin.rest.service.AclService aclService, PermissionFactory permissionFactory) {
        super((AclService)aclService);
        super.setPermissionFactory(permissionFactory);
        this.permissionFactory = permissionFactory;
    }

    public boolean hasPermission(Authentication authentication, Object targetDomainObject, Object permission) {
        ExternalAclProvider eap;
        if (Objects.isNull(targetDomainObject)) {
            return false;
        }
        if (targetDomainObject instanceof String) {
            targetDomainObject = NProjectManager.getInstance(KylinConfig.getInstanceFromEnv()).getProject(targetDomainObject.toString());
        }
        if (Objects.isNull(eap = ExternalAclProvider.getInstance())) {
            return super.hasPermission(authentication, targetDomainObject, permission);
        }
        AclEntity e = (AclEntity)targetDomainObject;
        return this.checkExternalPermission(eap, authentication, e.getClass().getSimpleName(), e.getId(), permission);
    }

    private boolean checkExternalPermission(ExternalAclProvider eap, Authentication authentication, String entityType, String entityUuid, Object permission) {
        String currentUser = authentication.getName();
        List<String> authorities = AclPermissionUtil.transformAuthorities(authentication.getAuthorities());
        List<Permission> permissions = this.resolveKylinPermission(permission);
        for (Permission p : permissions) {
            if (!eap.checkPermission(currentUser, authorities, entityType, entityUuid, p)) continue;
            return true;
        }
        return false;
    }

    private List<Permission> resolveKylinPermission(Object permission) {
        if (permission instanceof Integer) {
            return Collections.singletonList(this.permissionFactory.buildFromMask(((Integer)permission).intValue()));
        }
        if (permission instanceof Permission) {
            return Collections.singletonList((Permission)permission);
        }
        if (permission instanceof Permission[]) {
            return Arrays.asList((Permission[])permission);
        }
        if (permission instanceof String) {
            Permission p;
            String permString = (String)permission;
            try {
                p = this.permissionFactory.buildFromName(permString);
            }
            catch (IllegalArgumentException notfound) {
                p = this.permissionFactory.buildFromName(permString.toUpperCase(Locale.ROOT));
            }
            if (Objects.nonNull(p)) {
                return Collections.singletonList(p);
            }
        }
        throw new IllegalArgumentException("Unsupported permission: " + permission);
    }

    public boolean hasPermission(Authentication authentication, Serializable targetId, String targetType, Object permission) {
        ExternalAclProvider eap = ExternalAclProvider.getInstance();
        if (Objects.isNull(eap)) {
            return super.hasPermission(authentication, targetId, targetType, permission);
        }
        return this.checkExternalPermission(eap, authentication, targetType, targetId.toString(), permission);
    }
}

