/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.security;

import java.io.Serializable;
import java.util.List;
import org.apache.kylin.rest.security.AclRecord;
import org.springframework.security.acls.model.AccessControlEntry;
import org.springframework.security.acls.model.Acl;
import org.springframework.security.acls.model.MutableAcl;
import org.springframework.security.acls.model.NotFoundException;
import org.springframework.security.acls.model.ObjectIdentity;
import org.springframework.security.acls.model.OwnershipAcl;
import org.springframework.security.acls.model.Permission;
import org.springframework.security.acls.model.Sid;
import org.springframework.security.acls.model.UnloadedSidException;

public class MutableAclRecord
implements Acl,
MutableAcl,
OwnershipAcl {
    private final AclRecord acl;

    public MutableAclRecord(AclRecord acl) {
        this.acl = acl;
    }

    public AclRecord getAclRecord() {
        return this.acl;
    }

    public Serializable getId() {
        return this.acl.getObjectIdentity().getIdentifier();
    }

    public ObjectIdentity getObjectIdentity() {
        return this.acl.getObjectIdentity();
    }

    public Sid getOwner() {
        return this.acl.getOwner();
    }

    public void setOwner(Sid newOwner) {
        this.acl.setOwner(newOwner);
    }

    public Acl getParentAcl() {
        return this.acl.getParentAcl();
    }

    public boolean isEntriesInheriting() {
        return this.acl.isEntriesInheriting();
    }

    public void setEntriesInheriting(boolean entriesInheriting) {
        this.acl.setEntriesInheriting(entriesInheriting);
    }

    public void setParent(Acl newParent) {
        this.acl.setParent(newParent);
    }

    public List<AccessControlEntry> getEntries() {
        return this.acl.getEntries();
    }

    public void insertAce(int atIndexLocation, Permission permission, Sid sid, boolean granting) throws NotFoundException {
        this.acl.insertAce(atIndexLocation, permission, sid, granting);
    }

    public void updateAce(int aceIndex, Permission permission) throws NotFoundException {
        this.acl.updateAce(aceIndex, permission);
    }

    public void deleteAce(int aceIndex) throws NotFoundException {
        this.acl.deleteAce(aceIndex);
    }

    public boolean isGranted(List<Permission> permission, List<Sid> sids, boolean administrativeMode) throws NotFoundException, UnloadedSidException {
        return this.acl.isGranted(permission, sids, administrativeMode);
    }

    public boolean isSidLoaded(List<Sid> sids) {
        return this.acl.isSidLoaded(sids);
    }
}

