/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.util;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Locale;
import java.util.TimeZone;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.code.ErrorCodeProducer;
import org.apache.kylin.common.exception.code.ErrorCodeServer;
import org.apache.kylin.common.util.DateFormat;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.metadata.model.PartitionDesc;

public final class DataRangeUtils {
    private DataRangeUtils() {
    }

    public static void validateRange(String start, String end) {
        DataRangeUtils.validateRange(Long.parseLong(start), Long.parseLong(end));
    }

    public static void validateRange(long start, long end) {
        if (start < 0L || end < 0L) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_LESS_THAN_ZERO, new Object[0]);
        }
        if (start >= end) {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_END_LESS_THAN_EQUALS_START, new Object[0]);
        }
    }

    public static void validateDataRange(String start, String end) {
        DataRangeUtils.validateDataRange(start, end, null);
    }

    public static void validateDataRange(String start, String end, String partitionColumnFormat) {
        if (StringUtils.isEmpty((CharSequence)start) && StringUtils.isEmpty((CharSequence)end)) {
            return;
        }
        if (StringUtils.isNotEmpty((CharSequence)start) && StringUtils.isNotEmpty((CharSequence)end)) {
            long startLong = 0L;
            long endLong = 0L;
            try {
                startLong = Long.parseLong(start);
                endLong = Long.parseLong(end);
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_NOT_FORMAT_MS, (Throwable)e, new Object[0]);
            }
            if (startLong < 0L || endLong < 0L) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_LESS_THAN_ZERO, new Object[0]);
            }
            try {
                startLong = DateFormat.getFormatTimeStamp((String)start, (String)DataRangeUtils.transformTimestamp2Format(partitionColumnFormat));
                endLong = DateFormat.getFormatTimeStamp((String)end, (String)DataRangeUtils.transformTimestamp2Format(partitionColumnFormat));
            }
            catch (Exception e) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_NOT_FORMAT_MS, new Object[0]);
            }
            if (startLong >= endLong) {
                throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_END_LESS_THAN_EQUALS_START, new Object[0]);
            }
        } else {
            throw new KylinException((ErrorCodeProducer)ErrorCodeServer.TIME_INVALID_RANGE_NOT_CONSISTENT, new Object[0]);
        }
    }

    private static String transformTimestamp2Format(String columnFormat) {
        for (PartitionDesc.TimestampType timestampType : PartitionDesc.TimestampType.values()) {
            if (!timestampType.name.equals(columnFormat)) continue;
            return timestampType.format;
        }
        return columnFormat;
    }

    public static boolean timeOverlap(List<String[]> rangeList, String[] range, String dateFormat) {
        Preconditions.checkArgument((rangeList != null ? 1 : 0) != 0);
        Preconditions.checkArgument((range != null ? 1 : 0) != 0);
        if (rangeList.size() == 1 && "0".equals(rangeList.get(0)[0]) && "0".equals(rangeList.get(0)[1])) {
            return true;
        }
        if (rangeList.isEmpty() || range.length != 2 || StringUtils.isEmpty((CharSequence)dateFormat)) {
            return false;
        }
        if ("0".equals(range[0]) && "0".equals(range[1])) {
            return true;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.ROOT);
        sdf.setLenient(false);
        try {
            Date newStart = sdf.parse(range[0]);
            Date newEnd = sdf.parse(range[1]);
            if (!newStart.before(newEnd)) {
                throw new IllegalArgumentException("Invalid time range: start time must be before end time");
            }
            for (String[] existingRange : rangeList) {
                if (existingRange.length != 2) continue;
                Date existingStart = sdf.parse(existingRange[0]);
                Date existingEnd = sdf.parse(existingRange[1]);
                if (!newStart.before(existingEnd) || !existingStart.before(newEnd)) continue;
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }

    public static List<String[]> mergeTimeRange(List<String> values, String dateFormat) throws ParseException {
        ArrayList<String[]> mergedRanges = new ArrayList<String[]>();
        if (values == null || values.isEmpty()) {
            return mergedRanges;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(dateFormat, Locale.ROOT);
        try {
            Date start;
            ArrayList<Date> dates = new ArrayList<Date>();
            for (String value : values) {
                dates.add(sdf.parse(value));
            }
            dates.sort(Date::compareTo);
            Date end = start = (Date)dates.get(0);
            for (int i = 1; i < dates.size(); ++i) {
                Date current = (Date)dates.get(i);
                boolean isConsecutive = false;
                Calendar calStart = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
                Calendar calEnd = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
                Calendar calCurrent = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
                calStart.setTime(end);
                calEnd.setTime(end);
                calCurrent.setTime(current);
                switch (dateFormat) {
                    case "yyyy": {
                        isConsecutive = calCurrent.get(1) == calEnd.get(1) + 1;
                        break;
                    }
                    case "yyyy-MM-dd": 
                    case "yyyyMMdd": 
                    case "yyyy/MM/dd": {
                        long diffDays = (current.getTime() - end.getTime()) / 86400000L;
                        isConsecutive = diffDays == 1L;
                        break;
                    }
                    case "yyyy-MM": 
                    case "yyyyMM": {
                        isConsecutive = calCurrent.get(1) == calEnd.get(1) && calCurrent.get(2) == calEnd.get(2) + 1 || calCurrent.get(1) == calEnd.get(1) + 1 && calCurrent.get(2) == 0 && calEnd.get(2) == 11;
                        break;
                    }
                    default: {
                        throw new IllegalArgumentException(String.format(Locale.ROOT, "dateFormat %s is not supported", dateFormat));
                    }
                }
                if (isConsecutive) {
                    end = current;
                    continue;
                }
                mergedRanges.add(new String[]{sdf.format(start), DataRangeUtils.incrementDate(end, dateFormat, sdf)});
                start = current;
                end = current;
            }
            mergedRanges.add(new String[]{sdf.format(start), DataRangeUtils.incrementDate(end, dateFormat, sdf)});
        }
        catch (ParseException e) {
            e.printStackTrace();
            throw e;
        }
        return mergedRanges;
    }

    private static String incrementDate(Date date, String dateFormat, SimpleDateFormat sdf) {
        Calendar calendar = Calendar.getInstance(TimeZone.getDefault(), Locale.ROOT);
        calendar.setTime(date);
        switch (dateFormat) {
            case "yyyy": {
                calendar.add(1, 1);
                break;
            }
            case "yyyy-MM-dd": 
            case "yyyyMMdd": 
            case "yyyy/MM/dd": {
                calendar.add(5, 1);
                break;
            }
            case "yyyy-MM": 
            case "yyyyMM": {
                calendar.add(2, 1);
                break;
            }
            default: {
                throw new IllegalArgumentException(String.format(Locale.ROOT, "dateFormat %s is not supported", dateFormat));
            }
        }
        return sdf.format(calendar.getTime());
    }

    public static boolean timeInRange(String[] dataRange, List<String[]> partitionRange, String timeFmt) {
        if (dataRange == null || dataRange.length != 2 || partitionRange == null || partitionRange.isEmpty() || timeFmt == null || timeFmt.isEmpty()) {
            return false;
        }
        SimpleDateFormat sdf = new SimpleDateFormat(timeFmt, Locale.ROOT);
        sdf.setLenient(false);
        try {
            Date dataStart = sdf.parse(dataRange[0]);
            Date dataEnd = sdf.parse(dataRange[1]);
            if (!dataStart.before(dataEnd)) {
                return false;
            }
            Date minPartitionStart = null;
            Date maxPartitionEnd = null;
            for (String[] range : partitionRange) {
                Date partitionStart = sdf.parse(range[0]);
                Date partitionEnd = sdf.parse(range[1]);
                if (minPartitionStart == null || partitionStart.before(minPartitionStart)) {
                    minPartitionStart = partitionStart;
                }
                if (maxPartitionEnd != null && !partitionEnd.after(maxPartitionEnd)) continue;
                maxPartitionEnd = partitionEnd;
            }
            if (minPartitionStart != null && maxPartitionEnd != null && !dataStart.before(minPartitionStart) && !dataEnd.after(maxPartitionEnd)) {
                return true;
            }
        }
        catch (ParseException e) {
            e.printStackTrace();
            return false;
        }
        return false;
    }
}

