/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.lang.reflect.Field;
import java.util.HashMap;
import java.util.Map;
import org.apache.hadoop.util.Shell;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

class EnvironmentUpdateUtils {
    EnvironmentUpdateUtils() {
    }

    public static synchronized void put(String key, String value) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.put(key, value);
        if (!Shell.WINDOWS) {
            EnvironmentUpdateUtils.updateEnvironment(environment);
        } else {
            EnvironmentUpdateUtils.updateEnvironmentOnWindows(environment);
        }
    }

    public static synchronized void putAll(Map<String, String> additionalEnvironment) {
        HashMap<String, String> environment = new HashMap<String, String>(System.getenv());
        environment.putAll(additionalEnvironment);
        if (!Shell.WINDOWS) {
            EnvironmentUpdateUtils.updateEnvironment(environment);
        } else {
            EnvironmentUpdateUtils.updateEnvironmentOnWindows(environment);
        }
    }

    private static void updateEnvironment(Map<String, String> environment) {
        Map<String, String> currentEnv = System.getenv();
        EnvironmentUpdateUtils.copyMapValuesToPrivateField(currentEnv.getClass(), currentEnv, "m", environment);
    }

    private static void updateEnvironmentOnWindows(Map<String, String> environment) {
        try {
            Class<?> processEnvironmentClass = Class.forName("java.lang.ProcessEnvironment");
            EnvironmentUpdateUtils.copyMapValuesToPrivateField(processEnvironmentClass, null, "theEnvironment", environment);
            EnvironmentUpdateUtils.copyMapValuesToPrivateField(processEnvironmentClass, null, "theCaseInsensitiveEnvironment", environment);
        }
        catch (ClassNotFoundException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
    }

    private static void copyMapValuesToPrivateField(Class<?> klass, Object object, String fieldName, Map<String, String> newMapValues) {
        try {
            Field field = klass.getDeclaredField(fieldName);
            field.setAccessible(true);
            Map currentMap = (Map)field.get(object);
            currentMap.clear();
            currentMap.putAll(newMapValues);
        }
        catch (IllegalAccessException | IllegalStateException | NoSuchFieldException e) {
            throw new IllegalStateException("Failed to update Environment variables", e);
        }
    }

    @Test
    @MetadataInfo(onlyProps=true)
    void testGetRoutineOpsTaskTimeOut() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Assert.assertEquals((long)14400000L, (long)config.getRoutineOpsTaskTimeOut());
        config.setProperty("kylin.metadata.ops-cron-timeout", "30m");
        Assert.assertEquals((long)1800000L, (long)config.getRoutineOpsTaskTimeOut());
        config.setProperty("kylin.metadata.ops-cron-timeout", "1d");
        Assert.assertEquals((long)86400000L, (long)config.getRoutineOpsTaskTimeOut());
        config.setProperty("kylin.metadata.ops-cron-timeout", "4h");
        Assert.assertEquals((long)14400000L, (long)config.getRoutineOpsTaskTimeOut());
    }

    @Test
    @MetadataInfo(onlyProps=true)
    void testGetColOrderInModelView() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setProperty("kylin.query.select-star-col-order-in-model-view", "0");
        Assertions.assertEquals((Object)"default", (Object)config.getColOrderForSelectStarInModelView());
        config.setProperty("kylin.query.select-star-col-order-in-model-view", "1");
        Assertions.assertEquals((Object)"orderByModel", (Object)config.getColOrderForSelectStarInModelView());
        config.setProperty("kylin.query.select-star-col-order-in-model-view", "2");
        Assertions.assertEquals((Object)"orderByTable", (Object)config.getColOrderForSelectStarInModelView());
        config.setProperty("kylin.query.select-star-col-order-in-model-view", "order-By-Model");
        Assertions.assertEquals((Object)"orderByModel", (Object)config.getColOrderForSelectStarInModelView());
        config.setProperty("kylin.query.select-star-col-order-in-model-view", "order-By-Table");
        Assertions.assertEquals((Object)"orderByTable", (Object)config.getColOrderForSelectStarInModelView());
    }
}

