/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.stream.Collectors;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;

@MetadataInfo
public class KylinConfigMultithreadingTest {
    @Test
    public void test9PropertiesHotLoadWithMultithreading() throws InterruptedException, ExecutionException {
        Callable<String> callable1 = () -> {
            this.reloadFromSiteProperties();
            return "ok";
        };
        Callable<String> callable2 = () -> {
            this.readKylinConfig();
            return "ok";
        };
        KylinConfigMultithreadingTest.concurrentTest(10L, 30, Lists.newArrayList((Object[])new Callable[]{callable1, callable2}));
    }

    void reloadFromSiteProperties() {
        TestUtils.getTestConfig().setProperty("server.port", "4444");
        KylinConfig.getInstanceFromEnv().reloadKylinConfigPropertiesFromSiteProperties();
    }

    void readKylinConfig() {
        for (int i = 0; i < 100; ++i) {
            KylinConfig config = KylinConfig.getInstanceFromEnv();
            config.getServerPort();
        }
    }

    public static <T> void concurrentTest(long concurrentThreads, int times, List<Callable<T>> tasks) throws InterruptedException, ExecutionException {
        ExecutorService executor = Executors.newFixedThreadPool((int)concurrentThreads);
        ArrayList results = new ArrayList(times);
        for (int i = 0; i < times; ++i) {
            tasks.forEach(task -> results.add(executor.submit(task)));
        }
        executor.shutdown();
        for (Future r : results) {
            Assertions.assertEquals((Object)"ok", (Object)String.valueOf(r.get()));
        }
    }

    @Test
    public void test8ReloadKylinConfigPropertiesFromSiteProperties() {
        KylinConfig.getInstanceFromEnv().reloadKylinConfigPropertiesFromSiteProperties();
        Properties oldProperties = KylinConfig.getInstanceFromEnv().exportToProperties();
        KylinConfig.getInstanceFromEnv().reloadKylinConfigPropertiesFromSiteProperties();
        Properties newProperties = KylinConfig.getInstanceFromEnv().exportToProperties();
        this.comparePropertiesKeys(oldProperties, newProperties);
    }

    void comparePropertiesKeys(Properties expected, Properties actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Set expectedKeys = expected.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        Set actualKeys = actual.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)expectedKeys.containsAll(actualKeys));
        Assertions.assertTrue((boolean)actualKeys.containsAll(expectedKeys));
    }

    @Test
    public void test7ReloadKylinConfig2Properties() {
        Properties properties = KylinConfig.getInstanceFromEnv().exportToProperties();
        KylinConfig.getInstanceFromEnv().reloadKylinConfig2Properties(properties);
        Properties actual = KylinConfig.getInstanceFromEnv().exportToProperties();
        this.comparePropertiesKeys(properties, actual);
        this.comparePropertiesValues(properties, actual);
    }

    @Test
    void test8ReloadKylinConfig2Properties() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Properties properties = config.exportToProperties();
        properties.setProperty("kylin.env.hdfs-write-working-dir", "file://");
        Properties actual = config.reloadKylinConfig2Properties(properties);
        Assertions.assertEquals((int)properties.size(), (int)actual.size());
        config.setProperty("kylin.env.hdfs-write-working-dir", "");
    }

    void comparePropertiesValues(Properties expected, Properties actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Set expectedKeys = expected.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        for (String key : expectedKeys) {
            Assertions.assertEquals((Object)expected.get(key), (Object)actual.get(key));
        }
    }

    @Test
    public void test5GetMetadataUrlPrefixFromProperties() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Properties properties = kylinConfig.exportToProperties();
        String metadataUrlPrefixFromProperties = kylinConfig.getMetadataUrlPrefixFromProperties(properties);
        String metadataUrlPrefix = kylinConfig.getMetadataUrlPrefix();
        Assertions.assertEquals((Object)metadataUrlPrefix, (Object)metadataUrlPrefixFromProperties);
    }

    @Test
    public void test4GetMetadataUrlFromProperties() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Properties properties = kylinConfig.exportToProperties();
        StorageURL metadataUrlFromProperties = kylinConfig.getMetadataUrlFromProperties(properties);
        StorageURL metadataUrl = kylinConfig.getMetadataUrl();
        Assertions.assertEquals((Object)metadataUrl.getScheme(), (Object)metadataUrlFromProperties.getScheme());
        Assertions.assertEquals((Object)metadataUrl.getIdentifier(), (Object)metadataUrlFromProperties.getIdentifier());
        Assertions.assertEquals((Object)metadataUrl.toString(), (Object)metadataUrlFromProperties.toString());
        Map allParameters = metadataUrl.getAllParameters();
        Map allParametersFromProperties = metadataUrlFromProperties.getAllParameters();
        this.compareMapKeys(allParameters, allParametersFromProperties);
        this.compareMapValues(allParameters, allParametersFromProperties);
    }

    void compareMapKeys(Map<String, String> expected, Map<String, String> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Set expectedKeys = expected.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        Set actualKeys = actual.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        Assertions.assertTrue((boolean)expectedKeys.containsAll(actualKeys));
        Assertions.assertTrue((boolean)actualKeys.containsAll(expectedKeys));
    }

    void compareMapValues(Map<String, String> expected, Map<String, String> actual) {
        Assertions.assertEquals((int)expected.size(), (int)actual.size());
        Set expectedKeys = expected.keySet().stream().map(String::valueOf).collect(Collectors.toSet());
        for (String key : expectedKeys) {
            Assertions.assertEquals((Object)expected.get(key), (Object)actual.get(key));
        }
    }

    @Test
    public void test3getMetadataUrlUniqueIdFromProperties() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Properties properties = kylinConfig.exportToProperties();
        String metadataUrlUniqueIdFromProperties = kylinConfig.getMetadataUrlUniqueIdFromProperties(properties);
        String metadataUrlUniqueId = kylinConfig.getMetadataUrlUniqueId();
        Assertions.assertEquals((Object)metadataUrlUniqueId, (Object)metadataUrlUniqueIdFromProperties);
    }

    @Test
    public void test2GetChannelFromProperties() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Properties properties = kylinConfig.exportToProperties();
        String channelFromProperties = kylinConfig.getChannelFromProperties(properties);
        String channel = kylinConfig.getChannel();
        Assertions.assertEquals((Object)channel, (Object)channelFromProperties);
    }

    @Test
    public void test1GetOptionalFromProperties() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Properties properties = kylinConfig.exportToProperties();
        String portFromProperties = kylinConfig.getOptionalFromProperties("server.port", "7071", properties);
        String port = kylinConfig.getOptional("server.port", "7071");
        Assertions.assertEquals((Object)port, (Object)portFromProperties);
        Assertions.assertEquals((Object)"7070", (Object)portFromProperties);
    }

    @Test
    public void test6GetHdfsWorkingDirectoryFromProperties() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        Properties properties = kylinConfig.exportToProperties();
        String hdfsWorkingDirectoryFromProperties = kylinConfig.getHdfsWorkingDirectoryFromProperties(properties);
        String hdfsWorkingDirectory = kylinConfig.getHdfsWorkingDirectory();
        Assertions.assertEquals((Object)hdfsWorkingDirectory, (Object)hdfsWorkingDirectoryFromProperties);
    }
}

