/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import org.apache.commons.lang3.StringUtils;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.SystemPropertiesCache;
import org.apache.kylin.common.util.ClusterConstant;
import org.apache.kylin.common.util.TestUtils;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mockito;

@MetadataInfo(onlyProps=true)
public class KylinConfigTest {
    @BeforeEach
    public void setup() {
        KylinConfig config = TestUtils.getTestConfig();
        config.setProperty("kylin.test.bcc.new-key", "some-value");
        config.setProperty("kylin.engine.mr.config-override.test1", "test1");
        config.setProperty("kylin.engine.mr.config-override.test2", "test2");
        config.setProperty("kylin.job.lock", "org.apache.kylin.job.lock.MockJobLock");
        config.setProperty("kap.storage.columnar.spark-conf.spark.driver.memory", "1234m");
        config.setProperty("kap.storage.columnar.spark-conf.spark.executor.memoryOverhead", "4321m");
        config.setProperty("kap.storage.monitor-spark-period-seconds", "5678");
    }

    @Test
    public void testDuplicateConfig() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String v = config.getJobControllerLock();
        Assertions.assertEquals((Object)"org.apache.kylin.job.lock.MockJobLock", (Object)v);
    }

    @Test
    public void testBackwardCompatibility() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        String oldk = "kylin.test.bcc.old-key";
        String newk = "kylin.test.bcc.new-key";
        Assertions.assertNull((Object)config.getOptional("kylin.test.bcc.old-key"));
        Assertions.assertNotNull((Object)config.getOptional("kylin.test.bcc.new-key"));
        HashMap override = Maps.newHashMap();
        override.put("kylin.test.bcc.old-key", "1");
        KylinConfigExt ext = KylinConfigExt.createInstance((KylinConfig)config, (Map)override);
        Assertions.assertNull((Object)ext.getOptional("kylin.test.bcc.old-key"));
        Assertions.assertEquals((Object)"1", (Object)ext.getOptional("kylin.test.bcc.new-key"));
        Assertions.assertNotEquals((Object)"1", (Object)config.getOptional("kylin.test.bcc.new-key"));
        config.setProperty("kylin.test.bcc.old-key", "2");
        Assertions.assertEquals((Object)"2", (Object)config.getOptional("kylin.test.bcc.new-key"));
    }

    @Test
    public void testBackwardCompatibility_KAP_KYLIN() {
        Properties config = KylinConfig.getInstanceFromEnv().getAllProperties();
        Assertions.assertEquals((Object)"1234m", (Object)config.get("kylin.storage.columnar.spark-conf.spark.driver.memory"));
        Assertions.assertEquals((Object)"4321m", (Object)config.get("kylin.storage.columnar.spark-conf.spark.executor.memoryOverhead"));
        Assertions.assertEquals((Object)"5678", (Object)config.get("kylin.storage.monitor-spark-period-seconds"));
    }

    @Test
    public void testExtShareTheBase() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        HashMap override = Maps.newHashMap();
        KylinConfigExt configExt = KylinConfigExt.createInstance((KylinConfig)config, (Map)override);
        Assertions.assertSame((Object)config.properties, (Object)configExt.properties);
        config.setProperty("1234", "1234");
        Assertions.assertEquals((Object)"1234", (Object)configExt.getOptional("1234"));
    }

    @Test
    public void testGetMetadataUrlPrefix() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        config.setMetadataUrl("testMetaPrefix@hdfs");
        Assertions.assertEquals((Object)"testMetaPrefix", (Object)config.getMetadataUrlPrefix());
        config.setMetadataUrl("/kylin/temp");
        Assertions.assertEquals((Object)"/kylin/temp", (Object)config.getMetadataUrlPrefix());
    }

    @Test
    public void testThreadLocalOverride() throws InterruptedException {
        String metadata1 = "meta1@hdfs";
        String metadata2 = "meta2@hdfs";
        KylinConfig sysConfig = KylinConfig.getInstanceFromEnv();
        sysConfig.setMetadataUrl("meta1@hdfs");
        Assertions.assertEquals((Object)"meta1@hdfs", (Object)KylinConfig.getInstanceFromEnv().getMetadataUrl().toString());
        KylinConfig threadConfig = KylinConfig.createKylinConfig((Properties)new Properties());
        threadConfig.setMetadataUrl("meta2@hdfs");
        try (KylinConfig.SetAndUnsetThreadLocalConfig autoUnset = KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)threadConfig);){
            Assertions.assertEquals((Object)"meta2@hdfs", (Object)KylinConfig.getInstanceFromEnv().getMetadataUrl().toString());
            final String[] holder = new String[1];
            Thread child = new Thread(new Runnable(){

                @Override
                public void run() {
                    holder[0] = KylinConfig.getInstanceFromEnv().getMetadataUrl().toString();
                }
            });
            child.start();
            child.join();
            Assertions.assertEquals((Object)"meta1@hdfs", (Object)holder[0]);
        }
    }

    @Test
    public void testOverrideSparkJobJarPath() {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        String oldSparkJobJarPath = System.getProperty("kylin.engine.spark.job-jar");
        String overrideSparkJobJarPath = oldSparkJobJarPath + "_override";
        conf.overrideSparkJobJarPath(overrideSparkJobJarPath);
        String newSparkJobJarPath = System.getProperty("kylin.engine.spark.job-jar");
        Assertions.assertEquals((Object)newSparkJobJarPath, (Object)overrideSparkJobJarPath);
        if (StringUtils.isBlank((CharSequence)oldSparkJobJarPath)) {
            SystemPropertiesCache.clearProperty((String)"kylin.engine.spark.job-jar");
        } else {
            conf.overrideSparkJobJarPath(oldSparkJobJarPath);
        }
    }

    @Test
    public void testGetKylinJobJarPath() {
        KylinConfig conf = KylinConfig.getInstanceFromEnv();
        String kylinJobJarPath = conf.getKylinJobJarPath();
        Assertions.assertEquals((Object)"", (Object)kylinJobJarPath);
    }

    @Test
    public void testPlaceholderReplace() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        kylinConfig.setProperty("ph_1", "${prop_a}/${prop1}");
        Assertions.assertEquals((Object)"${prop_a}/${prop1}", (Object)kylinConfig.getOptional("ph_1"));
        kylinConfig.setProperty("prop_a", "prop_A");
        kylinConfig.setProperty("prop1", "prop_1");
        Assertions.assertEquals((Object)"prop_A/prop_1", (Object)kylinConfig.getOptional("ph_1"));
        kylinConfig.setProperty("ph_2", "${prop2}/${prop_b}");
        Assertions.assertEquals((Object)"${prop2}/${prop_b}", (Object)kylinConfig.getOptional("ph_2"));
        kylinConfig.setProperty("prop_b", "prop_B");
        kylinConfig.setProperty("prop2", "${prop_b}");
        Assertions.assertEquals((Object)"prop_B/prop_B", (Object)kylinConfig.getOptional("ph_2"));
        kylinConfig.setProperty("ph_3", "${prop3}/${prop_c}/xxx/${prop2}/${prop_xxx}");
        Assertions.assertEquals((Object)"${prop3}/${prop_c}/xxx/prop_B/${prop_xxx}", (Object)kylinConfig.getOptional("ph_3"));
        kylinConfig.setProperty("prop_c", "${prop_C}");
        kylinConfig.setProperty("prop3", "prop_3");
        Assertions.assertEquals((Object)"prop_3/${prop_C}/xxx/prop_B/${prop_xxx}", (Object)kylinConfig.getOptional("ph_3"));
        HashMap override = Maps.newHashMap();
        override.put("ph_4", "${prop4}/${prop_d}:${prop3}/${prop_c}");
        KylinConfigExt kylinConfigExt = KylinConfigExt.createInstance((KylinConfig)kylinConfig, (Map)override);
        Assertions.assertEquals((Object)"${prop4}/${prop_d}:prop_3/${prop_C}", (Object)kylinConfigExt.getOptional("ph_4"));
        kylinConfigExt.getExtendedOverrides().put("prop_d", "prop_D");
        kylinConfigExt.getExtendedOverrides().put("prop4", "${prop_d}");
        Assertions.assertEquals((Object)"prop_D/prop_D:prop_3/${prop_C}", (Object)kylinConfigExt.getOptional("ph_4"));
        kylinConfig.setProperty("ph_5", "${prop5}");
        Assertions.assertEquals((Object)"${prop5}", (Object)kylinConfig.getOptional("ph_5"));
        kylinConfig.setProperty("prop_d", "${ph_5}");
        kylinConfig.setProperty("prop5", "${prop_d}");
        Assertions.assertThrows(IllegalStateException.class, () -> kylinConfig.getOptional("ph_5"));
    }

    void updateProperty(String key, String value) {
        Throwable throwable;
        File propFile = KylinConfig.getSitePropertiesFile();
        Properties conf = new Properties();
        try {
            throwable = null;
            try (FileInputStream is = new FileInputStream(propFile);){
                conf.load(is);
                conf.setProperty(key, value);
            }
            catch (Throwable throwable2) {
                throwable = throwable2;
                throw throwable2;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
        try {
            throwable = null;
            try (FileOutputStream out = new FileOutputStream(propFile);){
                conf.store(out, null);
            }
            catch (Throwable throwable3) {
                throwable = throwable3;
                throw throwable3;
            }
        }
        catch (Exception e) {
            System.err.println(e.getMessage());
        }
    }

    @Test
    public void testServerMode() {
        KylinConfig config = (KylinConfig)Mockito.spy(KylinConfig.class);
        this.mockMode(config, ClusterConstant.ALL, null);
        Assertions.assertArrayEquals((boolean[])new boolean[]{true, true, false, true, false, false, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.JOB, null);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, true, true, false, false, false, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.QUERY, null);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.ALL, ClusterConstant.DATA_LOADING);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, false, true, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.JOB, ClusterConstant.DATA_LOADING);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, false, true, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.QUERY, ClusterConstant.DATA_LOADING);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, false, true, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.ALL, ClusterConstant.COMMON);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, true, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.JOB, ClusterConstant.COMMON);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, true, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.QUERY, ClusterConstant.COMMON);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, true, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.ALL, ClusterConstant.SMART);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, false, false, true}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.JOB, ClusterConstant.SMART);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, false, false, true}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.QUERY, ClusterConstant.SMART);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, false, false, false, false, true}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.ALL, ClusterConstant.QUERY);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.JOB, ClusterConstant.QUERY);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, false, false}, (boolean[])this.getServerModeStatus(config));
        this.mockMode(config, ClusterConstant.QUERY, ClusterConstant.QUERY);
        Assertions.assertArrayEquals((boolean[])new boolean[]{false, false, false, true, true, false, false, false}, (boolean[])this.getServerModeStatus(config));
    }

    boolean[] getServerModeStatus(KylinConfig config) {
        return new boolean[]{config.isAllNode(), config.isJobNode(), config.isJobNodeOnly(), config.isQueryNode(), config.isQueryNodeOnly(), config.isMetadataNode(), config.isDataLoadingNode(), config.isSmartNode()};
    }

    void mockMode(KylinConfig config, String serverMode, String microServiceMode) {
        Mockito.when((Object)config.getServerMode()).thenReturn((Object)serverMode);
        Mockito.when((Object)config.getMicroServiceMode()).thenReturn((Object)microServiceMode);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    void testLoadMicroServiceMode() throws IOException {
        ClassLoader threadClassLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader cl = (ClassLoader)Mockito.mock(ClassLoader.class);
            Thread.currentThread().setContextClassLoader(cl);
            String fileName = "application.yaml";
            File file = new File(fileName);
            Mockito.when((Object)cl.getResource(fileName)).thenReturn((Object)file.toURI().toURL());
            KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("common", file);
            Assertions.assertEquals((Object)ClusterConstant.COMMON, (Object)kylinConfig.getMicroServiceMode());
            Assertions.assertEquals((Object)ClusterConstant.COMMON, (Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("data-loading", file);
            Assertions.assertEquals((Object)ClusterConstant.DATA_LOADING, (Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("query", file);
            Assertions.assertEquals((Object)ClusterConstant.QUERY, (Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("smart", file);
            Assertions.assertEquals((Object)ClusterConstant.SMART, (Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("ops", file);
            Assertions.assertEquals((Object)ClusterConstant.OPS, (Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("resource", file);
            Assertions.assertEquals((Object)ClusterConstant.RESOURCE, (Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            this.createYamlFile("illegal", file);
            Assertions.assertNull((Object)kylinConfig.getMicroServiceMode());
            kylinConfig.properties.clear();
            kylinConfig.setProperty("kylin.micro.service", "true");
            Mockito.when((Object)cl.getResource(fileName)).thenReturn(null);
            Assertions.assertNull((Object)kylinConfig.getMicroServiceMode());
            Assertions.assertTrue((boolean)file.delete());
        }
        catch (Exception e) {
            Assertions.fail((String)e.getMessage());
        }
        finally {
            Thread.currentThread().setContextClassLoader(threadClassLoader);
        }
    }

    void createYamlFile(String applicationName, File file) throws IOException {
        String context = String.format("spring:\n  web: 123\n---\nspring:\n  application:\n    host: localhost\n---\nspring:\n  application:\n    name: %s", applicationName);
        FileWriter fs = new FileWriter(file);
        fs.write(context);
        fs.flush();
        fs.close();
    }

    @Test
    void isIndexPreloadCacheEnabled() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Assertions.assertFalse((boolean)config.isIndexPreloadCacheEnabled());
        config.setProperty("kylin.storage.columnar.spark-conf.spark.plugins", "GlutenPlugin");
        config.setProperty("kylin.storage.columnar.spark-conf.spark.gluten.enabled", "true");
        Assertions.assertTrue((boolean)config.isIndexPreloadCacheEnabled());
        config.setProperty("kylin.index.preloaded-cache.enabled", "false");
        Assertions.assertFalse((boolean)config.isIndexPreloadCacheEnabled());
    }

    @Test
    void isInternalTablePreloadCacheEnabled() {
        KylinConfig config = KylinConfig.getInstanceFromEnv();
        Assertions.assertFalse((boolean)config.isInternalTablePreloadCacheEnabled());
        config.setProperty("kylin.internal-table-enabled", "true");
        Assertions.assertFalse((boolean)config.isInternalTablePreloadCacheEnabled());
        config.setProperty("kylin.storage.columnar.spark-conf.spark.plugins", "GlutenPlugin");
        config.setProperty("kylin.storage.columnar.spark-conf.spark.gluten.enabled", "true");
        Assertions.assertTrue((boolean)config.isInternalTablePreloadCacheEnabled());
        config.setProperty("kylin.internal-table.preloaded-cache.enabled", "false");
        Assertions.assertFalse((boolean)config.isInternalTablePreloadCacheEnabled());
    }
}

