/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.constant;

import java.io.IOException;
import java.util.Map;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileStatus;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.constant.ObsConfig;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.junit.annotation.MetadataInfo;
import org.junit.jupiter.api.Test;

@MetadataInfo(onlyProps=true)
class ObsConfigTest {
    ObsConfigTest() {
    }

    @Test
    void getByLocation() {
        ObsConfig oss = ObsConfig.OSS;
        assert (!ObsConfig.getByType(null).isPresent());
        assert (!ObsConfig.getByType((String)"Foo").isPresent());
        assert (((ObsConfig)ObsConfig.getByType((String)"oss").get()).equals((Object)oss));
        assert (ObsConfig.getByLocation((String)"oss://bucket/path").get() == oss);
        assert (ObsConfig.getByLocation((String)"s3a://bucket/path").get() == ObsConfig.S3);
        assert (!ObsConfig.getByLocation((String)"/path").isPresent());
        Map credentialConf = FileSystemUtil.generateRoleCredentialConf((String)"oss", (String)"bucket1", (String)"role", (String)"cn-hangzhou", (String)"oss-cn-hangzhou.aliyuncs.com");
        assert (((String)credentialConf.get(String.format(ObsConfig.OSS.getRoleArnKey(), "bucket1"))).equals("role"));
        try {
            FileStatus[] s = FileSystemUtil.listStatus((FileSystem)FileSystem.getLocal((Configuration)new Configuration()), (Path)new Path("/"));
            assert (s.length > 0);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

