/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.persistence;

import java.util.List;
import java.util.NavigableSet;
import java.util.function.Consumer;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.persistence.JsonSerializer;
import org.apache.kylin.common.persistence.MetadataType;
import org.apache.kylin.common.persistence.RawResource;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.ResourceTool;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.Serializer;
import org.apache.kylin.common.persistence.StringEntity;
import org.apache.kylin.common.persistence.TransparentResourceStore;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.guava30.shaded.common.base.Throwables;
import org.junit.Assert;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ResourceStoreTestBase {
    private static final Logger logger = LoggerFactory.getLogger(ResourceStoreTestBase.class);
    private static final String PERFORMANCE_TEST_ROOT_PATH = "/performance";
    private static final int TEST_RESOURCE_COUNT = 100;

    public static void wrapInNewUrl(String url, KylinConfig kylinConfig, Consumer<ResourceStore> f) {
        String oldUrl = ResourceStoreTestBase.replaceMetadataUrl(kylinConfig, url);
        f.accept(ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig));
        ResourceStoreTestBase.replaceMetadataUrl(kylinConfig, oldUrl);
    }

    public static String mockUrl(String tag, KylinConfig kylinConfig) {
        String str = kylinConfig.getMetadataUrlPrefix() + "@" + tag;
        return str;
    }

    public static void testAStore(ResourceStore store) {
        ResourceStoreTestBase.testBasics(store);
        ResourceStoreTestBase.testGetAllResources(store);
    }

    public static void testPerformance(ResourceStore store) {
        logger.info("Test basic functions");
        ResourceStoreTestBase.testAStore(store);
        logger.info("Basic function ok. Start to test performance for class : {}", store.getClass());
        logger.info("Write metadata time : {}", (Object)ResourceStoreTestBase.testWritePerformance(store));
        logger.info("Read metadata time {}", (Object)ResourceStoreTestBase.testReadPerformance(store));
        logger.info("Performance test end. Class : {}", store.getClass());
    }

    private static void testGetAllResources(ResourceStore store) {
        String folder = MetadataType.SYSTEM.name();
        NLocalFileMetadataTestCase.staticCleanupTestMetadata();
        JsonSerializer serializer = new JsonSerializer(TestEntity.class);
        store.checkAndPutResource(folder + "/res1", (RootPersistentEntity)new TestEntity("data1"), (Serializer)serializer);
        try {
            Thread.sleep(10L);
        }
        catch (InterruptedException e) {
            throw Throwables.propagate((Throwable)e);
        }
        long startTime = System.currentTimeMillis();
        store.checkAndPutResource(folder + "/res2", (RootPersistentEntity)new TestEntity("data2"), (Serializer)serializer);
        store.checkAndPutResource(folder + "/res3", (RootPersistentEntity)new TestEntity("data3"), (Serializer)serializer);
        store.checkAndPutResource(folder + "/res4", (RootPersistentEntity)new TestEntity("data4"), (Serializer)serializer);
        List result = store.getAllResources(folder, (Serializer)serializer);
        ResourceStoreTestBase.assertEntity((TestEntity)((Object)result.get(0)), "data1", 0L);
        ResourceStoreTestBase.assertEntity((TestEntity)((Object)result.get(1)), "data2", 0L);
        ResourceStoreTestBase.assertEntity((TestEntity)((Object)result.get(3)), "data4", 0L);
        Assert.assertEquals((long)4L, (long)result.size());
        ((TestEntity)((Object)result.get(1))).setVersion("new_data2");
        store.checkAndPutResource(folder + "/res2", (RootPersistentEntity)result.get(1), (Serializer)serializer);
        result = store.getAllResources(folder, startTime, Long.MAX_VALUE, (Serializer)serializer);
        Assert.assertEquals((long)3L, (long)result.size());
        ResourceTool.resetR(store, folder);
    }

    private static void assertEntity(TestEntity entity, String data, long mvcc) {
        Assert.assertEquals((Object)data, (Object)entity.getVersion());
        Assert.assertTrue((System.currentTimeMillis() - entity.getLastModified() < 10000L ? 1 : 0) != 0);
        Assert.assertEquals((long)mvcc, (long)entity.getMvcc());
    }

    private static void testBasics(ResourceStore store) {
        String dir1 = MetadataType.MODEL.name();
        String path1 = MetadataType.mergeKeyWithType((String)"_test", (MetadataType)MetadataType.MODEL);
        StringEntity content1 = new StringEntity("anything");
        String dir2 = MetadataType.TABLE_INFO.name();
        String path2 = MetadataType.mergeKeyWithType((String)"_test", (MetadataType)MetadataType.TABLE_INFO);
        StringEntity content2 = new StringEntity("something");
        store.deleteResource(path1);
        store.deleteResource(path2);
        store.checkAndPutResource(path1, (RootPersistentEntity)content1, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path1));
        StringEntity t = (StringEntity)store.getResource(path1, StringEntity.serializer);
        Assert.assertEquals((Object)content1, (Object)t);
        store.checkAndPutResource(path2, (RootPersistentEntity)content2, StringEntity.serializer);
        Assert.assertTrue((boolean)store.exists(path2));
        t = (StringEntity)store.getResource(path2, StringEntity.serializer);
        Assert.assertEquals((Object)content2, (Object)t);
        t.setStr("new string");
        store.checkAndPutResource(path2, (RootPersistentEntity)t, StringEntity.serializer);
        t = (StringEntity)store.getResource(path2, StringEntity.serializer);
        t.setLastModified(t.getLastModified() - 1L);
        store.checkAndPutResource(path2, (RootPersistentEntity)t, StringEntity.serializer);
        if (store instanceof TransparentResourceStore) {
            t = (StringEntity)store.getResource(path2, StringEntity.serializer);
            t.setMvcc(t.getMvcc() - 1L);
            store.checkAndPutResource(path2, (RootPersistentEntity)t, StringEntity.serializer);
        } else {
            boolean versionConflictExceptionSeen = false;
            try {
                t = (StringEntity)store.getResource(path2, StringEntity.serializer);
                t.setMvcc(t.getMvcc() - 1L);
                store.checkAndPutResource(path2, (RootPersistentEntity)t, StringEntity.serializer);
                Assert.fail((String)"write conflict should trigger IllegalStateException");
            }
            catch (Exception e) {
                versionConflictExceptionSeen = true;
            }
            Assert.assertEquals((Object)true, (Object)versionConflictExceptionSeen);
        }
        NavigableSet list = null;
        list = store.listResources(dir1);
        System.out.println(list);
        Assert.assertTrue((boolean)list.contains(path1));
        Assert.assertFalse((boolean)list.contains(path2));
        list = store.listResources(dir2);
        Assert.assertTrue((boolean)list.contains(path2));
        Assert.assertFalse((boolean)list.contains(path1));
        list = store.listResources(MetadataType.ALL.name());
        Assert.assertTrue((boolean)list.contains(dir1));
        Assert.assertTrue((boolean)list.contains(dir2));
        Assert.assertFalse((boolean)list.contains(path1));
        Assert.assertFalse((boolean)list.contains(path2));
        RawResource raw = store.getResource(path1);
        Assert.assertNotNull((Object)raw);
        raw = store.getResource(path2);
        Assert.assertNotNull((Object)raw);
        store.deleteResource(path1);
        Assert.assertFalse((boolean)store.exists(path1));
        list = store.listResources(dir1);
        Assert.assertTrue((list == null || !list.contains(path1) ? 1 : 0) != 0);
        store.deleteResource(path2);
        Assert.assertFalse((boolean)store.exists(path2));
        list = store.listResources(dir2);
        Assert.assertTrue((list == null || !list.contains(path2) ? 1 : 0) != 0);
    }

    private static long testWritePerformance(ResourceStore store) {
        store.deleteResource(PERFORMANCE_TEST_ROOT_PATH);
        long startTime = System.currentTimeMillis();
        for (int i = 0; i < 100; ++i) {
            String resourcePath = "/performance/res_" + i;
            StringEntity content = new StringEntity("something_" + i);
            store.checkAndPutResource(resourcePath, (RootPersistentEntity)content, StringEntity.serializer);
        }
        return System.currentTimeMillis() - startTime;
    }

    private static long testReadPerformance(ResourceStore store) {
        long startTime = System.currentTimeMillis();
        int step = 0;
        for (int i = 0; i < 100; ++i) {
            String resourcePath = "/performance/res_" + i;
            StringEntity t = (StringEntity)store.getResource(resourcePath, StringEntity.serializer);
            step |= t.toString().length();
        }
        logger.info("step : {}", (Object)step);
        return System.currentTimeMillis() - startTime;
    }

    private static String replaceMetadataUrl(KylinConfig kylinConfig, String newUrl) {
        String oldUrl = kylinConfig.getMetadataUrl().toString();
        kylinConfig.setProperty("kylin.metadata.url", newUrl);
        return oldUrl;
    }

    public static void testPotentialMemoryLeak(String url, KylinConfig kylinConfig) {
        String oldUrl = ResourceStoreTestBase.replaceMetadataUrl(kylinConfig, url);
        ResourceStore.clearCache();
        Assert.assertFalse((boolean)ResourceStore.isPotentialMemoryLeak());
        ResourceStore.getKylinMetaStore((KylinConfig)kylinConfig);
        for (int i = 0; i < 100; ++i) {
            ResourceStore.getKylinMetaStore((KylinConfig)KylinConfig.createKylinConfig((KylinConfig)kylinConfig));
        }
        Assert.assertTrue((boolean)ResourceStore.isPotentialMemoryLeak());
        ResourceStore.clearCache((KylinConfig)kylinConfig);
        Assert.assertFalse((boolean)ResourceStore.isPotentialMemoryLeak());
        ResourceStore.clearCache();
        Assert.assertFalse((boolean)ResourceStore.isPotentialMemoryLeak());
        ResourceStoreTestBase.replaceMetadataUrl(kylinConfig, oldUrl);
    }

    public static void testGetUUID(ResourceStore store) {
        String uuid1 = store.getMetaStoreUUID();
        Assert.assertNotNull((Object)uuid1);
    }

    public static class TestEntity
    extends RootPersistentEntity {
        public TestEntity(String version) {
            this.version = version;
        }

        public TestEntity() {
        }
    }
}

