/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.common.util;

import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.ContentSummary;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.FileSystemTestHelper;
import org.apache.hadoop.fs.FsStatus;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.NLocalFileMetadataTestCase;
import org.apache.kylin.common.util.SegmentMergeStorageChecker;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.Mockito;

public class SegmentMergeStorageCheckerTest
extends NLocalFileMetadataTestCase {
    private static String pathName = "kylinTest" + RandomStringUtils.randomAlphanumeric((int)8);
    private static String quotaPathName = "kylinQuotaTest" + RandomStringUtils.randomAlphanumeric((int)8);

    @Before
    public void setUp() throws Exception {
        NLocalFileMetadataTestCase.staticCreateTestMetadata(new String[0]);
        this.overwriteSystemProp("kylin.hadoop.conf.dir", "../examples/test_case_data/sandbox");
    }

    @After
    public void after() throws Exception {
        SegmentMergeStorageCheckerTest.staticCleanupTestMetadata();
    }

    private FileSystemTestHelper.MockFileSystem createMockFileSystem() throws IOException, URISyntaxException {
        FileSystemTestHelper.MockFileSystem mockFs = new FileSystemTestHelper.MockFileSystem();
        FileSystemTestHelper.MockFileSystem rawFileSystem = mockFs.getRawFileSystem();
        rawFileSystem.create(new Path(pathName));
        rawFileSystem.create(new Path(quotaPathName));
        Mockito.when((Object)mockFs.getUri()).thenReturn((Object)new URI("hdfs://hdfstest:0"));
        Mockito.when((Object)rawFileSystem.getUri()).thenReturn((Object)new URI("hdfs://hdfstest:0"));
        Mockito.when((Object)rawFileSystem.getContentSummary(new Path("/"))).thenReturn((Object)new ContentSummary(0L, 0L, 0L, -1L, 0L, -1L));
        Mockito.when((Object)rawFileSystem.getContentSummary(new Path(pathName))).thenReturn((Object)new ContentSummary(0L, 0L, 0L, -1L, 0L, -1L));
        Mockito.when((Object)rawFileSystem.getContentSummary(new Path(quotaPathName))).thenReturn((Object)new ContentSummary(0L, 0L, 0L, -1L, 0L, 0xA00000L));
        Mockito.when((Object)rawFileSystem.getStatus()).thenReturn((Object)new FsStatus(524288000L, 0x6400000L, 0x19000000L));
        Mockito.when((Object)rawFileSystem.exists(new Path(quotaPathName))).thenReturn((Object)true);
        Mockito.when((Object)rawFileSystem.exists(new Path(pathName))).thenReturn((Object)true);
        return mockFs;
    }

    @Test
    public void testGetSpaceQuotaPath() throws IOException, URISyntaxException {
        String workingDir = "/";
        FileSystem fileSystem = HadoopUtil.getFileSystem((String)workingDir);
        Path quotaPath = SegmentMergeStorageChecker.getSpaceQuotaPath((FileSystem)fileSystem, (Path)new Path(workingDir));
        Assert.assertNull((Object)quotaPath);
        FileSystemTestHelper.MockFileSystem mockFs = this.createMockFileSystem();
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        conf.set("fs.defaultFS", "hdfs://hdfstest:0");
        FileSystemTestHelper.MockFileSystem rawFileSystem = mockFs.getRawFileSystem();
        quotaPath = SegmentMergeStorageChecker.getSpaceQuotaPath((FileSystem)rawFileSystem, (Path)new Path(pathName));
        Assert.assertNull((Object)quotaPath);
        quotaPath = SegmentMergeStorageChecker.getSpaceQuotaPath((FileSystem)rawFileSystem, (Path)new Path(quotaPathName));
        Assert.assertEquals((Object)quotaPath.toUri().getPath(), (Object)quotaPathName);
    }

    @Test
    public void testHadoopSpaceInfo() throws IOException, URISyntaxException {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        FileSystem rootFileSystem = HadoopUtil.getFileSystem((String)"/");
        SegmentMergeStorageChecker.setRootFileSystem((FileSystem)rootFileSystem);
        SegmentMergeStorageChecker.HadoopSpaceInfo hadoopSpaceInfo = SegmentMergeStorageChecker.HadoopSpaceInfo.getHadoopSpaceInfo((Configuration)conf, (String)"/");
        Assert.assertEquals((long)rootFileSystem.getStatus().getCapacity(), (long)hadoopSpaceInfo.getTotalSpace());
        String workingDir = KylinConfig.getInstanceFromEnv().getHdfsWorkingDirectory();
        hadoopSpaceInfo = SegmentMergeStorageChecker.HadoopSpaceInfo.getHadoopSpaceInfo((Configuration)conf, (String)workingDir);
        Assert.assertEquals((long)rootFileSystem.getStatus().getCapacity(), (long)hadoopSpaceInfo.getTotalSpace());
        FileSystemTestHelper.MockFileSystem mockFs = this.createMockFileSystem();
        conf.set("fs.defaultFS", "hdfs://hdfstest:0");
        FileSystemTestHelper.MockFileSystem rawFileSystem = mockFs.getRawFileSystem();
        SegmentMergeStorageChecker.setRootFileSystem((FileSystem)rawFileSystem);
        hadoopSpaceInfo = SegmentMergeStorageChecker.HadoopSpaceInfo.getHadoopSpaceInfo((Configuration)conf, (String)pathName);
        Assert.assertEquals((long)rawFileSystem.getStatus().getCapacity(), (long)hadoopSpaceInfo.getTotalSpace());
        Assert.assertEquals((long)rawFileSystem.getStatus().getRemaining(), (long)hadoopSpaceInfo.getRemainingSpace());
        Assert.assertEquals((long)rawFileSystem.getStatus().getUsed(), (long)hadoopSpaceInfo.getUsedSpace());
        hadoopSpaceInfo = SegmentMergeStorageChecker.HadoopSpaceInfo.getHadoopSpaceInfo((Configuration)conf, (String)quotaPathName);
        Assert.assertEquals((long)0xA00000L, (long)hadoopSpaceInfo.getTotalSpace());
    }

    @Test
    public void testGetDfsReplication() {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        Assert.assertEquals((long)3L, (long)SegmentMergeStorageChecker.getDfsReplication((String)"/", (Configuration)conf));
        conf.set("dfs.replication", "");
        HadoopUtil.setCurrentConfiguration((Configuration)conf);
        Assert.assertEquals((long)3L, (long)SegmentMergeStorageChecker.getDfsReplication((String)"/", (Configuration)conf));
    }

    @Test
    public void testCheckClusterStorageThresholdValue() throws IOException, URISyntaxException {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        FileSystemTestHelper.MockFileSystem mockFs = this.createMockFileSystem();
        conf.set("fs.defaultFS", "hdfs://hdfstest:0");
        FileSystemTestHelper.MockFileSystem rawFileSystem = mockFs.getRawFileSystem();
        SegmentMergeStorageChecker.setRootFileSystem((FileSystem)rawFileSystem);
        this.overwriteSystemProp("kylin.cube.merge-segment-storage-threshold", "0.75");
        this.overwriteSystemProp("kylin.env.hdfs-working-dir", quotaPathName);
        SegmentMergeStorageChecker.checkClusterStorageThresholdValue((String)quotaPathName, (Configuration)conf, (Long)0x200000L, (double)0.75, (int)3);
        Assert.assertTrue((boolean)true);
        SegmentMergeStorageChecker.checkClusterStorageThresholdValue((String)quotaPathName, (Configuration)conf, (Long)0x300000L, (double)0.75, (int)2);
        Assert.assertTrue((boolean)true);
        try {
            SegmentMergeStorageChecker.checkClusterStorageThresholdValue((String)quotaPathName, (Configuration)conf, (Long)0x300000L, (double)0.75, (int)3);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof KylinException));
            Assert.assertEquals((Object)MsgPicker.getMsg().getSegmentMergeStorageCheckError(), (Object)ex.getMessage());
        }
    }

    @Test
    public void testGetThresholdConfig() {
        KylinConfig instanceFromEnv = KylinConfig.getInstanceFromEnv();
        Assert.assertTrue((instanceFromEnv.getMergeSegmentStorageThreshold() == 0.0 ? 1 : 0) != 0);
    }

    @Test
    public void testIsThresholdAlarms() {
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)2000.0, (double)1000.0, (double)10000.0, (double)0.8));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)3000.0, (double)2000.0, (double)10000.0, (double)0.8));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)4000.0, (double)3000.0, (double)10000.0, (double)0.8));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)5000.0, (double)4000.0, (double)10000.0, (double)0.8));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)6000.0, (double)5000.0, (double)10000.0, (double)0.8));
        Assert.assertFalse((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)1000.0, (double)6000.0, (double)10000.0, (double)0.75));
        Assert.assertFalse((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)2000.0, (double)5000.0, (double)10000.0, (double)0.75));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)3000.0, (double)4000.0, (double)10000.0, (double)0.75));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)4000.0, (double)3000.0, (double)10000.0, (double)0.75));
        Assert.assertTrue((boolean)SegmentMergeStorageChecker.isThresholdAlarms((double)5000.0, (double)2000.0, (double)10000.0, (double)0.75));
    }

    @Test
    public void testRecountExpectedSpaceByte() throws IOException {
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        long spaceByte = SegmentMergeStorageChecker.recountExpectedSpaceByte((long)1024L, (int)3);
        System.out.println(spaceByte);
    }

    @Test
    public void testGetHadoopConfiguration() {
        KylinConfig kylinConfig = SegmentMergeStorageCheckerTest.getTestConfig();
        Configuration hadoopConfiguration = SegmentMergeStorageChecker.getHadoopConfiguration((KylinConfig)kylinConfig, (String)"hdfs://test:8080/kylin");
        Assert.assertNotEquals((Object)"hdfs://test:8080/kylin", (Object)hadoopConfiguration.get("fs.defaultFS"));
        kylinConfig.setProperty("kylin.engine.submit-hadoop-conf-dir", "/write_hadoop_conf");
        hadoopConfiguration = SegmentMergeStorageChecker.getHadoopConfiguration((KylinConfig)kylinConfig, (String)"hdfs://test:8080/kylin");
        Assert.assertEquals((Object)"hdfs://test:8080/kylin", (Object)hadoopConfiguration.get("fs.defaultFS"));
    }

    @Test
    public void testCheckMergeSegmentThreshold() throws IOException, URISyntaxException {
        KylinConfig testConfig = SegmentMergeStorageCheckerTest.getTestConfig();
        testConfig.setProperty("kylin.cube.merge-segment-storage-threshold", "0");
        SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)testConfig, (String)"/", (long)10240L);
        testConfig.setProperty("kylin.cube.merge-segment-storage-threshold", "2");
        SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)testConfig, (String)"/", (long)10240L);
        Configuration conf = HadoopUtil.getCurrentConfiguration();
        FileSystemTestHelper.MockFileSystem mockFs = this.createMockFileSystem();
        conf.set("fs.defaultFS", "hdfs://hdfstest:0");
        FileSystemTestHelper.MockFileSystem rawFileSystem = mockFs.getRawFileSystem();
        SegmentMergeStorageChecker.setRootFileSystem((FileSystem)rawFileSystem);
        testConfig.setProperty("kylin.cube.merge-segment-storage-threshold", "0.75");
        ArrayList<Long> mergeSegmentsSizeKB = new ArrayList<Long>();
        mergeSegmentsSizeKB.add(524288L);
        mergeSegmentsSizeKB.add(0x100000L);
        mergeSegmentsSizeKB.add(262144L);
        long expectedSpaceByKB = mergeSegmentsSizeKB.stream().mapToLong(Long::longValue).sum();
        SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)testConfig, (String)pathName, (long)expectedSpaceByKB);
        SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)testConfig, (String)quotaPathName, (long)expectedSpaceByKB);
        mergeSegmentsSizeKB.add(0x100000L);
        expectedSpaceByKB = mergeSegmentsSizeKB.stream().mapToLong(Long::longValue).sum();
        SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)testConfig, (String)pathName, (long)expectedSpaceByKB);
        try {
            SegmentMergeStorageChecker.checkMergeSegmentThreshold((KylinConfig)testConfig, (String)quotaPathName, (long)expectedSpaceByKB);
            Assert.fail();
        }
        catch (Exception ex) {
            Assert.assertTrue((boolean)(ex instanceof KylinException));
            Assert.assertEquals((Object)MsgPicker.getMsg().getSegmentMergeStorageCheckError(), (Object)ex.getMessage());
        }
    }
}

