/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.rest.service;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.rest.util.PagingUtil;
import org.junit.Assert;
import org.junit.Test;

public class PagingUtilTest {
    @Test
    public void testPageCut() {
        ArrayList list = Lists.newArrayList((Object[])new String[]{"a", "b", "c", "d", "e"});
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"d"}), (Object)PagingUtil.cutPage((List)list, (int)3, (int)1));
    }

    @Test
    public void testFuzzyMatching() {
        ArrayList noAccessList = Lists.newArrayList((Object[])new String[]{"a1", "AB1", "Ab1", "aB1", "abc1"});
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"AB1", "Ab1", "aB1", "abc1"}), (Object)PagingUtil.getIdentifierAfterFuzzyMatching((String)"ab", (boolean)false, (Collection)noAccessList));
        Assert.assertEquals((Object)Lists.newArrayList((Object[])new String[]{"abc1"}), (Object)PagingUtil.getIdentifierAfterFuzzyMatching((String)"ab", (boolean)true, (Collection)noAccessList));
    }

    @Test
    public void testIsInCurrentPage() {
        Assert.assertTrue((boolean)PagingUtil.isInCurrentPage((int)0, (int)0, (int)5));
        Assert.assertTrue((boolean)PagingUtil.isInCurrentPage((int)6, (int)1, (int)5));
        Assert.assertFalse((boolean)PagingUtil.isInCurrentPage((int)11, (int)1, (int)5));
        Assert.assertFalse((boolean)PagingUtil.isInCurrentPage((int)1, (int)1, (int)5));
    }
}

