/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.query.pushdown;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Map;
import org.apache.commons.dbcp2.BasicDataSource;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.query.pushdown.DataSourceConfig;

public class JdbcPushDownConnectionManager {
    private static final Map<String, JdbcPushDownConnectionManager> managerMap = Maps.newConcurrentMap();
    private final BasicDataSource dataSource = new BasicDataSource();
    private final DataSourceConfig dataSourceConfig;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    static JdbcPushDownConnectionManager getConnectionManager(KylinConfig config, String project) throws ClassNotFoundException {
        DataSourceConfig newDataSourceConfig;
        JdbcPushDownConnectionManager manager = managerMap.get(project);
        if (!JdbcPushDownConnectionManager.needUpdateProjectConnectionManager(manager, newDataSourceConfig = new DataSourceConfig(config))) return manager;
        Class<JdbcPushDownConnectionManager> clazz = JdbcPushDownConnectionManager.class;
        synchronized (JdbcPushDownConnectionManager.class) {
            if (!JdbcPushDownConnectionManager.needUpdateProjectConnectionManager(manager, newDataSourceConfig)) return manager;
            manager = new JdbcPushDownConnectionManager(config, newDataSourceConfig);
            managerMap.put(project, manager);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return manager;
        }
    }

    static boolean needUpdateProjectConnectionManager(JdbcPushDownConnectionManager manager, DataSourceConfig config) {
        return manager == null || !manager.dataSourceConfig.equals(config);
    }

    private JdbcPushDownConnectionManager(KylinConfig config, DataSourceConfig newDataSourceConfig) throws ClassNotFoundException {
        this.dataSourceConfig = newDataSourceConfig;
        Class.forName(config.getJdbcDriverClass());
        this.dataSource.setDriverClassName(config.getJdbcDriverClass());
        this.dataSource.setUrl(config.getJdbcUrl());
        this.dataSource.setUsername(config.getJdbcUsername());
        this.dataSource.setPassword(config.getJdbcPassword());
        this.dataSource.setMaxTotal(config.getPoolMaxTotal());
        this.dataSource.setMaxIdle(config.getPoolMaxIdle());
        this.dataSource.setMinIdle(config.getPoolMinIdle());
        this.dataSource.setTestOnBorrow(true);
        this.dataSource.setValidationQuery("select 1");
        this.dataSource.setRemoveAbandonedOnBorrow(true);
        this.dataSource.setRemoveAbandonedTimeout(300);
    }

    public void close() {
        try {
            this.dataSource.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void close(Connection conn) {
        try {
            conn.close();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public synchronized Connection getConnection() {
        try {
            return this.dataSource.getConnection();
        }
        catch (SQLException e) {
            throw new RuntimeException(e);
        }
    }
}

