/*
 * Decompiled with CFR 0.152.
 */
package org.apache.spark.sql;

import java.io.Serializable;
import java.lang.invoke.MethodHandle;
import java.lang.invoke.SerializedLambda;
import java.security.PrivilegedAction;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.QueryContext;
import org.apache.kylin.common.exception.ErrorCodeSupplier;
import org.apache.kylin.common.exception.KylinException;
import org.apache.kylin.common.exception.KylinTimeoutException;
import org.apache.kylin.common.exception.ServerErrorCode;
import org.apache.kylin.common.msg.MsgPicker;
import org.apache.kylin.common.util.DefaultHostInfoFetcher;
import org.apache.kylin.common.util.FileSystemUtil;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.engine.spark.QueryCostCollector;
import org.apache.kylin.engine.spark.filter.BloomFilterSkipCollector;
import org.apache.kylin.engine.spark.filter.ParquetPageFilterCollector;
import org.apache.kylin.metadata.model.NTableMetadataManager;
import org.apache.kylin.metadata.model.TableExtDesc;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.query.runtime.plan.QueryToExecutionIDCache$;
import org.apache.spark.ContextCleaner;
import org.apache.spark.ExecutorAllocationClient;
import org.apache.spark.SparkConf;
import org.apache.spark.SparkContext;
import org.apache.spark.SparkContext$;
import org.apache.spark.SparkEnv$;
import org.apache.spark.executor.InputMetrics;
import org.apache.spark.internal.Logging;
import org.apache.spark.scheduler.ContainerSchedulerManager;
import org.apache.spark.scheduler.SchedulerBackend;
import org.apache.spark.scheduler.SparkListener;
import org.apache.spark.scheduler.SparkListenerEvent;
import org.apache.spark.scheduler.SparkListenerInterface;
import org.apache.spark.scheduler.SparkListenerLogRollUp;
import org.apache.spark.scheduler.SparkListenerTaskEnd;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.KapFunctions$;
import org.apache.spark.sql.KylinSession$;
import org.apache.spark.sql.LogicalViewLoader;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.SparkSession$;
import org.apache.spark.sql.SparkSessionExtensions;
import org.apache.spark.sql.catalyst.optimizer.ConvertInnerJoinToSemiJoin;
import org.apache.spark.sql.catalyst.parser.ParseException;
import org.apache.spark.sql.catalyst.plans.logical.LogicalPlan;
import org.apache.spark.sql.execution.datasource.KylinDeltaSourceStrategy;
import org.apache.spark.sql.execution.datasource.KylinSourceStrategy$;
import org.apache.spark.sql.execution.datasource.LayoutFileSourceStrategy$;
import org.apache.spark.sql.execution.datasource.RewriteInferFiltersFromConstraints$;
import org.apache.spark.sql.execution.ui.PostQueryExecutionForKylin;
import org.apache.spark.sql.hive.HiveStorageRule$;
import org.apache.spark.sql.udf.UdfManager$;
import org.apache.spark.util.ThreadUtils$;
import org.apache.spark.util.Utils$;
import org.slf4j.Logger;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.Tuple2;
import scala.collection.IterableLike;
import scala.collection.Seq;
import scala.collection.immutable.StringOps;
import scala.collection.mutable.ArrayOps;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.LambdaDeserialize;
import scala.runtime.ObjectRef;
import scala.runtime.java8.JFunction0;

public final class SparderEnv$
implements Logging {
    public static SparderEnv$ MODULE$;
    private volatile SparkSession org$apache$spark$sql$SparderEnv$$spark;
    private final ReentrantLock org$apache$spark$sql$SparderEnv$$initializingLock;
    private final Condition org$apache$spark$sql$SparderEnv$$initializingCondition;
    private boolean org$apache$spark$sql$SparderEnv$$initializing;
    private final ExecutorService initializingExecutor;
    private volatile String APP_MASTER_TRACK_URL;
    private volatile int startSparkFailureTimes;
    private volatile long lastStartSparkFailureTime;
    private Option<ContainerSchedulerManager> _containerSchedulerManager;
    private final ThreadLocal<String> _separator;
    private final ThreadLocal<Dataset<Row>> _df;
    private final ThreadLocal<Boolean> _needCompute;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    static {
        new SparderEnv$();
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public SparkSession org$apache$spark$sql$SparderEnv$$spark() {
        return this.org$apache$spark$sql$SparderEnv$$spark;
    }

    private void org$apache$spark$sql$SparderEnv$$spark_$eq(SparkSession x$1) {
        this.org$apache$spark$sql$SparderEnv$$spark = x$1;
    }

    public ReentrantLock org$apache$spark$sql$SparderEnv$$initializingLock() {
        return this.org$apache$spark$sql$SparderEnv$$initializingLock;
    }

    public Condition org$apache$spark$sql$SparderEnv$$initializingCondition() {
        return this.org$apache$spark$sql$SparderEnv$$initializingCondition;
    }

    private boolean org$apache$spark$sql$SparderEnv$$initializing() {
        return this.org$apache$spark$sql$SparderEnv$$initializing;
    }

    public void org$apache$spark$sql$SparderEnv$$initializing_$eq(boolean x$1) {
        this.org$apache$spark$sql$SparderEnv$$initializing = x$1;
    }

    private ExecutorService initializingExecutor() {
        return this.initializingExecutor;
    }

    public String APP_MASTER_TRACK_URL() {
        return this.APP_MASTER_TRACK_URL;
    }

    public void APP_MASTER_TRACK_URL_$eq(String x$1) {
        this.APP_MASTER_TRACK_URL = x$1;
    }

    public int startSparkFailureTimes() {
        return this.startSparkFailureTimes;
    }

    public void startSparkFailureTimes_$eq(int x$1) {
        this.startSparkFailureTimes = x$1;
    }

    public long lastStartSparkFailureTime() {
        return this.lastStartSparkFailureTime;
    }

    public void lastStartSparkFailureTime_$eq(long x$1) {
        this.lastStartSparkFailureTime = x$1;
    }

    private Option<ContainerSchedulerManager> _containerSchedulerManager() {
        return this._containerSchedulerManager;
    }

    private void _containerSchedulerManager_$eq(Option<ContainerSchedulerManager> x$1) {
        this._containerSchedulerManager = x$1;
    }

    public SparkSession getSparkSessionWithConfig(KylinConfig config) {
        if (this.org$apache$spark$sql$SparderEnv$$spark() == null || this.org$apache$spark$sql$SparderEnv$$spark().sparkContext().isStopped()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Init spark.");
            this.initSpark((Function0<BoxedUnit>)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.doInitSpark(), config);
        }
        if (this.org$apache$spark$sql$SparderEnv$$spark() == null) {
            throw new KylinException((ErrorCodeSupplier)ServerErrorCode.SPARK_FAILURE, MsgPicker.getMsg().getSparkFailure());
        }
        return this.org$apache$spark$sql$SparderEnv$$spark();
    }

    public SparkSession getSparkSession() {
        return this.getSparkSessionWithConfig(null);
    }

    public String rollUpEventLog() {
        if (this.org$apache$spark$sql$SparderEnv$$spark() != null && !this.org$apache$spark$sql$SparderEnv$$spark().sparkContext().isStopped()) {
            String check = new StringBuilder(13).append("CHECK_ROLLUP_").append(System.currentTimeMillis()).toString();
            this.org$apache$spark$sql$SparderEnv$$spark().sparkContext().listenerBus().post((SparkListenerEvent)new SparkListenerLogRollUp(check));
            return check;
        }
        return "";
    }

    public void setSparkSession(SparkSession sparkSession) {
        this.org$apache$spark$sql$SparderEnv$$spark_$eq(sparkSession);
        UdfManager$.MODULE$.create(sparkSession);
    }

    public void setAPPMasterTrackURL(String url) {
        this.APP_MASTER_TRACK_URL_$eq(url);
    }

    public boolean isSparkAvailable() {
        return this.org$apache$spark$sql$SparderEnv$$spark() != null && !this.org$apache$spark$sql$SparderEnv$$spark().sparkContext().isStopped();
    }

    public synchronized void restartSpark() {
        Object object = this.org$apache$spark$sql$SparderEnv$$spark() != null && !this.org$apache$spark$sql$SparderEnv$$spark().sparkContext().isStopped() ? Utils$.MODULE$.tryWithSafeFinally((Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> MODULE$.org$apache$spark$sql$SparderEnv$$spark().stop(), (Function0)(JFunction0.mcV.sp & Serializable & scala.Serializable)() -> SparkContext$.MODULE$.clearActiveContext()) : BoxedUnit.UNIT;
        this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Restart Spark");
        this.init();
    }

    public void init() {
        this.getSparkSession();
    }

    public String getSparkConf(String key) {
        return this.getSparkSession().sparkContext().conf().get(key);
    }

    public boolean isSparkExecutorResourceLimited(SparkConf sparkConf) {
        return !new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.dynamicAllocation.enabled", "false"))).toBoolean() || new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.dynamicAllocation.maxExecutors", Integer.toString(Integer.MIN_VALUE)))).toInt() > 0;
    }

    public int getTotalCore() {
        SparkConf sparkConf = this.getSparkSession().sparkContext().getConf();
        if (sparkConf.get("spark.master").startsWith("local")) {
            return 1;
        }
        int instances = this.getExecutorNum(sparkConf);
        int cores = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.cores"))).toInt();
        return Math.max(instances * cores, 1);
    }

    /*
     * WARNING - void declaration
     */
    public int getExecutorNum(SparkConf sparkConf) {
        int n;
        if (new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.dynamicAllocation.enabled", "false"))).toBoolean()) {
            void var2_2;
            int maxExecutors = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.dynamicAllocation.maxExecutors", Integer.toString(Integer.MAX_VALUE)))).toInt();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(72).append("Use spark.dynamicAllocation.maxExecutors:").append(maxExecutors).append(" as num instances of executors.").toString());
            n = var2_2;
        } else {
            n = new StringOps(Predef$.MODULE$.augmentString(sparkConf.get("spark.executor.instances"))).toInt();
        }
        return n;
    }

    public void initSpark(Function0<BoxedUnit> doInit, KylinConfig config) {
        try {
            Object object;
            this.org$apache$spark$sql$SparderEnv$$initializingLock().lock();
            if ((this.org$apache$spark$sql$SparderEnv$$spark() == null || this.org$apache$spark$sql$SparderEnv$$spark().sparkContext().isStopped()) && !this.org$apache$spark$sql$SparderEnv$$initializing()) {
                this.org$apache$spark$sql$SparderEnv$$initializing_$eq(true);
                object = this.initializingExecutor().submit(new Callable<BoxedUnit>(config, doInit){
                    private final KylinConfig config$1;
                    private final Function0 doInit$1;

                    public void call() {
                        Object object = this.config$1 != null ? KylinConfig.setAndUnsetThreadLocalConfig((KylinConfig)this.config$1) : BoxedUnit.UNIT;
                        try {
                            SparderEnv$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initializing Spark thread starting.");
                            this.doInit$1.apply$mcV$sp();
                        }
                        finally {
                            SparderEnv$.MODULE$.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Initialized Spark");
                            SparderEnv$.MODULE$.org$apache$spark$sql$SparderEnv$$initializingLock().lock();
                            SparderEnv$.MODULE$.org$apache$spark$sql$SparderEnv$$initializing_$eq(false);
                            SparderEnv$.MODULE$.org$apache$spark$sql$SparderEnv$$initializingCondition().signalAll();
                            SparderEnv$.MODULE$.org$apache$spark$sql$SparderEnv$$initializingLock().unlock();
                        }
                    }
                    {
                        this.config$1 = config$1;
                        this.doInit$1 = doInit$1;
                    }

                    private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                        return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$call$1(), $anonfun$call$2()}, serializedLambda);
                    }
                });
            } else {
                object = BoxedUnit.UNIT;
            }
        }
        finally {
            this.org$apache$spark$sql$SparderEnv$$initializingLock().unlock();
        }
        try {
            try {
                this.org$apache$spark$sql$SparderEnv$$initializingLock().lock();
                if (Thread.interrupted()) {
                    throw new InterruptedException();
                }
                while (this.org$apache$spark$sql$SparderEnv$$initializing()) {
                    this.org$apache$spark$sql$SparderEnv$$initializingCondition().await();
                }
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                QueryContext.current().getQueryTagInfo().setTimeout(true);
                this.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(23).append("Query timeouts after: ").append(KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds()).append("s").toString());
                throw new KylinTimeoutException(new StringBuilder(71).append("The query exceeds the set time limit of ").append(KylinConfig.getInstanceFromEnv().getQueryTimeoutSeconds()).append("s. Current step: Init sparder. ").toString());
            }
        }
        finally {
            this.org$apache$spark$sql$SparderEnv$$initializingLock().unlock();
        }
        this.initConnWithHive();
    }

    public KylinConfig initSpark$default$2() {
        return null;
    }

    private void initConnWithHive() {
        try {
            UserGroupInformation.getLoginUser().doAs((PrivilegedAction)new PrivilegedAction<BoxedUnit>(){

                public void run() {
                    SparderEnv$.MODULE$.org$apache$spark$sql$SparderEnv$$spark().sql("show databases").show();
                }
            });
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error for initializing connection with hive.", throwable);
        }
    }

    public void doInitSpark() {
        try {
            boolean isLocalMode;
            SparkSession$.MODULE$.clearActiveSession();
            DefaultHostInfoFetcher hostInfoFetcher = new DefaultHostInfoFetcher();
            String appName = new StringBuilder(9).append("sparder-").append(UserGroupInformation.getCurrentUser().getShortUserName()).append("-").append(hostInfoFetcher.getHostname()).toString();
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(18).append("sparder init user:").append(UserGroupInformation.getCurrentUser().getUserName()).toString());
            boolean bl = isLocalMode = KylinConfig.getInstanceFromEnv().isJobNodeOnly() || "true".equals(System.getenv("SPARK_LOCAL")) || "true".equals(System.getProperty("spark.local"));
            SparkSession sparkSession = true == bl ? KylinSession$.MODULE$.KylinBuilder(SparkSession$.MODULE$.builder().master("local[3]").appName("sparder-local-sql-context").enableHiveSupport()).getOrCreateKylinSession() : KylinSession$.MODULE$.KylinBuilder(SparkSession$.MODULE$.builder().appName(appName).master("yarn").enableHiveSupport()).getOrCreateKylinSession();
            SparkSession sparkSession2 = sparkSession;
            this.injectExtensions(sparkSession2.extensions());
            if (KylinConfig.getInstanceFromEnv().getPercentileApproxAlgorithm().equalsIgnoreCase("t-digest")) {
                UdfManager$.MODULE$.register(sparkSession2, KapFunctions$.MODULE$.percentileFunction());
            }
            this.org$apache$spark$sql$SparderEnv$$spark_$eq(sparkSession2);
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Spark context started successfully with stack trace:");
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])Thread.currentThread().getStackTrace())).mkString("\n"));
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(14).append("Class loader: ").append(Thread.currentThread().getContextClassLoader().toString()).toString());
            this.registerListener(sparkSession2.sparkContext());
            this.registerContainerSchedulerManager(sparkSession2.sparkContext());
            this.registerQueryMetrics(sparkSession2.sparkContext());
            this.APP_MASTER_TRACK_URL_$eq(null);
            this.startSparkFailureTimes_$eq(0);
            this.lastStartSparkFailureTime_$eq(0L);
            if (KylinConfig.getInstanceFromEnv().useDynamicRoleCredentialInTable()) {
                NProjectManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv()).listAllProjects().forEach(project -> {
                    NTableMetadataManager tableMetadataManager = NTableMetadataManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)project.getName());
                    tableMetadataManager.listAllTables().forEach(tableDesc -> MODULE$.addCredential(tableMetadataManager.getOrCreateTableExt(tableDesc).getRoleCredentialInfo(), MODULE$.org$apache$spark$sql$SparderEnv$$spark()));
                });
            }
            if (KylinConfig.getInstanceFromEnv().isDDLLogicalViewEnabled()) {
                LogicalViewLoader.initScheduler();
            }
        }
        catch (Throwable throwable) {
            this.logError((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "Error for initializing spark ", throwable);
            this.startSparkFailureTimes_$eq(this.startSparkFailureTimes() + 1);
            this.lastStartSparkFailureTime_$eq(System.currentTimeMillis());
        }
    }

    public Option<ContainerSchedulerManager> containerSchedulerManager() {
        return this._containerSchedulerManager();
    }

    public void setContainerSchedulerManager(ContainerSchedulerManager containerSchedulerManager) {
        this._containerSchedulerManager_$eq((Option<ContainerSchedulerManager>)new Some((Object)containerSchedulerManager));
        this._containerSchedulerManager().foreach((Function1 & Serializable & scala.Serializable)x$1 -> {
            x$1.start();
            return BoxedUnit.UNIT;
        });
    }

    public void registerContainerSchedulerManager(SparkContext sc) {
        block2: {
            None$ none$;
            if (!KylinConfig.getInstanceFromEnv().isContainerSchedulerEnabled()) break block2;
            SchedulerBackend schedulerBackend = sc.schedulerBackend();
            if (schedulerBackend instanceof ExecutorAllocationClient) {
                SchedulerBackend schedulerBackend2 = schedulerBackend;
                none$ = new Some((Object)new ContainerSchedulerManager((ExecutorAllocationClient)schedulerBackend2, sc.listenerBus(), sc.conf(), (Option<ContextCleaner>)sc.cleaner(), sc.resourceProfileManager()));
            } else {
                none$ = None$.MODULE$;
            }
            this._containerSchedulerManager_$eq((Option<ContainerSchedulerManager>)none$);
            this._containerSchedulerManager().foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
                x$2.start();
                return BoxedUnit.UNIT;
            });
        }
    }

    public void injectExtensions(SparkSessionExtensions sse) {
        block0: {
            sse.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$3 -> KylinSourceStrategy$.MODULE$);
            sse.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$4 -> LayoutFileSourceStrategy$.MODULE$);
            sse.injectPlannerStrategy((Function1 & Serializable & scala.Serializable)x$5 -> new KylinDeltaSourceStrategy());
            sse.injectPostHocResolutionRule((Function1)HiveStorageRule$.MODULE$);
            sse.injectOptimizerRule((Function1 & Serializable & scala.Serializable)x$6 -> new ConvertInnerJoinToSemiJoin());
            if (!Predef$.MODULE$.Boolean2boolean(KapConfig.getInstanceFromEnv().isConstraintPropagationEnabled())) break block0;
            sse.injectOptimizerRule((Function1 & Serializable & scala.Serializable)x$7 -> RewriteInferFiltersFromConstraints$.MODULE$);
        }
    }

    public void registerListener(SparkContext sc) {
        SparkListener sparkListener = new SparkListener(){

            public void onOtherEvent(SparkListenerEvent event) {
                SparkListenerEvent sparkListenerEvent = event;
                if (sparkListenerEvent instanceof PostQueryExecutionForKylin) {
                    PostQueryExecutionForKylin postQueryExecutionForKylin = (PostQueryExecutionForKylin)sparkListenerEvent;
                    String queryID = postQueryExecutionForKylin.localProperties().getProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_ID_KEY(), "");
                    QueryToExecutionIDCache$.MODULE$.setQueryExecutionID(queryID, Long.toString(postQueryExecutionForKylin.executionId()));
                    String executionID = postQueryExecutionForKylin.localProperties().getProperty(QueryToExecutionIDCache$.MODULE$.KYLIN_QUERY_EXECUTION_ID(), "");
                    QueryToExecutionIDCache$.MODULE$.setQueryExecution(executionID, postQueryExecutionForKylin.queryExecution());
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                } else {
                    BoxedUnit boxedUnit = BoxedUnit.UNIT;
                }
            }
        };
        sc.addSparkListener((SparkListenerInterface)sparkListener);
    }

    public void registerQueryMetrics(SparkContext sc) {
        if (!KylinConfig.getInstanceFromEnv().isCollectQueryMetricsEnabled()) {
            return;
        }
        SparkListener taskListener = new SparkListener(){

            public void onTaskEnd(SparkListenerTaskEnd taskEnd) {
                try {
                    if (StringUtils.isNotBlank((CharSequence)taskEnd.queryId())) {
                        InputMetrics inputMetrics = taskEnd.taskMetrics().inputMetrics();
                        BloomFilterSkipCollector.addQueryMetrics((String)taskEnd.queryId(), (long)inputMetrics.totalBloomBlocks(), (long)inputMetrics.totalSkipBloomBlocks(), (long)inputMetrics.totalSkipBloomRows(), (long)inputMetrics.footerReadTime(), (long)inputMetrics.footerReadNumber());
                        ParquetPageFilterCollector.addQueryMetrics((String)taskEnd.queryId(), (long)inputMetrics.totalPagesCount(), (long)inputMetrics.filteredPagesCount(), (long)inputMetrics.afterFilterPagesCount());
                        QueryCostCollector.addQueryMetrics((String)taskEnd.queryId(), (long)taskEnd.taskMetrics().executorCpuTime());
                        QueryCostCollector.addQueryMetrics((String)taskEnd.queryId(), (long)taskEnd.taskMetrics().executorDeserializeCpuTime());
                    }
                }
                catch (Throwable e) {
                    SparderEnv$.MODULE$.logWarning((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "error when add metrics for query", e);
                }
            }

            private static /* synthetic */ Object $deserializeLambda$(SerializedLambda serializedLambda) {
                return LambdaDeserialize.bootstrap("lambdaDeserialize", new MethodHandle[]{$anonfun$onTaskEnd$1()}, serializedLambda);
            }
        };
        sc.addSparkListener((SparkListenerInterface)taskListener);
    }

    /*
     * WARNING - void declaration
     */
    public LogicalPlan validateSql(String sqlText) throws ParseException {
        void var2_2;
        LogicalPlan logicalPlan = this.getSparkSession().sessionState().sqlParser().parsePlan(sqlText);
        return var2_2;
    }

    public ThreadLocal<String> _separator() {
        return this._separator;
    }

    public ThreadLocal<Dataset<Row>> _df() {
        return this._df;
    }

    public ThreadLocal<Boolean> _needCompute() {
        return this._needCompute;
    }

    public void setSeparator(String separator) {
        this._separator().set(separator);
    }

    public String getSeparator() {
        return this._separator().get() == null ? "," : this._separator().get();
    }

    public Dataset<Row> getDF() {
        return this._df().get();
    }

    public void setDF(Dataset<Row> df) {
        this._df().set(df);
    }

    public void clean() {
        this._df().remove();
        this._needCompute().remove();
    }

    public Boolean needCompute() {
        return Predef$.MODULE$.boolean2Boolean(!Predef$.MODULE$.Boolean2boolean(this._needCompute().get()));
    }

    public void skipCompute() {
        this._needCompute().set(Predef$.MODULE$.boolean2Boolean(true));
    }

    public void cleanCompute() {
        this._needCompute().set(Predef$.MODULE$.boolean2Boolean(false));
    }

    public void addCredential(TableExtDesc.RoleCredentialInfo credentialInfo, SparkSession sparkSession) {
        block0: {
            if (credentialInfo == null) break block0;
            Map conf = FileSystemUtil.generateRoleCredentialConf((String)credentialInfo.getType(), (String)credentialInfo.getBucket(), (String)credentialInfo.getRole(), (String)credentialInfo.getEndpoint(), (String)credentialInfo.getRegion());
            conf.forEach((key, value) -> sparkSession.conf().set(key, value));
        }
    }

    public Configuration getHadoopConfiguration() {
        ObjectRef configuration = ObjectRef.create((Object)HadoopUtil.getCurrentConfiguration());
        ((IterableLike)this.org$apache$spark$sql$SparderEnv$$spark().conf().getAll().filter((Function1 & Serializable & scala.Serializable)item -> BoxesRunTime.boxToBoolean((boolean)SparderEnv$.$anonfun$getHadoopConfiguration$1(item)))).foreach((Function1 & Serializable & scala.Serializable)item -> {
            SparderEnv$.$anonfun$getHadoopConfiguration$2(configuration, item);
            return BoxedUnit.UNIT;
        });
        return (Configuration)configuration.elem;
    }

    public Seq<String> getActiveExecutorIds() {
        return this.getSparkSession().sparkContext().getExecutorIds();
    }

    public void deleteQueryTaskResultBlock(String queryExecutionID) {
        SparkEnv$.MODULE$.get().deleteAllBlockForQueryResult(queryExecutionID);
    }

    public static final /* synthetic */ boolean $anonfun$getHadoopConfiguration$1(Tuple2 item) {
        return ((String)item._1()).startsWith("fs.");
    }

    public static final /* synthetic */ void $anonfun$getHadoopConfiguration$2(ObjectRef configuration$1, Tuple2 item) {
        ((Configuration)configuration$1.elem).set((String)item._1(), (String)item._2());
    }

    private SparderEnv$() {
        MODULE$ = this;
        Logging.$init$((Logging)this);
        this.org$apache$spark$sql$SparderEnv$$initializingLock = new ReentrantLock();
        this.org$apache$spark$sql$SparderEnv$$initializingCondition = this.org$apache$spark$sql$SparderEnv$$initializingLock().newCondition();
        this.org$apache$spark$sql$SparderEnv$$initializing = false;
        this.initializingExecutor = ThreadUtils$.MODULE$.newDaemonFixedThreadPool(1, "SparderEnv-Init");
        this.APP_MASTER_TRACK_URL = null;
        this.startSparkFailureTimes = 0;
        this.lastStartSparkFailureTime = 0L;
        this._containerSchedulerManager = None$.MODULE$;
        this._separator = new ThreadLocal();
        this._df = new ThreadLocal();
        this._needCompute = new ThreadLocal<Boolean>(){

            public Boolean initialValue() {
                return Predef$.MODULE$.boolean2Boolean(false);
            }
        };
    }
}

