/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.job;

import com.fasterxml.jackson.core.JsonProcessingException;
import java.io.File;
import java.io.IOException;
import java.nio.file.Paths;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Properties;
import java.util.Set;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.security.UserGroupInformation;
import org.apache.kylin.common.KapConfig;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.common.KylinConfigBase;
import org.apache.kylin.common.KylinConfigExt;
import org.apache.kylin.common.StorageURL;
import org.apache.kylin.common.persistence.ResourceStore;
import org.apache.kylin.common.persistence.RootPersistentEntity;
import org.apache.kylin.common.persistence.metadata.MetadataStore;
import org.apache.kylin.common.util.ClassUtil;
import org.apache.kylin.common.util.FileUtils;
import org.apache.kylin.common.util.HadoopUtil;
import org.apache.kylin.common.util.JsonUtil;
import org.apache.kylin.common.util.StringHelper;
import org.apache.kylin.engine.spark.job.EmptyJob;
import org.apache.kylin.engine.spark.job.ISparkJobHandler;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.SparkAppDescription;
import org.apache.kylin.engine.spark.job.StageEnum;
import org.apache.kylin.guava30.shaded.common.annotations.VisibleForTesting;
import org.apache.kylin.guava30.shaded.common.base.Preconditions;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Maps;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.job.JobContext;
import org.apache.kylin.job.common.ExecutableUtil;
import org.apache.kylin.job.exception.ExecuteException;
import org.apache.kylin.job.exception.JobStoppedException;
import org.apache.kylin.job.execution.AbstractExecutable;
import org.apache.kylin.job.execution.ChainedStageExecutable;
import org.apache.kylin.job.execution.ExecutableManager;
import org.apache.kylin.job.execution.ExecutableState;
import org.apache.kylin.job.execution.ExecuteResult;
import org.apache.kylin.job.execution.StageExecutable;
import org.apache.kylin.job.util.JobContextUtil;
import org.apache.kylin.metadata.cube.model.NDataflow;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.project.NProjectManager;
import org.apache.kylin.metadata.project.ProjectInstance;
import org.apache.kylin.metadata.view.LogicalView;
import org.apache.kylin.metadata.view.LogicalViewManager;
import org.apache.kylin.profiler.BuildAsyncProfilerSparkPlugin;
import org.apache.kylin.util.DumpInfo;
import org.apache.kylin.util.MetadataDumpUtil;
import org.apache.spark.sql.KylinSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NSparkExecutable
extends AbstractExecutable
implements ChainedStageExecutable {
    private static final Logger logger = LoggerFactory.getLogger(NSparkExecutable.class);
    private static final String AM_EXTRA_JAVA_OPTIONS = "spark.yarn.am.extraJavaOptions";
    private static final String DRIVER_EXTRA_JAVA_OPTIONS = "spark.driver.extraJavaOptions";
    private static final String EXECUTOR_EXTRA_JAVA_OPTIONS = "spark.executor.extraJavaOptions";
    private static final String HADOOP_CONF_PATH = "./__spark_conf__/__hadoop_conf__/";
    private static final String APP_JAR_NAME = "__app__.jar";
    private static final String SPARK_JARS_1 = "spark.jars";
    private static final String SPARK_JARS_2 = "spark.yarn.dist.jars";
    private static final String SPARK_FILES_1 = "spark.files";
    private static final String SPARK_FILES_2 = "spark.yarn.dist.files";
    private static final String COMMA = ",";
    private static final String COLON = ":";
    private static final String EMPTY = "";
    private static final String EQUALS = "=";
    private static final String SPACE = " ";
    private static final String PATH_DELIMITER = "/";
    private static final String SUBMIT_LINE_FORMAT = " \\\n";
    private static final String DRIVER_EXTRA_CLASSPATH = "spark.driver.extraClassPath";
    private static final String EXECUTOR_EXTRA_CLASSPATH = "spark.executor.extraClassPath";
    public static final String SPARK_MASTER = "spark.master";
    protected static final String DEPLOY_MODE = "spark.submit.deployMode";
    protected static final String CLUSTER_MODE = "cluster";
    private static final String K8S_ENV_TZ = "spark.kubernetes.driverEnv.TZ";
    private static final String K8S_ENV_EXECUTOR_TZ = "spark.executorEnv.TZ";
    private static final String KRB5_CONF_WITH_CLUSTER_ON_K8S = "/etc/krb5.conf";
    private static final String KEYTAB_FILE_WITH_CLUSTER_ON_K8S = "/mnt/secrets/kerberos-keytab";
    public static final String JOB_LAST_RUNNING_START_TIME = "jobLastRunningStartTime";
    protected ISparkJobHandler sparkJobHandler;
    private final transient List<StageExecutable> stages = Lists.newCopyOnWriteArrayList();
    private final Map<String, List<StageExecutable>> stagesMap = Maps.newConcurrentMap();

    public NSparkExecutable() {
        this.initHandler();
    }

    public NSparkExecutable(Object notSetId) {
        super(notSetId);
        this.initHandler();
    }

    public String getDataflowId() {
        return this.getParam("dataflowId");
    }

    protected void initHandler() {
        this.sparkJobHandler = (ISparkJobHandler)ClassUtil.newInstance((String)KylinConfig.getInstanceFromEnv().getSparkBuildJobHandlerClassName());
    }

    public void killApplicationIfExistsOrUpdateStepStatus() {
    }

    public Set<String> getSegmentIds() {
        return Sets.newHashSet((Object[])StringUtils.split((String)this.getParam("segmentIds"), (String)COMMA));
    }

    public Set<Long> getCuboidLayoutIds() {
        return NSparkCubingUtil.str2Longs((String)this.getParam("layoutIds"));
    }

    protected void setSparkSubmitClassName(String className) {
        if (KylinConfig.getInstanceFromEnv().getSparkEngineBuildStepsToSkip().contains(((Object)((Object)this)).getClass().getName())) {
            className = EmptyJob.class.getName();
        }
        this.setParam("className", className);
    }

    public String getSparkSubmitClassName() {
        return this.getParam("className");
    }

    public String getJars() {
        return this.getParam("jars");
    }

    private boolean isLocalFs() {
        String fs = HadoopUtil.getWorkingFileSystem().getUri().toString();
        return fs.startsWith("file:");
    }

    private String getDistMetaFs() {
        String result;
        String defaultFs = HadoopUtil.getWorkingFileSystem().getUri().toString();
        String engineWriteFs = KylinConfig.getInstanceFromEnv().getEngineWriteFs();
        String string = result = StringUtils.isBlank((CharSequence)engineWriteFs) ? defaultFs : engineWriteFs;
        if (result.startsWith("maprfs://")) {
            return "maprfs://";
        }
        return result;
    }

    public void setDistMetaUrl(StorageURL storageURL) {
        String fs = this.getDistMetaFs();
        HashMap stringStringHashMap = Maps.newHashMap((Map)storageURL.getAllParameters());
        if (!this.isLocalFs()) {
            stringStringHashMap.put("path", fs + storageURL.getParameter("path"));
        }
        StorageURL copy = storageURL.copy((Map)stringStringHashMap);
        this.setParam("distMetaUrl", copy.toString());
        this.setParam("outputMetaUrl", copy + "_output");
    }

    public String getDistMetaUrl() {
        return this.getParam("distMetaUrl");
    }

    public void waiteForResourceStart(JobContext context) {
        JobContextUtil.withTxAndRetry(() -> {
            NSparkExecutable.getExecutableManager((String)this.getProject()).updateStageStatus(this.getId() + "_00", null, ExecutableState.RUNNING, null, null);
            return true;
        });
    }

    protected ExecuteResult doWork(JobContext context) throws ExecuteException {
        String hadoopConfDir;
        File hiveConfFile;
        String sparkHome;
        this.waiteForResourceStart(context);
        this.setLogPath(this.getSparkDriverLogHdfsPath(context.getKylinConfig()));
        KylinConfig config = this.getConfig();
        String jobId = this.getId();
        if (!config.isDevOrUT()) {
            this.setDistMetaUrl(config.getJobTmpMetaStoreUrl(this.project, jobId));
        }
        if (StringUtils.isEmpty((CharSequence)(sparkHome = KylinConfigBase.getSparkHome())) && !config.isUTEnv()) {
            throw new RuntimeException("Missing spark home");
        }
        String kylinJobJar = config.getKylinJobJarPath();
        if (StringUtils.isEmpty((CharSequence)kylinJobJar) && !config.isUTEnv()) {
            throw new RuntimeException("Missing kylin job jar");
        }
        if (!config.isDevOrUT()) {
            this.sparkJobHandler.checkApplicationJar(config);
        }
        if (!(hiveConfFile = new File(hadoopConfDir = HadoopUtil.getHadoopConfDir(), "hive-site.xml")).exists() && !config.isUTEnv()) {
            throw new RuntimeException("Cannot find hive-site.xml in kylin_hadoop_conf_dir: " + hadoopConfDir + ". In order to enable spark cubing, you must set kylin.env.hadoop-conf-dir to a dir which contains at least core-site.xml, hdfs-site.xml, hive-site.xml, mapred-site.xml, yarn-site.xml");
        }
        this.deleteSnapshotDirectoryOnExists();
        this.deleteJobTmpDirectoryOnExists();
        this.onExecuteStart();
        try {
            this.dumpKylinProps(config);
            if (!this.isResumable()) {
                DumpInfo dumpInfo = this.generateDumpInfo(config, DumpInfo.DumpType.DATA_LOADING);
                MetadataDumpUtil.dumpMetadata((DumpInfo)dumpInfo);
            }
        }
        catch (Exception e) {
            throw new ExecuteException("meta dump failed", (Throwable)e);
        }
        if (!this.isResumable()) {
            JobContextUtil.withTxAndRetry(() -> {
                ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).setJobResumable(this.getId());
                return true;
            });
        }
        this.sparkJobHandler.prepareEnviroment(this.project, jobId, this.getParams());
        String argsPath = this.createArgsFileOnHDFS(config, jobId);
        this.checkParentJobStatus();
        if (config.isDevOrUT()) {
            return this.runLocalMode(argsPath);
        }
        return this.runSparkSubmit(hadoopConfDir, kylinJobJar, "-className " + this.getSparkSubmitClassName() + SPACE + argsPath);
    }

    protected void onExecuteStart() throws JobStoppedException {
        this.wrapWithCheckQuit(() -> {
            Map<String, String> sparkConf = this.getSparkConf();
            HashMap jobParams = Maps.newHashMap();
            jobParams.put("job_params", JsonUtil.writeValueAsString(sparkConf));
            this.updateJobOutput(this.project, this.getId(), ExecutableState.RUNNING, jobParams, null, null);
        });
        this.setParam(JOB_LAST_RUNNING_START_TIME, String.valueOf(this.getParent().getOutput().getLastRunningStartTime()));
    }

    protected String createArgsFileOnHDFS(KylinConfig config, String jobId) throws ExecuteException {
        return this.sparkJobHandler.createArgsFileOnRemoteFileSystem(config, this.getProject(), jobId, this.getParams());
    }

    @VisibleForTesting
    public Map<String, String> filterEmptySegments(Map<String, String> originParams) {
        HashMap copied = Maps.newHashMap(originParams);
        String originSegments = (String)copied.get("segmentIds");
        String dfId = this.getDataflowId();
        NDataflow dataFlow = NDataflowManager.getInstance((KylinConfig)this.getConfig(), (String)this.getProject()).getDataflow(dfId);
        if (Objects.isNull(dataFlow) || StringUtils.isBlank((CharSequence)originSegments)) {
            return copied;
        }
        String newSegments = Stream.of(StringUtils.split((String)originSegments, (String)COMMA)).filter(id -> Objects.nonNull(dataFlow.getSegment(id))).collect(Collectors.joining(COMMA));
        copied.put("segmentIds", newSegments);
        return copied;
    }

    public String getSparkDriverLogHdfsPath(KylinConfig config) {
        return String.format(Locale.ROOT, "%s.%s.log", config.getJobTmpOutputStorePath(this.getProject(), this.getId()), System.currentTimeMillis());
    }

    private Boolean checkHadoopWorkingDir() {
        KylinConfig kylinConfig = KylinConfig.getInstanceFromEnv();
        String hdfsWorkingDirectory = kylinConfig.getHdfsWorkingDirectory();
        Properties properties = KylinConfig.buildSiteProperties();
        String hdfsWorkingDirectoryFromProperties = kylinConfig.getHdfsWorkingDirectoryFromProperties(properties);
        return StringUtils.equals((CharSequence)hdfsWorkingDirectory, (CharSequence)hdfsWorkingDirectoryFromProperties);
    }

    public KylinConfig getConfig() {
        String path;
        String yarnQueue;
        KylinConfig originalConfig = KylinConfig.getInstanceFromEnv();
        if (!originalConfig.isDevOrUT() && !this.checkHadoopWorkingDir().booleanValue()) {
            KylinConfig.getInstanceFromEnv().reloadKylinConfigPropertiesFromSiteProperties();
        }
        String project = this.getProject();
        Preconditions.checkState((boolean)StringUtils.isNotBlank((CharSequence)project), (Object)("job " + this.getId() + " project info is empty"));
        KylinConfigExt kylinConfigExt = this.getKylinConfigExt(originalConfig, project);
        HashMap jobOverrides = Maps.newHashMap();
        String parentId = this.getParentId();
        jobOverrides.put("job.id", StringUtils.defaultIfBlank((CharSequence)parentId, (CharSequence)this.getId()));
        jobOverrides.put("job.project", project);
        if (StringUtils.isNotBlank((CharSequence)originalConfig.getMountSparkLogDir())) {
            jobOverrides.put("job.mountDir", originalConfig.getMountSparkLogDir());
        }
        if (StringUtils.isNotBlank((CharSequence)parentId)) {
            jobOverrides.put("job.stepId", this.getId());
        }
        jobOverrides.put("user.timezone", KylinConfig.getInstanceFromEnv().getTimeZone());
        jobOverrides.put("spark.driver.log4j.appender.hdfs.File", Objects.isNull(this.getLogPath()) ? "null" : this.getLogPath());
        jobOverrides.putAll(kylinConfigExt.getExtendedOverrides());
        if (this.getParent() != null && !StringUtils.isEmpty((CharSequence)(yarnQueue = this.getParent().getSparkYarnQueue()))) {
            jobOverrides.put(KylinConfig.getInstanceFromEnv().getQueueKey(), yarnQueue);
        }
        if (StringUtils.isNotEmpty((CharSequence)(path = kylinConfigExt.getKubernetesUploadPath()))) {
            jobOverrides.put(kylinConfigExt.getKubernetesUploadPathKey(), path + PATH_DELIMITER + (String)StringUtils.defaultIfBlank((CharSequence)parentId, (CharSequence)this.getId()));
        }
        return KylinConfigExt.createInstance((KylinConfig)kylinConfigExt, (Map)jobOverrides);
    }

    public KylinConfigExt getKylinConfigExt(KylinConfig originalConfig, String project) {
        NDataflowManager dataflowManager;
        NDataflow dataflow;
        String dataflowId = this.getParam("dataflowId");
        if (StringUtils.isNotBlank((CharSequence)dataflowId) && null != (dataflow = (dataflowManager = NDataflowManager.getInstance((KylinConfig)originalConfig, (String)project)).getDataflow(dataflowId))) {
            return dataflow.getConfig();
        }
        ProjectInstance projectInstance = NProjectManager.getInstance((KylinConfig)originalConfig).getProject(project);
        return projectInstance.getConfig();
    }

    public SparkAppDescription getSparkAppDesc() {
        SparkAppDescription desc = new SparkAppDescription();
        KylinConfig conf = this.getConfig();
        desc.setJobNamePrefix(this.getJobNamePrefix());
        desc.setProject(this.getProject());
        desc.setJobId(this.getId());
        desc.setStepId(this.getStepId());
        desc.setSparkSubmitClassName(this.getSparkSubmitClassName());
        Map<String, String> sparkConf = this.getSparkConf(conf);
        desc.setSparkConf(sparkConf);
        desc.setComma(COMMA);
        desc.setSparkJars(this.getSparkJars(conf, sparkConf));
        desc.setSparkFiles(this.getSparkFiles(conf, sparkConf));
        return desc;
    }

    protected ExecuteResult runSparkSubmit(String hadoopConfDir, String kylinJobJar, String appArgs) {
        this.sparkJobHandler.killOrphanApplicationIfExists(this.project, this.getId(), this.getConfig(), Boolean.valueOf(true), this.getSparkConf());
        try {
            SparkAppDescription desc = this.getSparkAppDesc();
            desc.setHadoopConfDir(hadoopConfDir);
            desc.setKylinJobJar(kylinJobJar);
            desc.setAppArgs(appArgs);
            Object cmd = this.sparkJobHandler.generateSparkCmd(KylinConfig.getInstanceFromEnv(), desc);
            Map updateInfo = this.sparkJobHandler.runSparkSubmit(cmd, this.getParentId());
            String output = (String)updateInfo.get("output");
            if (StringUtils.isNotEmpty((CharSequence)((CharSequence)updateInfo.get("process_id")))) {
                try {
                    updateInfo.remove("output");
                    JobContextUtil.withTxAndRetry(() -> {
                        ExecutableManager.getInstance((KylinConfig)KylinConfig.getInstanceFromEnv(), (String)this.project).updateJobOutput(this.getParentId(), this.getStatus(), updateInfo, null, null);
                        return null;
                    });
                }
                catch (Exception e) {
                    logger.warn("failed to record process id.");
                }
            }
            return ExecuteResult.createSucceed((String)output);
        }
        catch (Exception e) {
            logger.warn("failed to execute spark submit command.");
            this.wrapWithExecuteExceptionUpdateJobError(e);
            return ExecuteResult.createError((Throwable)e);
        }
    }

    public void killOrphanApplicationIfExists(String jobStepId) {
        this.sparkJobHandler.killOrphanApplicationIfExists(this.project, jobStepId, this.getConfig(), Boolean.valueOf(false), this.getSparkConf());
    }

    protected Map<String, String> getSparkConfigOverride(KylinConfig config) {
        Map confMap = config.getSparkConfigOverride();
        String driverMemConf = "spark.driver.memory";
        if (!confMap.containsKey("spark.driver.memory")) {
            confMap.put("spark.driver.memory", this.computeStepDriverMemory() + "m");
        }
        if (UserGroupInformation.isSecurityEnabled()) {
            confMap.put("spark.hadoop.hive.metastore.sasl.enabled", "true");
        }
        if (!this.needRemoveGlutenParams(config)) {
            return ExecutableUtil.removeGultenParams((Map)confMap);
        }
        return confMap;
    }

    public boolean needRemoveGlutenParams(KylinConfig config) {
        return this.isInternalTableSparkJob() || config.buildUseGlutenEnabled();
    }

    private ExecuteResult runLocalMode(String appArgs) {
        try {
            Class appClz = ClassUtil.forName((String)this.getSparkSubmitClassName(), Object.class);
            appClz.getMethod("main", String[].class).invoke(appClz.newInstance(), new Object[]{new String[]{appArgs}});
            return ExecuteResult.createSucceed();
        }
        catch (Exception e) {
            return ExecuteResult.createError((Throwable)e);
        }
    }

    protected Set<String> getMetadataDumpList(KylinConfig config) {
        return Collections.emptySet();
    }

    public void attachMetadataAndKylinProps(KylinConfig config) throws Exception {
        this.dumpKylinProps(config);
        DumpInfo dumpInfo = this.generateDumpInfo(config, DumpInfo.DumpType.DATA_LOADING);
        MetadataDumpUtil.dumpMetadata((DumpInfo)dumpInfo);
    }

    protected Set<String> getLogicalViewMetaDumpList(KylinConfig config) {
        LogicalView logicalView;
        LinkedHashSet<String> dumpList = new LinkedHashSet<String>();
        if (!config.isDDLLogicalViewEnabled()) {
            return dumpList;
        }
        String table = this.getParam("table");
        String dataflowId = this.getDataflowId();
        LogicalViewManager viewManager = LogicalViewManager.getInstance((KylinConfig)config);
        if (StringUtils.isNotBlank((CharSequence)dataflowId)) {
            Set viewsMeta = viewManager.findLogicalViewsInModel(this.getProject(), this.getDataflowId()).stream().map(RootPersistentEntity::getResourcePath).collect(Collectors.toSet());
            dumpList.addAll(viewsMeta);
        }
        if (StringUtils.isNotBlank((CharSequence)table) && (logicalView = viewManager.findLogicalViewInProject(this.getProject(), table)) != null) {
            dumpList.add(logicalView.getResourcePath());
        }
        return dumpList;
    }

    protected void dumpKylinProps(KylinConfig config) throws IOException {
        String metaDumpUrl = this.getDistMetaUrl();
        if (StringUtils.isEmpty((CharSequence)metaDumpUrl)) {
            throw new RuntimeException("Missing metaUrl");
        }
        File tmpDir = File.createTempFile("kylin_job_meta", EMPTY);
        org.apache.commons.io.FileUtils.forceDelete((File)tmpDir);
        Properties props = config.exportToProperties();
        props.setProperty("kylin.metadata.url", metaDumpUrl);
        props.setProperty("kylin.env.transaction-lock-manager", "org.apache.kylin.common.persistence.transaction.TransactionPessimisticLockManager");
        this.modifyDump(props);
        ResourceStore.dumpKylinProps((File)tmpDir, (Properties)props);
        KylinConfig dstConfig = KylinConfig.createKylinConfig((Properties)props);
        MetadataStore.createMetadataStore((KylinConfig)dstConfig).uploadFromFile(tmpDir);
        logger.debug("Copied kylinProperties to the target metaUrl, delete the temp dir: {}", (Object)tmpDir);
        org.apache.commons.io.FileUtils.forceDelete((File)tmpDir);
    }

    protected DumpInfo generateDumpInfo(KylinConfig config, DumpInfo.DumpType type) {
        String project = this.getProject();
        String distMetaUrl = this.getDistMetaUrl();
        Set<String> metadataDumpList = this.getMetadataDumpList(config);
        return new DumpInfo(project, distMetaUrl, metadataDumpList, type);
    }

    protected void modifyDump(Properties props) {
        this.sparkJobHandler.modifyDump(props);
        this.removeUnNecessaryDump(props);
    }

    private void removeUnNecessaryDump(Properties props) {
        props.remove("kylin.engine.spark-conf.spark.jars");
        props.remove("kylin.engine.spark-conf.spark.yarn.dist.jars");
        props.remove("kylin.engine.spark-conf.spark.files");
        props.remove("kylin.engine.spark-conf.spark.yarn.dist.files");
        props.remove("kylin.engine.spark-conf.spark.driver.extraJavaOptions");
        props.remove("kylin.engine.spark-conf.spark.yarn.am.extraJavaOptions");
        props.remove("kylin.engine.spark-conf.spark.executor.extraJavaOptions");
        props.remove("kylin.engine.spark-conf.spark.driver.extraClassPath");
        props.remove("kylin.engine.spark-conf.spark.executor.extraClassPath");
        props.remove("kylin.query.async-query.spark-conf.spark.yarn.am.extraJavaOptions");
        props.remove("kylin.query.async-query.spark-conf.spark.executor.extraJavaOptions");
        props.remove("kylin.storage.columnar.spark-conf.spark.yarn.am.extraJavaOptions");
        props.remove("kylin.storage.columnar.spark-conf.spark.executor.extraJavaOptions");
        props.remove("kylin.extension.info.factory");
    }

    private void deleteSnapshotDirectoryOnExists() {
        if (this.isResumable()) {
            return;
        }
        KylinConfig kylinConf = KylinConfig.getInstanceFromEnv();
        String snapshotPath = kylinConf.getSnapshotCheckPointDir(this.getProject(), this.getId().split("_")[0]);
        try {
            Path path = new Path(snapshotPath);
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)path);
        }
        catch (Exception e) {
            logger.error("delete snapshot checkpoint in path {} failed.", (Object)snapshotPath, (Object)e);
        }
    }

    private void deleteJobTmpDirectoryOnExists() {
        if (!this.getConfig().isDeleteJobTmpWhenRetry()) {
            return;
        }
        if (this.isResumable()) {
            return;
        }
        StorageURL storageURL = StorageURL.valueOf((String)this.getDistMetaUrl());
        String metaPath = storageURL.getParameter("path");
        String[] directories = metaPath.split(PATH_DELIMITER);
        String lastDirectory = directories[directories.length - 1];
        String taskPath = metaPath.substring(0, metaPath.length() - 1 - lastDirectory.length());
        try {
            Path path = new Path(taskPath);
            HadoopUtil.deletePath((Configuration)HadoopUtil.getCurrentConfiguration(), (Path)path);
        }
        catch (Exception e) {
            logger.error("delete job tmp in path {} failed.", (Object)taskPath, (Object)e);
        }
    }

    protected String getJobNamePrefix() {
        return "job_step_";
    }

    protected String getExtJar() {
        return EMPTY;
    }

    public boolean needMergeMetadata() {
        return false;
    }

    public AbstractExecutable addStage(StageEnum stageEnum) {
        StageExecutable stage = stageEnum.createExecutable();
        return this.addStage((AbstractExecutable)stage);
    }

    public AbstractExecutable addStage(AbstractExecutable step) {
        int stepId = this.stages.size();
        step.setId(this.getId() + "_" + String.format(Locale.ROOT, "%02d", stepId));
        step.setParent((AbstractExecutable)this);
        step.setStepId(stepId);
        this.stages.add((StageExecutable)step);
        return step;
    }

    public void setStageMap() {
        if (CollectionUtils.isEmpty(this.stages)) {
            return;
        }
        if (StringUtils.isBlank((CharSequence)this.getParam("segmentIds"))) {
            this.stagesMap.put(this.getId(), this.stages);
            return;
        }
        for (String segmentId : this.getSegmentIds()) {
            this.stagesMap.put(segmentId, this.stages);
        }
        if (StringUtils.isNotBlank((CharSequence)this.getParam("layoutIds"))) {
            int indexCount = StringHelper.splitAndTrim((String)this.getParam("layoutIds"), (String)COMMA).length;
            this.setParam("indexCount", String.valueOf(indexCount));
        }
    }

    public void setStageMapWithSegment(String id, List<StageExecutable> steps) {
        List<StageExecutable> old = this.stagesMap.getOrDefault(id, Lists.newCopyOnWriteArrayList());
        old.addAll(steps);
        this.stagesMap.put(id, steps);
    }

    public Map<String, List<StageExecutable>> getStagesMap() {
        return this.stagesMap;
    }

    private boolean isClusterMode(Map<String, String> sparkConf) {
        return CLUSTER_MODE.equals(sparkConf.get(DEPLOY_MODE));
    }

    private Map<String, String> getSparkConf() {
        return this.getSparkConf(this.getConfig());
    }

    private Map<String, String> getSparkConf(KylinConfig kylinConf) {
        KapConfig kapConf = KapConfig.wrap((KylinConfig)kylinConf);
        Map<String, String> sparkConf = this.getSparkConfigOverride(kylinConf);
        this.rewriteKerberosConf(kapConf, sparkConf);
        this.rewriteTZenv(kylinConf, sparkConf);
        this.rewriteDriverExtraJavaOptions(kylinConf, kapConf, sparkConf);
        this.rewriteExecutorExtraJavaOptions(kylinConf, sparkConf);
        this.rewritePluginOptions(kylinConf, sparkConf);
        this.rewriteExtraClasspath(kylinConf, sparkConf);
        this.rewriteConfOfKubernetes(sparkConf);
        this.rewriteConfOfIndexPlanner(kylinConf, sparkConf);
        return Collections.unmodifiableMap(sparkConf);
    }

    private void rewriteConfOfIndexPlanner(KylinConfig kylinConf, Map<String, String> sparkConf) {
        boolean indexPlannerEnabled = Boolean.parseBoolean(this.getParam("kylin.planner.autoApproveEnabled"));
        if (indexPlannerEnabled) {
            Map indexPlannerSparkConf = kylinConf.getIndexPlannerBuildingConfigOverride();
            try {
                String indexPlannerSparkConfStr = JsonUtil.writeValueAsString((Object)indexPlannerSparkConf);
                sparkConf.putAll(indexPlannerSparkConf);
                logger.info("Override spark submit conf using index planner specified sparkConf: {}", (Object)indexPlannerSparkConfStr);
            }
            catch (JsonProcessingException e) {
                logger.error("Error when rewrite index planner spark submit conf");
            }
        }
    }

    private void rewriteConfOfKubernetes(Map<String, String> sparkConf) {
        if (sparkConf.get(SPARK_MASTER).startsWith("k8s")) {
            String podNamePrefix = KylinSession.generateExecutorPodNamePrefixForK8s((String)EMPTY);
            logger.info("Spark job run on k8s, generated executorPodNamePrefix is {}", (Object)podNamePrefix);
            sparkConf.putIfAbsent("spark.kubernetes.executor.podNamePrefix", podNamePrefix);
        }
    }

    private void rewriteTZenv(KylinConfig kylinConf, Map<String, String> sparkConf) {
        if (CLUSTER_MODE.equals(sparkConf.get(DEPLOY_MODE)) && sparkConf.get(SPARK_MASTER).startsWith("k8s") && StringUtils.isEmpty((CharSequence)sparkConf.get(K8S_ENV_TZ))) {
            sparkConf.put(K8S_ENV_TZ, kylinConf.getTimeZone());
            sparkConf.put(K8S_ENV_EXECUTOR_TZ, kylinConf.getTimeZone());
        }
    }

    private void rewriteDriverExtraJavaOptions(KylinConfig kylinConf, KapConfig kapConf, Map<String, String> sparkConf) {
        String logLocalWorkingDirectory;
        Map extendedOverrides;
        StringBuilder sb = new StringBuilder();
        if (sparkConf.containsKey(DRIVER_EXTRA_JAVA_OPTIONS)) {
            sb.append(sparkConf.get(DRIVER_EXTRA_JAVA_OPTIONS));
        }
        String hdfsWorkingDir = kylinConf.getHdfsWorkingDirectory();
        String sparkDriverHdfsLogPath = null;
        if (kylinConf instanceof KylinConfigExt && Objects.nonNull(extendedOverrides = ((KylinConfigExt)kylinConf).getExtendedOverrides())) {
            sparkDriverHdfsLogPath = (String)extendedOverrides.get("spark.driver.log4j.appender.hdfs.File");
        }
        if (kapConf.isCloud() && StringUtils.isNotBlank((CharSequence)(logLocalWorkingDirectory = kylinConf.getLogLocalWorkingDirectory()))) {
            hdfsWorkingDir = logLocalWorkingDirectory;
            sparkDriverHdfsLogPath = logLocalWorkingDirectory + sparkDriverHdfsLogPath;
        }
        sb.append(SPACE).append("-Dkylin.hdfs.working.dir=").append(hdfsWorkingDir);
        sb.append(SPACE).append("-Dspark.driver.log4j.appender.hdfs.File=").append(sparkDriverHdfsLogPath);
        this.rewriteDriverLog4jConf(sb, kylinConf, sparkConf);
        sb.append(SPACE).append("-Dspark.driver.rest.server.address=").append(kylinConf.getServerAddress());
        sb.append(SPACE).append("-Dspark.driver.param.taskId=").append(this.getId());
        sb.append(SPACE).append("-Dspark.driver.local.logDir=").append(KapConfig.getKylinLogDirAtBestEffort()).append("/spark");
        if (kapConf.getPlatformZKEnable()) {
            sb.append(SPACE).append("-Djava.security.auth.login.config=").append(kapConf.getKerberosJaasConfPath());
        }
        if (kylinConf.buildJobProfilingEnabled()) {
            sb.append(SPACE).append("-Dspark.profiler.flagsDir=").append(kylinConf.getJobTmpProfilerFlagsDir(this.project, this.getId()));
            sb.append(SPACE).append("-Dspark.profiler.collection.timeout=").append(kylinConf.buildJobProfilingResultTimeout());
            sb.append(SPACE).append("-Dspark.profiler.profiling.timeout=").append(kylinConf.buildJobProfilingProfileTimeout());
        }
        sparkConf.put(DRIVER_EXTRA_JAVA_OPTIONS, sb.toString().trim());
    }

    @VisibleForTesting
    public String getDriverExtraJavaOptions(KylinConfig kylinConf) {
        KapConfig kapConf = KapConfig.wrap((KylinConfig)kylinConf);
        Map<String, String> sparkConf = this.getSparkConfigOverride(kylinConf);
        this.rewriteDriverExtraJavaOptions(kylinConf, kapConf, sparkConf);
        return sparkConf.get(DRIVER_EXTRA_JAVA_OPTIONS);
    }

    private void rewriteKerberosConf(KapConfig kapConf, final Map<String, String> sparkConf) {
        if (Boolean.FALSE.equals(kapConf.isKerberosEnabled())) {
            return;
        }
        if (CLUSTER_MODE.equals(sparkConf.get(DEPLOY_MODE)) && sparkConf.get(SPARK_MASTER).startsWith("k8s")) {
            if (!FileUtils.fileExist((String)KRB5_CONF_WITH_CLUSTER_ON_K8S)) {
                throw new RuntimeException("spark-on-k8s with deployMode=cluster, krb5conf must be /etc/krb5.conf");
            }
            if (!FileUtils.folderExist((String)KEYTAB_FILE_WITH_CLUSTER_ON_K8S) || !FileUtils.fileExist((String)("/mnt/secrets/kerberos-keytab/" + kapConf.getKerberosKeytab()))) {
                throw new RuntimeException("spark-on-k8s with deployMode=cluster, keytab must in /mnt/secrets/kerberos-keytab");
            }
            sparkConf.put("spark.kerberos.principal", kapConf.getKerberosPrincipal());
            sparkConf.put("spark.kerberos.keytab", "/mnt/secrets/kerberos-keytab/" + kapConf.getKerberosKeytab());
            sparkConf.put("spark.kubernetes.kerberos.krb5.path", KRB5_CONF_WITH_CLUSTER_ON_K8S);
        } else {
            sparkConf.put("spark.kerberos.principal", kapConf.getKerberosPrincipal());
            sparkConf.put("spark.kerberos.keytab", kapConf.getKerberosKeytabPath());
            String remoteKrb5 = HADOOP_CONF_PATH + kapConf.getKerberosKrb5Conf();
            ConfMap confMap = new ConfMap(){

                @Override
                public String get(String key) {
                    return (String)sparkConf.get(key);
                }

                @Override
                public void set(String key, String value) {
                    sparkConf.put(key, value);
                }
            };
            if (this.isClusterMode(sparkConf)) {
                this.rewriteSpecifiedKrb5Conf(DRIVER_EXTRA_JAVA_OPTIONS, remoteKrb5, confMap);
            } else {
                this.rewriteSpecifiedKrb5Conf(DRIVER_EXTRA_JAVA_OPTIONS, kapConf.getKerberosKrb5ConfPath(), confMap);
            }
            this.rewriteSpecifiedKrb5Conf(AM_EXTRA_JAVA_OPTIONS, remoteKrb5, confMap);
            this.rewriteSpecifiedKrb5Conf(EXECUTOR_EXTRA_JAVA_OPTIONS, remoteKrb5, confMap);
        }
    }

    private void rewriteExecutorExtraJavaOptions(KylinConfig kylinConf, Map<String, String> sparkConf) {
        StringBuilder sb = new StringBuilder();
        if (sparkConf.containsKey(EXECUTOR_EXTRA_JAVA_OPTIONS)) {
            sb.append(sparkConf.get(EXECUTOR_EXTRA_JAVA_OPTIONS));
        }
        sb.append(SPACE).append("-Dkylin.dictionary.globalV2-store-class-name=").append(kylinConf.getGlobalDictV2StoreImpl());
        sparkConf.put(EXECUTOR_EXTRA_JAVA_OPTIONS, sb.toString().trim());
    }

    private void rewriteSpecifiedKrb5Conf(String key, String value, ConfMap confMap) {
        String originOptions = confMap.get(key);
        if (Objects.isNull(originOptions)) {
            originOptions = EMPTY;
        }
        if (originOptions.contains("-Djava.security.krb5.conf")) {
            return;
        }
        String newOptions = "-Djava.security.krb5.conf=" + value + SPACE + originOptions;
        confMap.set(key, newOptions.trim());
    }

    private void rewritePluginOptions(KylinConfig kylinConf, Map<String, String> sparkConf) {
        if (kylinConf.buildJobProfilingEnabled()) {
            sparkConf.computeIfPresent("spark.plugins", (pluginKey, pluginValue) -> pluginValue + COMMA + BuildAsyncProfilerSparkPlugin.class.getCanonicalName());
            sparkConf.computeIfAbsent("spark.plugins", pluginKey -> BuildAsyncProfilerSparkPlugin.class.getCanonicalName());
        }
    }

    private void rewriteExtraClasspath(KylinConfig kylinConf, Map<String, String> sparkConf) {
        LinkedHashSet sparkJars = Sets.newLinkedHashSet();
        boolean glutenEnabled = Boolean.parseBoolean(sparkConf.get("spark.gluten.enabled"));
        if (this.isClusterMode(sparkConf)) {
            sparkJars.add(APP_JAR_NAME);
            if (glutenEnabled) {
                sparkJars.add("gluten.jar");
            }
            sparkJars.addAll(this.getSparkJars(kylinConf, sparkConf));
            String jointJarNames = sparkJars.stream().map(jar -> Paths.get(jar, new String[0]).getFileName().toString()).sorted().collect(Collectors.joining(COLON));
            sparkConf.put(DRIVER_EXTRA_CLASSPATH, jointJarNames);
            sparkConf.put(EXECUTOR_EXTRA_CLASSPATH, jointJarNames);
            return;
        }
        sparkJars.addAll(this.getSparkJars(kylinConf, sparkConf));
        if (sparkConf.get(SPARK_MASTER).startsWith("yarn")) {
            if (glutenEnabled) {
                sparkJars.add(sparkConf.get("spark.gluten.sql.driver.jar.path"));
            }
            sparkConf.put(DRIVER_EXTRA_CLASSPATH, sparkJars.stream().sorted(Comparator.comparing(jar -> jar.substring(jar.lastIndexOf(PATH_DELIMITER)))).collect(Collectors.joining(COLON)));
            sparkConf.put(EXECUTOR_EXTRA_CLASSPATH, sparkJars.stream().map(jar -> Paths.get(jar, new String[0]).getFileName().toString()).sorted().collect(Collectors.joining(COLON)));
        } else {
            String driverCp = sparkJars.stream().sorted(Comparator.comparing(jar -> jar.substring(jar.lastIndexOf(PATH_DELIMITER)))).collect(Collectors.joining(COLON));
            String executorCp = sparkJars.stream().map(jar -> Paths.get(jar, new String[0]).getFileName().toString()).sorted().collect(Collectors.joining(COLON));
            if (glutenEnabled) {
                driverCp = sparkConf.get("spark.gluten.sql.driver.jar.path") + COLON + driverCp;
                executorCp = sparkConf.get("spark.gluten.sql.executor.jar.path") + COLON + executorCp;
            }
            sparkConf.put(DRIVER_EXTRA_CLASSPATH, driverCp);
            sparkConf.put(EXECUTOR_EXTRA_CLASSPATH, executorCp);
        }
    }

    private void rewriteDriverLog4jConf(StringBuilder sb, KylinConfig config, Map<String, String> sparkConf) {
        String localLog4j = config.getLogSparkDriverPropertiesFile();
        String remoteLog4j = Paths.get(localLog4j, new String[0]).getFileName().toString();
        if (this.isClusterMode(sparkConf) || config.getSparkMaster().startsWith("k8s")) {
            sb.append(SPACE).append("-Dlog4j.configurationFile=").append(remoteLog4j);
        } else {
            sb.append(SPACE).append("-Dlog4j.configurationFile=file:").append(localLog4j);
        }
    }

    private Set<String> getSparkJars(KylinConfig kylinConf, Map<String, String> sparkConf) {
        LinkedHashSet jarPaths = Sets.newLinkedHashSet();
        jarPaths.add(kylinConf.getKylinJobJarPath());
        jarPaths.add(kylinConf.getExtraJarsPath());
        jarPaths.add(this.getJars());
        jarPaths.add(this.getExtJar());
        jarPaths.add(sparkConf.get(SPARK_JARS_1));
        jarPaths.add(sparkConf.get(SPARK_JARS_2));
        LinkedHashSet sparkJars = jarPaths.stream().filter(StringUtils::isNotEmpty).flatMap(p -> Arrays.stream(StringUtils.split((String)p, (String)COMMA))).filter(jar -> jar.endsWith(".jar")).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(sparkJars);
    }

    private Set<String> getSparkFiles(KylinConfig kylinConf, Map<String, String> sparkConf) {
        LinkedHashSet filePaths = Sets.newLinkedHashSet();
        filePaths.add(kylinConf.getLogSparkAppMasterPropertiesFile());
        filePaths.add(kylinConf.getLogSparkDriverPropertiesFile());
        filePaths.add(kylinConf.getLogSparkExecutorPropertiesFile());
        if (kylinConf.buildJobProfilingEnabled()) {
            try {
                filePaths.add(kylinConf.getAsyncProfilerFiles());
            }
            catch (IOException e) {
                logger.error("Add SparkPluginFile failed.", (Throwable)e);
            }
        }
        filePaths.add(sparkConf.get(SPARK_FILES_1));
        filePaths.add(sparkConf.get(SPARK_FILES_2));
        if (sparkConf.get(SPARK_MASTER).startsWith("yarn") && Boolean.parseBoolean(sparkConf.get("spark.gluten.enabled"))) {
            filePaths.add(sparkConf.get("spark.gluten.sql.driver.jar.path"));
        }
        LinkedHashSet sparkFiles = filePaths.stream().filter(StringUtils::isNotEmpty).flatMap(p -> Arrays.stream(StringUtils.split((String)p, (String)COMMA))).filter(StringUtils::isNotEmpty).collect(Collectors.toCollection(LinkedHashSet::new));
        return Collections.unmodifiableSet(sparkFiles);
    }

    public void cancelJob() {
        this.killOrphanApplicationIfExists(this.getId());
    }

    private static interface ConfMap {
        public String get(String var1);

        public void set(String var1, String var2);
    }
}

