/*
 * Decompiled with CFR 0.152.
 */
package org.apache.kylin.engine.spark.smarter;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.function.Function;
import org.apache.commons.lang3.StringUtils;
import org.apache.hadoop.fs.Path;
import org.apache.kylin.common.KylinConfig;
import org.apache.kylin.engine.spark.builder.NBuildSourceInfo;
import org.apache.kylin.engine.spark.job.BuildJobInfos;
import org.apache.kylin.engine.spark.job.BuildLayoutWithUpdate;
import org.apache.kylin.engine.spark.job.CuboidAggregator$;
import org.apache.kylin.engine.spark.job.DFBuildJob;
import org.apache.kylin.engine.spark.job.DFChooser;
import org.apache.kylin.engine.spark.job.DFChooser$;
import org.apache.kylin.engine.spark.job.NSparkCubingUtil;
import org.apache.kylin.engine.spark.job.SanityChecker$;
import org.apache.kylin.engine.spark.smarter.DFSmartBuild$;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableSet;
import org.apache.kylin.guava30.shaded.common.collect.Lists;
import org.apache.kylin.guava30.shaded.common.collect.Sets;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTree;
import org.apache.kylin.metadata.cube.cuboid.NSpanningTreeFactory;
import org.apache.kylin.metadata.cube.model.IndexEntity;
import org.apache.kylin.metadata.cube.model.IndexPlan;
import org.apache.kylin.metadata.cube.model.LayoutEntity;
import org.apache.kylin.metadata.cube.model.NDataLayout;
import org.apache.kylin.metadata.cube.model.NDataSegment;
import org.apache.kylin.metadata.cube.model.NDataflowManager;
import org.apache.kylin.metadata.model.NDataModel;
import org.apache.spark.internal.Logging;
import org.apache.spark.sql.Column;
import org.apache.spark.sql.Dataset;
import org.apache.spark.sql.Row;
import org.apache.spark.sql.SparkSession;
import org.apache.spark.sql.datasource.storage.StorageStoreUtils$;
import org.apache.spark.sql.hive.utils.ResourceDetectUtils$;
import org.apache.spark.tracker.AppStatusContext;
import org.apache.spark.tracker.IndexTaskContext;
import org.apache.spark.tracker.IndexTaskScheduler;
import org.apache.spark.tracker.ResourceState$;
import org.slf4j.Logger;
import scala.Enumeration;
import scala.Function0;
import scala.Function1;
import scala.Predef$;
import scala.Some;
import scala.collection.Iterable;
import scala.collection.Iterable$;
import scala.collection.IterableLike;
import scala.collection.JavaConverters$;
import scala.collection.Seq;
import scala.collection.Seq$;
import scala.collection.Set;
import scala.collection.TraversableLike;
import scala.collection.TraversableOnce;
import scala.collection.immutable.;
import scala.collection.immutable.List;
import scala.collection.immutable.Nil$;
import scala.collection.mutable.ArrayOps;
import scala.collection.mutable.Buffer;
import scala.collection.mutable.ListBuffer;
import scala.collection.mutable.ListBuffer$;
import scala.math.Ordering;
import scala.math.PartialOrdering;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;

@ScalaSignature(bytes="\u0006\u0001\t5h\u0001B\u001b7\u0001\rCQ!\u0015\u0001\u0005\u0002ICq!\u0016\u0001A\u0002\u0013Ea\u000bC\u0004e\u0001\u0001\u0007I\u0011C3\t\r1\u0004\u0001\u0015)\u0003X\u0011%i\u0007\u00011AA\u0002\u0013Ea\u000eC\u0005x\u0001\u0001\u0007\t\u0019!C\tq\"I!\u0010\u0001a\u0001\u0002\u0003\u0006Ka\u001c\u0005\nw\u0002\u0001\r\u00111A\u0005\u0012YC\u0011\u0002 \u0001A\u0002\u0003\u0007I\u0011C?\t\u0013}\u0004\u0001\u0019!A!B\u00139\u0006bCA\u0001\u0001\u0001\u0007\t\u0019!C\t\u0003\u0007A1\"a\u0003\u0001\u0001\u0004\u0005\r\u0011\"\u0005\u0002\u000e!Y\u0011\u0011\u0003\u0001A\u0002\u0003\u0005\u000b\u0015BA\u0003\u0011-\t\u0019\u0002\u0001a\u0001\u0002\u0004%\t\"!\u0006\t\u0017\u0005-\u0002\u00011AA\u0002\u0013E\u0011Q\u0006\u0005\f\u0003c\u0001\u0001\u0019!A!B\u0013\t9\u0002C\u0006\u00024\u0001\u0001\r\u00111A\u0005\u0012\u0005U\u0002bCA\"\u0001\u0001\u0007\t\u0019!C\t\u0003\u000bB1\"!\u0013\u0001\u0001\u0004\u0005\t\u0015)\u0003\u00028!I\u00111\n\u0001A\u0002\u0013%\u0011Q\n\u0005\n\u0003?\u0002\u0001\u0019!C\u0005\u0003CB\u0001\"!\u001a\u0001A\u0003&\u0011q\n\u0005\n\u0003O\u0002\u0001\u0019!C\u0005\u0003\u001bB\u0011\"!\u001b\u0001\u0001\u0004%I!a\u001b\t\u0011\u0005=\u0004\u0001)Q\u0005\u0003\u001fB\u0011\"!\u001d\u0001\u0001\u0004%I!a\u001d\t\u0013\u0005u\u0004\u00011A\u0005\n\u0005}\u0004\u0002CAB\u0001\u0001\u0006K!!\u001e\t\u0017\u0005\u0015\u0005\u00011AA\u0002\u0013%\u0011q\u0011\u0005\f\u0003+\u0003\u0001\u0019!a\u0001\n\u0013\t9\nC\u0006\u0002\u001c\u0002\u0001\r\u0011!Q!\n\u0005%\u0005bBAO\u0001\u0011E\u0013q\u0014\u0005\b\u0003C\u0003A\u0011KAP\u0011\u001d\t\u0019\u000b\u0001C!\u0003?Cq!!*\u0001\t\u0013\t9\u000bC\u0004\u0002.\u0002!\t!a,\t\u000f\u0005e\u0007\u0001\"\u0001\u0002\\\"9\u0011q\u001c\u0001\u0005\u0012\u0005\u0005\bbBAx\u0001\u0011%\u0011\u0011\u001f\u0005\b\u0003\u007f\u0004A\u0011\u0001B\u0001\u0011\u001d\u0011\u0019\u0003\u0001C\u0005\u0005KAqA!\u0017\u0001\t\u0013\u0011Y\u0006\u0003\u0007\u0003\u0004\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011)\t\u0003\u0007\u0003\u0010\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011\t\n\u0003\u0007\u0003\u001c\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011i\n\u0003\u0007\u0003.\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011y\u000b\u0003\u0007\u0003:\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011Y\f\u0003\u0007\u0003L\u0002\u0001\n\u0011!A\u0001\n\u0003\u0011imB\u0004\u0003XZB\tA!7\u0007\rU2\u0004\u0012\u0001Bn\u0011\u0019\t&\u0007\"\u0001\u0003d\"9!Q\u001d\u001a\u0005\u0002\t\u001d(\u0001\u0004#G'6\f'\u000f\u001e\"vS2$'BA\u001c9\u0003\u001d\u0019X.\u0019:uKJT!!\u000f\u001e\u0002\u000bM\u0004\u0018M]6\u000b\u0005mb\u0014AB3oO&tWM\u0003\u0002>}\u0005)1.\u001f7j]*\u0011q\bQ\u0001\u0007CB\f7\r[3\u000b\u0003\u0005\u000b1a\u001c:h\u0007\u0001\u00192\u0001\u0001#K!\t)\u0005*D\u0001G\u0015\t9\u0005(A\u0002k_\nL!!\u0013$\u0003\u0015\u00113%)^5mI*{'\r\u0005\u0002L\u001f6\tAJ\u0003\u0002N\u001d\u0006A\u0011N\u001c;fe:\fGN\u0003\u0002:}%\u0011\u0001\u000b\u0014\u0002\b\u0019><w-\u001b8h\u0003\u0019a\u0014N\\5u}Q\t1\u000b\u0005\u0002U\u00015\ta'A\bU\u000b6\u0003v\fR%S?N+fIR%Y+\u00059\u0006C\u0001-b\u001d\tIv\f\u0005\u0002[;6\t1L\u0003\u0002]\u0005\u00061AH]8pizR\u0011AX\u0001\u0006g\u000e\fG.Y\u0005\u0003Av\u000ba\u0001\u0015:fI\u00164\u0017B\u00012d\u0005\u0019\u0019FO]5oO*\u0011\u0001-X\u0001\u0014)\u0016k\u0005k\u0018#J%~\u001bVK\u0012$J1~#S-\u001d\u000b\u0003M*\u0004\"a\u001a5\u000e\u0003uK!![/\u0003\tUs\u0017\u000e\u001e\u0005\bW\u000e\t\t\u00111\u0001X\u0003\rAH%M\u0001\u0011)\u0016k\u0005k\u0018#J%~\u001bVK\u0012$J1\u0002\n\u0001b\u001d5be\u0016$\u0015N]\u000b\u0002_B\u0011\u0001/^\u0007\u0002c*\u0011!o]\u0001\u0003MNT!\u0001\u001e \u0002\r!\fGm\\8q\u0013\t1\u0018O\u0001\u0003QCRD\u0017\u0001D:iCJ,G)\u001b:`I\u0015\fHC\u00014z\u0011\u001dYg!!AA\u0002=\f\u0011b\u001d5be\u0016$\u0015N\u001d\u0011\u0002\u0015\u0011\fG/\u00194m_^LE-\u0001\beCR\fg\r\\8x\u0013\u0012|F%Z9\u0015\u0005\u0019t\bbB6\n\u0003\u0003\u0005\raV\u0001\fI\u0006$\u0018M\u001a7po&#\u0007%\u0001\u0006tK\u001elWM\u001c;JIN,\"!!\u0002\u0011\t\u001d\f9aV\u0005\u0004\u0003\u0013i&!B!se\u0006L\u0018AD:fO6,g\u000e^%eg~#S-\u001d\u000b\u0004M\u0006=\u0001\u0002C6\r\u0003\u0003\u0005\r!!\u0002\u0002\u0017M,w-\\3oi&#7\u000fI\u0001\nS:$W\r\u001f)mC:,\"!a\u0006\u0011\t\u0005e\u0011qE\u0007\u0003\u00037QA!!\b\u0002 \u0005)Qn\u001c3fY*!\u0011\u0011EA\u0012\u0003\u0011\u0019WOY3\u000b\u0007\u0005\u0015B(\u0001\u0005nKR\fG-\u0019;b\u0013\u0011\tI#a\u0007\u0003\u0013%sG-\u001a=QY\u0006t\u0017!D5oI\u0016D\b\u000b\\1o?\u0012*\u0017\u000fF\u0002g\u0003_A\u0001b[\b\u0002\u0002\u0003\u0007\u0011qC\u0001\u000bS:$W\r\u001f)mC:\u0004\u0013!\u00048Ta\u0006tg.\u001b8h)J,W-\u0006\u0002\u00028A!\u0011\u0011HA \u001b\t\tYD\u0003\u0003\u0002>\u0005}\u0011AB2vE>LG-\u0003\u0003\u0002B\u0005m\"!\u0004(Ta\u0006tg.\u001b8h)J,W-A\to'B\fgN\\5oOR\u0013X-Z0%KF$2AZA$\u0011!Y'#!AA\u0002\u0005]\u0012A\u00048Ta\u0006tg.\u001b8h)J,W\rI\u0001\u0013a\u0016\u00148/[:uK\u00124E.\u0019;UC\ndW-\u0006\u0002\u0002PA)\u0011\u0011KA./6\u0011\u00111\u000b\u0006\u0005\u0003+\n9&A\u0004nkR\f'\r\\3\u000b\u0007\u0005eS,\u0001\u0006d_2dWm\u0019;j_:LA!!\u0018\u0002T\tQA*[:u\u0005V4g-\u001a:\u0002-A,'o]5ti\u0016$g\t\\1u)\u0006\u0014G.Z0%KF$2AZA2\u0011!YW#!AA\u0002\u0005=\u0013a\u00059feNL7\u000f^3e\r2\fG\u000fV1cY\u0016\u0004\u0013A\u00069feNL7\u000f^3e-&,wOR1diR\u000b'\r\\3\u00025A,'o]5ti\u0016$g+[3x\r\u0006\u001cG\u000fV1cY\u0016|F%Z9\u0015\u0007\u0019\fi\u0007\u0003\u0005l1\u0005\u0005\t\u0019AA(\u0003]\u0001XM]:jgR,GMV5fo\u001a\u000b7\r\u001e+bE2,\u0007%\u0001\tsk:t\u0017N\\4J]\u0012,\u0007\u0010T5tiV\u0011\u0011Q\u000f\t\u0007\u0003#\nY&a\u001e\u0011\u0007\u001d\fI(C\u0002\u0002|u\u0013A\u0001T8oO\u0006!\"/\u001e8oS:<\u0017J\u001c3fq2K7\u000f^0%KF$2AZAA\u0011!Y7$!AA\u0002\u0005U\u0014!\u0005:v]:LgnZ%oI\u0016DH*[:uA\u0005a!-^5mI\u000e{g\u000e^3yiV\u0011\u0011\u0011\u0012\t\u0005\u0003\u0017\u000b\t*\u0004\u0002\u0002\u000e*\u0019\u0011q\u0012(\u0002\u000fQ\u0014\u0018mY6fe&!\u00111SAG\u0005A\t\u0005\u000f]*uCR,8oQ8oi\u0016DH/\u0001\tck&dGmQ8oi\u0016DHo\u0018\u0013fcR\u0019a-!'\t\u0011-t\u0012\u0011!a\u0001\u0003\u0013\u000bQBY;jY\u0012\u001cuN\u001c;fqR\u0004\u0013!C3yiJ\f\u0017J\\5u)\u00051\u0017!\u00033p\u000bb,7-\u001e;f\u0003Eyg.\u0012=fGV$XMR5oSNDW\rZ\u0001\rg\u0016<W.\u001a8u\u0005VLG\u000e\u001a\u000b\u0004M\u0006%\u0006BBAVG\u0001\u0007q+A\u0003tK\u001eLE-A\rqe\u0016\u0004\u0018M]3Ck&dGM\u0012:p[\u001ac\u0017\r\u001e+bE2,G\u0003BAY\u0003\u001f\u0004b!a-\u0002>\u0006\rg\u0002BA[\u0003ss1AWA\\\u0013\u0005q\u0016bAA^;\u00069\u0001/Y2lC\u001e,\u0017\u0002BA`\u0003\u0003\u00141aU3r\u0015\r\tY,\u0018\t\u0005\u0003\u000b\fY-\u0004\u0002\u0002H*\u0019\u0011\u0011\u001a\u001d\u0002\u000f\t,\u0018\u000e\u001c3fe&!\u0011QZAd\u0005Aq%)^5mIN{WO]2f\u0013:4w\u000eC\u0004\u0002R\u0012\u0002\r!a5\u0002\u0013\u001147\t[8pg\u0016\u0014\bcA#\u0002V&\u0019\u0011q\u001b$\u0003\u0013\u001135\t[8pg\u0016\u0014\u0018\u0001\b9sKB\f'/\u001a\"vS2$gI]8n%\u0016,8/\u001a'bs>,Ho\u001d\u000b\u0005\u0003c\u000bi\u000eC\u0004\u0002R\u0016\u0002\r!a5\u0002\u000b\t,\u0018\u000e\u001c3\u0015\u000b\u0019\f\u0019/!:\t\r\u0005-f\u00051\u0001X\u0011\u001d\t9O\na\u0001\u0003S\f\u0001CY;jY\u0012\u001cv.\u001e:dK&sgm\\:\u0011\r\u0005M\u00161^Ab\u0013\u0011\ti/!1\u0003\u0011%#XM]1cY\u0016\fqBY;jY\u0012\u0014\u0015\r^2i\u0013:$W\r\u001f\u000b\u0007\u0003g\fY0!@\u0011\r\u0005E\u00131LA{!\u0011\tI\"a>\n\t\u0005e\u00181\u0004\u0002\f\u0013:$W\r_#oi&$\u0018\u0010C\u0004\u0002h\u001e\u0002\r!!;\t\r\u0005-v\u00051\u0001X\u0003}\u0019wN\\:ueV\u001cG\u000f\u00165f\u001d\u0016DHOQ1uG\"\u0014U/\u001b7e\u0013:4wn\u001d\u000b\u0007\u0005\u0007\u0011)Aa\u0004\u0011\r\u0005E\u00131LAb\u0011\u001d\u00119\u0001\u000ba\u0001\u0005\u0013\t1a]3h!\u0011\tIBa\u0003\n\t\t5\u00111\u0004\u0002\r\u001d\u0012\u000bG/Y*fO6,g\u000e\u001e\u0005\b\u0005#A\u0003\u0019\u0001B\n\u00039qW\r\u001f;CCR\u001c\u0007.\u00138eKb\u0004bA!\u0006\u0003 \u0005UXB\u0001B\f\u0015\u0011\u0011IBa\u0007\u0002\tU$\u0018\u000e\u001c\u0006\u0003\u0005;\tAA[1wC&!!\u0011\u0005B\f\u0005)\u0019u\u000e\u001c7fGRLwN\\\u0001\n_J$WM\u001d$v]\u000e,\"Aa\n\u0013\r\t%\"Q\u0006B\u001d\r\u0019\u0011Y#\u000b\u0001\u0003(\taAH]3gS:,W.\u001a8u}A!!q\u0006B\u001b\u001b\t\u0011\tD\u0003\u0003\u00034\tm\u0011\u0001\u00027b]\u001eLAAa\u000e\u00032\t1qJ\u00196fGR\u0004\u0002Ba\u000f\u0003B\t\u0015#1J\u0007\u0003\u0005{QAAa\u0010\u0003\u0018\u0005Aa-\u001e8di&|g.\u0003\u0003\u0003D\tu\"\u0001\u0003$v]\u000e$\u0018n\u001c8\u0011\t\u0005e!qI\u0005\u0005\u0005\u0013\nYB\u0001\u0007MCf|W\u000f^#oi&$\u0018\u0010E\u0003h\u0003\u000f\u0011i\u0005\u0005\u0003\u0003P\tUSB\u0001B)\u0015\r\u0011\u0019FT\u0001\u0004gFd\u0017\u0002\u0002B,\u0005#\u0012aaQ8mk6t\u0017AE5oi\u0016\u0014h.\u00197Ck&dG-\u00138eKb$\"B!\u0018\u0003j\t-$q\u000eB:!\u0019\u0011)Ba\u0018\u0003d%!!\u0011\rB\f\u0005\u0011a\u0015n\u001d;\u0011\t\u0005e!QM\u0005\u0005\u0005O\nYBA\u0006O\t\u0006$\u0018\rT1z_V$\bb\u0002B\u0004U\u0001\u0007!\u0011\u0002\u0005\b\u0005[R\u0003\u0019AA{\u0003\u0015Ig\u000eZ3y\u0011\u001d\u0011\tH\u000ba\u0001\u0003o\n\u0001\u0002]1sK:$\u0018\n\u001a\u0005\b\u0005kR\u0003\u0019\u0001B<\u0003\u0019\u0001\u0018M]3oiB1!q\nB=\u0005{JAAa\u001f\u0003R\t9A)\u0019;bg\u0016$\b\u0003\u0002B(\u0005\u007fJAA!!\u0003R\t\u0019!k\\<\u0002\u001fA\u0014x\u000e^3di\u0016$G%\u001b8g_N$BAa\"\u0003\u000eB\u0019QI!#\n\u0007\t-eIA\u0007Ck&dGMS8c\u0013:4wn\u001d\u0005\bW.\n\t\u00111\u0001T\u0003}\u0001(o\u001c;fGR,G\r\n2vS2$G*Y=pkR<\u0016\u000e\u001e5Va\u0012\fG/\u001a\u000b\u0005\u0005'\u0013I\nE\u0002F\u0005+K1Aa&G\u0005U\u0011U/\u001b7e\u0019\u0006Lx.\u001e;XSRDW\u000b\u001d3bi\u0016Dqa\u001b\u0017\u0002\u0002\u0003\u00071+\u0001\tqe>$Xm\u0019;fI\u0012\u001awN\u001c4jOR!!q\u0014BV!\u0011\u0011\tKa*\u000e\u0005\t\r&b\u0001BSy\u000511m\\7n_:LAA!+\u0003$\nY1*\u001f7j]\u000e{gNZ5h\u0011\u001dYW&!AA\u0002M\u000bA\u0002\u001d:pi\u0016\u001cG/\u001a3%gN$BA!-\u00038B!!q\nBZ\u0013\u0011\u0011)L!\u0015\u0003\u0019M\u0003\u0018M]6TKN\u001c\u0018n\u001c8\t\u000f-t\u0013\u0011!a\u0001'\u0006i\u0002O]8uK\u000e$X\r\u001a\u0013tCZ,\u0017I\u001c3Va\u0012\fG/\u001a'bs>,H\u000f\u0006\u0003\u0003>\n%G\u0003\u0003B2\u0005\u007f\u0013\u0019M!2\t\u000f\t\u0005w\u00061\u0001\u0003x\u00059A-\u0019;bg\u0016$\bb\u0002B\u0004_\u0001\u0007!\u0011\u0002\u0005\b\u0005\u000f|\u0003\u0019\u0001B#\u0003\u0019a\u0017-_8vi\"91nLA\u0001\u0002\u0004\u0019\u0016A\u00079s_R,7\r^3eI=tG*Y=pkR4\u0015N\\5tQ\u0016$G\u0003\u0002Bh\u0005+$2A\u001aBi\u0011\u001d\u0011\u0019\u000e\ra\u0001\u0003o\n\u0001\u0002\\1z_V$\u0018\n\u001a\u0005\bWB\n\t\u00111\u0001T\u00031!eiU7beR\u0014U/\u001b7e!\t!&gE\u00023\u0005;\u00042a\u001aBp\u0013\r\u0011\t/\u0018\u0002\u0007\u0003:L(+\u001a4\u0015\u0005\te\u0017\u0001B7bS:$2A\u001aBu\u0011\u001d\u0011Y\u000f\u000ea\u0001\u0003\u000b\tA!\u0019:hg\u0002")
public class DFSmartBuild
extends DFBuildJob
implements Logging {
    private String TEMP_DIR_SUFFIX;
    private Path shareDir;
    private String dataflowId;
    private String[] segmentIds;
    private IndexPlan indexPlan;
    private NSpanningTree nSpanningTree;
    private ListBuffer<String> persistedFlatTable;
    private ListBuffer<String> persistedViewFactTable;
    private ListBuffer<Object> runningIndexList;
    private AppStatusContext buildContext;
    private transient Logger org$apache$spark$internal$Logging$$log_;

    public static void main(String[] stringArray) {
        DFSmartBuild$.MODULE$.main(stringArray);
    }

    public String logName() {
        return Logging.logName$((Logging)this);
    }

    public Logger log() {
        return Logging.log$((Logging)this);
    }

    public void logInfo(Function0<String> msg) {
        Logging.logInfo$((Logging)this, msg);
    }

    public void logDebug(Function0<String> msg) {
        Logging.logDebug$((Logging)this, msg);
    }

    public void logTrace(Function0<String> msg) {
        Logging.logTrace$((Logging)this, msg);
    }

    public void logWarning(Function0<String> msg) {
        Logging.logWarning$((Logging)this, msg);
    }

    public void logError(Function0<String> msg) {
        Logging.logError$((Logging)this, msg);
    }

    public void logInfo(Function0<String> msg, Throwable throwable) {
        Logging.logInfo$((Logging)this, msg, (Throwable)throwable);
    }

    public void logDebug(Function0<String> msg, Throwable throwable) {
        Logging.logDebug$((Logging)this, msg, (Throwable)throwable);
    }

    public void logTrace(Function0<String> msg, Throwable throwable) {
        Logging.logTrace$((Logging)this, msg, (Throwable)throwable);
    }

    public void logWarning(Function0<String> msg, Throwable throwable) {
        Logging.logWarning$((Logging)this, msg, (Throwable)throwable);
    }

    public void logError(Function0<String> msg, Throwable throwable) {
        Logging.logError$((Logging)this, msg, (Throwable)throwable);
    }

    public boolean isTraceEnabled() {
        return Logging.isTraceEnabled$((Logging)this);
    }

    public void initializeLogIfNecessary(boolean isInterpreter) {
        Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter);
    }

    public boolean initializeLogIfNecessary(boolean isInterpreter, boolean silent) {
        return Logging.initializeLogIfNecessary$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public boolean initializeLogIfNecessary$default$2() {
        return Logging.initializeLogIfNecessary$default$2$((Logging)this);
    }

    public void initializeForcefully(boolean isInterpreter, boolean silent) {
        Logging.initializeForcefully$((Logging)this, (boolean)isInterpreter, (boolean)silent);
    }

    public Logger org$apache$spark$internal$Logging$$log_() {
        return this.org$apache$spark$internal$Logging$$log_;
    }

    public void org$apache$spark$internal$Logging$$log__$eq(Logger x$1) {
        this.org$apache$spark$internal$Logging$$log_ = x$1;
    }

    public /* synthetic */ BuildJobInfos protected$infos(DFSmartBuild x$1) {
        return x$1.infos;
    }

    public /* synthetic */ BuildLayoutWithUpdate protected$buildLayoutWithUpdate(DFSmartBuild x$1) {
        return x$1.buildLayoutWithUpdate;
    }

    public /* synthetic */ KylinConfig protected$config(DFSmartBuild x$1) {
        return x$1.config;
    }

    public /* synthetic */ SparkSession protected$ss(DFSmartBuild x$1) {
        return x$1.ss;
    }

    public /* synthetic */ NDataLayout protected$saveAndUpdateLayout(DFSmartBuild x$1, Dataset dataset, NDataSegment seg, LayoutEntity layout) {
        return x$1.saveAndUpdateLayout((Dataset<Row>)dataset, seg, layout);
    }

    public /* synthetic */ void protected$onLayoutFinished(DFSmartBuild x$1, long layoutId) {
        x$1.onLayoutFinished(layoutId);
    }

    public String TEMP_DIR_SUFFIX() {
        return this.TEMP_DIR_SUFFIX;
    }

    public void TEMP_DIR_SUFFIX_$eq(String x$1) {
        this.TEMP_DIR_SUFFIX = x$1;
    }

    public Path shareDir() {
        return this.shareDir;
    }

    public void shareDir_$eq(Path x$1) {
        this.shareDir = x$1;
    }

    public String dataflowId() {
        return this.dataflowId;
    }

    public void dataflowId_$eq(String x$1) {
        this.dataflowId = x$1;
    }

    public String[] segmentIds() {
        return this.segmentIds;
    }

    public void segmentIds_$eq(String[] x$1) {
        this.segmentIds = x$1;
    }

    public IndexPlan indexPlan() {
        return this.indexPlan;
    }

    public void indexPlan_$eq(IndexPlan x$1) {
        this.indexPlan = x$1;
    }

    public NSpanningTree nSpanningTree() {
        return this.nSpanningTree;
    }

    public void nSpanningTree_$eq(NSpanningTree x$1) {
        this.nSpanningTree = x$1;
    }

    private ListBuffer<String> persistedFlatTable() {
        return this.persistedFlatTable;
    }

    private void persistedFlatTable_$eq(ListBuffer<String> x$1) {
        this.persistedFlatTable = x$1;
    }

    private ListBuffer<String> persistedViewFactTable() {
        return this.persistedViewFactTable;
    }

    private void persistedViewFactTable_$eq(ListBuffer<String> x$1) {
        this.persistedViewFactTable = x$1;
    }

    private ListBuffer<Object> runningIndexList() {
        return this.runningIndexList;
    }

    private void runningIndexList_$eq(ListBuffer<Object> x$1) {
        this.runningIndexList = x$1;
    }

    private AppStatusContext buildContext() {
        return this.buildContext;
    }

    private void buildContext_$eq(AppStatusContext x$1) {
        this.buildContext = x$1;
    }

    @Override
    public void extraInit() {
        this.dataflowId_$eq(this.getParam("dataflowId"));
        java.util.Set layoutIds = NSparkCubingUtil.str2Longs((String)this.getParam("layoutIds"));
        this.segmentIds_$eq(StringUtils.split((String)this.getParam("segmentIds"), (String)","));
        this.shareDir_$eq(this.config.getJobTmpShareDir(this.project, this.jobId));
        this.buildLayoutWithUpdate = new BuildLayoutWithUpdate();
        this.dfMgr = NDataflowManager.getInstance((KylinConfig)this.config, (String)this.project);
        this.indexPlan_$eq(this.dfMgr.getDataflow(this.dataflowId()).getIndexPlan());
        scala.collection.mutable.Set cuboids = ((scala.collection.mutable.Set)((TraversableLike)JavaConverters$.MODULE$.asScalaSetConverter(NSparkCubingUtil.toLayouts((IndexPlan)this.indexPlan(), (java.util.Set)layoutIds)).asScala()).filter((Function1 & Serializable & scala.Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)DFSmartBuild.$anonfun$extraInit$1(x$1)))).seq();
        this.nSpanningTree_$eq(NSpanningTreeFactory.fromLayouts((Collection)((Collection)JavaConverters$.MODULE$.mutableSetAsJavaSetConverter(cuboids).asJava()), (String)this.dataflowId()));
        this.buildContext_$eq(new AppStatusContext(this.ss.sparkContext(), this.config));
        this.buildContext().appStatusTracker().startMonitorBuildResourceState();
    }

    @Override
    public void doExecute() {
        new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.segmentIds())).foreach((Function1 & Serializable & scala.Serializable)x$2 -> {
            this.segmentBuild(x$2);
            return BoxedUnit.UNIT;
        });
        this.onExecuteFinished();
    }

    @Override
    public void onExecuteFinished() {
        Map segmentSourceSize = ResourceDetectUtils$.MODULE$.getSegmentSourceSize(this.shareDir());
        this.updateSegmentSourceBytesSize(this.dataflowId(), segmentSourceSize);
        this.tailingCleanups((java.util.Set)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)new ArrayOps.ofRef(Predef$.MODULE$.refArrayOps((Object[])this.segmentIds())).toSet()).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.persistedFlatTable()).asJava(), (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter(this.persistedViewFactTable()).asJava());
        this.buildContext().stop();
    }

    private void segmentBuild(String segId) {
        NDataSegment seg = this.getSegment(segId);
        this.buildSnapshot();
        DFChooser dfChooser = new DFChooser(this.nSpanningTree(), seg, this.jobId, this.ss, this.config, true);
        dfChooser.decideSources();
        this.infos.clearCuboidsNumPerLayer(segId);
        Seq buildSourceInfos = (Seq)this.prepareBuildFromReuseLayouts(dfChooser).$plus$plus(this.prepareBuildFromFlatTable(dfChooser), Seq$.MODULE$.canBuildFrom());
        this.build(segId, (Iterable<NBuildSourceInfo>)buildSourceInfos);
    }

    public Seq<NBuildSourceInfo> prepareBuildFromFlatTable(DFChooser dfChooser) {
        NBuildSourceInfo buildFromFlatTable = dfChooser.flatTableSource();
        String segId = dfChooser.seg().getId();
        NBuildSourceInfo nBuildSourceInfo = buildFromFlatTable;
        String path = dfChooser.persistFlatTableIfNecessary();
        if (!path.isEmpty()) {
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> "FlatTable persisted, compute column size");
            this.persistedFlatTable().$plus$eq((Object)path);
            long rowCount = buildFromFlatTable.getFlattableDS().count();
            Map columnBytes = (Map)JavaConverters$.MODULE$.mapAsJavaMapConverter(dfChooser.computeColumnBytes().mapValues((Function1 & Serializable & scala.Serializable)x$3 -> DFSmartBuild.$anonfun$prepareBuildFromFlatTable$2(BoxesRunTime.unboxToLong((Object)x$3)))).asJava();
            this.updateColumnBytesInseg(this.dataflowId(), columnBytes, segId, rowCount);
        }
        Object object = !StringUtils.isBlank((CharSequence)buildFromFlatTable.getViewFactTablePath()) ? this.persistedViewFactTable().$plus$eq((Object)buildFromFlatTable.getViewFactTablePath()) : BoxedUnit.UNIT;
        BoxedUnit boxedUnit = !this.seg2Count.containsKey(segId) ? this.seg2Count.put(segId, Predef$.MODULE$.long2Long(buildFromFlatTable.getParentDS().count())) : BoxedUnit.UNIT;
        return (Seq)new .colon.colon((Object)buildFromFlatTable, (List)Nil$.MODULE$);
    }

    public Seq<NBuildSourceInfo> prepareBuildFromReuseLayouts(DFChooser dfChooser) {
        Object object;
        Map<Long, NBuildSourceInfo> buildFromLayouts = dfChooser.reuseSources();
        String segId = dfChooser.seg().getId();
        if (!buildFromLayouts.isEmpty()) {
            Ordering<NBuildSourceInfo> countOrdering = new Ordering<NBuildSourceInfo>(null){

                public Some tryCompare(Object x, Object y) {
                    return Ordering.tryCompare$((Ordering)this, (Object)x, (Object)y);
                }

                public boolean lteq(Object x, Object y) {
                    return Ordering.lteq$((Ordering)this, (Object)x, (Object)y);
                }

                public boolean gteq(Object x, Object y) {
                    return Ordering.gteq$((Ordering)this, (Object)x, (Object)y);
                }

                public boolean lt(Object x, Object y) {
                    return Ordering.lt$((Ordering)this, (Object)x, (Object)y);
                }

                public boolean gt(Object x, Object y) {
                    return Ordering.gt$((Ordering)this, (Object)x, (Object)y);
                }

                public boolean equiv(Object x, Object y) {
                    return Ordering.equiv$((Ordering)this, (Object)x, (Object)y);
                }

                public Object max(Object x, Object y) {
                    return Ordering.max$((Ordering)this, (Object)x, (Object)y);
                }

                public Object min(Object x, Object y) {
                    return Ordering.min$((Ordering)this, (Object)x, (Object)y);
                }

                public Ordering<NBuildSourceInfo> reverse() {
                    return Ordering.reverse$((Ordering)this);
                }

                public <U> Ordering<U> on(Function1<U, NBuildSourceInfo> f) {
                    return Ordering.on$((Ordering)this, f);
                }

                public Ordering.Ops mkOrderingOps(Object lhs) {
                    return Ordering.mkOrderingOps$((Ordering)this, (Object)lhs);
                }

                public int compare(NBuildSourceInfo x, NBuildSourceInfo y) {
                    return (int)(x.getCount() - y.getCount());
                }
                {
                    PartialOrdering.$init$((PartialOrdering)this);
                    Ordering.$init$((Ordering)this);
                }
            };
            NBuildSourceInfo min = (NBuildSourceInfo)((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(buildFromLayouts.values()).asScala()).min((Ordering)countOrdering);
            long count = SanityChecker$.MODULE$.getCount(min.getParentDS(), this.indexPlan().getLayoutEntity(Predef$.MODULE$.long2Long(min.getLayoutId())));
            object = this.seg2Count.put(segId, Predef$.MODULE$.long2Long(count));
        } else {
            object = BoxedUnit.UNIT;
        }
        return ((TraversableOnce)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(buildFromLayouts.values()).asScala()).toSeq();
    }

    public void build(String segId, Iterable<NBuildSourceInfo> buildSourceInfos) {
        ListBuffer<IndexEntity> rootBatch = this.buildBatchIndex(buildSourceInfos, segId);
        this.runningIndexList().$plus$plus$eq((TraversableOnce)rootBatch.map((Function1 & Serializable & scala.Serializable)index -> BoxesRunTime.boxToLong((long)index.getId()), ListBuffer$.MODULE$.canBuildFrom()));
        IndexTaskContext itc = new IndexTaskContext(this.config, this.getSegment(segId), this.project, this.buildLayoutWithUpdate, this.runningIndexList());
        IndexTaskScheduler its = new IndexTaskScheduler(itc);
        its.startUpdateBuildProcess();
        IntRef indexCnt = IntRef.create((int)rootBatch.size());
        int allIndexNum = this.nSpanningTree().getAllIndexEntities().size();
        while (!this.runningIndexList().isEmpty() || indexCnt.elem != allIndexNum) {
            Enumeration.Value currState;
            this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(32).append("Curr index cnt ").append(indexCnt$1.elem).append(" , all index num ").append(allIndexNum).toString());
            Enumeration.Value value = currState = this.buildContext().appStatusTracker().currentResourceState();
            Enumeration.Value value2 = ResourceState$.MODULE$.Idle();
            if (!(value != null ? !value.equals(value2) : value2 != null)) {
                Collection nextBatch = this.nSpanningTree().decideTheNextBatch(this.getSegment(segId));
                ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nextBatch).asScala()).foreach((Function1 & Serializable & scala.Serializable)index -> itc.runningIndex().$plus$eq((Object)BoxesRunTime.boxToLong((long)index.getId())));
                this.logInfo((Function0<String>)(Function0 & Serializable & scala.Serializable)() -> new StringBuilder(12).append("Next batch: ").append(Arrays.deepToString((Object[])((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nextBatch).asScala()).map((Function1 & Serializable & scala.Serializable)x$4 -> Long.toString(x$4.getId()), Iterable$.MODULE$.canBuildFrom())).toArray(ClassTag$.MODULE$.Object()))).toString());
                ListBuffer<NBuildSourceInfo> nextBatchInfos = this.constructTheNextBatchBuildInfos(this.getSegment(segId), nextBatch);
                indexCnt.elem += this.buildBatchIndex((Iterable<NBuildSourceInfo>)nextBatchInfos, segId).size();
            }
            Thread.sleep(1000L);
        }
        its.stopUpdateBuildProcess();
    }

    private ListBuffer<IndexEntity> buildBatchIndex(Iterable<NBuildSourceInfo> buildSourceInfos, String segId) {
        NDataSegment seg = this.getSegment(segId);
        IntRef cuboidsNumInBatch = IntRef.create((int)0);
        ListBuffer allIndexesInCurrentBatch = new ListBuffer();
        buildSourceInfos.foreach((Function1 & Serializable & scala.Serializable)info -> {
            DFSmartBuild.$anonfun$buildBatchIndex$1(this, seg, cuboidsNumInBatch, allIndexesInCurrentBatch, info);
            return BoxedUnit.UNIT;
        });
        this.infos.recordCuboidsNumPerLayer(segId, cuboidsNumInBatch.elem);
        return allIndexesInCurrentBatch;
    }

    /*
     * WARNING - void declaration
     */
    public ListBuffer<NBuildSourceInfo> constructTheNextBatchBuildInfos(NDataSegment seg, Collection<IndexEntity> nextBatchIndex) {
        void var3_3;
        ListBuffer childrenBuildSourceInfos = new ListBuffer();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(nextBatchIndex).asScala()).foreach((Function1 & Serializable & scala.Serializable)index -> {
            NBuildSourceInfo theRootLevelBuildInfos = new NBuildSourceInfo();
            theRootLevelBuildInfos.setSparkSession(this.protected$ss(this));
            IndexEntity parentIndex = this.nSpanningTree().getParentByIndexEntity(index);
            LayoutEntity layout = (LayoutEntity)new ArrayList(this.nSpanningTree().getLayouts(parentIndex)).get(0);
            theRootLevelBuildInfos.setLayoutId(layout.getId());
            theRootLevelBuildInfos.setParentStorageDF((Dataset<Row>)StorageStoreUtils$.MODULE$.toDF(seg, layout, this.protected$ss(this)));
            theRootLevelBuildInfos.setToBuildCuboids(Lists.newArrayList((Object[])new IndexEntity[]{index}));
            return childrenBuildSourceInfos.$plus$eq((Object)theRootLevelBuildInfos);
        });
        return var3_3;
    }

    private Function<LayoutEntity, Column[]> orderFunc() {
        return new Function<LayoutEntity, Column[]>(null){

            public <V> Function<V, Column[]> compose(Function<? super V, ? extends LayoutEntity> x$1) {
                return Function.super.compose(x$1);
            }

            public <V> Function<LayoutEntity, V> andThen(Function<? super Column[], ? extends V> x$1) {
                return Function.super.andThen(x$1);
            }

            public Column[] apply(LayoutEntity layout) {
                return NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{layout.getOrderedDimensions().keySet(), layout.getOrderedMeasures().keySet()});
            }
        };
    }

    public java.util.List<NDataLayout> org$apache$kylin$engine$spark$smarter$DFSmartBuild$$internalBuildIndex(NDataSegment seg, IndexEntity index, long parentId, Dataset<Row> parent) {
        Dataset dataset;
        String parentName = parentId == DFChooser$.MODULE$.FLAT_TABLE_FLAG() ? "flat table" : String.valueOf(parentId);
        this.log().info("Build index:{}, in segment:{}", (Object)BoxesRunTime.boxToLong((long)index.getId()), (Object)seg.getId());
        java.util.Set dimIndexes = index.getEffectiveDimCols().keySet();
        if (IndexEntity.isTableIndex((long)index.getId())) {
            Predef$.MODULE$.assert(index.getMeasures().isEmpty());
            dataset = parent.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{dimIndexes})));
        } else {
            dataset = CuboidAggregator$.MODULE$.agg(parent, dimIndexes, (Map<Integer, NDataModel.Measure>)index.getEffectiveMeasures(), seg, this.nSpanningTree());
        }
        Dataset afterPrj = dataset;
        ListBuffer layouts = new ListBuffer();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(this.nSpanningTree().getLayouts(index)).asScala()).foreach((Function1 & Serializable & scala.Serializable)layout -> {
            DFSmartBuild.$anonfun$internalBuildIndex$1(this, index, parentName, afterPrj, layouts, seg, layout);
            return BoxedUnit.UNIT;
        });
        this.ss.sparkContext().setJobDescription(null);
        this.log().info("Finished Build index :{}, in segment:{}", (Object)BoxesRunTime.boxToLong((long)index.getId()), (Object)seg.getId());
        return (java.util.List)JavaConverters$.MODULE$.bufferAsJavaListConverter((Buffer)layouts).asJava();
    }

    public static final /* synthetic */ boolean $anonfun$extraInit$1(LayoutEntity x$1) {
        return x$1 != null;
    }

    public static final /* synthetic */ Object $anonfun$prepareBuildFromFlatTable$2(long x$3) {
        return BoxesRunTime.boxToLong((long)x$3);
    }

    public static final /* synthetic */ void $anonfun$buildBatchIndex$1(DFSmartBuild $this, NDataSegment seg$1, IntRef cuboidsNumInBatch$1, ListBuffer allIndexesInCurrentBatch$1, NBuildSourceInfo info) {
        Collection<IndexEntity> toBuildCuboids = info.getToBuildCuboids();
        HashSet children = Sets.newHashSet((java.lang.Iterable)((java.lang.Iterable)JavaConverters$.MODULE$.setAsJavaSetConverter((Set)((TraversableOnce)((TraversableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(toBuildCuboids).asScala()).map((Function1 & Serializable & scala.Serializable)x$5 -> BoxesRunTime.boxToLong((long)x$5.getId()), Iterable$.MODULE$.canBuildFrom())).toSet()).asJava()));
        $this.protected$infos($this).recordParent2Children(seg$1.getLayout(info.getLayoutId()), children);
        cuboidsNumInBatch$1.elem += toBuildCuboids.size();
        Predef$.MODULE$.assert(!toBuildCuboids.isEmpty(), (Function0 & Serializable & scala.Serializable)() -> "To be built cuboids is empty.");
        Dataset<Row> parentDS = info.getParentDS();
        ((IterableLike)JavaConverters$.MODULE$.collectionAsScalaIterableConverter(toBuildCuboids).asScala()).foreach((Function1 & Serializable & scala.Serializable)index -> {
            Predef$.MODULE$.assert(parentDS != null, (Function0 & Serializable & scala.Serializable)() -> "Parent dataset is null when building.");
            $this.protected$buildLayoutWithUpdate($this).submit(new BuildLayoutWithUpdate.JobEntity($this, (IndexEntity)index, seg$1, info, (Dataset)parentDS){
                private final /* synthetic */ DFSmartBuild $outer;
                private final IndexEntity index$1;
                private final NDataSegment seg$1;
                private final NBuildSourceInfo info$1;
                private final Dataset parentDS$1;

                public long getIndexId() {
                    return this.index$1.getId();
                }

                public String getName() {
                    return new StringBuilder(12).append("build-index-").append(this.index$1.getId()).toString();
                }

                public java.util.List<NDataLayout> build() {
                    return this.$outer.org$apache$kylin$engine$spark$smarter$DFSmartBuild$$internalBuildIndex(this.seg$1, this.index$1, this.info$1.getLayoutId(), (Dataset<Row>)this.parentDS$1);
                }
                {
                    if ($outer == null) {
                        throw null;
                    }
                    this.$outer = $outer;
                    this.index$1 = index$1;
                    this.seg$1 = seg$1;
                    this.info$1 = info$1;
                    this.parentDS$1 = parentDS$1;
                }
            }, $this.protected$config($this));
            return allIndexesInCurrentBatch$1.$plus$eq(index);
        });
    }

    public static final /* synthetic */ void $anonfun$internalBuildIndex$1(DFSmartBuild $this, IndexEntity index$2, String parentName$1, Dataset afterPrj$1, ListBuffer layouts$1, NDataSegment seg$3, LayoutEntity layout) {
        $this.log().info("Build layout:{}, in index:{}", (Object)BoxesRunTime.boxToLong((long)layout.getId()), (Object)BoxesRunTime.boxToLong((long)index$2.getId()));
        $this.protected$ss($this).sparkContext().setJobDescription(new StringBuilder(19).append("build ").append(layout.getId()).append(" from parent ").append(parentName$1).toString());
        ImmutableSet rowKeys = layout.getOrderedDimensions().keySet();
        Dataset afterSort = afterPrj$1.select((Seq)Predef$.MODULE$.wrapRefArray((Object[])$this.orderFunc().apply(layout))).sortWithinPartitions((Seq)Predef$.MODULE$.wrapRefArray((Object[])NSparkCubingUtil.getColumns((java.util.Set[])new java.util.Set[]{rowKeys})));
        layouts$1.$plus$eq((Object)$this.protected$saveAndUpdateLayout($this, afterSort, seg$3, layout));
        $this.protected$onLayoutFinished($this, layout.getId());
    }

    public DFSmartBuild() {
        Logging.$init$((Logging)this);
        this.TEMP_DIR_SUFFIX = "_temp";
        this.persistedFlatTable = new ListBuffer();
        this.persistedViewFactTable = new ListBuffer();
        this.runningIndexList = new ListBuffer();
    }
}

