/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.adapter.java;

import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.calcite.DataContext;
import org.apache.calcite.adapter.enumerable.EnumUtils;
import org.apache.calcite.adapter.java.AbstractQueryableTable;
import org.apache.calcite.adapter.java.JavaTypeFactory;
import org.apache.calcite.linq4j.Enumerable;
import org.apache.calcite.linq4j.Enumerator;
import org.apache.calcite.linq4j.Linq4j;
import org.apache.calcite.linq4j.QueryProvider;
import org.apache.calcite.linq4j.Queryable;
import org.apache.calcite.linq4j.function.Function1;
import org.apache.calcite.linq4j.tree.Expression;
import org.apache.calcite.linq4j.tree.Expressions;
import org.apache.calcite.linq4j.tree.Primitive;
import org.apache.calcite.rel.RelReferentialConstraint;
import org.apache.calcite.rel.type.RelDataType;
import org.apache.calcite.rel.type.RelDataTypeFactory;
import org.apache.calcite.schema.Function;
import org.apache.calcite.schema.ScannableTable;
import org.apache.calcite.schema.Schema;
import org.apache.calcite.schema.SchemaFactory;
import org.apache.calcite.schema.SchemaPlus;
import org.apache.calcite.schema.Schemas;
import org.apache.calcite.schema.Statistic;
import org.apache.calcite.schema.Statistics;
import org.apache.calcite.schema.Table;
import org.apache.calcite.schema.TableMacro;
import org.apache.calcite.schema.TranslatableTable;
import org.apache.calcite.schema.impl.AbstractSchema;
import org.apache.calcite.schema.impl.AbstractTableQueryable;
import org.apache.calcite.schema.impl.ReflectiveFunctionBase;
import org.apache.calcite.util.BuiltInMethod;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableMultimap;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.checkerframework.checker.nullness.qual.MonotonicNonNull;
import org.checkerframework.checker.nullness.qual.Nullable;

public class ReflectiveSchema
extends AbstractSchema {
    private final Class clazz;
    private final Object target;
    private @MonotonicNonNull Map<String, Table> tableMap;
    private @MonotonicNonNull Multimap<String, Function> functionMap;

    public ReflectiveSchema(Object target) {
        this.clazz = target.getClass();
        this.target = target;
    }

    public String toString() {
        return "ReflectiveSchema(target=" + this.target + ")";
    }

    public Object getTarget() {
        return this.target;
    }

    @Override
    protected Map<String, Table> getTableMap() {
        if (this.tableMap == null) {
            this.tableMap = this.createTableMap();
        }
        return this.tableMap;
    }

    private Map<String, Table> createTableMap() {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (Field field : this.clazz.getFields()) {
            String fieldName = field.getName();
            Table table = this.fieldRelation(field);
            if (table == null) continue;
            builder.put((Object)fieldName, (Object)table);
        }
        ImmutableMap tableMap = builder.build();
        for (Field field : this.clazz.getFields()) {
            RelReferentialConstraint rc;
            if (!RelReferentialConstraint.class.isAssignableFrom(field.getType())) continue;
            try {
                rc = (RelReferentialConstraint)field.get(this.target);
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException("Error while accessing field " + field, e);
            }
            Objects.requireNonNull(rc, () -> "field must not be null: " + field);
            FieldTable table = (FieldTable)tableMap.get(Util.last(rc.getSourceQualifiedName()));
            assert (table != null);
            ImmutableList referentialConstraints = table.getStatistic().getReferentialConstraints();
            if (referentialConstraints == null) {
                referentialConstraints = ImmutableList.of();
            }
            table.statistic = Statistics.of((List<RelReferentialConstraint>)ImmutableList.copyOf((Iterable)Iterables.concat((Iterable)referentialConstraints, Collections.singleton(rc))));
        }
        return tableMap;
    }

    @Override
    protected Multimap<String, Function> getFunctionMultimap() {
        if (this.functionMap == null) {
            this.functionMap = this.createFunctionMap();
        }
        return this.functionMap;
    }

    private Multimap<String, Function> createFunctionMap() {
        ImmutableMultimap.Builder builder = ImmutableMultimap.builder();
        for (Method method : this.clazz.getMethods()) {
            String methodName = method.getName();
            if (method.getDeclaringClass() == Object.class || methodName.equals("toString") || !TranslatableTable.class.isAssignableFrom(method.getReturnType())) continue;
            MethodTableMacro tableMacro = new MethodTableMacro(this, method);
            builder.put((Object)methodName, (Object)tableMacro);
        }
        return builder.build();
    }

    Expression getTargetExpression(@Nullable SchemaPlus parentSchema, String name) {
        return EnumUtils.convert((Expression)Expressions.call((Expression)Schemas.unwrap(this.getExpression(parentSchema, name), ReflectiveSchema.class), (Method)BuiltInMethod.REFLECTIVE_SCHEMA_GET_TARGET.method, (Expression[])new Expression[0]), this.target.getClass());
    }

    private <T> @Nullable Table fieldRelation(Field field) {
        Object o;
        Type elementType = ReflectiveSchema.getElementType(field.getType());
        if (elementType == null) {
            return null;
        }
        try {
            o = field.get(this.target);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Error while accessing field " + field, e);
        }
        Objects.requireNonNull(o, () -> "field " + field + " is null for " + this.target);
        Enumerable enumerable = ReflectiveSchema.toEnumerable(o);
        return new FieldTable(field, elementType, enumerable);
    }

    private static @Nullable Type getElementType(Class clazz) {
        if (clazz.isArray()) {
            return clazz.getComponentType();
        }
        if (Iterable.class.isAssignableFrom(clazz)) {
            return Object.class;
        }
        return null;
    }

    private static Enumerable toEnumerable(Object o) {
        if (o.getClass().isArray()) {
            if (o instanceof Object[]) {
                return Linq4j.asEnumerable((Object[])((Object[])o));
            }
            return Linq4j.asEnumerable((List)Primitive.asList((Object)o));
        }
        if (o instanceof Iterable) {
            return Linq4j.asEnumerable((Iterable)((Iterable)o));
        }
        throw new RuntimeException("Cannot convert " + o.getClass() + " into a Enumerable");
    }

    private static class FieldSelector
    implements Function1<Object, Object[]> {
        private final Field[] fields;

        FieldSelector(Class elementType) {
            this.fields = elementType.getFields();
        }

        public @Nullable Object[] apply(Object o) {
            try {
                @Nullable Object[] objects = new Object[this.fields.length];
                for (int i = 0; i < this.fields.length; ++i) {
                    objects[i] = this.fields[i].get(o);
                }
                return objects;
            }
            catch (IllegalAccessException e) {
                throw new RuntimeException(e);
            }
        }
    }

    private static class FieldTable<T>
    extends ReflectiveTable {
        private final Field field;
        private Statistic statistic;

        FieldTable(Field field, Type elementType, Enumerable<T> enumerable) {
            this(field, elementType, enumerable, Statistics.UNKNOWN);
        }

        FieldTable(Field field, Type elementType, Enumerable<T> enumerable, Statistic statistic) {
            super(elementType, enumerable);
            this.field = field;
            this.statistic = statistic;
        }

        public String toString() {
            return "Relation {field=" + this.field.getName() + "}";
        }

        @Override
        public Statistic getStatistic() {
            return this.statistic;
        }

        @Override
        public Expression getExpression(SchemaPlus schema, String tableName, Class clazz) {
            ReflectiveSchema reflectiveSchema = Objects.requireNonNull(schema.unwrap(ReflectiveSchema.class), () -> "schema.unwrap(ReflectiveSchema.class) for " + schema);
            return Expressions.field((Expression)reflectiveSchema.getTargetExpression(schema.getParentSchema(), schema.getName()), (Field)this.field);
        }
    }

    private static class MethodTableMacro
    extends ReflectiveFunctionBase
    implements TableMacro {
        private final ReflectiveSchema schema;

        MethodTableMacro(ReflectiveSchema schema, Method method) {
            super(method);
            this.schema = schema;
            assert (TranslatableTable.class.isAssignableFrom(method.getReturnType())) : "Method should return TranslatableTable so the macro can be expanded";
        }

        public String toString() {
            return "Member {method=" + this.method + "}";
        }

        @Override
        public TranslatableTable apply(List<? extends @Nullable Object> arguments) {
            try {
                Object o = Objects.requireNonNull(this.method.invoke(this.schema.getTarget(), arguments.toArray()), () -> "method " + this.method + " returned null for arguments " + arguments);
                return (TranslatableTable)o;
            }
            catch (IllegalAccessException | InvocationTargetException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static class Factory
    implements SchemaFactory {
        @Override
        public Schema create(SchemaPlus parentSchema, String name, Map<String, Object> operand) {
            Object target;
            Class<?> clazz;
            Object className = operand.get("class");
            if (className != null) {
                try {
                    clazz = Class.forName((String)className);
                }
                catch (ClassNotFoundException e) {
                    throw new RuntimeException("Error loading class " + className, e);
                }
            } else {
                throw new RuntimeException("Operand 'class' is required");
            }
            Object methodName = operand.get("staticMethod");
            if (methodName != null) {
                try {
                    Method method = clazz.getMethod((String)methodName, new Class[0]);
                    target = method.invoke(null, new Object[0]);
                    Objects.requireNonNull(target, () -> "method " + method + " returns null");
                }
                catch (Exception e) {
                    throw new RuntimeException("Error invoking method " + methodName, e);
                }
            }
            try {
                Constructor<?> constructor = clazz.getConstructor(new Class[0]);
                target = constructor.newInstance(new Object[0]);
            }
            catch (Exception e) {
                throw new RuntimeException("Error instantiating class " + className, e);
            }
            return new ReflectiveSchema(target);
        }
    }

    private static class ReflectiveTable
    extends AbstractQueryableTable
    implements Table,
    ScannableTable {
        private final Enumerable enumerable;

        ReflectiveTable(Type elementType, Enumerable enumerable) {
            super(elementType);
            this.enumerable = enumerable;
        }

        @Override
        public RelDataType getRowType(RelDataTypeFactory typeFactory) {
            return ((JavaTypeFactory)typeFactory).createType(this.elementType);
        }

        @Override
        public Statistic getStatistic() {
            return Statistics.UNKNOWN;
        }

        @Override
        public Enumerable<@Nullable Object[]> scan(DataContext root) {
            if (this.elementType == Object[].class) {
                return this.enumerable;
            }
            return this.enumerable.select((Function1)new FieldSelector((Class)this.elementType));
        }

        @Override
        public <T> Queryable<T> asQueryable(QueryProvider queryProvider, SchemaPlus schema, String tableName) {
            return new AbstractTableQueryable<T>(queryProvider, schema, this, tableName){

                public Enumerator<T> enumerator() {
                    return enumerable.enumerator();
                }
            };
        }
    }
}

