/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.interpreter;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.Objects;
import org.apache.calcite.interpreter.AbstractSingleNode;
import org.apache.calcite.interpreter.Compiler;
import org.apache.calcite.interpreter.Row;
import org.apache.calcite.rel.RelFieldCollation;
import org.apache.calcite.rel.core.Sort;
import org.apache.calcite.rex.RexLiteral;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.Ordering;

public class SortNode
extends AbstractSingleNode<Sort> {
    public SortNode(Compiler compiler, Sort rel) {
        super(compiler, rel);
    }

    private static int getValueAsInt(RexNode node) {
        return Objects.requireNonNull(((RexLiteral)node).getValueAs(Integer.class), () -> "getValueAs(Integer.class) for " + node);
    }

    @Override
    public void run() throws InterruptedException {
        block10: {
            int fetch;
            int offset = ((Sort)this.rel).offset == null ? 0 : SortNode.getValueAsInt(((Sort)this.rel).offset);
            int n = fetch = ((Sort)this.rel).fetch == null ? -1 : SortNode.getValueAsInt(((Sort)this.rel).fetch);
            if (((Sort)this.rel).getCollation().getFieldCollations().isEmpty()) {
                Row row;
                int i;
                for (i = 0; i < offset; ++i) {
                    row = this.source.receive();
                    if (row != null) {
                        continue;
                    }
                    break block10;
                }
                if (fetch >= 0) {
                    for (i = 0; i < fetch && (row = this.source.receive()) != null; ++i) {
                        this.sink.send(row);
                    }
                } else {
                    while ((row = this.source.receive()) != null) {
                        this.sink.send(row);
                    }
                }
            } else {
                Row row;
                ArrayList<Row> list = new ArrayList<Row>();
                while ((row = this.source.receive()) != null) {
                    list.add(row);
                }
                list.sort(this.comparator());
                int end = fetch < 0 || offset + fetch > list.size() ? list.size() : offset + fetch;
                for (int i = offset; i < end; ++i) {
                    this.sink.send((Row)list.get(i));
                }
            }
        }
        this.sink.end();
    }

    private Comparator<Row> comparator() {
        if (((Sort)this.rel).getCollation().getFieldCollations().size() == 1) {
            return SortNode.comparator(((Sort)this.rel).getCollation().getFieldCollations().get(0));
        }
        return Ordering.compound(Util.transform(((Sort)this.rel).getCollation().getFieldCollations(), SortNode::comparator));
    }

    private static Comparator<Row> comparator(RelFieldCollation fieldCollation) {
        int nullComparison = fieldCollation.nullDirection.nullComparison;
        int x = fieldCollation.getFieldIndex();
        switch (fieldCollation.direction) {
            case ASCENDING: {
                return (o1, o2) -> {
                    Comparable c1 = (Comparable)o1.getValues()[x];
                    Comparable c2 = (Comparable)o2.getValues()[x];
                    return RelFieldCollation.compare(c1, c2, nullComparison);
                };
            }
        }
        return (o1, o2) -> {
            Comparable c1 = (Comparable)o1.getValues()[x];
            Comparable c2 = (Comparable)o2.getValues()[x];
            return RelFieldCollation.compare(c2, c1, -nullComparison);
        };
    }
}

