/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.sql.util;

import java.lang.reflect.Field;
import java.util.Collection;
import java.util.List;
import java.util.Locale;
import org.apache.calcite.sql.SqlFunction;
import org.apache.calcite.sql.SqlFunctionCategory;
import org.apache.calcite.sql.SqlIdentifier;
import org.apache.calcite.sql.SqlOperator;
import org.apache.calcite.sql.SqlOperatorTable;
import org.apache.calcite.sql.SqlSyntax;
import org.apache.calcite.sql.fun.SqlStdOperatorTable;
import org.apache.calcite.sql.validate.SqlNameMatcher;
import org.apache.calcite.util.Pair;
import org.apache.calcite.util.Util;
import org.apache.kylin.guava30.shaded.common.collect.HashMultimap;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableList;
import org.apache.kylin.guava30.shaded.common.collect.Multimap;
import org.checkerframework.checker.nullness.qual.Nullable;

public abstract class ReflectiveSqlOperatorTable
implements SqlOperatorTable {
    public static final String IS_NAME = "INFORMATION_SCHEMA";
    private final Multimap<CaseSensitiveKey, SqlOperator> caseSensitiveOperators = HashMultimap.create();
    private final Multimap<CaseInsensitiveKey, SqlOperator> caseInsensitiveOperators = HashMultimap.create();

    protected ReflectiveSqlOperatorTable() {
    }

    public final void init() {
        for (Field field : this.getClass().getFields()) {
            try {
                SqlOperator op;
                if (SqlFunction.class.isAssignableFrom(field.getType())) {
                    op = (SqlFunction)field.get(this);
                    if (op == null) continue;
                    this.register(op);
                    continue;
                }
                if (!SqlOperator.class.isAssignableFrom(field.getType()) || (op = (SqlOperator)field.get(this)) == null) continue;
                this.register(op);
            }
            catch (IllegalAccessException | IllegalArgumentException e) {
                throw Util.throwAsRuntime(Util.causeOrSelf(e));
            }
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void lookupOperatorOverloads(SqlIdentifier opName, @Nullable SqlFunctionCategory category, SqlSyntax syntax, List<SqlOperator> operatorList, SqlNameMatcher nameMatcher) {
        String simpleName;
        if (opName.names.size() > 1) {
            if (!((String)opName.names.get(opName.names.size() - 2)).equals(IS_NAME)) return;
            simpleName = Util.last(opName.names);
        } else {
            simpleName = opName.getSimple();
        }
        Collection<SqlOperator> list = this.lookUpOperators(simpleName, syntax, nameMatcher);
        if (list.isEmpty()) {
            return;
        }
        for (SqlOperator op : list) {
            if (op.getSyntax() == syntax) {
                operatorList.add(op);
                continue;
            }
            if (syntax != SqlSyntax.FUNCTION || !(op instanceof SqlFunction)) continue;
            operatorList.add(op);
        }
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                for (SqlOperator extra : this.lookUpOperators(simpleName, syntax, nameMatcher)) {
                    if (extra == null || operatorList.contains(extra)) continue;
                    operatorList.add(extra);
                }
                return;
            }
        }
    }

    private Collection<SqlOperator> lookUpOperators(String name, SqlSyntax syntax, SqlNameMatcher nameMatcher) {
        if (nameMatcher.isCaseSensitive() && !(this instanceof SqlStdOperatorTable)) {
            return this.caseSensitiveOperators.get((Object)new CaseSensitiveKey(name, syntax));
        }
        return this.caseInsensitiveOperators.get((Object)new CaseInsensitiveKey(name, syntax));
    }

    public void register(SqlOperator op) {
        this.caseSensitiveOperators.put((Object)new CaseSensitiveKey(op.getName(), op.getSyntax()), (Object)op);
        this.caseInsensitiveOperators.put((Object)new CaseInsensitiveKey(op.getName(), op.getSyntax()), (Object)op);
    }

    @Override
    public List<SqlOperator> getOperatorList() {
        return ImmutableList.copyOf((Collection)this.caseSensitiveOperators.values());
    }

    private static SqlSyntax normalize(SqlSyntax syntax) {
        switch (syntax) {
            case BINARY: 
            case PREFIX: 
            case POSTFIX: {
                return syntax;
            }
        }
        return SqlSyntax.FUNCTION;
    }

    private static class CaseSensitiveKey
    extends Pair<String, SqlSyntax> {
        CaseSensitiveKey(String name, SqlSyntax syntax) {
            super(name, ReflectiveSqlOperatorTable.normalize(syntax));
        }
    }

    private static class CaseInsensitiveKey
    extends Pair<String, SqlSyntax> {
        CaseInsensitiveKey(String name, SqlSyntax syntax) {
            super(name.toUpperCase(Locale.ROOT), ReflectiveSqlOperatorTable.normalize(syntax));
        }
    }
}

