/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.tools;

import java.util.List;
import java.util.concurrent.atomic.AtomicInteger;
import org.apache.calcite.rel.RelNode;
import org.apache.calcite.rex.RexCall;
import org.apache.calcite.rex.RexNode;
import org.apache.calcite.rex.RexVisitorImpl;
import org.apache.calcite.sql.SqlOperator;
import org.apache.kylin.guava30.shaded.common.collect.Lists;

public class RelUtils {
    private RelUtils() {
    }

    public static boolean findOLAPRel(RelNode rel) {
        Class<?> aClass;
        try {
            aClass = Thread.currentThread().getContextClassLoader().loadClass("org.apache.kylin.query.relnode.OLAPRel");
        }
        catch (ClassNotFoundException e) {
            return false;
        }
        return RelUtils.findRel(rel, Lists.newArrayList((Object[])new Class[]{aClass})) != null;
    }

    private static RelNode findRel(RelNode rel, List<Class> candidate) {
        for (Class clazz : candidate) {
            if (!clazz.isInstance(rel)) continue;
            return rel;
        }
        if (rel.getInputs().size() < 1) {
            return null;
        }
        return RelUtils.findRel(rel.getInput(0), candidate);
    }

    public static int countOperatorCall(final SqlOperator operator, RexNode node) {
        final AtomicInteger atomicInteger = new AtomicInteger(0);
        RexVisitorImpl<Void> visitor = new RexVisitorImpl<Void>(true){

            @Override
            public Void visitCall(RexCall call) {
                if (call.getOperator().equals(operator)) {
                    atomicInteger.incrementAndGet();
                }
                return (Void)super.visitCall(call);
            }
        };
        node.accept(visitor);
        return atomicInteger.get();
    }
}

