/*
 * Decompiled with CFR 0.152.
 */
package org.apache.calcite.util;

import java.util.Objects;
import java.util.function.BiConsumer;
import org.apache.calcite.linq4j.Ord;
import org.apache.calcite.rex.RexUnknownAs;
import org.apache.calcite.util.RangeSets;
import org.apache.kylin.guava30.shaded.common.collect.ImmutableRangeSet;
import org.apache.kylin.guava30.shaded.common.collect.Iterables;
import org.apache.kylin.guava30.shaded.common.collect.Range;
import org.apache.kylin.guava30.shaded.common.collect.RangeSet;
import org.checkerframework.checker.nullness.qual.Nullable;

public class Sarg<C extends Comparable<C>>
implements Comparable<Sarg<C>> {
    public final RangeSet<C> rangeSet;
    public final RexUnknownAs nullAs;
    public final int pointCount;
    private static final SpecialSarg FALSE = new SpecialSarg(ImmutableRangeSet.of(), RexUnknownAs.FALSE, "Sarg[FALSE]", 2);
    private static final SpecialSarg IS_NOT_NULL = new SpecialSarg(ImmutableRangeSet.of().complement(), RexUnknownAs.FALSE, "Sarg[IS NOT NULL]", 3);
    private static final SpecialSarg IS_NULL = new SpecialSarg(ImmutableRangeSet.of(), RexUnknownAs.TRUE, "Sarg[IS NULL]", 4);
    private static final SpecialSarg TRUE = new SpecialSarg(ImmutableRangeSet.of().complement(), RexUnknownAs.TRUE, "Sarg[TRUE]", 5);
    private static final SpecialSarg NOT_EQUAL = new SpecialSarg(ImmutableRangeSet.of(), RexUnknownAs.UNKNOWN, "Sarg[<>]", 6);
    private static final SpecialSarg EQUAL = new SpecialSarg(ImmutableRangeSet.of().complement(), RexUnknownAs.UNKNOWN, "Sarg[=]", 7);

    private Sarg(ImmutableRangeSet<C> rangeSet, RexUnknownAs nullAs) {
        this.rangeSet = (RangeSet)Objects.requireNonNull(rangeSet, "rangeSet");
        this.nullAs = Objects.requireNonNull(nullAs, "nullAs");
        this.pointCount = RangeSets.countPoints(rangeSet);
    }

    @Deprecated
    public static <C extends Comparable<C>> Sarg<C> of(boolean containsNull, RangeSet<C> rangeSet) {
        return Sarg.of(containsNull ? RexUnknownAs.TRUE : RexUnknownAs.UNKNOWN, rangeSet);
    }

    public static <C extends Comparable<C>> Sarg<C> of(RexUnknownAs nullAs, RangeSet<C> rangeSet) {
        if (rangeSet.isEmpty()) {
            switch (nullAs) {
                case FALSE: {
                    return FALSE;
                }
                case TRUE: {
                    return IS_NULL;
                }
            }
            return NOT_EQUAL;
        }
        if (rangeSet.equals(RangeSets.rangeSetAll())) {
            switch (nullAs) {
                case FALSE: {
                    return IS_NOT_NULL;
                }
                case TRUE: {
                    return TRUE;
                }
            }
            return EQUAL;
        }
        return new Sarg<C>(ImmutableRangeSet.copyOf(rangeSet), nullAs);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        this.printTo(sb, StringBuilder::append);
        return sb.toString();
    }

    public StringBuilder printTo(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
        sb.append("Sarg[");
        RangeSets.Consumer printer = RangeSets.printer(sb, valuePrinter);
        Ord.forEach((Iterable)this.rangeSet.asRanges(), (r, i) -> {
            if (i > 0) {
                sb.append(", ");
            }
            RangeSets.forEach(r, printer);
        });
        switch (this.nullAs) {
            case FALSE: {
                return sb.append("; NULL AS FALSE]");
            }
            case TRUE: {
                return sb.append("; NULL AS TRUE]");
            }
            case UNKNOWN: {
                return sb.append("]");
            }
        }
        throw new AssertionError();
    }

    @Override
    public int compareTo(Sarg<C> o) {
        return RangeSets.compare(this.rangeSet, o.rangeSet);
    }

    public int hashCode() {
        return RangeSets.hashCode(this.rangeSet) * 31 + this.nullAs.ordinal();
    }

    public boolean equals(@Nullable Object o) {
        return o == this || o instanceof Sarg && this.nullAs == ((Sarg)o).nullAs && this.rangeSet.equals(((Sarg)o).rangeSet);
    }

    public boolean isAll() {
        return false;
    }

    public boolean isNone() {
        return false;
    }

    public boolean isPoints() {
        return this.pointCount == this.rangeSet.asRanges().size();
    }

    public boolean isComplementedPoints() {
        return this.rangeSet.span().encloses(Range.all()) && !this.rangeSet.equals(RangeSets.rangeSetAll()) && this.rangeSet.complement().asRanges().stream().allMatch(RangeSets::isPoint);
    }

    public int complexity() {
        int complexity = this.rangeSet.asRanges().size() == 2 && this.rangeSet.complement().asRanges().size() == 1 && RangeSets.isPoint((Range)Iterables.getOnlyElement((Iterable)this.rangeSet.complement().asRanges())) ? 1 : this.rangeSet.asRanges().size();
        if (this.nullAs == RexUnknownAs.TRUE) {
            ++complexity;
        }
        return complexity;
    }

    public Sarg negate() {
        return Sarg.of(this.nullAs.negate(), this.rangeSet.complement());
    }

    private static class SpecialSarg<C extends Comparable<C>>
    extends Sarg<C> {
        final String name;
        final int ordinal;

        SpecialSarg(ImmutableRangeSet<C> rangeSet, RexUnknownAs nullAs, String name, int ordinal) {
            super(rangeSet, nullAs);
            this.name = name;
            this.ordinal = ordinal;
            assert (rangeSet.isEmpty() == ((ordinal & 1) == 0));
            assert (rangeSet.equals(RangeSets.rangeSetAll()) == ((ordinal & 1) == 1));
        }

        @Override
        public boolean equals(@Nullable Object o) {
            return this == o;
        }

        @Override
        public int hashCode() {
            return this.ordinal;
        }

        @Override
        public boolean isAll() {
            return (this.ordinal & 1) == 1;
        }

        @Override
        public boolean isNone() {
            return (this.ordinal & 1) == 0;
        }

        @Override
        public int complexity() {
            switch (this.ordinal) {
                case 2: {
                    return 0;
                }
                case 5: {
                    return 2;
                }
            }
            return 1;
        }

        @Override
        public StringBuilder printTo(StringBuilder sb, BiConsumer<StringBuilder, C> valuePrinter) {
            return sb.append(this.name);
        }

        @Override
        public String toString() {
            return this.name;
        }
    }
}

