/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.iterator;

import java.io.Serializable;
import java.util.Iterator;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.gluten.exception.GlutenException;
import org.apache.spark.sql.vectorized.ColumnarBatch;

public abstract class ClosableIterator
implements AutoCloseable,
Serializable,
Iterator<ColumnarBatch> {
    protected final AtomicBoolean closed = new AtomicBoolean(false);

    @Override
    public final boolean hasNext() {
        if (this.closed.get()) {
            throw new GlutenException("Iterator has been closed.");
        }
        try {
            return this.hasNext0();
        }
        catch (Exception e) {
            throw new GlutenException(e);
        }
    }

    @Override
    public final ColumnarBatch next() {
        if (this.closed.get()) {
            throw new GlutenException("Iterator has been closed.");
        }
        try {
            return this.next0();
        }
        catch (Exception e) {
            throw new GlutenException(e);
        }
    }

    @Override
    public final void close() {
        if (this.closed.compareAndSet(false, true)) {
            this.close0();
        }
    }

    protected abstract void close0();

    protected abstract boolean hasNext0() throws Exception;

    protected abstract ColumnarBatch next0() throws Exception;
}

