/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory;

import java.util.Collections;
import java.util.Map;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.gluten.memory.MemoryUsageRecorder;
import org.apache.gluten.proto.MemoryUsageStats;

public class SimpleMemoryUsageRecorder
implements MemoryUsageRecorder {
    private final AtomicLong peak = new AtomicLong(0L);
    private final AtomicLong current = new AtomicLong(0L);

    @Override
    public void inc(long bytes) {
        long prevPeak;
        long total = this.current.addAndGet(bytes);
        while (total > (prevPeak = this.peak.get()) && !this.peak.compareAndSet(prevPeak, total)) {
        }
    }

    @Override
    public long peak() {
        return this.peak.get();
    }

    @Override
    public long current() {
        return this.current.get();
    }

    public MemoryUsageStats toStats(Map<String, MemoryUsageStats> children) {
        return MemoryUsageStats.newBuilder().setPeak(this.peak.get()).setCurrent(this.current.get()).putAllChildren(children).build();
    }

    @Override
    public MemoryUsageStats toStats() {
        return this.toStats(Collections.emptyMap());
    }
}

