/*
 * Decompiled with CFR 0.152.
 */
package org.apache.gluten.memory.memtarget;

import java.util.Map;
import org.apache.gluten.memory.MemoryUsageStatsBuilder;
import org.apache.gluten.memory.memtarget.MemoryTargetVisitor;
import org.apache.gluten.memory.memtarget.Spiller;
import org.apache.gluten.memory.memtarget.TreeMemoryTarget;
import org.apache.gluten.proto.MemoryUsageStats;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RetryOnOomMemoryTarget
implements TreeMemoryTarget {
    private static final Logger LOGGER = LoggerFactory.getLogger(RetryOnOomMemoryTarget.class);
    private final TreeMemoryTarget target;
    private final Runnable onRetry;

    RetryOnOomMemoryTarget(TreeMemoryTarget target, Runnable onRetry) {
        this.target = target;
        this.onRetry = onRetry;
    }

    @Override
    public long borrow(long size) {
        long granted = this.target.borrow(size);
        if (granted < size) {
            LOGGER.info("Granted size {} is less than requested size {}, retrying...", (Object)granted, (Object)size);
            long remaining = size - granted;
            this.onRetry.run();
            LOGGER.info("Newest granted size after retrying: {}, requested size {}.", (Object)(granted += this.target.borrow(remaining)), (Object)size);
        }
        return granted;
    }

    @Override
    public long repay(long size) {
        return this.target.repay(size);
    }

    @Override
    public long usedBytes() {
        return this.target.usedBytes();
    }

    @Override
    public <T> T accept(MemoryTargetVisitor<T> visitor) {
        return visitor.visit(this);
    }

    @Override
    public String name() {
        return this.target.name();
    }

    @Override
    public MemoryUsageStats stats() {
        return this.target.stats();
    }

    @Override
    public TreeMemoryTarget newChild(String name, long capacity, Spiller spiller, Map<String, MemoryUsageStatsBuilder> virtualChildren) {
        return this.target.newChild(name, capacity, spiller, virtualChildren);
    }

    @Override
    public Map<String, TreeMemoryTarget> children() {
        return this.target.children();
    }

    @Override
    public TreeMemoryTarget parent() {
        return this.target.parent();
    }

    @Override
    public Spiller getNodeSpiller() {
        return this.target.getNodeSpiller();
    }

    public TreeMemoryTarget target() {
        return this.target;
    }
}

